<?php
/************************FoxPHP威客系统************************/
/*                                                            */
/*  FoxPHP.Com (C)2006-2016 FoxPHP Inc.                       */
/*  This is NOT a freeware, use is subject to license terms   */
/*  FoxPHP威客系统是商业软件,使用于商业用途请购买授权         */
/*  V3.0 2016.3                                               */
/*  foxphp@aliyun.com                                         */
/*  http://www.foxphp.com                                     */
/*                                                            */
/**************************************************************/

namespace Admin\Controller;
use Think\Controller;
class UpdateController extends IndexController {
	
	public function cacheAction(){
		
		//更新导航菜单
		$this->UpdateNav();

		//内容分类
		$this->UpdateCategorySubclassID('Category');
		
		//城市分类
		$this->UpdateCategorySubclassID('CategoryCity');
		

		//会员
		M('Config')->token(false)->where(" name_foxphp='siteuserdata' ")->save(array('value_foxphp'=>M('Member')->token(false)->count()));
		
		//统计任务数据
		M('Config')->token(false)->where(" name_foxphp='sitetaskdata' ")->save(array('value_foxphp'=>M('Data')->token(false)->where('type=1')->count()));
		
		//统计服务数据
		M('Config')->token(false)->where(" name_foxphp='sitefuwudata' ")->save(array('value_foxphp'=>M('Data')->token(false)->where('type=2')->count()));
		
		//投稿
		M('Config')->token(false)->where(" name_foxphp='siteorderdata' ")->save(array('value_foxphp'=>M('DataOrder')->token(false)->count()));
		
		//交易收入
		M('Config')->token(false)->where(" name_foxphp='sitepayin' ")->save(array('value_foxphp'=>M('Consume')->token(false)->where('payin_uid=1 AND process=5 AND paytype<3 ')->sum('amount')/100));
		
		//交易支出
		M('Config')->token(false)->where(" name_foxphp='sitepayout' ")->save(array('value_foxphp'=>M('Consume')->token(false)->where('payout_uid=1 AND process=5 AND paytype<3 ')->sum('amount')/100));
		
		//充值
		M('Config')->token(false)->where(" name_foxphp='sitemoneyin' ")->save(array('value_foxphp'=>M('Consume')->token(false)->where('paytype=3 AND process=5')->sum('amount')/100));
		
		//提现
		M('Config')->token(false)->where(" name_foxphp='sitewithdraw' ")->save(array('value_foxphp'=>M('Consume')->token(false)->where('paytype=4 AND process=5')->sum('amount')/100));


		
		//删除缓存文件 /Runtime/Cache
		$this->DeleteCache(FOXPHP_PATH.'/Apps/Runtime/Cache/');
		
		//删除数据文件  /Runtime/Data
		$this->DeleteCache(FOXPHP_PATH.'/Apps/Runtime/Data/');
		
		//删除日志文件 /Runtime/Logs
		$this->DeleteCache(FOXPHP_PATH.'/Apps/Runtime/Logs/');
		
		//删除临时文件 /Runtime/Temp
		$this->DeleteCache(FOXPHP_PATH.'/Apps/Runtime/Temp/');
		
		//删除静态页面 /Apps/Html
		$this->DeleteCache(FOXPHP_PATH.'/Apps/Html/');
		
		//缓存配置
		@unlink(FOXPHP_PATH.'/Apps/Runtime/common~runtime.php');
		
		  
		$this->ajaxReturn(array('title'=>'更新缓存成功！','message'=>'更新缓存成功！','status'=>'ok','refresh'=>true));
	}
	
	
	//提取文件名称与路径
	function DeleteCache($url=null){
		$dir = new \RecursiveIteratorIterator(new \RecursiveDirectoryIterator($url)); 
		foreach($dir as $file) { 
			if($file->isFile()){
				@unlink($file->getPath().'/'.$file->getFileName()); 
			}
		}  
	}
	
	function UpdateNav(){
		WriteFile(C('S_APPS').'/Common/Conf/nav.php',serialize(M('Nav')->token(false)->where('status=1')->order('displayorder ASC')->select()));
	}
	
	//子类ID
	function UpdateCategorySubclassID($tname='Category'){
		set_time_limit(0);
		//1
		$category1=M($tname)->token(false)->where('upid=0')->field('catid,upid')->select();
		if(!empty($category1)){
			foreach($category1 as $key1=>$value1){
				$nexts='';
				$catid1=$value1['catid'];
				if($catid1){
					$nexts=$catid1;
					//2
					$category2=M($tname)->token(false)->where(" upid=$catid1 ")->field('catid,upid')->select();
					if(!empty($category2)){
						foreach($category2 as $key2=>$value2){
							$catid2=$value2['catid'];
							if($catid2){
								$nexts.=','.$catid2;
								//3
								$category3=M($tname)->token(false)->where(" upid=$catid2 ")->field('catid,upid')->select();
								if(!empty($category3)){
									foreach($category3 as $key3=>$value3){
										$catid3=$value3['catid'];
										if($catid3){
											$nexts.=','.$catid3;
											M($tname)->token(false)->where(" catid=$catid3 ")->save(array('nexts'=>$nexts));
										}
									}
								}
							}
							
							M($tname)->token(false)->where(" catid=$catid2 ")->save(array('nexts'=>$nexts));
						}
					}
				}
				
				M($tname)->token(false)->where(" catid=$catid1 ")->save(array('nexts'=>$nexts));
			}
		}
	}
}