<?php
/************************FoxPHP威客系统************************/
/*                                                            */
/*  FoxPHP.Com (C)2006-2016 FoxPHP Inc.                       */
/*  This is NOT a freeware, use is subject to license terms   */
/*  FoxPHP威客系统是商业软件,使用于商业用途请购买授权         */
/*  V3.0 2016.3                                               */
/*  foxphp@aliyun.com                                         */
/*  http://www.foxphp.com                                     */
/*                                                            */
/**************************************************************/


function GetNav(){
	return unserialize(GetFile(C('S_APPS').'/Common/Conf/nav.php'));
}
//跨域
function JsonAccessAllow(){
	header('content-type:application:json;charset=utf8');  
	header('Access-Control-Allow-Origin:*');  
	header('Access-Control-Allow-Methods:POST');  
	header('Access-Control-Allow-Headers:x-requested-with,content-type'); 
	$_POST['datatype']='json';
}

function VerifyForm(){
	return  $_SESSION['VerifyForm']=RandomText(16,1);
}
	
function CheckVerifyForm($code=''){
	$verify=empty($_SESSION['VerifyForm']) ? '' : $_SESSION['VerifyForm'];
	if($code==$verify){
		unset($_SESSION['VerifyForm']);
		return true;
	}else{
		unset($_SESSION['VerifyForm']);
		return false;
	} 
}

function NowTime(){
	return @time();
}

function FormatDate($dateformat, $date='',$format=0) {
   
	 $time = NowTime() - $date;
	 $result = '';
	 if($format) {
		 if($time > 24*3600) {
			 $result = @date($dateformat,$date);
		 } elseif ($time > 3600) {
			 $result = intval($time/3600).'小时前';
		 } elseif ($time > 60) {
			 $result = intval($time/60).'分钟前';
		 } elseif ($time > 0) {
			 $result = $time.'秒前';
		 } else {
			 $result = '刚刚';
		 }
	  }else{
		 $result = @date($dateformat,$date);
	 }
	 return $result;
}

function SelectDate($time=0){
	
	$selectdate='';
		
	$nowyear=FormatDate("Y",NowTime());

	$year=FormatDate("Y",$time);
	
	for($i=($nowyear);$i>=($nowyear-100);$i--){
		if($time){
			$yearselected=$year==$i ? ' selected="selected" ' : '';
		}
		$selectdate.='<option value="'.$i.'"'.$yearselected.'>'.$i.'</option>';
	}
	return $selectdate;
}
 
//获取 文件内容
function GetFile($filedir){
	if ($open_file = @fopen($filedir, "rb")){		   
		$filecontent=fread($open_file,filesize($filedir));			
		fclose($open_file);
		return $filecontent;
	}else{
		 return false;
	}
}

function WriteFile($wfile,$cfile,$wr='w'){

    if($openwrite =  @fopen($wfile, $wr)){
		 fwrite($openwrite,$cfile);
		 fclose($openwrite);
		 return true;
    }else{
		 return false;
    }
}


//生成随机码
function RandomText($count,$lowercase='0'){

	srand((double)microtime()*1000000);
	$doublenum=mt_rand(10000,1000000);
	srand((double)microtime()*$doublenum); 
 
	if($lowercase==1){
		$numrand=array_flip(array_merge(range(1,9),range('A','N'),range('P','Z'),range('a','n'),range('p','z')));
	}elseif($lowercase==2){
		$numrand=array_flip(range(1,9));
	}else{
		$numrand=array_flip(array_merge(range(1,9),range('A','N'),range('P','Z'))); 
	}
	 
	$textkey='';
	for($i=0;$i<$count;$i++){
	    $textkey .= array_rand($numrand);
	} 
	return $textkey; 
}

function PasswordKey($username,$password,$powercode){
	return md5(md5(md5($password).$powercode).$username);
}


//是否超级管理员
function IsAdmin($uid=0){
	if($uid>0){
		if(intval($uid)==1){
			return true;
		}
	}
	return false;
}
 
 
 //字符串分割判断
function explodestr($intif,$str){
	$strarray=explode(',',$str);
	$strok='';
	foreach($strarray as $value){				 
		if(intval($intif)==intval($value)){
			$strok=true;
		}
	}
	return $strok;
}

 //字符串分割重组 ID集,排除ID
function ExplodeStrArr($str,$delid=0){
	$strarray=explode(',',$str);
	$strok='';
	 if(is_array($strarray)){
		 foreach($strarray as $value){				 
			 $isid=intval($value);
			  if($isid>0 && $isid!=$delid){
				  if(empty($strok)){
					 $strok.=$isid;
				  }else{
					   $strok.=','.$isid;
				  }
			  
			 }
		 }
	  
	 }else{
		 $strok=0;
	 }
 
	 if(empty($strok)){
		  $strok=0;
	 }
 
	 return $strok;
}

//获取用户IP
function GetClientIp(){

	if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
		$realip = $_SERVER['HTTP_X_FORWARDED_FOR'];
	} elseif (isset($_SERVER['HTTP_CLIENT_IP'])) {
		$realip = $_SERVER['HTTP_CLIENT_IP'];
	} else {
		$realip = $_SERVER['REMOTE_ADDR'];
	} 
	return preg_match('/^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$/',$realip)?$realip:'0.0.0.0'; 
}

//是否客服
function IsService($sid){
	
	$uid=intval(session('USER_USERID'));
	
	 if($uid>0){
		   if($uid==$sid){
				return true;
		   }else{
				return false;
		   }
	 }else{
		  return false;
	 }
	 
	 return false;
	  
}

function GetFileForm($filename){
	 $formarr=explode('.',$filename);
	 $num=count($formarr);
	 return strtolower($formarr[$num-1]);	
}
	
//删除文件
function DelFile($filepath){
	@unlink($filepath);
}


function GetFileHeader($filename){
		$file= @fopen($filename, "rb");
		$bin= fread($file, 2); 
		fclose($file);
		$strInfo  = @unpack("C2chars", $bin);
		return intval($strInfo['chars1'].$strInfo['chars2']);
}

function GetFileInfoMIME($filename){
	   $finfo = finfo_open(FILEINFO_MIME);
	   $mimetype = finfo_file($finfo, $filename);
	   finfo_close($finfo);
	   $mimetypearr=explode(';',$mimetype);
	   return $mimetypearr[0];
}


//简版用户头像 uid | 大小类型 200 120 48 | 样式名称
function GetAvatarSimple($uid=0,$type=200,$imgclass='user_avatar'){

	if($uclient=GetClient()){
		$avatar=str_replace('/>','class=\''.$imgclass.'\' />',str_replace('"',"'",$uclient->getavatar($uid,$type)));
	}else{

		$avatardir=substr($uid,-2,2).'/'.$uid.'.jpg';
		if($type==200){
			if(is_file(FOXPHP_PATH.'/attachment/avatar/big/'.$avatardir)){
				$avatar='<img src=\'/attachment/avatar/big/'.$avatardir.'\' class=\''.$imgclass.'\' />';
			}else{
				$avatar='<img src=\''.AURL.'/img/avatars/noavatar_big.gif\' class=\''.$imgclass.'\'/>';
			}
		}elseif($type==120){
			if(is_file(FOXPHP_PATH.'/attachment/avatar/middle/'.$avatardir)){
				$avatar='<img src=\'/attachment/avatar/middle/'.$avatardir.'\' class=\''.$imgclass.'\'/>';
			}else{
				$avatar='<img src=\''.AURL.'/img/avatars/noavatar_middle.gif\' class=\''.$imgclass.'\'/>';
			}
		}elseif($type==48){
			if(is_file(FOXPHP_PATH.'/attachment/avatar/small/'.$avatardir)){
				$avatar='<img src=\'/attachment/avatar/small/'.$avatardir.'\' class=\''.$imgclass.'\'/>';
			}else{
				$avatar='<img src=\''.AURL.'/img/avatars/noavatar_small.gif\' class=\''.$imgclass.'\'/>';
			}
		}
		
	}
	  
	return $avatar;
	
}

//检查是否有POST提交
function IsPost($name=''){
	if(!empty($_POST[$name])){
		if(is_array($_POST) && !empty($_POST)){
			return true;
		}else{
			return false;
		}
	}else{
		return false;
	}
}
//检查提交ID
function GetCheckBox($checkbox='',$explode=0){
    
	$ids='';
	
	if($checkbox){
		
		  foreach($checkbox as $value){
				if($ids){
					  $ids.=','.$value;
				 }else{
					  $ids=$value;
				 }
		  }
		
	}else{
		 return false;	   
		 exit();
		
	}
	
	if($explode){
		 return $ids;
	}else{
		 return ExplodeStrArr($ids);
	}

}

function IsNum($val){
    return preg_match('/^[0-9]+$/',$val);
}


//处理特殊字符
function safe_b64encode($string) {
	$data = base64_encode($string);
	$data = str_replace(array('+','/','='),array('-','_',''),$data);
	return $data;
}

//解析特殊字符
function safe_b64decode($string) {
	$data = str_replace(array('-','_'),array('+','/'),$string);
	$mod4 = strlen($data) % 4;
	if ($mod4) {
		$data .= substr('====', $mod4);
	}
	return base64_decode($data);
}

//mcrypt加密
function McryptEncrypt($string=''){
	$crypttext= base64_encode(mcrypt_encrypt(MCRYPT_RIJNDAEL_256,md5(C('MCRYPT_KEY')),$string,MCRYPT_MODE_CBC,md5(md5(C('MCRYPT_KEY')))));
	return trim(safe_b64encode($crypttext));
}

//mcrypt解密
function McryptDecrypt($encrypted=''){
	$crypttexttb=safe_b64decode($encrypted);
	return rtrim(mcrypt_decrypt(MCRYPT_RIJNDAEL_256,md5(C('MCRYPT_KEY')),base64_decode($crypttexttb),MCRYPT_MODE_CBC, md5(md5(C('MCRYPT_KEY')))));
}
	

function GetClient($username='',$password='',$email=''){
	$uc_open=C('uc_open');		 
	if(!empty($uc_open)){

		if(C('uc_apitype')==1){
			include_once(C('S_APPS').'/Ucclient/class/pw_client_class_phpapp.php');
		}elseif(C('uc_apitype')==2){
			include_once(C('S_APPS').'/Ucclient/class/pw9_client_class_phpapp.php');
		}else{
			include_once(C('S_APPS').'/Ucclient/class/dz_client_class_phpapp.php');
		}
		
		return new UserClientAPI($username,$password,$email);

	}else{
		return false;
	}
}

function CurlGetContent($type='GET',$url='',$data=array()){
	
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $url); 
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	if($type=='GET'){
		curl_setopt($ch, CURLOPT_HEADER, 0);
	}else{
		curl_setopt($ch, CURLOPT_POST, 1); 
		curl_setopt($ch, CURLOPT_POSTFIELDS,$data); 
	}
	
	$result = curl_exec($ch);
	curl_getinfo($ch);  
	curl_close($ch);
	
	return $result;
}

//排序
function arg_sort($array) {
	ksort($array);
	reset($array);
	return $array;
}

//生成签名
function make_sign($array,$postkey) {
	$arg  = "";
	foreach($array as $key=>$value){
		$arg.=$key."=".$value."&";
	}
	$prestr= substr($arg,0,count($arg)-2);		    
	$prestr = $prestr.$postkey;
	return md5($prestr);	   
}

//筛选
function SetWhere($getval='',$filter='',$iswhere=0){

	$sqlkey=$sqlvalue=$sqlarr=array();
	$sqlurl='';

	foreach($getval as $key=>$value){
		   
		   if(isset($filter[$key])){
		   
				   $keyarr=$filter[$key];

				   if(!empty($keyarr[1])){
						 
						 if($keyarr[1]=='float'){
							  $value=floatval($value);
							  if($value>0){
								  $sqlarr[]=$keyarr[0].'=%f';
								  $sqlvalue[$key]=$value;
							  }
							  
						 }elseif($keyarr[1]=='int' && $value!=null){
							  $value=intval($value);
							  if($value>0 || IsNum($value)){
								  $sqlarr[]=$keyarr[0].'=%d';
								  $sqlvalue[$key]=$value;
							  }

						}elseif($keyarr[1]=='string' && $value!=null){
							  $value=I('get.'.$keyarr[0]);
							  $value=strip_tags($value);
							  $value=trim(htmlspecialchars($value,ENT_QUOTES,C('S_CHARSET')));
							  if($value){
								  $sqlarr[]=$keyarr[0]."='%s'";
								  $sqlvalue[$key]=urldecode($value);
							  }
							  
						 }elseif($keyarr[1]=='search' && $value!=null){
							  $value=I('get.'.$keyarr[0]);
							  $value=strip_tags($value);
							  $value=trim(htmlspecialchars($value,ENT_QUOTES,C('S_CHARSET')));
							  if($value){
								  $sqlarr[]="$keyarr[0] like '%%%s%%'";  
								  $sqlvalue[$key]=urldecode($value);
							  }  
						 }elseif($keyarr[1]=='time'){
							  
								  $partkey=iconv_substr($key,-1,1,C('S_CHARSET'));
									
								  if($partkey ==1){
										$value=empty($value) ? '' : intval(strtotime($value));
										if($value){
											 $sqlarr[]=$keyarr[0].'>=\''.$value.'\'';  
											 
											 $sqlkey[$key]=@date("Y-m-d",$value);
										}
										
										
								  }
								  
								  if($partkey ==2){
										$value=empty($value) ? '' : intval(strtotime($value));
										if($value){
											 $sqlarr[]=$keyarr[0].'<=\''.$value.'\'';  
											 $sqlkey[$key]=@date("Y-m-d",$value);
										}
										
										
								  }
			
					
							  
						 }elseif($keyarr[1]=='part'){
							 
									$partkey=iconv_substr($key,-1,1,C('S_CHARSET'));
					
									if($partkey ==1){
										
										  if($value){
											   $sqlarr[]=$keyarr[0].'>=\''.floatval($value).'\'';  
										  }
										  
										  $sqlvalue[$key]=floatval($value);
									}
										
									if($partkey ==2){
										
										  if($value){
											   $sqlarr[]=$keyarr[0].'<=\''.floatval($value).'\'';  
										  }
										  
										  $sqlvalue[$key]=floatval($value);
									}	
						 
						 
						 }
						 elseif($keyarr[1]=='city'){
						
							  $value=intval($value);
							  $categoryarray=M('CategoryCity')->token(false)->where(" catid='$value' ")->find();
							  if($categoryarray['nexts']){
								  $sqlarr[]=$keyarr[0].' IN (%s)';
								  $sqlvalue[$key]=$categoryarray['nexts'];
							  }
						 }elseif($keyarr[1]=='catid'){
							 
							  $value=intval($value);
							  $categoryarray=M('Category')->token(false)->where(" catid='$value' ")->find();
							  
							  if($categoryarray['nexts']){
								  $sqlarr[]=$keyarr[0].' IN (%s)';
								  
								  $sqlvalue[$key]=$categoryarray['nexts'];
							  } 
						 }
			
						 $sqlurl.='&'.$key.'='.urlencode($value);
						 
				   }
				
		   
		   }
		
	}
	

	$showsql=implode(' AND ',$sqlarr);

	if(empty($showsql)){
		$wheresql=array('',$sqlvalue,"$sqlurl");
	}else{
		if($iswhere){
			 $showsql=' AND '.$showsql;
		}else{
			 $showsql=$showsql;
		}
		$wheresql=array("$showsql",$sqlvalue,"$sqlurl",$sqlkey);
	}

	return $wheresql;
  
}	