<?php
/************************FoxPHP威客系统************************/
/*                                                            */
/*  FoxPHP.Com (C)2006-2016 FoxPHP Inc.                       */
/*  This is NOT a freeware, use is subject to license terms   */
/*  FoxPHP威客系统是商业软件,使用于商业用途请购买授权         */
/*  V3.0 2016.3                                               */
/*  foxphp@aliyun.com                                         */
/*  http://www.foxphp.com                                     */
/*                                                            */
/**************************************************************/


namespace Data\Model;
use Think\Model;
use \Org\Util\String;

class DataModel extends Model {
	
	//单人订单流程
	public $processorderarr=array(1=>'发布托管赏金',2=>'服务商交稿',3=>'雇主选稿',4=>'中标服务商交接',5=>'雇主验收付款',6=>'评价');
	
	//protected $insertFields = array('username','usertype','typename','password','powercode','usergroup','groupname','email','unionid','uniontime','regip','dateline','mobile');
	
	//任务筛选许可字段
	public $selectkey=array('city'=>'c','mode'=>'m','deposit'=>'d','time'=>'t','order'=>'o','search'=>'s');
	
	public $selectfuwukey=array('city'=>'c','buy'=>'b','time'=>'t','order'=>'o','search'=>'s');
	
	public $selectrencaikey=array('city'=>'c','haoping'=>'h','time'=>'t','order'=>'o','search'=>'s');
	
	
	//字段检查-----------------------------------------------------------------------------------------------
	protected $_validate = array(
		array('catid','require','请选择分类！'),
		array('subject','require','请输入标题！'),
		array('content','require','请输入内容！')
	);
	
	//数据过滤-----------------------------------------------------------------------------------------------
	function FormatData($field='task'){
		$data['process']=1;
		$data['id']=intval($_POST['id']);
		$data['uid']=$this->uid;
		$data['username']=$this->username;
		$data['subject']=String::msubstr(I('post.subject'),0,60,C('S_CHARSET'),false);
		$_POST['content']=I('post.content','','strip_tags','',C('S_HTML_ALLOW'));
		$data['content']=String::msubstr(I('post.content','','htmlspecialchars'),0,999,C('S_CHARSET'),false);
		$data['description']=String::msubstr(I('post.content'),0,50,C('S_CHARSET'),true);
		$data['catid']=intval($_POST['catid']);
		
		$data['dateline']=NowTime();
		
		$data['adddate']=FormatDate("Y-m-d",NowTime());
		
		//所在地---------------------------------------------------------------------------------
		$provid=$data['provid']=intval($_POST['provid']);
		
		$cityid=$data['cityid']=intval($_POST['cityid']);
		
		$distid=$data['distid']=intval($_POST['distid']);
		
		if(C('otoo_open')){
			$model=new \Member\Model\MemberModel();
			$member=$model->UidGetMember($this->uid);
			if(!empty($member['longitude']) && !empty($member['latitude'])){
				
				$data['longitude']=$member['longitude'];
				$data['latitude']=$member['latitude'];
				$provid=$data['provid']=$member['provid'];
				$cityid=$data['cityid']=$member['cityid'];
				$distid=$data['distid']=$member['distid'];
			 
			}else{
			
				$cityarr=session('City');
				if(!empty($cityarr['catid'])){
					//上级
					$distid=$cityarr['catid'];
					$upidid=$cityarr['upid'];
					$provnamearr=M('CategoryCity')->where("catid=$upidid")->find();
					if(!empty($provnamearr)){
						$provid=$provnamearr['catid'];
						$data['provname']=$provnamearr['name'];
					}
					$data['cityname']=$cityarr['name'];
				}

				$data['longitude']=session('PointX');
				$data['latitude']=session('PointY');
				
				//session('CityId');
				
				$provid=$data['provid']=$provid;
			
				$cityid=$data['cityid']=$distid;
			
				$distid=$data['distid']=$distid;
			}
		}
		

		if($provid && $cityid && $distid){
		
			$provnamearr=M('CategoryCity')->where("catid=$provid")->find();
			
			$citynamearr=M('CategoryCity')->where("catid=$cityid")->find();
			
			$distnamearr=M('CategoryCity')->where("catid=$distid")->find();
			
			$data['provname']=$provnamearr['name'];
			
			$data['cityname']=$citynamearr['name'];
			
			$data['distname']=$distnamearr['name'];
		
		}

		
		if($data['catid']){
			$catid=$data['catid'];
			$categoryarr=M('Category')->token(false)->where("catid=$catid")->find();
			if(!empty($categoryarr['name'])){
				$data['catid_1']=$categoryarr['catid'];
				$data['category_name_1']=$categoryarr['name'];
			}
			
			if($categoryarr['upid']){
				$catid=$categoryarr['upid'];
				$categoryarr=M('Category')->token(false)->where("catid=$catid")->find();
			}
			
			if($categoryarr['name']){
				$data['catid_2']=$categoryarr['catid'];
				$data['category_name_2']=$categoryarr['name'];
			}
			
			if($categoryarr['upid']){
				$catid=$categoryarr['upid'];
				$categoryarr=M('Category')->token(false)->where("catid=$catid")->find();
			}
			
			if($categoryarr['name']){
				$data['catid_1']=$categoryarr['catid'];
				$data['category_name_3']=$categoryarr['name'];
			}
		}
		
		//任务信息
		if($field=='task'){
			$data['type']=1; //数据类型
			$data['phone']=IsNum($_POST['phone']) ? String::msubstr($_POST['phone'],0,12,C('S_CHARSET'),false) : 0;
			$data['endtime_number']=intval($_POST['endtime_number'])>0 && intval($_POST['endtime_number'])<=C('task_endtime') ?  intval($_POST['endtime_number']) : 1;
			$data['endtime']=time()+ ($data['endtime_number']*24*60*60);
			$data['enddate']=FormatDate("Y-m-d",time()+ ($data['endtime_number']*24*60*60));
		}
		
		//服务
		if($field=='fuwu'){
			$data['type']=2; //数据类型
			$data['process']=0;
			$data['endtime']=intval($_POST['endtime']);
			$data['money']=IsNum($_POST['money']) ? intval($_POST['money']) : 1;
		}

		$data['SecurityForm']=I('post.SecurityForm');
		return $data;
	}
	
	
	function FormatTaskPublishMoney(){

		$data['id']=intval($_POST['id']);
		
		$data['task_number']=intval($_POST['number']) ? intval($_POST['number']) :1;
		
		$data['money']=floatval($_POST['money']) ? intval(floatval($_POST['money'])*100) :1;
		
		$data['promise']=$_POST['promise']=='true' ? 1 : 0;
		
		$data['top']=$_POST['top']=='true' ? 1 : 0;
		
		$data['robots']=$_POST['robots']=='true' ? 1 : 0;
		
		$data['hidetask']=$_POST['hidetask']=='true' ? 1 : 0;
		
		$data['hidedraft']=$_POST['hidedraft']=='true' ? 1 : 0;
		
		$data['task_mode']=$_POST['task_mode']==1 ? 1 : 2;
		
		$data['SecurityForm']=I('post.SecurityForm');
		
		return $data;
	}
	
	//发布任务(第一步)
	function InsertTask($post=array(),$isusefile=1){
		
		//客服   
		$serviceuser=M('CustomerService')->token(false)->order('dateline ASC')->select();
		
		if($serviceuser){
			//绑定客服
			$suid=intval($serviceuser[0]['uid']);

			if($suid>0){
				M('CustomerService')->token(false)->where(" uid=$suid ")->save(array('dateline'=>NowTime()));
				$post['service_uid']=$serviceuser[0]['uid'];
				$post['service_username']=$serviceuser[0]['username'];
				$post['service_phone']=$serviceuser[0]['phone'];
			}  
		}
		
		if ($this->create($post)){
			if($id=$this->add()){
				//处理上传文件
				if($isusefile){
					$upload=new \Upload\Model\FileModel();
					$upload->UseFile('tid',$id);
					$file = $upload->token(false)->where(" tid=$id AND thumbcut is not null ")->order('dateline ASC')->find();
					if(!empty($file['thumbcut'])){
						$this->where(" uid=$this->uid AND id=$id")->save(array('picture'=>$file['thumbcut']));
					}
				}
				return $id;
			}
		}
		$this->error=$this->getError();
		return false;
	}
	
	//修改任务(第一步)
	function EditTask($post=array(),$isusefile=1){
		$id=$post['id'];
		if ($this->create($post)){
			if($this->where(" uid=$this->uid AND id=$id")->save()){
				//处理上传文件
				if($isusefile){
					$upload=new \Upload\Model\FileModel();
					$upload->UseFile('tid',$id);
					$file = $upload->token(false)->where(" tid=$id AND thumbcut is not null ")->order('dateline ASC')->find();
					if(!empty($file['thumbcut'])){
						$this->where(" uid=$this->uid AND id=$id")->save(array('picture'=>$file['thumbcut']));
					}
				}
			}
			return $id;
		}
		
		$this->error=$this->getError();
		return false;
	}
	
	
	//发布服务
	function InsertFuwu($post=array(),$isusefile=1){
		
		//是否开店
		if(M('Member')->token(false)->where("uid=$this->uid AND isshop=0")->count()){
			$this->error('对不起,您未开店不能操作！请先开通店铺！','/seller/shop');
			return false;
		}
		
		$allow=$this->CheckAllow(array(
			'addservice'=>$this->token(false)->where("uid=$this->uid AND type=2")->count() //发布服务数量
			)
		);
		
		if(!$allow){
			$this->error=$this->getError();
			return false;
		}
		
		if ($this->create($post)){
			if($id=$this->add()){
				$newdata=serialize($this->token(false)->where("type=2 AND uid=$this->uid ")->order('dateline DESC')->field('id,uid,username,dateline,subject,money,sell_number')->limit(3)->select());
				M('Member')->token(false)->where(" uid=$this->uid ")->save(array('newdata'=>$newdata));
				
				//审核-------------------------------
				if($this->CheckAllow(array('checkservice'=>0))){
					$this->where(" uid=$this->uid AND id=$id")->save(array('process'=>4));
					//通知-----------------------------------------------------------------------------------------
					$notice_subject='恭喜您，'.$id.'号服务审核通过';
					$notice_content='<a href="/shop/fuwu/'.$id.'" target="_blank">'.$post['subject'].'</a> 服务审核通过！';

					$notice=new \Member\Model\MemberNoticeModel();
					$notice->SendNotice(array('uid'=>$this->uid,'subject'=>$notice_subject,'content'=>$notice_content));
				}
				//-------------------------------
				
				//处理上传文件
				if($isusefile){
					$upload=new \Upload\Model\FileModel();
					$upload->UseFile('sid',$id);
					$file = $upload->token(false)->where(" sid=$id AND thumbcut is not null ")->order('dateline ASC')->find();
					if(!empty($file['thumbcut'])){
						$this->where(" uid=$this->uid AND id=$id")->save(array('picture'=>$file['thumbcut']));
					}
				}
				
				//通知-----------------------------------------------------------------------------------------	
				$event_content='发布了 <a href="/task/'.$id.'" target="_blank"><span class="color_f60">￥'.(number_format($post['money'],2)).'</span> '.$post['subject'].'</a> 服务';
				
				$feed=new \Member\Model\MemberFeedModel();
				$feed->InsertData($feed->FormatData(array('uid'=>$this->uid,'username'=>$this->username,'type'=>2,'content'=>$event_content,'url'=>U('/shop/fuwu/'.$id))));
			
			
				$socketparams=array('event'=>'fuwu','uid'=>0,'content'=>json_encode(array('uid'=>$this->uid,'date'=>FormatDate("d",NowTime()),'time'=>FormatDate("H:i",NowTime()),'username'=>$this->username,'touid'=>0,'avatar'=>GetAvatarSimple($this->uid,48,'socket_avatar badge-picture'),'message'=>'发布了 <span class="color_f60">￥'.(number_format($post['money'],2)).'</span> '.$post['subject'].' 服务.','url'=>U('/shop/fuwu/'.$id))));
				tag('SocketIO',$socketparams);
				
				//---------------------------------------------------------------------------------------------
			
				return $id;
			}
		}
		$this->error=$this->getError();
		return false;
	}
	
	//修改服务
	function EditFuwu($post=array(),$isusefile=1){
		$id=$post['id'];
		if ($this->create($post)){
			if($this->where(" uid=$this->uid AND id=$id")->save()){
				//处理上传文件
				if($isusefile){
					$upload=new \Upload\Model\FileModel();
					$upload->UseFile('sid',$id);
					$file = $upload->token(false)->where(" sid=$id AND thumbcut is not null ")->order('dateline ASC')->find();
					if(!empty($file['thumbcut'])){
						$this->where(" uid=$this->uid AND id=$id")->save(array('picture'=>$file['thumbcut']));
					}
				}
			}
			return $id;
		}
		
		$this->error=$this->getError();
		return false;
	}
	
	
	//数据是否存在
	function IsData($id=0){
		$id=intval($id);
		return $this->token(false)->where("id=$id")->count();
	}
	
	
	//获取一维数据
	function GetData($id=0,$uid=0){
		
		$where='';
		if(!empty($uid)){
			$where=" uid=$uid AND ";
		}
		$id=intval($id);
		$data = $this->token(false)->where($where." id=$id")->find();
		if(!empty($data['id'])){
			return $data;
		}
		$this->error='数据不存在!';
		return false;
	}
	
	//获取支付金额
	function GetPayMoney($id=0){
		$id=intval($id);
		$manage = $this->token(false)->where(" uid=$this->uid AND id=$id")->find();
		
		$total=$money=0;
		//悬赏
		if($manage['task_mode']==1){
			$money=$manage['task_number']*$manage['money']/100;
			
			$total+=$money;
			
			if($manage['top']){
				$total+=intval(C('tasktopfee'));
			}
			
			if($manage['robots']){
				$total+=intval(C('taskrobotsfee'));
			}  
			
			if($manage['hidetask']){
				$total+=intval(C('hidetaskfee'));
			} 
			
			if($manage['hidedraft']){
				$total+=intval(C('hidedraftfee'));
			}  
			
			if($manage['promise']){
				$total+=intval(C('taskpromisefee'));
			}  
		}
		
		if($manage['task_mode']==3){
			$total=$money=$manage['money']/100;
		}
		
		return array('money'=>$money,'total'=>$total,'task'=>$manage);
	}
	
	//显示任务状态
	function TaskStatus($process=0){
		switch($process){
			case 1:
				return '待支付托管金';
			break;
			case 2:
				return '买家已支付托管金';
			break;
			case 3:
				return '待审核';
			break;
			case 4:
				return '进行中';
			break;
			case 5:
				return '暂投稿中';
			break;
			case 6:
				return '待选稿中';
			break;
			case 7:
				return '退款中';
			break;
			case 8:
				return '结束';
			break;
			case 9:
				return '关闭';
			break;
			default:
		}
	}
	
	//发布任务状态
	function PublishTaskStatus($process=0){
		if($process>2){
			$this->error='对不起！任务不能操作！';
			return false;
		}
		return true;
	}
	
	//任务状态权限
	function TaskStatusAllow($process=0){
		switch($process){
			case 1:
				return '待支付托管金';
			break;
			case 2:
				return '买家已支付托管金';
			break;
			case 3:
				return '待审核';
			break;
			case 4:
				return '进行中';
			break;
			case 5:
				return '暂投稿中';
			break;
			case 6:
				return '待选稿中';
			break;
			case 7:
				return '退款中';
			break;
			case 8:
				return '结束';
			break;
			case 9:
				return '关闭';
			break;
			default:
		}
	}
	
	function PayTask($id=0){
		if(!$id){
			$id=intval($_POST['id']);
		}
		$pay=$this->GetPayMoney($id);

		if($pay['total']){
			$model=new \Consume\Model\ConsumeModel();
			$cid=$model->PayTask($id,$pay['total']);

			if($cid){
				//完成
				$this->TaskPayComplete($id,$cid,$pay['task']);
				return $id;
			}
		}else{
			$this->TaskPayComplete($id,0,$pay['task']);	
			return $id;
		}
		
		$this->error=$model->getError();
		return false;
		
	}
	
	//更新任务流程
	function UpdateTaskProcess($process,$id,$processorder=0){
		$post=array('process'=>$process);
		if($processorder){
			$post['process_time_'.$processorder]=NowTime();
			$post=array_merge($post,array('process_order'=>$processorder,'process_order_name'=>$this->processorderarr[$processorder]));
		}
		return $this->token(false)->where(" id=$id ")->save($post);
	}
	
	function TaskPayComplete($id=0,$cid=0,$task=array()){
		
		//通知
		
		//自动审核
		if(C('task_check')){

			$this->UpdateTaskProcess(4,$id,1);
			
			$send_subject=$task['username'].'发布了￥'.(number_format($task['money']/100,2)).'任务!';
			$send_content='发布了 <span class="color_f60">￥'.(number_format($task['money']/100,2)).'</span> '.$task['subject'].' 任务';
			
			$notice_subject='恭喜您，'.$id.'号任务审核通过';
			$notice_content='<a href="/task/'.$id.'" target="_blank">'.$task['subject'].'</a> 任务审核通过！';

			$notice=new \Member\Model\MemberNoticeModel();
			$notice->SendNotice(array('uid'=>$this->uid,'subject'=>$notice_subject,'content'=>$notice_content));
			
			$feed=new \Member\Model\MemberFeedModel();
			$feed->InsertData($feed->FormatData(array('uid'=>$this->uid,'username'=>$this->username,'type'=>1,'content'=>'发布了 <a href="/task/'.$id.'" target="_blank"><span class="color_f60">￥'.(number_format($task['money']/100,2)).'</span> '.$task['subject'].'</a> 任务','url'=>U('/task/'.$id))));
			
			$socketparams=array('event'=>'task','uid'=>0,'content'=>json_encode(array('uid'=>$task['uid'],'date'=>FormatDate("d",NowTime()),'time'=>FormatDate("H:i",NowTime()),'username'=>$task['username'],'touid'=>0,'avatar'=>GetAvatarSimple($task['uid'],48,'socket_avatar badge-picture'),'message'=>$send_content,'url'=>U('/task/'.$id))));
			tag('SocketIO',$socketparams);
				

		}else{
			$this->UpdateTaskProcess(3,$id,1);
		}
		
		$post=array('cid'=>$cid,'dateline'=>NowTime());
		if($task['task_mode']==2){
			$post['top']=0;
			$post['robots']=0;
			$post['hidetask']=0;
			$post['hidedraft']=0;
		}	
		
		//更新任务信息
		$this->token(false)->where(" id=$id ")->save($post);
		$tasknum=$this->token(false)->where(" uid=$this->uid ")->count();
		M('Member')->token(false)->where(" uid=$this->uid ")->save(array('task_number'=>$tasknum));
	
					 
		return true;
		  
	}
	
	function CheckAllow($allow=array()){
		$auth=new \Member\Model\AuthGroupModel();
		if($auth->UserAllow($allow)){
			return true;
		}else{
			$this->error=$auth->getError();
			return false;
		}
	}
	
	function PostDraft($isusefile=1,$id=0,$uid=0,$username='',$sid=0){
		if(!$id){
			$id=intval($_POST['id']);
		}
		
		if(!$uid){
			$uid=$this->uid;
		}
		
		if(!$username){
			$username=$this->username;
		}
		
		$oid=intval($_POST['oid']);
		if(!$uid){
			$this->error='对不起！请登录后操作！';
			return false;
		}
		
		$task = $this->token(false)->where("id=$id")->find();
		
		if(!empty($task['id']) && intval($task['process'])==4){
			
			$allow=$this->CheckAllow(array(
				'adddraft'=>'' //是否能投稿
				)
			);
			
			if(!$allow){
				$this->error=$this->getError();
				return false;
			}
			
			if($allow){

				if($uid==$task['uid']){ 
					$this->error='对不起！任务主不能自己投标！';
					return false;
				}
				
				$data=array('id'=>$id,'dateline'=>NowTime(),'buyer_uid'=>$task['uid'],'buyer_username'=>$task['username'],'seller_uid'=>$uid,'seller_username'=>$username);
				$_POST['content']=I('post.content','','strip_tags','',C('S_HTML_ALLOW'));
				$data['content']=String::msubstr(I('post.content','','htmlspecialchars'),0,999,C('S_CHARSET'),false);
				$data['SecurityForm']=I('post.SecurityForm');
				
				if($sid){
					$data['sid']=$sid;
				}
		
				if(empty($data['content'])){
					$this->error='对不起！请输入内容！';
					return false;
				}
				
				//招标
				if($task['task_mode']==2){
					$data['offer']= intval($_POST['offer'])>0 && intval($_POST['offer'])<100000 ? intval($_POST['offer']) : 0;
					$data['time']= intval($_POST['time'])>0 && intval($_POST['time'])<=31 ? intval($_POST['time']) : 0;
					
					if(empty($data['offer'])){
						$this->error='对不起！报价不能小于0元或大于100000元！';
						return false;
					}
					
					if(empty($data['time'])){
						$this->error='对不起！时间不能小于0天或大于31天！';
						return false;
					}
				}
				
				//计件
				if($task['task_number']>1){
					if($task['draft_notreviewed']>=$task['task_number']){
						$this->error='对不起！投稿名额已满,请等待雇主审核再投稿！';
						return false;
					}
				}

				if($oid>0 && M('DataOrder')->token(false)->where(" seller_uid=$uid AND oid=$oid")->count()){
					//修改
					$data['process']=0;
					M('DataOrder')->create($data);
					if(!M('DataOrder')->where(" seller_uid=$uid AND oid=$oid ")->save()){
						$this->error='对不起！修改错误！';
						return false;
					}
				}else{
					
					if($task['task_mode']==2){
						if(M('DataOrder')->token(false)->where(" seller_uid=$uid AND id=$id")->count()){
							$this->error='对不起！您已经投稿过了！';
							return false;
						} 
					}
					
					$data['subject']=$task['subject'];
					
					M('DataOrder')->token(false)->create($data);
					$oid=M('DataOrder')->token(false)->add();
				}
				
				if($oid){
					
					if($isusefile){
						$upload=new \Upload\Model\FileModel();
						$upload->UseFile('oid',$oid);
					}
			
					$draftnum=M('DataOrder')->token(false)->where(" id=$id ")->count();
					$draftnotreviewednum=M('DataOrder')->token(false)->where(" id=$id AND process=0")->count();
					$post=array('draft_number'=>$draftnum,'draft_notreviewed'=>$draftnotreviewednum);
					
					//更新任务订单流程 与时间
					$processorder=array();
					if($this->token(false)->where(" id=$id AND process_time_2=0 ")->count()){
						$processorder=array('process_order'=>2,'process_order_name'=>$this->processorderarr[2],'process_time_2'=>NowTime());
					}

					$this->token(false)->where(" id=$id ")->save(array_merge($post,$processorder));
					
					//用户
					$sellerdraftnumber=M('DataOrder')->token(false)->where(" seller_uid=$uid ")->count();
					M('Member')->token(false)->where(" uid=$uid ")->save(array('draft_number'=>$sellerdraftnumber));
					
					//通知-------------------------------------------------------------------------
					$notice_subject=$this->username.' 在 '.$task['id'].' 号任务投稿了.';
					$notice_content=$this->username.' 在 <a href="/task/'.$id.'" target="_blank">'.$task['subject'].'</a> 任务投稿了.';

					$notice=new \Member\Model\MemberNoticeModel();
					$notice->SendNotice(array('uid'=>$task['uid'],'subject'=>$notice_subject,'content'=>$notice_content));
					
					$feed=new \Member\Model\MemberFeedModel();
					$feed->InsertData($feed->FormatData(array('uid'=>$this->uid,'username'=>$this->username,'type'=>4,'content'=>' 在 <a href="/task/'.$id.'" target="_blank">'.$task['subject'].'</a> 任务投稿了.','url'=>U('/task/'.$id))));
			
					$socketparams=array('event'=>'fuwu','uid'=>0,'content'=>json_encode(array('uid'=>$this->uid,'date'=>FormatDate("d",NowTime()),'time'=>FormatDate("H:i",NowTime()),'username'=>$this->username,'touid'=>0,'avatar'=>GetAvatarSimple($this->uid,48,'socket_avatar badge-picture'),'message'=>'在 '.$task['subject'].' 任务投稿了.','url'=>U('/task/'.$id))));
					tag('SocketIO',$socketparams);
					//-----------------------------------------------------------------------------
				
					return array('oid'=>$oid,'task'=>$task);
				}else{
					$this->error=M('DataOrder')->getError();
					return false;
				}

			}else{
				$this->error=$errors;
				return false;

			}
			
		}else{
			$this->error='对不起！任务当前状态不能操作！';
			return false;
		}
	}
	
	//提交评论
	function PostComment($task=array()){
		
		$oid=intval($_POST['oid']);		
		
		$content=String::msubstr(I('post.content'),0,200,C('S_CHARSET'),false);
		if(!$task['id'] && !$oid && !$content){
			$this->error='对不起!评论不能空!';
			return false;
		}
		
		$data=array('oid'=>$oid,'id'=>$task['id'],'dateline'=>NowTime(),'content'=>$content,'adddate'=>@Date("Y-m-d H:i:s",NowTime()),'uid'=>$this->uid,'username'=>$this->username);
		
		$data['SecurityForm']=I('post.SecurityForm');

		M('DataOrderComment')->token(false)->create($data);
		
		$cid=M('DataOrderComment')->token(false)->add();

		if($cid){
			//更新 data_order
			$commentnum=M('DataOrderComment')->token(false)->where(" oid=$oid ")->count();
			
			$comment=M('DataOrderComment')->token(false)->where(" oid=$oid ")->order('dateline ASC')->limit(5)->select();
			
			$num=count($comment);
			for($i=0;$i<$num;$i++){
				$comment[$i]['avatar']=GetAvatarSimple($comment[$i]['uid'],48,'img-rounded');
			}

			M('DataOrder')->token(false)->where(" oid=$oid ")->save(array('comment'=>serialize($comment),'comment_num'=>$commentnum));

			$this->success='提交成功！';
			return array('comment_num'=>$commentnum,'comment'=>$comment);
		}else{
			$this->error=M('DataOrderComment')->getError();
			return false;
		}
	}

	//中标设置
	function SetSuccess($task=array(),$oid=0){
		$id=intval($task['id']);
		$oid=intval($oid);
		
		if(@time()>$task['endtime']){
			$this->error='任务已截止投稿！';
			return false;
		}
		
		//任务状态
		if($task['process']>3 && $task['process']<7 && $oid>0){
			
			if($task['uid']==$this->uid ){ //|| IsService($task['serviceuid']) || IsAdmin()
					 
				M('DataOrder')->startTrans();
				
				//计件
				if($task['task_number']>1){
					if($task['draft_success']>=$task['task_number']){
						$this->error='对不起！中标名额已满！';
						return false;
					}
				}
				
				$draft= M('DataOrder')->token(false)->lock(true)->where(" oid=$oid ")->find();
				
				if(!empty($draft['oid']) && intval($draft['process'])==0){
					
					//生成订单-------------------------------------------------------------------------------------
					$model=new \Consume\Model\ConsumeModel();
					//招标
					if($task['task_mode']==2 && $task['task_number']==1 && $draft['offer'] && $draft['time']){
						//托管
						$cid=$model->PayTask($id,$draft['offer']);
						if(!$cid){
							$this->error=$model->getError();
							return false;
						}
					}
					
					$payorder=$model->PayCreateTaskOrder($task,$draft);

					//生成订单 end-------------------------------------------------------------------------------------
				}else{
					$this->error='当前稿件状态不能操作！';
					return false;
				}
		
				M('DataOrder')->commit();
				
				
				if(!empty($payorder['cid'])){
					
					//更新稿件信息-------------------------------------------------------------------------------------
					M('DataOrder')->token(false)->where(" oid=$oid ")->save(array('cid'=>$payorder['cid']));
					
					//更新任务信息-------------------------------------------------------------------------------------
					$tasksuccessnum=M('DataOrder')->token(false)->where(" id=$id AND process=1")->count();
					$draftnotreviewednum=M('DataOrder')->token(false)->where(" id=$id AND process=0")->count();
					$draft_success_id=$oid;
					if($task['draft_success_id']){
						$draft_success_id=$task['draft_success_id'].','.$oid;
					}

					$post=array('draft_notreviewed'=>$draftnotreviewednum,'process_time_3'=>NowTime(),'process_order'=>3,'process_order_name'=>$this->processorderarr[3],'draft_success'=>$tasksuccessnum,'draft_success_id'=>$draft_success_id);

					if($task['task_number']==1){
						$post['autopaytime']=$payorder['runtime'];
					}else{
						//更新中标头像
						$avatarsuccess=explode(',',$task['avatar_success']);
						$avatarsuccessnum=intval(count($avatarsuccess));
						if($avatarsuccessnum>=12){
							unset($avatarsuccess[0]);
						}
						if(!empty($task['avatar_success'])){
							$post['avatar_success']=implode(',',$avatarsuccess);
							$post['avatar_success'].=','.GetAvatarSimple($draft['seller_uid'],48,'img-rounded');
						}else{
							$post['avatar_success']=GetAvatarSimple($draft['seller_uid'],48,'img-rounded');
						}
					}
					
					if($tasksuccessnum>=$task['task_number']){
						$post['process']=5;
					}
					
					if(!$task['cid'] && !empty($cid)){
						$post['cid']=$cid;
					}
					
					$this->token(false)->where(" id=$id ")->save($post);
					//更新任务信息 end-------------------------------------------------------------------------------------
					
					
					//更新用户信息-------------------------------------------------------------------------------------
					$selleruid=$draft['seller_uid'];
					$sellersuccessnumber=M('DataOrder')->token(false)->where(" seller_uid=$selleruid AND process=1")->count();
					M('Member')->token(false)->where(" uid=$selleruid ")->save(array('success_number'=>$sellersuccessnumber));
					//更新用户信息 end-------------------------------------------------------------------------------------
					
					
					//更新推广用户信息-------------------------------------------------------------------------------------
					
					//更新推广用户信息 end-------------------------------------------------------------------------------------
					
					
					//发送中标信息-------------------------------------------------------------------------------------
					//通知-------------------------------------------------------------------------
					$notice_subject='恭喜您，您的 '.$draft['oid'].' 稿件中标了.';
					$notice_content='在 <a href="/task/'.$id.'/'.$draft['oid'].'" target="_blank">'.$task['subject'].'</a> 任务的投稿中标了.';
					
					$feed=new \Member\Model\MemberFeedModel();
					$feed->InsertData($feed->FormatData(array('uid'=>$draft['seller_uid'],'username'=>$draft['seller_username'],'type'=>5,'content'=>' 的 <a href="/task/'.$id.'" target="_blank">'.$draft['oid'].'</a> 号稿件中标.','url'=>U('/task/'.$id))));

					$notice=new \Member\Model\MemberNoticeModel();
					$notice->SendNotice(array('uid'=>$selleruid,'subject'=>$notice_subject,'content'=>$notice_content));
					//发送中标信息end-------------------------------------------------------------------------------------
					
					return $oid;
					
				}else{
					$this->error=$model->getError();
					return false;
				}
			}else{
				$this->error='对不起！您没有权限操作';
				return false;
			}
		}else{
			$this->error='任务状态不能操作！';
			return false;
		}
	}
	
	function SetFailure($task=array(),$oid=0){
		$id=intval($task['id']);
		$oid=intval($oid);
		//任务状态
		$draft= M('DataOrder')->token(false)->lock(true)->where(" oid=$oid ")->find();
		
		if($task['process']>3 && $task['process']<7 && $draft['oid']>0){
			
			if($task['uid']==$this->uid ){
				
				M('DataOrder')->token(false)->where(" oid=$oid ")->save(array('process'=>2,'verifytime'=>NowTime()));
				
				//更新任务信息-------------------------------------------------------------------------------------
				$taskfailurenum=M('DataOrder')->token(false)->where(" id=$id AND process=2")->count();
				$draftnotreviewednum=M('DataOrder')->token(false)->where(" id=$id AND process=0")->count();
				$draft_success_id=$oid;
				if($task['draft_success_id']){
					$draft_success_id=$task['draft_success_id'].','.$oid;
				}
				
				$this->token(false)->where(" id=$id ")->save(array('draft_notreviewed'=>$draftnotreviewednum,'draft_failure'=>$taskfailurenum));
				//更新任务信息 end-------------------------------------------------------------------------------------
				
				
				//更新用户信息-------------------------------------------------------------------------------------
				
				//更新用户信息 end-------------------------------------------------------------------------------------
				
				
				//发送失败信息-------------------------------------------------------------------------------------
				//通知-------------------------------------------------------------------------
				$notice_subject='您的 '.$oid.' 号稿件不合格.';
				$notice_content='您在 <a href="/task/'.$id.'/'.$oid.'" target="_blank">'.$task['subject'].'</a> 任务的投稿不合格.';

				$notice=new \Member\Model\MemberNoticeModel();
				$notice->SendNotice(array('uid'=>$draft['seller_uid'],'subject'=>$notice_subject,'content'=>$notice_content));
				//发送失败信息end-------------------------------------------------------------------------------------
				return $oid;
			}else{
				$this->error='对不起！您没有权限操作';
				return false;
			}
		}else{
			$this->error='任务状态不能操作！';
			return false;
		}
	}
	
	function FailureDraft($task=array()){
		return $this->SetFailure($task,$_POST['oid']);
	}
	
	//稿件中标
	function SuccessDraft($task=array()){
		return $this->SetSuccess($task,$_POST['oid']);
	}
	
	//退款
	function RefundOrder($task=array()){
		$id=intval($task['id']);
		$oid=intval($_POST['oid']);
		$refundmoney=intval($_POST['refund']);
		
		$model=new \Consume\Model\ConsumeModel();
		$model->startTrans();
		$consume=$model->token(false)->lock(true)->where(" payin_uid=1 AND dataid=$id AND process=5 AND amount>0 ")->find();
		if(empty($consume['amount'])){
			$this->error='任务未托管不能操作！';
			return false;
		}
		$model->commit();
		
		$draft= M('DataOrder')->token(false)->where(" oid=$oid ")->find();
		
		if(($refundmoney*100) >$consume['amount']){
			$this->error='退款金额最大'.($consume['amount']/100).'元';
			return false;
		}
		
		if($refundmoney<1){
			$this->error='退款金额最小1元';
			return false;
		}
		
		M('Refund')->startTrans();
		if(M('Refund')->token(false)->where(" id=$id ")->count()){
			$this->error='该任务已申请退款过了！';
			return false;
		}
		M('Refund')->commit();
			
		
		//任务状态
		if($task['process']>3 && $task['process']<7 && $draft['oid']>0){
			
			//退款交接 加 1个月时间
			$runtime=$task['autopaytime']+31*24*30*30;
			$post=array('autopaytime'=>$runtime);
			
			//支付订单是否存在
			$model->startTrans();
			$payoutarr=$model->token(false)->lock(true)->where(" payout_uid=1 AND dataid=$id AND process=3")->find();
			$cid=$payoutarr['id'];
			if(!$cid){
				$this->error='任务流程操作错误！';
				return false;
			}
			$model->token(false)->where(" payout_uid=1 AND dataid=$id AND process=3 ")->save($post);
			$model->commit();
			$this->startTrans();
			$this->token(false)->where(" id=$id ")->save($post);
			$this->commit();
			
			$refund=array();
			$refund['cid']=$cid;
			$refund['oid']=$oid;
			$refund['id']=$id;
			$refund['subject']=$task['subject'];
			$refund['money']=$payoutarr['amount'];
			$refund['refund']=$refundmoney*100;	
			$refund['buyer_uid']=$draft['buyer_uid'];
			$refund['buyer_username']=	$draft['buyer_username'];
			$refund['seller_uid']=$draft['seller_uid'];	
			$refund['seller_username']=$draft['seller_username'];
			$refund['process']=1;
			$refund['dateline']=NowTime();
			$refund['service_uid']=$task['service_uid'];
			$refund['service_username']=$task['service_username'];

			M('Refund')->startTrans();
			if (M('Refund')->token(false)->create($refund)){
				if($id=M('Refund')->token(false)->add()){
					M('Refund')->commit();
					
					//发通知
					
					
					return $id;
				}
			}
		
			M('Refund')->commit();
			$this->error=M('Refund')->getError();
			return false;
		
		}else{
			$this->error='任务状态不能操作！';
			return false;
		}
	}
	
	//交接原件
	function DeliveryDraft($task=array()){
		$id=intval($task['id']);
		$oid=intval($_POST['oid']);
		$draft= M('DataOrder')->token(false)->where(" oid=$oid ")->find();
		//任务状态
		if($task['process']>3 && $task['process']<7 && $draft['oid']>0){
			
			$model=new \Consume\Model\ConsumeModel();
			if($runtime=$model->PayDeliveryTaskOrder($task,$draft)){
				$this->startTrans();
				$this->token(false)->where(" id=$id ")->save(array('process_time_4'=>NowTime(),'process_order'=>4,'process_order_name'=>$this->processorderarr[4],'autopaytime'=>$runtime));
				M('DataOrder')->token(false)->where(" id=$id AND oid=$oid ")->save(array('seller_is_complete'=>1));
				$upload=new \Upload\Model\FileModel();
				$upload->UseFile('oid',$oid);	
				
				//发通知------------------------------------------------------
				$notice_subject=$oid.' 号稿件已提交原件交接';
				$notice_content='<a href="/task/'.$id.'" target="_blank">'.$task['subject'].'</a> 任务的中标稿件已提交原件交接.';

				$notice=new \Member\Model\MemberNoticeModel();
				$notice->SendNotice(array('uid'=>$task['uid'],'subject'=>$notice_subject,'content'=>$notice_content));
				//------------------------------------------------------------
				
				$this->commit();
				return true;
			}else{
				$this->error=$model->getError();
				return false;
			}
		}else{
			$this->error='任务状态不能操作！';
			return false;
		}
	}
	
	//支付订单
	function PayOrder($task=array(),$oid=0){
		$id=intval($task['id']);
		if(!$oid){
			$oid=intval($_POST['oid']);
		}
		$draft= M('DataOrder')->token(false)->where(" oid=$oid ")->find();
		//任务状态
		if($task['process']>3 && $task['process']<7 && $draft['oid']>0){
			$this->startTrans();
			$this->token(false)->where(" id=$id ")->save(array('process'=>8,'process_time_5'=>NowTime(),'process_order'=>5,'process_order_name'=>$this->processorderarr[5]));
			$this->commit();
			
			$model=new \Consume\Model\ConsumeModel();
			if($model->PaySuccessTaskOrder($task,$draft)){
				
				//发通知------------------------------------------------------
				$notice_subject=$oid.' 号稿件雇主已确认支付';
				$notice_content='<a href="/task/'.$id.'/'.$oid.'" target="_blank">'.$task['subject'].'</a> 任务的中标稿件雇主已确认支付.';

				$notice=new \Member\Model\MemberNoticeModel();
				$notice->SendNotice(array('uid'=>$draft['seller_uid'],'subject'=>$notice_subject,'content'=>$notice_content));
				//------------------------------------------------------------
				
				return true;
			}else{
				$this->error=$model->getError();
				return false;
			}
		}else{
			$this->error='任务状态不能操作！';
			return false;
		}
	}
	
	//评价
	function Evaluate($task=array()){
		$id=intval($task['id']);
		$oid=intval($_POST['oid']);
		$draft= M('DataOrder')->token(false)->where(" oid=$oid ")->find();
		//任务状态
		if($task['process']>=4 && $draft['oid']>0){

			if($this->uid==$draft['buyer_uid']){
				//是否评价
				if(M('DataOrder')->token(false)->where(" oid=$oid AND buyer_is_evaluate=1")->count()){
					$this->error='您已评价过了！';
					return false;
				}
				
				//买家评价卖家
				$data['buyer_is_evaluate']=1;
				$data['buyer_evaluate_content']=String::msubstr(I('post.content'),0,60,C('S_CHARSET'),false);
				$data['buyer_evaluate']=intval($_POST['evaluate']) ? intval($_POST['evaluate']) : 1;
				$data['buyer_works_peed']=intval($_POST['workspeed'])>=0 && intval($_POST['workspeed'])<6 ? intval($_POST['workspeed']) : 5;
				$data['buyer_works_attitude']=intval($_POST['worksattitude'])>=0 && intval($_POST['worksattitude'])<6 ? intval($_POST['worksattitude']) : 5;
				$data['buyer_works_quality']=intval($_POST['worksquality'])>=0 && intval($_POST['worksquality'])<6 ? intval($_POST['worksquality']) : 5;
				$data['buyer_evaluate_time']=NowTime();
				
				//更新卖家-----------------------------------------------------------------------------------
				$selleruid=$draft['seller_uid'];
				$sellerarray= M('Member')->token(false)->where(" uid=$selleruid ")->field('buyer_level,seller_level,seller_haoping,seller_zhongping,seller_chaping,buyer_haoping,buyer_zhongping,buyer_chaping,seller_works_peed,seller_works_attitude,seller_works_quality')->find();
				if($data['buyer_works_peed']){
					$sellerdata['seller_works_peed']=intval(($sellerarray['seller_works_peed']+$data['buyer_works_peed']*100)/2);
				}
				if($data['buyer_works_attitude']){
					$sellerdata['seller_works_attitude']=intval(($sellerarray['seller_works_attitude']+$data['buyer_works_attitude']*100)/2);
				}
				if($data['buyer_works_quality']){
					$sellerdata['seller_works_quality']=intval(($sellerarray['seller_works_quality']+$data['buyer_works_quality']*100)/2);
				}
				//-------------------------------------------------------------------------------------------
				
				//通知-------------------------------------------------------------------------
				$notice_subject='买家已评价 '.$oid.' 号稿件.';
				$notice_content='买家已评价 <a href="/task/'.$id.'/'.$oid.'" target="_blank">查看详细</a>';

				$notice=new \Member\Model\MemberNoticeModel();
				$notice->SendNotice(array('uid'=>$selleruid,'subject'=>$notice_subject,'content'=>$notice_content));
				//-----------------------------------------------------------------------------
				
			}elseif($this->uid==$draft['seller_uid']){
				$buyeruid=$draft['buyer_uid'];
				//是否评价
				if(M('DataOrder')->token(false)->where(" oid=$oid AND seller_is_evaluate=1")->count()){
					$this->error='您已评价过了！';
					return false;
				}
				
				//卖家评价买家
				$data['seller_is_evaluate']=1;
				$data['seller_evaluate_content']=String::msubstr(I('post.content'),0,60,C('S_CHARSET'),false);
				$data['seller_evaluate']=intval($_POST['evaluate']) ? intval($_POST['evaluate']) : 1;
				$data['seller_evaluate_time']=NowTime();
				
				//通知-------------------------------------------------------------------------
				$notice_subject='卖家已评价 '.$oid.' 号稿件.';
				$notice_content='卖家已评价 <a href="/task/'.$id.'/'.$oid.'" target="_blank">查看详细</a>';

				$notice=new \Member\Model\MemberNoticeModel();
				$notice->SendNotice(array('uid'=>$buyeruid,'subject'=>$notice_subject,'content'=>$notice_content));
				//-----------------------------------------------------------------------------
			}else{
				$this->error='没有权限操作！！';
				return false;
			}
			
			if(M('DataOrder')->token(false)->where(" oid=$oid ")->save($data)){
				
				if(!empty($draft['sid'])){
					//更新出售
					$sid=intval($draft['sid']);
					$snum=M('DataOrder')->token(false)->where(" sid=$sid AND process=1 ")->count();
					$buyerevaluatenum=M('DataOrder')->token(false)->where(" sid=$sid AND process=1 AND buyer_is_evaluate=1 ")->count();
					$sellerevaluatenum=M('DataOrder')->token(false)->where(" sid=$sid AND process=1 AND seller_is_evaluate=1 ")->count();
					$this->token(false)->where(" id=$sid ")->save(array('sell_number'=>$snum,'buyer_evaluate_number'=>$buyerevaluatenum,'seller_evaluate_number'=>$sellerevaluatenum,'seller_works_peed'=>$sellerdata['seller_works_peed'],'seller_works_attitude'=>$sellerdata['seller_works_attitude'],'seller_works_quality'=>$sellerdata['seller_works_quality']));
				}
					
				//双方是否已评价
				if(M('DataOrder')->token(false)->where(" oid=$oid AND buyer_is_evaluate=1 AND seller_is_evaluate=1")->count()){
					if($task['task_number']>1){
						$posttask=array('endtime'=>NowTime(),'process_time_4'=>NowTime(),'process_order'=>4,'process_order_name'=>$this->processorderarr[6]);
					}else{
						$posttask=array('endtime'=>NowTime(),'process_time_6'=>NowTime(),'process_order'=>6,'process_order_name'=>$this->processorderarr[6]);
					}
					$this->token(false)->where(" id=$id ")->save($posttask);
				}
				
				//更新个人信用				
				//卖家--------------------------------------------------------------------------------------------------------------
				if($selleruid){
					$sellerdata['seller_haoping']=M('DataOrder')->token(false)->where(" seller_uid=$selleruid AND buyer_is_evaluate=1 AND buyer_evaluate=1 ")->count();
					$sellerdata['seller_zhongping']=M('DataOrder')->token(false)->where(" seller_uid=$selleruid AND buyer_is_evaluate=1 AND buyer_evaluate=2 ")->count();
					$sellerdata['seller_chaping']=M('DataOrder')->token(false)->where(" seller_uid=$selleruid AND buyer_is_evaluate=1 AND buyer_evaluate=3 ")->count();
					$sellerdata['seller_level']=$this->GetCreditLevel(1,$sellerdata['seller_haoping']-$sellerdata['seller_chaping']);
					$sellerdata['seller_haopinglu']=intval($sellerdata['seller_haoping']/($sellerdata['seller_haoping']+$sellerdata['seller_zhongping']+$sellerdata['seller_chaping'])*10000);
			
					//等级
					$consume=new \Consume\Model\ConsumeModel();
					$abilitylevel=$sellerdata['ability_level']=round($consume->GetTransactionMoney($selleruid) * $sellerdata['seller_haopinglu']/10000,2,PHP_ROUND_HALF_DOWN);
					$level= M('MemberLevel')->token(false)->where(" $abilitylevel >=small AND $abilitylevel <= big ")->find();
					if(!empty($level['id'])){
						$sellerdata['level']=$level['id'];
					}
					
					M('Member')->token(false)->where(" uid=$selleruid ")->save($sellerdata);
				}
				//--------------------------------------------------------------------------------------------------------------
				
				
				//买家--------------------------------------------------------------------------------------------------------------
				if($buyeruid){
					$buyerdata['buyer_haoping']=M('DataOrder')->token(false)->where(" buyer_uid=$buyeruid AND seller_is_evaluate=1 AND seller_evaluate=1 ")->count();
					$buyerdata['buyer_zhongping']=M('DataOrder')->token(false)->where(" buyer_uid=$buyeruid AND seller_is_evaluate=1 AND seller_evaluate=2 ")->count();
					$buyerdata['buyer_chaping']=M('DataOrder')->token(false)->where(" buyer_uid=$buyeruid AND seller_is_evaluate=1 AND seller_evaluate=3 ")->count();
					$buyerdata['buyer_level']=$this->GetCreditLevel(2,$sellerdata['buyer_haoping']-$sellerdata['buyer_chaping']);
					$buyerdata['buyer_haopinglu']=intval($sellerdata['buyer_haoping']/($sellerdata['buyer_haoping']+$sellerdata['buyer_zhongping']+$sellerdata['buyer_chaping'])*10000);
					M('Member')->token(false)->where(" uid=$buyeruid ")->save($buyerdata);
				}
				//--------------------------------------------------------------------------------------------------------------
				
				
				
				return true;
			}else{
				$this->error=M('DataOrder')->getError();
				return false;
			}
			
		}else{
			$this->error='任务状态不能操作！';
			return false;
		}
	}
	
	//1 卖 2买
	function GetCreditLevel($type=1,$credit=0){
		if($credit>0){
			$level= M('ShopLevel')->token(false)->where(" type=$type AND $credit>=small AND $credit<=big ")->find();
			if(!empty($level['imgid'])){
				return $level['imgid'];
			}
		}
		
		return 0;
	}
	
	
	//更新数据
	function UpdateData($id=0){
		//访问数量
		$this->token(false)->where(" id=$id ")->setInc('show_number');
	}
	
	//收藏
	function Favorites(){
		$this->startTrans();
		$data=$this->GetData(intval($_POST['id']));
		$id=$data['id'];
		if(empty($id)){
			$this->error='数据不在！';
			return false;
		}
		if(M('Favorites')->token(false)->where(" id=$id AND uid=$this->uid ")->count()){
			$this->error='您已收藏了！';
			return false;
		}
		
		$post=array('type'=>$data['type'],'id'=>$id,'dateline'=>NowTime(),'uid'=>$this->uid);
		
		if (M('Favorites')->token(false)->create($post)){
			if($fid=M('Favorites')->token(false)->add()){
				$favoritesnum=M('Favorites')->token(false)->where(" id=$id ")->count();
				$this->token(false)->where(" id=$id ")->save(array('favorites_number'=>$favoritesnum));
				$this->commit();
				return $fid;
			}
		}
		$this->commit();
		$this->error=M('Favorites')->getError();
		return false;
	}
	
	//留言
	function Message(){
	
		$data=$this->GetData(intval($_POST['id']));
		$id=$data['id'];
		if(empty($id)){
			$this->error='数据不在！';
			return false;
		}
		
		$post=array('id'=>$id,'dateline'=>NowTime(),'uid'=>$this->uid,'username'=>$this->username);
		$post['content']=String::msubstr(I('post.content'),0,200,C('S_CHARSET'),false);
		
		if(empty($post['content'])){
			$this->error='请输入留言内容！';
			return false;
		}
		
		if (M('DataMessage')->token(false)->create($post)){
			if($mid=M('DataMessage')->token(false)->add()){
				$messagenumber=M('DataMessage')->token(false)->where(" id=$id ")->count();
				$this->token(false)->where(" id=$id ")->save(array('message_number'=>$messagenumber));
				return $mid;
			}
		}
		$this->error=M('DataMessage')->getError();
		return false;
	}
	
	//留言列表
	function ListMessage(){
		$id=intval($_GET['id']);
		$pagenum=intval($_GET['p']);
		
		$datamessage=M('DataMessage')->token(false)->where(" id=$id ")->order($order)->page($pagenum,5)->select();
		
		if(!empty($datamessage)){
			$num=count($datamessage);
			for($i=0;$i<$num;$i++){
				$datamessage[$i]['avatar']=GetAvatarSimple($datamessage[$i]['uid'],48,'img-rounded');
				$datamessage[$i]['adddate']=FormatDate("Y-m-d H:i",$datamessage[$i]['dateline']);
			}
		}
		
		$count=M('DataMessage')->token(false)->where(" id=$id ")->count();
		$Page = new \Think\Page($count,5);
		if($Page->show()){
			$pagemessage=preg_replace("/href=\"(.*?)\"/i","href=\"javascript:GetDataMessage('$1')\"",$Page->show());
		}	
		
		return array('list'=>$datamessage,'pagemessage'=>$pagemessage);
	}
	
	//举报
	function Report(){
		$post['uid']=$this->uid;
		$post['content']=String::msubstr(I('post.content'),0,100,C('S_CHARSET'),false);
		$rid=intval($_POST['rid']);
		$post['id']=intval($_POST['id']);
		$oid=$post['oid']=intval($_POST['oid']);
		$post['dateline']=NowTime();
		
		$reporttype= M('ReportType')->token(false)->where(" rid=$rid ")->find();
		
		if(empty($reporttype['rid'])){
			$this->error='数据不在！';
			return false;
		}
		
		$data=$this->GetData($post['id']);
		$id=$data['id'];
		if(empty($id)){
			$this->error='数据不在！！';
			return false;
		}
		
		if($data['type']==1){
			//任务
			$post['url']='/task/'.$id;
			$post['subject']='#'.$id.'号任务';
		}elseif($data['type']==2){
			//服务
			$post['url']='/fuwu/'.$id;
			$post['subject']='#'.$id.'号服务';
		}
		
		$post['ruid']=$data['uid'];
		
		$where=" AND oid=0 ";
		if($oid){
			$order= M('DataOrder')->token(false)->where(" oid=$oid ")->find();
			if(empty($order)){
				$this->error='数据不在！！！';
				return false;
			}
			$where=" AND oid=$oid ";
			$post['url'].='/'.$oid;
			$post['subject'].='第 #'.$oid.'号稿件';
			$post['ruid']=$order['seller_uid'];
		}
		
		$post['subject'].=','.$reporttype['name'];
		
		if(M('Report')->token(false)->where(" id=$id AND uid=$this->uid ".$where)->count()){
			$this->error='您已举报过了！';
			return false;
		}
		
		if (M('Report')->token(false)->create($post)){
			if($id=M('Report')->token(false)->add()){
				return $id;
			}
		}
		
		$this->error=M('Report')->getError();
		return false;
		
	}
	
	//获取雇用信息
	function EmployInfo(){
		$uid=intval($_GET['uid']);
		$id=intval($_GET['id']);
		if($uid>0 && !$id){
			//用户
			$model=new \Member\Model\MemberModel();
			$data=$model->UidGetMember($uid);
			if(!empty($data['uid'])){
				$data=array('uid'=>$data['uid'],'username'=>$data['username'],'groupname'=>$data['groupname'],'shopname'=>$data['shopname'],'task_number'=>$data['task_number'],'draft_number'=>$data['draft_number'],'success_number'=>$data['success_number'],'provname'=>$data['provname'],'cityname'=>$data['cityname'],'distname'=>$data['distname'],'moneyin'=>$data['moneyin']);
				$data['picture']=GetAvatarSimple($data['uid'],120);
				return $data;
			}
		}elseif($uid>0 && $id>0){
			//服务
			$data=$this->GetData($id,$uid);
			if(!empty($data['id'])){
				if($data['type']==2){
					return $data;
				}
			}
		}
		return false;
	}
	
	//雇用购买
	function EmployBuy(){
		$post['id']=intval($_POST['id']);
		$post['uid']=intval($_POST['uid']);
		$post['money']=intval($_POST['money']);
		$post['phone']=IsNum($_POST['phone']) ? String::msubstr($_POST['phone'],0,12,C('S_CHARSET'),false) : 0;
		$post['content']=String::msubstr(I('post.content','','htmlspecialchars'),0,999,C('S_CHARSET'),false);
		
		if($post['money']<1){
			$this->error='购买金额不能小于1元！';
			return false;
		}
		
		if(empty($post['phone']) || empty($post['content'])){
			$this->error='请填写手机号码和需求内容！';
			return false;
		}
		
		if($post['id']>0 && $post['uid']>0){
			$data=$this->GetData($post['id'],$post['uid']);
			
			if(!empty($data['id'])){
				if($data['type']==2){
					if($data['uid']==$this->uid){
						$this->error='不能购买自己服务！';
						return false;
					}
					
					//未审核不能购买
					if($data['process']!=4){
						$this->error='该服务未审核,暂时不能购买！';
						return false;
					}
				
					return $this->EmployPay(1,$post,$data);
				}
			}
		}elseif(!$post['id'] && $post['uid']>0){
			$model=new \Member\Model\MemberModel();
			$data=$model->UidGetMember($post['uid']);
			if(!empty($data['uid'])){
				
				if($data['uid']==$this->uid){
					$this->error='不能雇用自己！';
					return false;
				}
				
				return $this->EmployPay(2,$post,$data);
			}
		}

		$this->error='数据不在！';
		return false;
		
	}
	
	//type 1购买服务 2雇用服务商
	function EmployPay($type,$post,$data){
		unset($post['id']);	
		$post['task_mode']=3;
		$post['type']=1; //数据类型
		$post['endtime_number']=!empty($data['endtime']) ?  intval($data['endtime']) : C('task_endtime');
		$post['endtime']=time()+ ($post['endtime_number']*24*60*60);
		$post['uid']=$this->uid;
		$post['username']=$this->username;
		$post['subject']=$data['subject'] ? $data['subject'] : '雇用'.$data['username'];
		$post['dateline']=NowTime();
		$post['adddate']=FormatDate("Y-m-d",NowTime());
		$post['SecurityForm']=I('post.SecurityForm');
		$post['task_number']=1;
		
		//检查用户金额
		$model=new \Consume\Model\ConsumeModel();
		if(!$model->CheckUserMoney($this->uid,$post['money']*100)){
			$this->error='您的可用金额不足'.$post['money'].'元,请充值后操作！';
			return false;
		}
		
		$post['money']=$post['money']*100;
		
		//入库任务
		if ($this->token(false)->create($post)){
			if($id=$this->token(false)->add()){
				$upload=new \Upload\Model\FileModel();
				$upload->UseFile('tid',$id);		
				//支付托管
				if($this->PayTask($id)){
					//交稿
					$_POST['content']=($post['money']/100).'元';
					if($result=$this->PostDraft(0,$id,$data['uid'],$data['username'],intval($data['id']))){
						//中标
						if($this->SetSuccess($result['task'],$result['oid'])){
							
							$feed=new \Member\Model\MemberFeedModel();
							$feed->InsertData($feed->FormatData(array('uid'=>$this->uid,'username'=>$this->username,'type'=>3,'content'=>'雇用了 <a href="/shop/'.$data['uid'].'" target="_blank">'.$data['username'].'</a> ￥'.(number_format($post['money']/100,2)))));
			
							return $id;
						}
					}
				}
			}
		}
		return false;
	}
	
	//服务列表
	function GetFuwuList($ismap=''){
		$pagenum=intval($_GET['p']);
		
		$selectwhere=$this->SelectFuwuWhere();
		$wheresql=$selectwhere[0];
		$order=$this->OrderFuwuWhere();
		
		if($ismap=='map'){
			$shownum=100;
		}else{
			$shownum=20;
		}
		
		//数据-------------------------------
		$list=$this->token(false)->where($wheresql,$selectwhere[4])->order($order)->page($pagenum,$shownum)->select();

		//页码-------------------------------
		$count=$this->token(false)->where($wheresql,$selectwhere[4])->count();
		$Page = new \Think\Page($count,$shownum);
	
		$newpage=str_replace("Index/index/catid/",'',$Page->show());
		$newpage=str_replace("Index/index/",'',$newpage);
		$newpage=str_replace("/m/fuwu",'',$newpage);
		$newpage=str_replace("buy/",'b',$newpage);
		$newpage=str_replace("order/",'o',$newpage);
		$newpage=str_replace("search",'s',$newpage);
		$newpage=str_replace("time/",'t',$newpage);
		$newpage=str_replace("city/",'c',$newpage);
		return array('list'=>$list,'page'=>$newpage,'cityname'=>$selectwhere[1],'category'=>$selectwhere[2],'route'=>$selectwhere[3],'search'=>$selectwhere[4],'categoryone'=>$selectwhere[5],'categorycity'=>$selectwhere[6]);
	}
	
	//服务排序SQL
	function OrderFuwuWhere(){
		$ordersql='top DESC,dateline DESC';
		
		$order=intval($_GET['order']);
		if($order==1){
			$ordersql='top DESC';
		}elseif($order==2){
			$ordersql='dateline DESC';
		}elseif($order==3){
			$ordersql='sell_number DESC';
		}elseif($order==4){
			$ordersql='money DESC';
		}
		
		return $ordersql;
	}
	
	//服务筛选SQL
	function SelectFuwuWhere(){
		$where=' type=2 AND process=4 ';
				
		$buy=intval($_GET['buy']);
		if($buy==1){
			$where.=' AND sell_number>0 ';
		}elseif($buy==2){
			$where.=' AND sell_number=0 ';
		}

		$time=intval($_GET['time']);
		if($time==1){
			$where.=" AND dateline>=UNIX_TIMESTAMP(timestamp(date(sysdate()))) AND dateline<=(UNIX_TIMESTAMP()+86400) ";
		}elseif($time==2){
			$where.=" AND dateline>=(UNIX_TIMESTAMP()-86400) AND dateline<=UNIX_TIMESTAMP(timestamp(date(sysdate()))) ";
		}elseif($time==3){
			$where.=" AND dateline>=(UNIX_TIMESTAMP()-259200) AND dateline<=UNIX_TIMESTAMP(timestamp(date(sysdate()))) ";
		}elseif($time==4){
			$where.=" AND dateline>=(UNIX_TIMESTAMP()-604800) AND dateline<=UNIX_TIMESTAMP(timestamp(date(sysdate()))) ";
		}elseif($time==5){
			$where.=" AND dateline>=(UNIX_TIMESTAMP()-2592000) AND dateline<=UNIX_TIMESTAMP(timestamp(date(sysdate()))) ";
		}
		
		$order=intval($_GET['order']);
		if($order==1){
			$where.=' AND top=1 ';
		}
		
		//分类
		$route='';
		if(preg_match('/^[a-z]+$/i',$_GET['catid'])){ 
			$route=$_GET['catid'];
			$categoryone= M('Category')->token(false)->where(" route='$route' ")->find();
			if(!empty($categoryone)){
				$catid=$categoryone['catid'];
				$route=$categoryone['route'];
				if(!empty($categoryone['nexts'])){
					$categoryid=$categoryone['nexts'];
					$where.=" AND catid IN($categoryid) ";
				}
				$category= M('Category')->token(false)->where(" upid=$catid AND task=1 ")->select();
			}
		}else{
			//1级
			$category= M('Category')->token(false)->where(" upid=0 AND task=1 ")->select();
		}
		
		if(empty($category)){
			$category=array($categoryone);
		}
		

		$city=intval($_GET['city']);
		$cityname='';
		if($city){
			$cityarr= M('CategoryCity')->token(false)->where(" catid=$city ")->find();
			if(!empty($cityarr)){
				$cityid=$cityarr['nexts'];
				$cityname=$cityarr['name'];
				if($cityid){
					$where.=" AND cityid IN($cityid) ";
				}
			}
		}
		
		//O2O
		$categorycity=array();
		if(C('otoo_open')==1 && $city){
			$categorycity=M('CategoryCity')->token(false)->where(" upid=$city ")->select();
			if(empty($categorycity)){
				$categorycity=array($cityarr);
			}
		}
		
		//搜索
		$search=String::msubstr(I('get.search'),0,12,C('S_CHARSET'),false);
		$search=strip_tags($search);
		$search=trim(htmlspecialchars($search,ENT_QUOTES,C('S_CHARSET')));
		if(!empty($search)){
			$where.=" AND subject like '%%%s%%'";  
		}
		
		return array($where,$cityname,$category,$route,$search,$categoryone,$categorycity);
	}
	
	
	//任务列表
	function GetTaskList($ismap=''){
		$pagenum=intval($_GET['p']);
		
		$selectwhere=$this->SelectTaskWhere();
		$wheresql=$selectwhere[0];
		$order=$this->OrderTaskWhere();
		
		if($ismap=='map'){
			$shownum=100;
		}else{
			$shownum=20;
		}
		
		//数据-------------------------------
		$list=$this->token(false)->where($wheresql,$selectwhere[4])->order($order)->page($pagenum,$shownum)->select();

		//页码-------------------------------
		$count=$this->token(false)->where($wheresql,$selectwhere[4])->count();
		$Page = new \Think\Page($count,$shownum);
	

		$newpage=str_replace("Index/index/catid/",'',$Page->show());
		$newpage=str_replace("index/index/catid/",'',$newpage);
		$newpage=str_replace("Index/index/",'',$newpage);
		$newpage=str_replace("index/index/",'',$newpage);
		$newpage=str_replace("/m/task",'',$newpage);
		$newpage=str_replace("mode/",'m',$newpage);
		$newpage=str_replace("order/",'o',$newpage);
		$newpage=str_replace("search",'s',$newpage);
		$newpage=str_replace("deposit/",'d',$newpage);
		$newpage=str_replace("time/",'t',$newpage);
		$newpage=str_replace("city/",'c',$newpage);
		return array('list'=>$list,'page'=>$newpage,'cityname'=>$selectwhere[1],'category'=>$selectwhere[2],'route'=>$selectwhere[3],'search'=>$selectwhere[4],'categoryone'=>$selectwhere[5],'categorycity'=>$selectwhere[6]);
	}
	
	//筛选
	function SelectMakeUrl($selectkey,$id='',$value=0){
		$selecturl='';		   
		foreach($selectkey as $key=>$name){
			if($id==$key){
				$selecturl.='/'.$name.$value;
			}else{
				if($key=='search'){	
					$search=String::msubstr(I('get.search'),0,12,C('S_CHARSET'),false);
					$search=strip_tags($search);
					$search=trim(htmlspecialchars($search,ENT_QUOTES,C('S_CHARSET')));	
					if(!empty($search)){
						$selecturl.='/'.$name.'/'.$search;
					}
				}else{
					$selecturl.='/'.$name.intval($_GET[$key]);
				}
			}
		}
		return $selecturl;
	}
	
	//任务筛选SQL
	function SelectTaskWhere(){
		$where=' type=1 AND process>3 AND task_mode<3 ';
		$mode=intval($_GET['mode']);
		if($mode==1){
			//悬赏
			$where.=' AND task_number=1 AND task_mode=1 ';
		}elseif($mode==2){
			//招标
			$where.=' AND task_number=1 AND task_mode=2 ';
		}elseif($mode==3){
			//计件
			$where.=' AND task_number>1 AND task_mode=1 ';
		}
		
		$deposit=intval($_GET['deposit']);
		if($deposit==1){
			$where.=' AND cid>0 ';
		}elseif($deposit==2){
			$where.=' AND cid=0 ';
		}
		
		$time=intval($_GET['time']);
		if($time==1){
			$where.=" AND dateline>=UNIX_TIMESTAMP(timestamp(date(sysdate()))) AND dateline<=(UNIX_TIMESTAMP()+86400) ";
		}elseif($time==2){
			$where.=" AND dateline>=(UNIX_TIMESTAMP()-86400) AND dateline<=UNIX_TIMESTAMP(timestamp(date(sysdate()))) ";
		}elseif($time==3){
			$where.=" AND dateline>=(UNIX_TIMESTAMP()-259200) AND dateline<=UNIX_TIMESTAMP(timestamp(date(sysdate()))) ";
		}elseif($time==4){
			$where.=" AND dateline>=(UNIX_TIMESTAMP()-604800) AND dateline<=UNIX_TIMESTAMP(timestamp(date(sysdate()))) ";
		}elseif($time==5){
			$where.=" AND dateline>=(UNIX_TIMESTAMP()-2592000) AND dateline<=UNIX_TIMESTAMP(timestamp(date(sysdate()))) ";
		}
		
		$order=intval($_GET['order']);
		if($order==1){
			$where.=' AND top=1 ';
		}
		
		//分类
		$route='';
		if(preg_match('/^[a-z]+$/i',$_GET['catid'])){ 
			$route=$_GET['catid'];
			$categoryone= M('Category')->token(false)->where(" route='$route' ")->find();
			if(!empty($categoryone)){
				$catid=$categoryone['catid'];
				$route=$categoryone['route'];
				if(!empty($categoryone['nexts'])){
					$categoryid=$categoryone['nexts'];
					$where.=" AND catid IN($categoryid) ";
				}
				$category= M('Category')->token(false)->where(" upid=$catid AND task=1 ")->select();
			}
		}else{
			//1级
			$category= M('Category')->token(false)->where(" upid=0 AND task=1 ")->select();
		}
		
		if(empty($category)){
			$category=array($categoryone);
		}
		
		$city=intval($_GET['city']);
		$cityname='';
		if($city){
			$cityarr= M('CategoryCity')->token(false)->where(" catid=$city ")->find();
			if(!empty($cityarr)){
				$cityid=$cityarr['nexts'];
				$cityname=$cityarr['name'];
				if($cityid){
					$where.=" AND cityid IN($cityid) ";
				}
			}
		}
		
		//O2O
		$categorycity=array();
		if(C('otoo_open')==1 && $city){
			$categorycity=M('CategoryCity')->token(false)->where(" upid=$city ")->select();
			if(empty($categorycity)){
				$categorycity=array($cityarr);
			}
		}
		
		//搜索
		$search=String::msubstr(I('get.search'),0,12,C('S_CHARSET'),false);
		$search=strip_tags($search);
		$search=trim(htmlspecialchars($search,ENT_QUOTES,C('S_CHARSET')));
		if(!empty($search)){
			$where.=" AND subject like '%%%s%%'";  
		}
		
		return array($where,$cityname,$category,$route,$search,$categoryone,$categorycity);
	}
	
	//任务排序SQL
	function OrderTaskWhere(){
		$ordersql='top DESC,dateline DESC';
		
		$order=intval($_GET['order']);
		if($order==1){
			$ordersql='top DESC';
		}elseif($order==2){
			$ordersql='dateline DESC';
		}elseif($order==3){
			$ordersql='draft_number DESC';
		}elseif($order==4){
			$ordersql='money DESC';
		}
		
		return $ordersql;
	}
	
	//获取数据
	function GetCustomData($where='',$order='',$limit=10){
		return $this->token(false)->where($where)->field('uid,username,dateline,endtime,task_mode,task_number,money,draft_success,process,process_order,process_order_name,id,subject,enddate,draft_number,picture')->order($order)->limit($limit)->select();
	}
	
	function GetSpaceTask(){
		$pagenum=intval($_GET['p']);
		$uid=intval($_GET['uid']);
		if(!$uid){
			$this->error='UID不存在！';
			return false;
		}
		
		$where=" uid=$uid AND type=1 AND task_mode<3";
		
		$list=$this->token(false)->where($where)->order($order)->field('uid,username,dateline,endtime,task_mode,task_number,money,draft_success,process_order_name,id,subject,enddate,draft_number')->page($pagenum,20)->select();
		
		if(!empty($list)){
			$num=count($list);
			for($i=0;$i<$num;$i++){
				$list[$i]['money']=$list[$i]['money']/100;
				$list[$i]['dateline']=FormatDate("Y-m-d H:i",$list[$i]['dateline']);
				$list[$i]['endtime']=FormatDate("Y-m-d H:i",$list[$i]['endtime']);
				if($list[$i]['task_mode']==1){
					if($list[$i]['task_number']>1){
						$list[$i]['task_mode']='计件';
					}else{
						$list[$i]['task_mode']='悬赏';
					}
				}elseif($list[$i]['task_mode']==2){
					$list[$i]['task_mode']='招标';
				}
			}
		}
				
		$count=$this->token(false)->where($where)->count();
		$Page = new \Think\Page($count,20);
		if($Page->show()){
			$pagenum=preg_replace("/href=\"(.*?)\"/i","href=\"javascript:GetDataTask('$1')\"",$Page->show());
		}	
		
		return array('list'=>$list,'page'=>$pagenum);
	}
	
	//设置服务店铺推荐
	function SetFuwuTop(){
		$mytop=intval($_POST['mytop']);
		$ids=ExplodeStrArr(implode(',',$_POST['checkbox']));
		if($mytop==1 && $ids){
			$this->token(false)->where(" uid=$this->uid AND type=2 AND id IN($ids) ")->save(array('mytop'=>1));
			return true;
		}elseif($mytop==2 && $ids){
			$this->token(false)->where(" uid=$this->uid AND type=2 AND id IN($ids) ")->save(array('mytop'=>0));
			return true;
		}
		
		$this->error='请选择ID操作！';
		return false;
	}
	
	//设置服务删除
	function SetFuwuDelete(){
		$ids=ExplodeStrArr(implode(',',$_POST['checkbox']));
		if($ids){
			$this->FuwuDelete(" uid=$this->uid AND type=2 AND id IN($ids) ");
			return true;
		}
		
		$this->error='请选择ID操作！';
		return false;
		
	}
	
	//删除服务
	function FuwuDelete($where){
		if($where){
			$data=$this->token(false)->where($where)->limit(20)->select();
			if($data){
				$model=new \Upload\Model\FileModel();
				foreach($data as $key=>$value){
					$sid=$value['id'];
					$file= M('File')->token(false)->where(" sid=$sid ")->find();
					if(!empty($file)){
						$model->DeleteUpload($file['fid']);
					}
				}
			}
			
			$this->token(false)->where($where)->delete();
		}
		return true;
	}
	
	
	//雇主订单筛选-------------------------------
	public function GetMyTask($orderarr=array(),$wherearr=array(),$order='id ASC',$showpage=10){
		$wheresql=$selectarray='';

		if(intval($_GET['search'])){

			$wheresqlarr=SetWhere($_GET,$wherearr);

			$wheresql=$wheresqlarr[0];

			$selectarray=$wheresqlarr[1];

		}
		
		//排序-------------------------------
		$iforder=I('get.iforder',2,'int');

		if($iforder==1){
			$selectorder=' ASC';
			$iforder=2;
		}else{
			$selectorder=' DESC';
			$iforder=1;
		}
		
		$sqlorder=I('get.sqlorder',0,'int');
		foreach($orderarr as $key=>$value){
			if($sqlorder==$key){
				$order=$value['order'].$selectorder;
			}
		}
		
		if($wheresql){
			$wheresql.=" AND type=1 AND uid=$this->uid ";
			if(IsNum($_GET['process_order']) && $_GET['process_order']==0){
				$wheresql.=" AND cid=0 ";
			}
		}else{
			$wheresql=" type=1 AND uid=$this->uid ";
			if(IsNum($_GET['process_order']) && $_GET['process_order']==0){
				$wheresql.=" AND cid=0 ";
			}
		}

		//数据-------------------------------
		$pagenum=I('get.p',0,'int');
		$list=$this->where($wheresql,$selectarray)->order($order)->page($pagenum,$showpage)->select();
		
		//页码-------------------------------
		$count=$this->where($wheresql,$selectarray)->count();
		$Page = new \Think\Page($count,$showpage);

		return array('list'=>$list,'page'=>$Page->show(),'count'=>$count,'orderarr'=>$orderarr,'iforder'=>$iforder,'sqlorder'=>$sqlorder,'pagenum'=>$pagenum,'selectarray'=>$selectarray);
	}
}

?>