<?php
/************************FoxPHP威客系统************************/
/*                                                            */
/*  FoxPHP.Com (C)2006-2016 FoxPHP Inc.                       */
/*  This is NOT a freeware, use is subject to license terms   */
/*  FoxPHP威客系统是商业软件,使用于商业用途请购买授权         */
/*  V3.0 2016.3                                               */
/*  foxphp@aliyun.com                                         */
/*  http://www.foxphp.com                                     */
/*                                                            */
/**************************************************************/


namespace Data\Model;
use Think\Model;
use \Org\Util\String;

class DataOrderModel extends Model {
	
	function ListDraft($task=array()){
		$id=intval($task['id']);
		$oid=intval($_GET['oid']);
		if(!$id){
			return false;
		}
		
		$type=intval($_GET['type']);
		$pagenum=intval($_GET['p']);
		
		$wheresql=" id=$id ";
		$order='dateline DESC';
		
		if($type==1){ //未审核
			$wheresql.=' AND process=0 ';
			$javascript='#ListDraftNotreviewed';
		}elseif($type==2){ //中标
			$wheresql.=' AND process=1 ';
			$javascript='#ListDraftSuccess';
		}elseif($type==3){//失败
			$wheresql.=' AND process=2 ';
			$javascript='#ListDraftFailure';
		}else{
			$javascript='#ListDraft';
		}
		
		$pageshow='';
		$pagecomment='';
		if($oid){
			//评论
			$list=$this->token(false)->where(" oid=$oid ")->select();
			$listcomment=M('DataOrderComment')->token(false)->where(" oid=$oid ")->order($order)->page($pagenum,5)->select();
			
			if(!empty($listcomment)){
				$num=count($listcomment);
				for($i=0;$i<$num;$i++){
					$listcomment[$i]['avatar']=GetAvatarSimple($listcomment[$i]['uid'],48,'img-rounded');
				}
			}
			
			$count=M('DataOrderComment')->token(false)->where(" oid=$oid ")->count();
			$Page = new \Think\Page($count,5);
			if($Page->show()){
				$pagecomment=preg_replace("/href=\"(.*?)\"/i","href=\"javascript:GetListComment('$1')\"",$Page->show());
			}	
		}else{	
			//数据-------------------------------
			$list=$this->token(false)->where($wheresql)->order($order)->page($pagenum,10)->select();
			
			if(!empty($list)){
				$oids='';
				foreach($list as $value){
					if($value['oid']){
						if($oids){
							$oids.=','.$value['oid'];
						}else{
							$oids=$value['oid'];
						}
					}
				}
				
				if($task['uid']==$this->uid && $oids){
					$this->token(false)->where(" oid IN($oids) ")->save(array('buyer_read'=>1));
				}
				
			}
		
			//页码-------------------------------
			$count=$this->token(false)->where($wheresql)->count();
			$Page = new \Think\Page($count,10);
			if($Page->show()){
				$pageshow=preg_replace("/href=\"(.*?)\"/i","href=\"javascript:GetListDraft('$1','$javascript')\"",$Page->show());
			}	
		}		
		
		if(!empty($list)){
			$num=count($list);
			for($i=0;$i<$num;$i++){
				
				$content='';  
				if (!$task['hidedraft']){
					$content=htmlspecialchars_decode($list[$i]['content']);
				}else{
					if($list[$i]['seller_uid']==$this->uid || $task['uid']==$this->uid ){ //  || $this->IsService($task['serviceuid'])
						$content=htmlspecialchars_decode($list[$i]['content']);
					}else{
						$content='<div class="alert alert-warning fade in"><button data-dismiss="alert" class="close">×</button><i class="fa-fw fa fa-warning"></i><strong>提示</strong> 该稿件已隐藏,只有雇主和投标本人登录后可见!</div>';	  
					}
				}

				$list[$i]['content']=$content;
				
				$list[$i]['dateline']=FormatDate("Y-m-d H:i",$list[$i]['dateline']);
				
				$list[$i]['avatar']=GetAvatarSimple($list[$i]['seller_uid'],48,'img-rounded');
				
				if($list[$i]['verifytime']){
					$list[$i]['verifytime']=FormatDate("Y-m-d H:i",$list[$i]['verifytime']);
				}
				
				//操作
				$op='<div class="text-right"><input class="check_box_id" type="checkbox" value="'.$list[$i]['oid'].'" id="CheckBoxID_'.$list[$i]['oid'].'" onclick="AddCheckBox('.$list[$i]['oid'].')"/>';	
				if($task['uid']==$this->uid ){ //|| IsService($task['serviceuid']) || IsAdmin()
					if($list[$i]['process']==0){
						$op.='<a class="btn btn-success btn-sm" href="javascript:void(0);" onclick="ApplySuccess('.$list[$i]['oid'].','.$type.','.$pagenum.')"><i class="fa fa-check"></i>中标</a> <a class="btn btn-danger btn-sm" href="javascript:void(0);" onclick="ApplyFailure('.$list[$i]['oid'].','.$type.','.$pagenum.')"><i class="fa fa-times"></i>不合格</a>';
					}	  		   
				}elseif($list[$i]['seller_uid']==$this->uid){
					if($list[$i]['process']!=1){
						$op.='<a class="btn btn-danger btn-sm" href="/task/show/edit/id/'.$list[$i]['id'].'/oid/'.$list[$i]['oid'].'"><i class="fa fa-pencil"></i>修改</a>';
					}
				}
				
				$op.='</div>';	
		
				$list[$i]['operate']=$op;

				if(!empty($list) && $oid){
					$list[$i]['comment']=$listcomment;
					$list[$i]['pagecomment']=$pagecomment;
				}else{
					$list[$i]['comment']=unserialize($list[$i]['comment']);
					$list[$i]['pagecomment']='';
				}
			}
		}

		return array('list'=>$list,'page'=>$pageshow,'count'=>$count,'pagenum'=>$pagenum);
	}
	
	//获取稿件一维数组
	function GetDataOrder($oid=0){
		$oid=intval($oid);
		return $this->token(false)->where(" seller_uid=$this->uid AND oid=$oid AND process!=1 ")->find();
	}
	
	//评价
	function ListEvaluate($type){
		$id=intval($_GET['id']);
		$pagenum=intval($_GET['p']);
		$selleruid=intval($_GET['seller_uid']);
		$buyeruid=intval($_GET['buyer_uid']);
		
		if($type=='buyer'){
			if($selleruid){
				$where=" seller_uid=$selleruid AND buyer_is_evaluate=1 ";
			}else{
				$where=" sid=$id AND buyer_is_evaluate=1 ";
			}
		}else{
			if($buyeruid){
				$where=" buyer_uid=$buyeruid AND seller_is_evaluate=1 ";
			}else{
				$where=" id=$id AND seller_is_evaluate=1 ";
			}
		}
		
		$order='buyer_evaluate_time ASC';
		$list=$this->token(false)->where($where)->order($order)->field('money,buyer_uid,buyer_username,seller_uid,seller_username,buyer_evaluate,buyer_evaluate_content,buyer_evaluate_time,seller_evaluate,seller_evaluate_content,seller_evaluate_time')->page($pagenum,10)->select();
		
		if(!empty($list)){
			$num=count($list);
			for($i=0;$i<$num;$i++){
				$list[$i]['type_evaluate']=$type;
				if($list[$i]['buyer_evaluate']==1){
					$list[$i]['buyer_evaluate']='好评';
				}elseif($list[$i]['buyer_evaluate']==2){
					$list[$i]['buyer_evaluate']='中评';
				}elseif($list[$i]['buyer_evaluate']==3){
					$list[$i]['buyer_evaluate']='差评';
				}
				
				if($list[$i]['seller_evaluate']==1){
					$list[$i]['seller_evaluate']='好评';
				}elseif($list[$i]['seller_evaluate']==2){
					$list[$i]['seller_evaluate']='中评';
				}elseif($list[$i]['seller_evaluate']==3){
					$list[$i]['seller_evaluate']='差评';
				}
				
				$list[$i]['money']=$list[$i]['money']/100;
				$list[$i]['buyer_evaluate_time']=FormatDate("Y-m-d H:i",$list[$i]['buyer_evaluate_time']);
				$list[$i]['seller_evaluate_time']=FormatDate("Y-m-d H:i",$list[$i]['seller_evaluate_time']);
			}
		}
				
		$count=$this->token(false)->where($where)->count();
		$Page = new \Think\Page($count,10);
		if($Page->show()){
			$pagenum=preg_replace("/href=\"(.*?)\"/i","href=\"javascript:GetDataEvaluate('$1')\"",$Page->show());
		}	
		
		return array('list'=>$list,'page'=>$pagenum);
	}
	
	//获取卖家中标
	function GetSuccessOrder($selleruid=0){
		$pagenum=intval($_GET['p']);
		$selleruid=intval($selleruid);
		if(!$selleruid){
			$this->error='UID不存在！';
			return false;
		}
		
		$where=" seller_uid=$selleruid AND process=1 ";
		
		$order='verifytime DESC';
		
		$list=$this->token(false)->where($where)->order($order)->field('money,buyer_uid,buyer_username,verifytime,sid,id,subject')->page($pagenum,20)->select();
		
		if(!empty($list)){
			$num=count($list);
			for($i=0;$i<$num;$i++){
				$list[$i]['money']=$list[$i]['money']/100;
				if($list[$i]['sid']){
					$list[$i]['tasktype']='雇用';
				}else{
					$list[$i]['tasktype']='任务';
				}
				$list[$i]['verifytime']=FormatDate("Y-m-d H:i",$list[$i]['verifytime']);
			}
		}
				
		$count=$this->token(false)->where($where)->count();
		$Page = new \Think\Page($count,20);
		if($Page->show()){
			$pagenum=preg_replace("/href=\"(.*?)\"/i","href=\"javascript:GetDataSuccess('$1')\"",$Page->show());
		}	
		
		return array('list'=>$list,'page'=>$pagenum);
		
	}
	
	
	//服务商订单筛选-------------------------------
	public function GetMyOrder($orderarr=array(),$wherearr=array(),$order='id ASC',$showpage=10){
		$wheresql=$selectarray='';
		
		$process=0;
		if($_GET['process']==3 || $_GET['process']==4){
			$process=intval($_GET['process']);
			$_GET['process']=null;
		}
		
		if(intval($_GET['search'])){

			$wheresqlarr=SetWhere($_GET,$wherearr);

			$wheresql=$wheresqlarr[0];

			$selectarray=$wheresqlarr[1];

		}
		
		//排序-------------------------------
		$iforder=I('get.iforder',2,'int');

		if($iforder==1){
			$selectorder=' ASC';
			$iforder=2;
		}else{
			$selectorder=' DESC';
			$iforder=1;
		}
		
		$sqlorder=I('get.sqlorder',0,'int');
		foreach($orderarr as $key=>$value){
			if($sqlorder==$key){
				$order=$value['order'].$selectorder;
			}
		}
		
		if($wheresql){
			$wheresql.=" AND seller_uid=$this->uid ";
			if(IsNum($_GET['process']) && $_GET['process']==0){
				$wheresql.=" AND process=0 ";
			}
			if($process==3){
				$wheresql.=" AND process=1 AND cid>0 AND seller_is_complete=0 AND seller_is_evaluate=0 ";
			}	
			if($process==4){
				$wheresql.=" AND process=1 AND cid>0 AND seller_is_complete=1 AND seller_is_evaluate=0 ";
			}
		}else{
			$wheresql=" seller_uid=$this->uid ";
			if(IsNum($_GET['process']) && $_GET['process']==0){
				$wheresql.=" AND process=0 ";
			}
			if($process==3){
				$wheresql.=" AND process=1 AND cid>0 AND seller_is_complete=0 AND seller_is_evaluate=0 ";
			}
			if($process==4){
				$wheresql.=" AND process=1 AND cid>0 AND seller_is_complete=1 AND seller_is_evaluate=0 ";
			}
		}

		//数据-------------------------------
		$pagenum=I('get.p',0,'int');
		$list=$this->where($wheresql,$selectarray)->order($order)->page($pagenum,$showpage)->select();
		
		//页码-------------------------------
		$count=$this->where($wheresql,$selectarray)->count();
		$Page = new \Think\Page($count,$showpage);
		
		if($process==3){
			$_GET['process']=3;
		}
		
		if($process==4){
			$_GET['process']=4;
		}

		return array('list'=>$list,'page'=>$Page->show(),'count'=>$count,'orderarr'=>$orderarr,'iforder'=>$iforder,'sqlorder'=>$sqlorder,'pagenum'=>$pagenum,'selectarray'=>$selectarray);
	}
}

?>