<?php
/************************FoxPHP威客系统************************/
/*                                                            */
/*  FoxPHP.Com (C)2006-2016 FoxPHP Inc.                       */
/*  This is NOT a freeware, use is subject to license terms   */
/*  FoxPHP威客系统是商业软件,使用于商业用途请购买授权         */
/*  V3.0 2016.3                                               */
/*  foxphp@aliyun.com                                         */
/*  http://www.foxphp.com                                     */
/*                                                            */
/**************************************************************/

namespace Get\Controller;
use Think\Controller;
class UpdateController extends Controller {
	
	public function indexAction(){
	}
	
	public function IsSign(){
		if(!intval(C('FOXPHP_UPDATE'))){
			return false;
		}
		
		$sign=$_POST['sign'];
		
		$foxphpid=intval($_POST['foxphpid']);

		if($sign){
			unset($_POST['sign']);
			unset($_POST['datatype']);
			unset($_POST['file']);
			
			$clientdomain=null;
			
			if(!empty($_SERVER['HTTP_REFERER'])){
				
				$referer=parse_url($_SERVER['HTTP_REFERER']);
				$domain=strtolower($referer['host']);
				$clientdomainip=gethostbyname($domain);
				
				if(!empty($domain)){
					
					$domainarray=explode('.',$domain);
					
					$domainnum=count($domainarray);
					
					$domain1='';
					if(!empty($domainarray[$domainnum-1])){
						$domain1=$domainarray[$domainnum-1];
					}
					
					$domain2='';
					if(!empty($domainarray[$domainnum-2])){
						$domain2=$domainarray[$domainnum-2];
					}
					
					if(preg_match("/^[a-zA-Z0-9]+$/is",$domain2.$domain1)){
						$clientdomain=$domain2.'.'.$domain1;
					}
				}
			}
			
			
			//if(!empty($clientdomain)){ //暂时获取不到域名
				
				$postsign=make_sign(arg_sort($_POST),C('FOXPHP_SIGN'));

				require_once(C('S_APPS').'/Common/Conf/updatekey.php');
				
				//if($sign==$postsign && GetClientIp()==C('FoxPHP_IP') && $updatekey==$_POST['updatekey']){
					
				if($sign==$postsign && $updatekey==$_POST['updatekey']){
					return true;
				}
				return false;
			//}
		}
		return false;
	}
	
	function DeleteCache($url=null){
		$dir = new \RecursiveIteratorIterator(new \RecursiveDirectoryIterator($url)); 
		foreach($dir as $file) { 
			if($file->isFile()){
				@unlink($file->getPath().'/'.$file->getFileName()); 
			}
		}  
	}
	
	//更新缓存记录
	public function cacheAction(){
		JsonAccessAllow();
		
		if($this->IsSign()){

			$version=intval($_POST['version']); //客户版本日期
			M('Update')->token(false)->create(array('version'=>$version,'dateline'=>@time()));
			M('Update')->token(false)->add();
			
			$this->ajaxReturn(array('title'=>'更新成功','message'=>'更新成功!','status'=>'ok'),'json');
			
		}else{
			$this->ajaxReturn(array('title'=>'更新失败','message'=>'签名错误或没有权限','status'=>'error'),'json');
		}
	}
	
	//升级SQL
	public function sqlAction(){
		JsonAccessAllow();
		$error=null;
		
		if($this->IsSign()){
			
			$version=intval($_POST['version']);
			
			if(!empty($_POST['sql'])){
				@require_once(FOXPHP_PATH.$_POST['sql']);
			}else{
				$error='SQL文件不存在!';
			}
			
			if($error){
				$this->ajaxReturn(array('title'=>'更新SQL','message'=>$error,'status'=>'error'),'json');
			}else{
				$this->DeleteCache(FOXPHP_PATH.'/Update/'.$version.'/sql/');
				$this->ajaxReturn(array('title'=>'更新成功','message'=>'更新成功!','status'=>'ok'),'json');
			}
			
		}else{
			$this->ajaxReturn(array('title'=>'更新失败','message'=>'签名错误或没有权限','status'=>'error'),'json');
		}
	}

	//复制文件
	public function copyAction(){
		JsonAccessAllow();
		//WriteFile(FOXPHP_PATH.'/file.txt','ok','w');
		$error=null;
		
		if($this->IsSign()){
			
			$copyfile=unserialize($_POST['copyfile']);
			
			if(!empty($copyfile)){
				foreach($copyfile as $key=>$file){
					if(is_file(FOXPHP_PATH.$file['source'])){
						if(!@copy(FOXPHP_PATH.$file['source'],FOXPHP_PATH.$file['destination'])){
							$error=$file['destination'];
							break;
						}
					}else{
						$error=$file['source'];
						break;
					}
				}
			}

			if($error){
				$this->ajaxReturn(array('title'=>'更新没有写入权限','message'=>'请设置目录 '.$error.' 777可写权限','status'=>'error'),'json');
			}else{
				
				if(!empty($copyfile)){
					foreach($copyfile as $key=>$file){
						@unlink(FOXPHP_PATH.$file['source']);
					}
				}
				$this->ajaxReturn(array('title'=>'更新成功','message'=>'更新成功!','status'=>'ok'),'json');
			}
			
		}else{
			$this->ajaxReturn(array('title'=>'更新失败','message'=>'签名错误或没有权限','status'=>'error'),'json');
		}
	}
	
	//备份文件
	public function backupAction(){
		JsonAccessAllow();
		
		$checkdirerror=null;
		
		if($this->IsSign()){
			
			$backupfile=unserialize($_POST['backupfile']);
			
			if(!empty($_POST['backuppath'])){
				
				if(!is_dir(FOXPHP_PATH.$_POST['backuppath'])){
					if(!@mkdir(FOXPHP_PATH.$_POST['backuppath'],0777)){
						$checkdirerror.=$_POST['backuppath'];
					}
				}

			
				if(!empty($_POST['backupfile']) && !$checkdirerror){
					foreach($backupfile as $key=>$file){
						//创建备份目录
						
						if(!is_dir(FOXPHP_PATH.$file['dir'])) {
							
							$dirarr=explode('/',$file['dir']);
							$count=count($dirarr);
							
							$mkdir='';
							for($i=1;$i<=$count;$i++){
								$mkdir.='/'.$dirarr[$i];
								if(!is_dir(FOXPHP_PATH.$mkdir)){
									if(!@mkdir(FOXPHP_PATH.$mkdir,0777)){
										$checkdirerror.=$mkdir;
										break;
									}
								}
								
								if(!WriteFile(FOXPHP_PATH.$mkdir.'/index.html','')){
									$checkdirerror.=$mkdir;
									break;
								}
								
							}
							
						}
					
						if(is_file(FOXPHP_PATH.$file['backup'])){
							@copy(FOXPHP_PATH.$file['backup'],FOXPHP_PATH.$file['path']);
						}
					}
				}
			
			}
			
			if($checkdirerror){
				$this->ajaxReturn(array('title'=>'更新没有写入权限','message'=>'请设置目录 '.$checkdirerror.' 777可写权限','status'=>'error'),'json');
			}else{
				$this->ajaxReturn(array('title'=>'更新成功','message'=>'更新成功!','status'=>'ok'),'json');
			}
			
		}else{
			$this->ajaxReturn(array('title'=>'更新失败','message'=>'签名错误或没有权限','status'=>'error'),'json');
		}
	}
	
	//下载文件
	public function fileAction(){
		JsonAccessAllow();

		if($this->IsSign()){
			$error=null;
			if(!$_FILES['file']['size']){
				$error='对不起!没有文件传输!';
			}else{

				$newfilepath=FOXPHP_PATH.$_POST['filepath'].$_POST['filename'];
				@move_uploaded_file($_FILES['file']['tmp_name'],$newfilepath);
				
				//WriteFile(FOXPHP_PATH.'/file.txt',md5_file($newfilepath).'=='.$_POST['filemd5'],'w');
				
				if(md5_file($newfilepath) !== $_POST['filemd5']){
					$error='对不起! '.$_POST['filename'].' 文件下载不完整,请重新更新！';
					@unlink($newfilepath);
				}
			}
			
			if($error){
				$this->ajaxReturn(array('title'=>'更新下载','message'=>$error,'status'=>'error'),'json');
			}else{
				$this->ajaxReturn(array('title'=>'下载成功','message'=>'下载成功!','status'=>'ok'),'json');
			}
		}else{
			$this->ajaxReturn(array('title'=>'更新失败','message'=>'签名错误或没有权限','status'=>'error'),'json');
		}
	}
	
	//检查目录权限
	public function checkdirAction(){

		JsonAccessAllow();
		
		if($this->IsSign()){
			
			$version=intval($_POST['version']); //客户版本日期
			
			$checkdirerror=null;
			
			if($_POST['filelist']){
				
				$filelist=explode(',',$_POST['filelist']);
				
				if($filelist){

					//Update
					foreach($filelist as $dir){
						
						$dir='/Update/'.$version.$dir;
						
						if(!is_dir(FOXPHP_PATH.$dir)) {
							
							$dirarr=explode('/',$dir);
							$count=count($dirarr);
							
							$mkdir='';
							for($i=1;$i<=$count;$i++){
								$mkdir.='/'.$dirarr[$i];
								if(!is_dir(FOXPHP_PATH.$mkdir)){
									if(!@mkdir(FOXPHP_PATH.$mkdir,0777)){
										$checkdirerror.=$mkdir;
										break;
									}
								}
								
								if(FOXPHP_PATH.$mkdir != FOXPHP_PATH.'/'){
									if(!WriteFile(FOXPHP_PATH.$mkdir.'/index.html','')){
										$checkdirerror.=$mkdir;
										break;
									}
								}
								
							}
							
						}
						
						if($checkdirerror){
							break;
						}
						
						if(!@WriteFile(FOXPHP_PATH.$dir.'/index.html','')){
							$checkdirerror.=$dir;
							break;
						}
					
					}
					
					
					//apps 
					foreach($filelist as $dir){
						
						$dirarr=explode('/',$dir);
						$count=count($dirarr);
						
						$mkdir='';
						for($i=2;$i<=$count;$i++){
							
							$mkdir.='/'.$dirarr[$i];
							
							if(!is_dir(FOXPHP_PATH.$mkdir)){
								if(!@mkdir(FOXPHP_PATH.$mkdir,0777)){
									$checkdirerror.=$mkdir;
									break;
								}
							}
							
							if(FOXPHP_PATH.$mkdir != FOXPHP_PATH.'/'){
								if(!@WriteFile(FOXPHP_PATH.$mkdir.'/index.html','')){
									$checkdirerror.=$mkdir;
									break;
								}
							}
							
						}
					
						if($checkdirerror){
							break;
						}
						
					}
					
				}
			}
			
			if($checkdirerror){
				$this->ajaxReturn(array('title'=>'更新没有写入权限','message'=>'请设置目录 '.$checkdirerror.' 777可写权限','status'=>'error'),'json');
			}else{
				$this->ajaxReturn(array('title'=>'更新成功','message'=>'更新成功!','status'=>'ok'),'json');
			}
		}else{
			$this->ajaxReturn(array('title'=>'更新失败','message'=>'签名错误或没有权限','status'=>'error'),'json');
		}
	}

}