<?php
/************************FoxPHP威客系统************************/
/*                                                            */
/*  FoxPHP.Com (C)2006-2016 FoxPHP Inc.                       */
/*  This is NOT a freeware, use is subject to license terms   */
/*  FoxPHP威客系统是商业软件,使用于商业用途请购买授权         */
/*  V3.0 2016.3                                               */
/*  foxphp@aliyun.com                                         */
/*  http://www.foxphp.com                                     */
/*                                                            */
/**************************************************************/

if(!defined('IN_FOXPHP')) {
	exit('Data error');
}
// FoxSendMail
class SendMail{
	
	private $SMTP;
	
	private $SmtpPort;
	
	private $LoginMail;
	
	private $LoginPassword;
	
	private $SendName;
	
	private $SendMailFrom;   //发送 mail 
	
	private $RcptTo;   //接收 mail 

	private $Subject;
	
	private $MailBody;
	
	private $Socket;
	
	private $fp;

	private $dateline;
	
	private $os;
	
	private $headers;
	
                
	function __construct($RcptTo='',$Subject='',$MailBody='',$MailFrom='',$SendName=''){	

		$this->SMTP=C('mailsmtp');
		$this->SmtpPort=intval(C('mailsmtpport'))?25:intval(C('mailsmtpport'));
		$this->LoginMail=C('mailloginname');
		$this->LoginPassword=C('mailloginpassword');
		$this->SendName=empty($SendName)? C('sitename'): $SendName;
		$this->SendMailFrom=empty($MailFrom)?C('sitemail'):$MailFrom;
		$this->RcptTo=$RcptTo;
		$this->Subject= '=?'.C('S_CHARSET').'?B?'.base64_encode(preg_replace("/[\r|\n]/", '', '['.C('sitename').'] '.$Subject)).'?=';
		$this->MailBody= chunk_split(base64_encode(str_replace("\n", "\r\n", str_replace("\r", "\n", str_replace("\r\n", "\n", str_replace("\n\r", "\r", $MailBody))))));
		$this->os=C('mailos') == 1 ? "\r\n" : (C('mailos') == 2 ? "\r" : "\n");
		$this->headers = "From: $this->SendName<$this->SendMailFrom>{$this->os}X-Priority: 3{$this->os}X-Mailer: ".$_SERVER['HTTP_HOST']." FoxPHP V3.0 {$this->os}MIME-Version: 1.0{$this->os}Content-type: text/html; charset=".C('S_CHARSET')."{$this->os}Content-Transfer-Encoding: base64{$this->os}";
		$this->dateline=NowTime();

	}
	
	function FoxPHPSendMail(){

		if(C('mailsendsystem')==1){
			ignore_user_abort();
		}
 
		set_time_limit(0);

		if($this->CheckEmail($this->RcptTo)){
			
			$this->FsockSendMail();
		}
  
	}
	
	function FsockSendMail(){
		
		if(!$this->fp = fsockopen($this->SMTP, $this->SmtpPort, $errno, $errstr, 30)) {
			exit("链接fsockopen $this->SMTP 失败!");
		}

		stream_set_blocking($this->fp, true);
		
		$isok=0;
		
		if($this->FsockWrites('HELO '.$_SERVER['HTTP_HOST'].$this->os)==220 ){
			
			$isok= fgets($this->fp, 512);
			
		}
		
		if($isok!=250){
			exit('HELO 链接失败!');
		}
		
		if($this->FsockWrites('AUTH LOGIN'.$this->os)!=334 ){
			exit('AUTH LOGIN 登录认证失败!');
		}

		if($this->FsockWrites(base64_encode($this->LoginMail).$this->os)!=334 ){
			exit($this->LoginMail.'帐号认证失败!');
		}

		if($this->FsockWrites(base64_encode($this->LoginPassword).$this->os)!=235){
			exit($this->LoginMail.'密码认证失败!');
		}

		if($this->FsockWrites('MAIL FROM: <'.$this->LoginMail.'>'.$this->os)!=250){
			exit($this->LoginMail.'发信人地址失败!');
		}

		if($this->FsockWrites('RCPT TO: <'.$this->RcptTo.'>'.$this->os)!=250){
			exit($this->RcptTo.'收信人地址失败!');
		}

		$this->FsockWrites('DATA'.$this->os);
		
		$this->headers.= 'Message-ID: <'.@date('YmdHs').'.'.substr(md5($this->MailBody.microtime()), 0, 6).rand(100000, 999999).'@'.$_SERVER['HTTP_HOST'].">{$this->os}";
		fwrite($this->fp, "Date: ".@date('r').$this->os);
		fwrite($this->fp, "To: ".$this->RcptTo.$this->os);
		fwrite($this->fp, "Subject: ".$this->Subject.$this->os);
		fwrite($this->fp, $this->headers.$this->os);
		fwrite($this->fp, $this->os.$this->os);
		fwrite($this->fp, $this->MailBody.$this->os.'.'.$this->os);
		fgets($this->fp, 512);
		fwrite($this->fp, "QUIT".$this->os);
		fclose($this->fp);
			   
		 	
	}
	
	function FsockWrites($Command){
		fwrite($this->fp,$Command); 
		$returninfo= fgets($this->fp, 512);
		return intval(substr($returninfo, 0, 3));
	}

     function SendCharset($convert){
	
		if(C('mailsendcharset')==1){  
			return  mb_convert_encoding($convert, "GBK", "UTF-8"); 
		}elseif(C('mailsendcharset')==2){
			return  mb_convert_encoding($convert, "UTF-8", "GBK");
		}else{
			return $convert;
		}
	 }
	 
	function CheckEmail($email){

		if(filter_var($email,FILTER_VALIDATE_EMAIL)){

		if(!preg_replace('/[\w]+|\@|\./','',$email)){

			if(preg_match('/([\w]+)(\@)([\w]+)(\.)([\w]+)/',$email)){
				return true;
			}else{
				return false;
			}

			}else{
				return false;
			}

		}else{
			return false;
		}
							 
	}
         
}

?>