<?php
/************************FoxPHP威客系统************************/
/*                                                            */
/*  FoxPHP.Com (C)2006-2016 FoxPHP Inc.                       */
/*  This is NOT a freeware, use is subject to license terms   */
/*  FoxPHP威客系统是商业软件,使用于商业用途请购买授权         */
/*  V3.0 2016.3                                               */
/*  foxphp@aliyun.com                                         */
/*  http://www.foxphp.com                                     */
/*                                                            */
/**************************************************************/

namespace Install\Controller;
use Think\Controller;
class CheckController extends Controller {
	
    public function indexAction(){
		if(@is_file(FOXPHP_PATH.'/Apps/Common/Conf/install.txt')){
			exit('您已安装过了,重新安装请删除 /Apps/Common/Conf/install.txt 文件和数据库表');
		}
		
		if(function_exists('gd_info')){
			$gd=gd_info();
			$this->assign('gd',$gd['GD Version']);
		}
		
		$version = M()->query("select version() as ver");

		$this->assign('mysql',$version[0]['ver']);
		
		if(function_exists('curl_init')){
			$curl=@curl_version();
			$this->assign('curl',$curl['version']);
		}
		
		$dirlist=$this->FoxPHPDirectoryPermissions(
			array(
				'/Apps',
				'/Apps/Common',
				'/Apps/Common/Common',
				'/Apps/Common/Conf',
				'/Apps/Common/Conf/config.php',
				'/Apps/Html',
				'/Apps/Runtime',
				'/Apps/Runtime/Cache',
				'/Apps/Runtime/Data',
				'/Apps/Runtime/Logs',
				'/Apps/Runtime/Temp',
				
				'/assets',
				'/assets/css',
				'/assets/img',
				'/assets/js',
				'/assets/plugin',
				
				'/attachment',
				'/attachment/avatar',
				'/attachment/avatar/big',
				'/attachment/avatar/middle',
				'/attachment/avatar/small',
				'/attachment/upload',
				
				'/Data',
				'/Data/Backup',
				
				'/Theme',
				'/Theme/default',
				'/Theme/default/Public',
				'/Theme/default/Public/Page',
				
				'/ThinkPHP/Library/Behavior',
				'/Update'
			)
		);
		
		$this->assign('dirlist',$dirlist);
	
		$this->display();
    }
	
	public function FoxPHPDirectoryPermissions($dirarr=array()){

		$pathlist=array();
		foreach($dirarr as $dir) { 
		
			if(is_file(FOXPHP_PATH.$dir)){
				if(is_writable(FOXPHP_PATH.$dir)){
					$pathlist[]=array('status'=>'ok','path'=>$dir);
				}else{
					$pathlist[]=array('status'=>'error','path'=>$dir);
				}
			}else{
				if(@WriteFile(FOXPHP_PATH.$dir.'/index.html','')){
					$pathlist[]=array('status'=>'ok','path'=>$dir);
				}else{
					$pathlist[]=array('status'=>'error','path'=>$dir);
				}
			}
			
		}  
		return  $pathlist;
	}
}