<?php
/************************FoxPHP威客系统************************/
/*                                                            */
/*  FoxPHP.Com (C)2006-2016 FoxPHP Inc.                       */
/*  This is NOT a freeware, use is subject to license terms   */
/*  FoxPHP威客系统是商业软件,使用于商业用途请购买授权         */
/*  V3.0 2016.3                                               */
/*  foxphp@aliyun.com                                         */
/*  http://www.foxphp.com                                     */
/*                                                            */
/**************************************************************/

namespace Member\Controller;
use Think\Controller;

/****************************************************/
//Member入口文件,所有会员控制器，必须继承该类
/****************************************************/

class IndexController extends Controller {
	
	//权限
	public function _initialize(){
		if(!$this->uid){
			if($_POST['datatype']){
				$this->ajaxReturn(array('title'=>'操作失败','message'=>'对不起，请登录后操作！','status'=>'error'));
				return false;
			}else{
				$this->error('对不起，请登录后操作！','/login',3);
			}
			exit();
		}
		$auth=new \Think\Auth();
		if(!$auth->check(MODULE_NAME."/".CONTROLLER_NAME."/".ACTION_NAME,$this->uid)){
			if($_POST['datatype']){
				$this->ajaxReturn(array('title'=>'操作失败','message'=>'对不起，您没有权限操作！','status'=>'error'));
				return false;
			}else{
				$this->error('对不起，您没有权限操作！','/',3);
			}
			exit();
		}

		$model=new \Member\Model\MemberModel();
		
		$this->assign('member',$model->UidGetMember($this->uid));
		
		$this->assign('url',$this->GetModuleUrl());
		
		$modulename=$this->GetModuleName();
		
		$this->assign('nav',$modulename);
		
		if($modulename=='Buyer'){
			$this->assign('membermenuarray',$this->BuyerMenuArray());
		}elseif($modulename=='Seller'){	
			$this->assign('membermenuarray',$this->SellerMenuArray());
		}else{
			$this->assign('membermenuarray',$this->MemberMenuArray());
		}
		
		$this->assign('uid',$this->uid);
		
		$this->assign('username',$this->username);
		
		//数据ID
		$this->assign('id',intval($_GET['id']));
		
		$this->assign('PATH',array('会员'));
	}
	
	//卖家菜单
	public function SellerMenuArray(){ 
	
        return array(
		
			//交易管理
          	array(
				'name'=>'交易管理',
               	'icon'=>'glyphicon glyphicon-th-list',
				'controller'=>array('index','task','favorites'), //控制器
				'submenu'=>array(
				
					 array(
						  'name'=>'服务商中心',
						  'icon'=>'',
						  'url'=>U('/seller'),
						  'controller'=>'index',
						  'action'=>'index'  //应用动作类名
					 ), 
					array(
						  'name'=>'我的订单',
						  'icon'=>'',
						  'url'=>U('/seller/task'),
						  'controller'=>'task',
						  'action'=>'index'  //应用动作类名
					 ),
					array(
						  'name'=>'我的收藏',
						  'icon'=>'',
						  'url'=>U('/seller/favorites'),
						  'controller'=>'favorites',
						  'action'=>'index'  //应用动作类名
					 ),  					 

				)
               
			),
			
					
			//店铺管理
          	array(
				'name'=>'店铺管理',
               	'icon'=>'glyphicon glyphicon-home',
				'controller'=>array('shop'), //控制器
				'submenu'=>array(
					
					array(
						  'name'=>'我的店铺',
						  'icon'=>'',
						  'url'=>U('/seller/shop'),
						  'controller'=>'shop',
						  'action'=>'index'  //应用动作类名
					 ), 
					 
					 array(
						  'name'=>'店铺LOGO',
						  'icon'=>'',
						  'url'=>U('/seller/shop/logo'),
						  'controller'=>'shop',
						  'action'=>'logo'  //应用动作类名
					 ), 
					 
					 array(
						  'name'=>'店铺幻灯片',
						  'icon'=>'',
						  'url'=>U('/seller/shop/slide'),
						  'controller'=>'shop',
						  'action'=>'slide'  //应用动作类名
					 )					 

				)
               
			),
			
			//服务管理
          	array(
				'name'=>'服务管理',
               	'icon'=>'glyphicon glyphicon-shopping-cart',
				'controller'=>array('fuwu'), //控制器
				'submenu'=>array(
				
					 array(
						  'name'=>'发布服务',
						  'icon'=>'',
						  'url'=>U('/fuwu/publish/index'),
						  'controller'=>'fuwu',
						  'action'=>'index'  //应用动作类名
					 ), 

					array(
						  'name'=>'已发布的服务',
						  'icon'=>'',
						  'url'=>U('/seller/fuwu'),
						  'controller'=>'fuwu',
						  'action'=>'index'  //应用动作类名
					 ),  					 

				)
               
			),
          
			//评价管理
          	array(
				'name'=>'评价管理',
               	'icon'=>'glyphicon glyphicon-comment',
				'controller'=>array('evaluate'), //控制器
				'submenu'=>array(
				
					array(
						  'name'=>'评价管理',
						  'icon'=>'',
						  'url'=>U('/seller/evaluate'),
						  'controller'=>'evaluate',
						  'action'=>'index'  //应用动作类名
					),

				)
               
			),
			
			//退款管理
          	array(
				'name'=>'退款管理',
               	'icon'=>'glyphicon glyphicon-fire',
				'controller'=>array('refund'), //控制器
				'submenu'=>array(
				
					array(
						  'name'=>'我收到的退款',
						  'icon'=>'',
						  'url'=>U('/seller/refund'),
						  'controller'=>'refund',
						  'action'=>'index'  //应用动作类名
					),   

				)
               
			),
			
			//举报管理
          	array(
				'name'=>'举报管理',
               	'icon'=>'glyphicon glyphicon-hand-up',
				'controller'=>array('report'), //控制器
				'submenu'=>array(
				
					array(
						  'name'=>'我发的举报',
						  'icon'=>'',
						  'url'=>U('/seller/report'),
						  'controller'=>'report',
						  'action'=>'index'  //应用动作类名
					),  
					
					array(
						  'name'=>'我收到的举报',
						  'icon'=>'',
						  'url'=>U('/seller/report/other'),
						  'controller'=>'report',
						  'action'=>'other'  //应用动作类名
					),  

				)
               
			),

		);
	
	}
	
	//买家菜单
	public function BuyerMenuArray(){         

        return array(
		
			//交易管理
          	array(
				'name'=>'交易管理',
               	'icon'=>'glyphicon glyphicon-th-list',
				'controller'=>array('index','task'), //控制器
				'submenu'=>array(
				
					 array(
						  'name'=>'雇主中心',
						  'icon'=>'',
						  'url'=>U('/buyer'),
						  'controller'=>'index',
						  'action'=>'index'  //应用动作类名
					 ),
					 array(
						  'name'=>'我的订单',
						  'icon'=>'',
						  'url'=>U('/buyer/task'),
						  'controller'=>'task',
						  'action'=>'index'  //应用动作类名
					 )					 

				)
               
			),
          
			//评价管理
          	array(
				'name'=>'评价管理',
               	'icon'=>'glyphicon glyphicon-comment',
				'controller'=>array('evaluate'), //控制器
				'submenu'=>array(
				
					array(
						  'name'=>'评价管理',
						  'icon'=>'',
						  'url'=>U('/buyer/evaluate'),
						  'controller'=>'evaluate',
						  'action'=>'index'  //应用动作类名
					),

				)
               
			),
			
			//退款管理
          	array(
				'name'=>'退款管理',
               	'icon'=>'glyphicon glyphicon-fire',
				'controller'=>array('refund'), //控制器
				'submenu'=>array(
				
					array(
						  'name'=>'退款管理',
						  'icon'=>'',
						  'url'=>U('/buyer/refund'),
						  'controller'=>'refund',
						  'action'=>'index'  //应用动作类名
					),   

				)
               
			),
			
			//举报管理
          	array(
				'name'=>'举报管理',
               	'icon'=>'glyphicon glyphicon-hand-up',
				'controller'=>array('report'), //控制器
				'submenu'=>array(
				
					array(
						  'name'=>'我发的举报',
						  'icon'=>'',
						  'url'=>U('/buyer/report'),
						  'controller'=>'report',
						  'action'=>'index'  //应用动作类名
					),  
					
					array(
						  'name'=>'我收到的举报',
						  'icon'=>'',
						  'url'=>U('/buyer/report/other'),
						  'controller'=>'report',
						  'action'=>'other'  //应用动作类名
					),  

				)
               
			),

		);
	}
	
	
	public function MemberMenuArray(){         
          //帐号管理菜单
        return array(
		
			//个人资料
          	array(
				'name'=>'个人资料',
               	'icon'=>'glyphicon glyphicon-user',
				'controller'=>array('index','avatar','info','contact','works','billaddress','location'), //控制器
				'submenu'=>array(
				
					 array(
						  'name'=>'安全信息',
						  'icon'=>'',
						  'url'=>U('/member'),
						  'controller'=>'index',
						  'action'=>'index'  //应用动作类名
					 ),                   
				
					 array(
						  'name'=>'个人信息',
						  'icon'=>'',
						  'url'=>U('/member/info'),
						  'controller'=>'info',
						  'action'=>'index'
					 ),
					 
					 array(
						  'name'=>'上传头像',
						  'icon'=>'',
						  'url'=>U('/member/avatar'),
						  'controller'=>'avatar',
						  'action'=>'index'
					 ),
					 
					 array(
						  'name'=>'联系方式',
						  'icon'=>'',
						  'url'=>U('/member/contact'),
						  'controller'=>'contact',
						  'action'=>'index'
					 ),
					 
					 array(
						  'name'=>'工作经历',
						  'icon'=>'',
						  'url'=>U('/member/works'),
						  'controller'=>'works',
						  'action'=>'index'
					 ),
					 
					 array(
						  'name'=>'收货地址',
						  'icon'=>'',
						  'url'=>U('/member/billaddress'),
						  'controller'=>'billaddress',
						  'action'=>'index'
					 ),
					 array(
						  'name'=>'我的位置',
						  'icon'=>'',
						  'url'=>U('/member/location'),
						  'controller'=>'location',
						  'action'=>'index'
					 )
				)
               
			),
          
			//消息
          	array(
				'name'=>'消息',
               	'icon'=>'glyphicon glyphicon-comment',
				'controller'=>array('dialog','notice'), //控制器
				'submenu'=>array(
				
					array(
						  'name'=>'站内消息',
						  'icon'=>'',
						  'url'=>U('/member/dialog'),
						  'controller'=>'dialog',
						  'action'=>'index'  //应用动作类名
					),	 
					array(
						  'name'=>'站内通知',
						  'icon'=>'',
						  'url'=>U('/member/notice'),
						  'controller'=>'notice',
						  'action'=>'index'  //应用动作类名
					),    

				)
               
			),
			
			//帐号绑定
          	array(
				'name'=>'账号绑定',
               	'icon'=>'glyphicon glyphicon-transfer',
				'controller'=>array('mobile','email','sinaweibo','qqweibo'), //控制器
				'submenu'=>array(
				
					array(
						  'name'=>'手机验证',
						  'icon'=>'',
						  'url'=>U('/member/mobile'),
						  'controller'=>'mobile',
						  'action'=>'index' 
					),	 
					array(
						  'name'=>'邮箱验证',
						  'icon'=>'',
						  'url'=>U('/member/email'),
						  'controller'=>'email',
						  'action'=>'index'
					),    
					array(
						  'name'=>'新浪微博绑定',
						  'icon'=>'',
						  'url'=>U('/member/sinaweibo'),
						  'controller'=>'sinaweibo',
						  'action'=>'index'
					),  
					array(
						  'name'=>'QQ微博绑定',
						  'icon'=>'',
						  'url'=>U('/member/qqweibo'),
						  'controller'=>'qqweibo',
						  'action'=>'index'
					),  
				)
               
			),
			
			//安全设置
          	array(
				'name'=>'安全设置',
               	'icon'=>'glyphicon glyphicon-tower',
				'controller'=>array('changepassword','idsecurity'), //控制器
				'submenu'=>array(
				
					array(
						  'name'=>'修改登录密码',
						  'icon'=>'',
						  'url'=>U('/member/changepassword'),
						  'controller'=>'changepassword',
						  'action'=>'index' 
					),	 
					array(
						  'name'=>'账号安全保护',
						  'icon'=>'',
						  'url'=>U('/member/idsecurity'),
						  'controller'=>'idsecurity',
						  'action'=>'index'
					)
				)
               
			),
			
			//我的金钱
          	array(
				'name'=>'我的金钱',
               	'icon'=>'fa fa-jpy',
				'controller'=>array('consume','payin','payout'), //控制器
				'submenu'=>array(
				
					array(
						  'name'=>'交易记录',
						  'icon'=>'',
						  'url'=>U('/member/consume'),
						  'controller'=>'consume',
						  'action'=>'index' 
					),	 
					array(
						  'name'=>'充值',
						  'icon'=>'',
						  'url'=>U('/member/payin'),
						  'controller'=>'payin',
						  'action'=>'index'
					),
					array(
						  'name'=>'提现',
						  'icon'=>'',
						  'url'=>U('/member/payout'),
						  'controller'=>'payout',
						  'action'=>'index'
					),
				)
               
			),
			
			//支付宝
          	array(
				'name'=>'支付帐号管理',
               	'icon'=>'glyphicon glyphicon-credit-card"',
				'controller'=>array('bankcard'), //控制器
				'submenu'=>array(
				
					array(
						  'name'=>'支付宝帐号',
						  'icon'=>'',
						  'url'=>U('/member/bankcard'),
						  'controller'=>'bankcard',
						  'action'=>'index' 
					)
				)
               
			),
			
			//推广
          	array(
				'name'=>'推广',
               	'icon'=>'glyphicon glyphicon-barcode"',
				'controller'=>array('spread'), //控制器
				'submenu'=>array(
				
					array(
						  'name'=>'推广会员',
						  'icon'=>'',
						  'url'=>U('/member/spread/index'),
						  'controller'=>'spread',
						  'action'=>'index' 
					),
					array(
						  'name'=>'推广联盟',
						  'icon'=>'',
						  'url'=>U('/member/spread/code'),
						  'controller'=>'spread',
						  'action'=>'code' 
					)
				)
               
			),
          
		);
	}
		  
		  
	//获取当前模块URL
	public function GetModuleUrl(){
		return strtolower('/'.MODULE_NAME.'/'.CONTROLLER_NAME);
	}
	
	//获取模块名称
	public function GetModuleName(){
		return MODULE_NAME;
	}

	//获取控制器名称
	public function GetControllerName(){
		return strtolower(CONTROLLER_NAME) ? strtolower(CONTROLLER_NAME) : 'index';
	}
	
	//获取动作名称
	public function GetActionName(){
		return strtolower(ACTION_NAME) ? strtolower(ACTION_NAME) : 'index';
	}
	
    public function indexAction(){
		
		$model=new \Member\Model\MemberModel();
		
		$isemail=M('MemberCertificate')->token(false)->where(" type=1 AND uid=$this->uid AND status=5 ")->count();
		$ismobile=M('MemberCertificate')->token(false)->where(" type=2 AND uid=$this->uid AND status=5 ")->count();
		
		$this->assign('isemail',$isemail);
		$this->assign('ismobile',$ismobile);
		
		$this->display();	
    }
}