<?php
/************************FoxPHP威客系统************************/
/*                                                            */
/*  FoxPHP.Com (C)2006-2016 FoxPHP Inc.                       */
/*  This is NOT a freeware, use is subject to license terms   */
/*  FoxPHP威客系统是商业软件,使用于商业用途请购买授权         */
/*  V3.0 2016.3                                               */
/*  foxphp@aliyun.com                                         */
/*  http://www.foxphp.com                                     */
/*                                                            */
/**************************************************************/


namespace MemberCertificate\Model;
use Think\Model;

class MemberCertificateModel extends Model {
	
	//是否手机认证
	function IsMobileCertificate($mobile=0){
		if(!$mobile){
			$mobile=IsNum($_POST['mobile'])? $_POST['mobile'] : 0;
		}
		if($mobile){
			if($this->token(false)->where(" mobile='%d' AND status=5 ",$mobile)->count()){
				$this->error='对不起!手机号码已存在!';
				return true;
			}else{
				$this->error='对不起!手机号码不存在!';
				return false;
			}
		}else{
			$this->error='对不起!手机号码不存在!';
			return false;
		}
	}
	
	//是否邮箱认证
	function IsEMailCertificate($email=''){
		if(!$email){
			$_POST['email']=I('post.email','','email');
			$email=I('post.email','email');
		}
		
		if($email){
			if($this->token(false)->where(" email='%s' AND status=5 ",$email)->count()){
				$this->error='对不起!邮箱已存在!';
				return true;
			}else{
				$this->error='对不起!邮箱不存在!';
				return false;
			}
		}else{
			$this->error='对不起!邮箱格式有误!';
			return false;
		}
	}
	
	
	
	//创建
	function CreateCertificate($post){
		if($this->token(false)->create($post)){
			$this->add();
			return true;
		}else{
			//$this->error='对不起!提交错误!';
			return false;
		}
	}
	
	
	//发验证码
	function SendCode($type='mobile',$resend=0){
		
		$mobile=IsNum($_POST['mobile'])? $_POST['mobile'] : 0;
		$change=$_POST['change']==1 ? 1 :0;
		$email=I('post.email','','email');
		
		$iscertificate=false;
		if($type=='mobile'){
			if(!$mobile && !$this->uid){
				$this->error='对不起!手机格式错误!';
				return false;
			}
			//手机是否认证过了
			$certificate=$this->where(" uid=$this->uid AND type=2 ")->find();
			$sqlwhere=" uid=$this->uid AND regtype='mobile' ";
			if(!$resend){
				if(($certificate['mobile']==$mobile && $change==1) || (empty($certificate['uid']) && $change!=1) ){	
					$iscertificate=true;
					$sendcode=RandomText(6,2);
					$postarray=array(C('TOKEN_NAME')=>$_POST[C('TOKEN_NAME')],'uid'=>$this->uid,'username'=>$this->username,'dateline'=>NowTime(),'code'=>$sendcode,'regtype'=>'mobile','mobile'=>$mobile);
				}
			}else{
				$iscertificate=true;
			}
		}elseif($type=='email'){
			if(!$email && !$this->uid){
				$this->error='对不起!邮箱格式错误!';
				return false;
			}
			$certificate=$this->where(" uid=$this->uid AND type=1 ")->find();
			$sqlwhere=" uid=$this->uid AND regtype='email' ";
			if(!$resend){
				if(($certificate['email']==$email && $change==1) || (empty($certificate['uid']) && $change!=1) ){	
					$iscertificate=true;
					$sendcode=RandomText(16,1);
					$postarray=array(C('TOKEN_NAME')=>$_POST[C('TOKEN_NAME')],'uid'=>$this->uid,'username'=>$this->username,'dateline'=>NowTime(),'code'=>$sendcode,'regtype'=>'email','email'=>$email);
				}
			}else{
				$iscertificate=true;
			}
		}
		
		//已认证过并更换手机号 或 新认证
		if($iscertificate){	
			$memberverify=new \Register\Model\MemberVerifyModel();
			$manage=$memberverify->IsMemberVerify($sqlwhere);
			if($manage['id']){
				if($memberverify->SendCode($manage['id'])){
					$this->success='发送成功！请注意查收！';
					return $manage['id'];
				}else{
					$this->error=$memberverify->getError();
					return false;
				}
			}elseif(!$resend){
				$id=$memberverify->CreateMemberVerify($postarray);
				if($id){
					$memberverify->SendCode($id);
					$this->success='发送成功！请注意查收！';
					return $id;
				}else{
					$this->error='保存数据失败！！'.$memberverify->getError();
				}
			}
			return false;
		}
		
		if($type=='mobile'){
			if($change){
				$this->error='原手机号码有误！';
			}else{
				$this->error='该手机已注册过了！';
			}
		}else{
			if($change){
				$this->error='原邮箱地址有误！';
			}else{
				$this->error='该邮箱地址已注册过了！';
			}
		}
		return false;
		
	}
	
	//验证手机码
	function VerifyCode(){
		$change=$_POST['change']==1 ? 1 :0;
		$id=intval($_POST['id']);
		if($id){
			$manage=M('MemberVerify')->where(" uid=$this->uid AND id=$id AND status!=1")->find();
			if(empty($manage['id'])){
				$this->error='数据不存在!';
				return false;
			}
		}else{
			$this->error='数据不存在!!';
			return false;
		}
		
		if (IS_POST && $manage){
			if(preg_match("/^[a-z0-9]+$/i",trim($_POST['code'])) && $_POST['code']){ 
				$code=$manage['code'];
				if(trim($_POST['code'])==$code){			
					if(NowTime() > ($manage['dateline']+86400)){
						M('MemberVerify')->where(" code='$code' AND id='$id' ")->save(array('status'=>2));
						//失败
						$this->error='激活码已过期!请重新发送激活码!';
						return false;
					}else{
						//注册模块
						if($manage['regtype']=='mobile'){
							$certificate=$this->where(" uid=$this->uid AND type=2")->find();
							$postcertificate=array('uid'=>$this->uid,'type'=>2,'dateline'=>NowTime(),'mobile'=>$manage['mobile'],'code'=>$manage['code'],'status'=>5);
						}else{
							$certificate=$this->where(" uid=$this->uid AND type=1")->find();
							$postcertificate=array('uid'=>$this->uid,'type'=>1,'dateline'=>NowTime(),'email'=>$manage['email'],'code'=>$manage['code'],'status'=>5);
						}
						
						if($change==1 && intval($certificate['status'])==5){
							//换手机号码
							if($manage['regtype']=='mobile'){
								$this->where(" uid=$this->uid AND type=2 AND status=5")->delete();
								$this->success='验证原手机成功！请重新认证新手机！';
							}else{
								$this->where(" uid=$this->uid AND type=1 AND status=5")->delete();
								$this->success='验证原邮箱成功！请重新认证新邮箱！';
							}
							M('MemberVerify')->where(" id=$id ")->delete();
							return true;
						}else{
							if(empty($certificate)){
								if($this->CreateCertificate($postcertificate)){
									M('MemberVerify')->where(" id=$id ")->delete();
									if($this->uid){
										if($manage['regtype']=='mobile'){
											$postmember=array('mobile'=>$manage['mobile']);
										}else{
											$postmember=array('email'=>$manage['email']);
										}
										M('Member')->token(false)->where(" uid=$this->uid ")->save($postmember);
									}
									$this->success='认证成功！';
									return true;
								}else{
									$this->error=$this->getError();
									return false;
								}
							}
							$this->error='数据已存在！';
							return false;
						}
					}
				}else{
					$this->error='您输入的激活码有误！请重新输入！';
					return false;
				}
			}else{
				$this->error='您输入的激活码格式有误！';
				return false;
			}
		}else{
			$this->error='没有数据提交！';
			return false;
		}
		
	}
	
}

?>