<?php
/************************FoxPHP威客系统************************/
/*                                                            */
/*  FoxPHP.Com (C)2006-2016 FoxPHP Inc.                       */
/*  This is NOT a freeware, use is subject to license terms   */
/*  FoxPHP威客系统是商业软件,使用于商业用途请购买授权         */
/*  V3.0 2016.3                                               */
/*  foxphp@aliyun.com                                         */
/*  http://www.foxphp.com                                     */
/*                                                            */
/**************************************************************/


namespace Refund\Model;
use Think\Model;
use \Org\Util\String;

class RefundModel extends Model {
	
	public function GetRefund($type=1){
		$pagenum=intval($_GET['p']);
		
		if($type==1){
			//我发退款
			$wheresql=" buyer_uid=$this->uid";
		}else{
			//我收到的退款
			$wheresql=" seller_uid=$this->uid";
		}

		$list=$this->token(false)->where($wheresql)->order('dateline DESC')->page($pagenum,10)->select();

		//页码-------------------------------
		$count=$this->token(false)->where($wheresql)->count();
		$Page = new \Think\Page($count,10);
		
		return array('list'=>$list,'page'=>$Page->show());
	}
	
	public function ShowRefund($rid=0){
		$rid=intval($rid);
		return $this->token(false)->where(" rid=$rid ")->find();
	}
	
	public function GetReportMessage(){
		$pagenum=intval($_GET['p']);
		$rid=intval($_GET['rid']);
		$wheresql=" rid=$rid ";
		$list=M('RefundMessage')->token(false)->where($wheresql)->order('dateline DESC')->page($pagenum,10)->select();

		//页码-------------------------------
		$count=M('RefundMessage')->token(false)->where($wheresql)->count();
		$Page = new \Think\Page($count,10);
		
		return array('list'=>$list,'page'=>$Page->show());
	}
	
	//留言说明
	public function ReportMessage(){
		
		$data=$this->ShowRefund(intval($_POST['rid']));
		$rid=$data['rid'];
		if(empty($rid)){
			$this->error='数据不在！';
			return false;
		}

		if($data['process']==3){
			$this->error='当前状态无法操作！';
			return false;
		}
		
		if($data['seller_uid']==$this->uid || $data['buyer_uid']==$this->uid){

			$post=array('rid'=>$rid,'dateline'=>NowTime(),'uid'=>$this->uid,'username'=>$this->username);
			$post['content']=String::msubstr(I('post.content'),0,200,C('S_CHARSET'),false);
			
			if(empty($post['content'])){
				$this->error='请输入说明内容！';
				return false;
			}
			
			if (M('RefundMessage')->token(false)->create($post)){
				if($id=M('RefundMessage')->token(false)->add()){
					return $id;
				}
			}
			$this->error=M('RefundMessage')->getError();
			
		}else{
			$this->error='没有权限操作！';
		}
		return false;
	}
	
	//不同意退款
	public function ReportDisagree(){
		$rid=intval($_POST['rid']);
		$data=$this->ShowRefund($rid);
		$rid=$data['rid'];
		$refundmoney=intval($data['refund']);
		if(empty($rid) && $refundmoney>0){
			$this->error='数据不在！';
			return false;
		}
		
		if($data['process']>1){
			$this->error='该退款已处理过了！';
			return false;
		}
		
		if($data['seller_uid']==$this->uid || IsService($data['service_uid'])){
			
			$this->startTrans();
			
			if($this->token(false)->lock(true)->where(" rid=$rid AND process>1 ")->count()){
				$this->error='该退款已处理过了！！';
				$this->commit();
				return false;
			}
			

				
				/*
				$send_subject=$task['tid'].'号任务订单退款成功。';
				$send_content='尊敬的用户：'.$task['tid'].' 号任务订单退款'.$consume['refundmoney'].'元成功！<a href="'.SURL.'/member.php?app=5&action=1&cid='.$newcid.'&opensearch=1&SelectData=1" target="_blank"><span class="show_details">[查看详细]</span></a>';

				$this->Port(array(


				'receive_uid'=>$task['uid'], 

					//SMS
					'sms_subject'=>$send_subject,
					'sms_content'=>$send_content,

					//EMail
					'email_title'=>$send_subject,
					'email_content'=>$send_content,

					//Mobile
					'mobile_content'=>$send_subject

					),20);

				}*/
			
			
			$post=array('process'=>2);
		
			if($this->token(false)->lock(true)->where(" rid=$rid AND process<2 ")->save($post)){
				$this->commit();
				return true;
			}
			
			$this->commit();
			$this->error=$this->getError();
			return false;
			
		}else{
			$this->error='没有权限操作！';
		}
		return false;
		
	}
	
	//同意退款
	public function ReportAgree($rid=0,$refundmoney=0,$isadmin=0){
		if(!$rid){
			$rid=intval($_POST['rid']);
		}
		$data=$this->ShowRefund($rid);
		$rid=$data['rid'];
		
		if(!$refundmoney){
			$refundmoney=intval($data['refund']);
		}
		
		if(empty($rid) && $refundmoney>0){
			$this->error='数据不在！';
			return false;
		}
		
		if($isadmin){
			if($data['process']>2){
				$this->error='该退款已处理过了！';
				return false;
			}
		}else{
			if($data['process']>1){
				$this->error='该退款已处理过了！';
				return false;
			}
		}
		
		if($data['seller_uid']==$this->uid || IsAdmin($this->uid) || IsService($data['service_uid'])){
			
			$this->startTrans();
			
			if($this->token(false)->lock(true)->where(" rid=$rid AND process=3 ")->count()){
				$this->error='该退款已处理过了！！';
				$this->commit();
				return false;
			}
			
			$consume=new \Consume\Model\ConsumeModel();
			if($consume->SetReport($data['cid'],$refundmoney)){
				
				$model=new \Data\Model\DataModel();
				$model->PayOrder($model->GetData($data['id']),$data['oid']);
				
				//退款
				$post=array(
					'subject'=>$data['id'].'号任务订单退款',  
					'dataid' =>$data['id'],
					'amount' =>$refundmoney,
					'payin_uid'=>$data['buyer_uid'],
					'payin_username'=>$data['buyer_username'],
				);
				
				$consume->startTrans();
				if($cid=$consume->AddConsume($post)){
					$consume->SuccessConsume($cid); 
				}
				$consume->commit();
				
				/*
				$send_subject=$task['tid'].'号任务订单退款成功。';
				$send_content='尊敬的用户：'.$task['tid'].' 号任务订单退款'.$consume['refundmoney'].'元成功！<a href="'.SURL.'/member.php?app=5&action=1&cid='.$newcid.'&opensearch=1&SelectData=1" target="_blank"><span class="show_details">[查看详细]</span></a>';
				*/
			
			}

			$post=array('endtime'=>NowTime(),'process'=>3,'refund'=>$refundmoney);
		
			if($this->token(false)->lock(true)->where(" rid=$rid AND process!=3 ")->save($post)){
				$this->commit();
				return true;
			}
			
			$this->commit();
			$this->error=$this->getError();
			return false;
			
		}else{
			$this->error='没有权限操作！';
		}
		return false;
	}
}

?>