<?php
/************************FoxPHP威客系统************************/
/*                                                            */
/*  FoxPHP.Com (C)2006-2016 FoxPHP Inc.                       */
/*  This is NOT a freeware, use is subject to license terms   */
/*  FoxPHP威客系统是商业软件,使用于商业用途请购买授权         */
/*  V3.0 2016.3                                               */
/*  foxphp@aliyun.com                                         */
/*  http://www.foxphp.com                                     */
/*                                                            */
/**************************************************************/


namespace Register\Model;
use Think\Model;

class MemberModel extends Model {
	
	protected $insertFields = array('username','usertype','typename','password','powercode','usergroup','groupname','email','unionid','uniontime','regip','dateline','mobile','unionid','uniontime','unionname');

	//提交注册
	function RegisterSubmit(){

		if($this->uid>0){
			$this->error='对不起!您已是会员了';
			return false;
		}

		if (!IS_POST){
			$this->error='对不起!没有数据请求！';
			return false;
		}
		
		require(FOXPHP_PATH."/Apps/Hook/GeeTest/geetest.php");
		$geetest = new \Geetest();
		$geetest->set_privatekey(C('Geetest_Key'));
				
		if(isset($_POST['geetest_challenge']) && isset($_POST['geetest_validate']) && isset($_POST['geetest_seccode'])) {
			$result = $geetest->validate($_POST['geetest_challenge'], $_POST['geetest_validate'], $_POST['geetest_seccode']);
			if ($result == FALSE) {
				$this->error='对不起!验证码有误！';
				return false;
			} 

		}else{
			$verify = new \Think\Verify();
			if(!$verify->check($_POST['seccode'])){
				$this->error='对不起!验证码有误！';
				return false;
			}
		}
	 
		if($id=$this->RegisterMemberVerify()){
			return $id;
		}else{
			return false;
		}
		

	}
	
	function RegisterMemberVerify(){
		//加入临时表等待验证  
		if($_POST['agreement']=='on'){   

			//检测是否可以注册
			if(!$this->CheckRegister()){
				return false;
			}
			
			//注册
			$id=$this->VerifyRegister();

			//发送验证码
			if($_POST['regtype']=='mobile'){
				//发送手机验证码
				$this->success= '注册成功！等待您验证手机！';
			}else{
				//发送邮箱验证码
				$this->success= '注册成功！等待您验证邮箱！';
			}
			  
  			return $id;
			 
		}else{
			$this->error='对不起!您未接受使用协议不能注册!';
			return false;
		}

		
	}
	
	function VerifyRegister(){
		$username=I('post.username');
		$password=I('post.password');
		$mobile=IsNum($_POST['mobile'])? $_POST['mobile'] : 0;
		$_POST['email']=I('post.email','','email');
		$email=I('post.email','email');
		$powercode=RandomText(16,1);
		if($_POST['regtype']=='mobile'){
			$sqlwhere=" mobile='$mobile' ";
			$sendcode=RandomText(6,2);
			$regtype='mobile';
		}else{
			$sqlwhere=" email='$email' ";
			$sendcode=RandomText(16,1);
			$regtype='email';
		}
		
		$passwordtrue=McryptEncrypt($password);

		$password=PasswordKey($username,$password,$powercode);

		$postarray=array(C('TOKEN_NAME')=>$_POST[C('TOKEN_NAME')],'username'=>$username,'password'=>$password,'passwordtrue'=>$passwordtrue,'powercode'=>$powercode,'regip'=>GetClientIp(),'dateline'=>NowTime(),'code'=>$sendcode,'regtype'=>$regtype,'mobile'=>$mobile,'email'=>$email);
		
		$unionid=intval(session('UNION'));
		if($unionid){
			$member=M('Member')->token(false)->where(" uid=$unionid ")->field('uid,username')->find();
			if(!empty($member['uid'])){
				if(intval(C('uniontime'))>0){
					$uniontime=time()+(24*60*60*intval(C('uniontime')));
				}else{
					$uniontime=0;
				}
				$postarray['unionid']=$unionid;
				$postarray['uniontime']=$uniontime;
				$postarray['unionname']=$member['username'];
			}
		}
		
		$memberverify=new \Register\Model\MemberVerifyModel();
		$manage=$memberverify->IsMemberVerify($sqlwhere);
		
		if($manage['id']){
			if($memberverify->SendCode($manage['id'])){
				return $manage['id'];
			}else{
				$this->error=$memberverify->getError();
				return false;
			}
		}else{
			$id=$memberverify->CreateMemberVerify($postarray);
			$memberverify->SendCode($id);
			return $id;
		}
	}
	
	//验证用户名
	function IsUserNameMember($username=''){
		$model=new \Member\Model\MemberModel();
		return $model->UserNameGetMember($username);
	}
	
	//禁止注册名称
	function AllowRegisterUserName($username=''){
		
		$allowregisterusername=C('allowregisterusername');
		
          if($allowregisterusername){
			  
			$allowregisterusername=str_replace('*','(.*)',$allowregisterusername);
			$allowarr=explode(',',$allowregisterusername);

			foreach($allowarr as $value){

				$mun=@preg_match_all("/$value/i",$username);

				if($mun>0){
					return false;
				}
			}

			return true;

		}else{
			return true;	 
		}
	}
	
	
	//注册会员
	function RegisterMember($post=array(),$isuc=1){
		
		$post=array_merge($post,array(C('TOKEN_NAME')=>$_POST[C('TOKEN_NAME')],'usertype'=>1,'typename'=>'个人','usergroup'=>3,'groupname'=>'普通会员','regip'=>GetClientIp(),'dateline'=>NowTime()));
		
		if($isuc){
			
			if($post['regtype']=='mobile'){
				//手机注册,补丁UC邮件
				$post['email']=!empty($post['email']) ? $post['email'] : RandomText(6,1).'@'.RandomText(6,1).'.com' ;
			}	
			
			if($uclient=GetClient($post)){
			 
				$ucreturn = $uclient->checkename();

				if($ucreturn == -1) {
					$this->error='对不起!昵称不合法';
					return false;
				}elseif($ucreturn == -2) {
					$this->error='对不起!昵称包含要允许注册的词语';
					return false;
				}elseif($ucreturn == -3) {
					$this->error='对不起!用户名已经注册!';
					return false;
				}
				
			}elseif($this->IsUserNameMember($post['username'])){
				$this->error='对不起!数据写入重复!';
				return false;
			}

			if(!empty($uclient)){
				
				$apiuid = $uclient->register();

				if($apiuid>0){
					$post['uid']=$apiuid;
				}else{
					switch($apiuid){
						case -1:				  
						$this->error= '用户名不合法';
						break;
						case -2:
						$this->error= '包含要允许注册的词语';				  
						break;
						case -3:
						$this->error= '用户名已经存在';
						break;
						case -4:
						$this->error= 'Email 格式有误';
						break;
						case -5:
						$this->error= 'Email 不允许注册';
						break;
						case -6:
						$this->error= '该 Email 已经被注册';
						break;
					}
					return false;
				}
			}
			
			if($this->create($post)){
				$newuid=$this->add();
			}else{
				return false;
			}
			
		}else{
			if($this->token(false)->create($post)){
				$newuid=$this->token(false)->add();
			}else{
				return false;
			}
		}

		if($newuid>0){
			
			if($isuc){
				if($post['regtype']=='mobile'){
					$postcertificate=array('uid'=>$newuid,'type'=>2,'dateline'=>NowTime(),'mobile'=>$post['mobile'],'code'=>$post['code'],'status'=>5);
				}else{
					$postcertificate=array('uid'=>$newuid,'type'=>1,'dateline'=>NowTime(),'email'=>$post['email'],'code'=>$post['code'],'status'=>5);
				}
			
				$certificate=new \MemberCertificate\Model\MemberCertificateModel();
				
				if($certificate->CreateCertificate($postcertificate)){
					return true;
				}else{
					$this->error=$certificate->getError();
					return false;
				}
			}
			
			return $newuid;
			
		}else{
			$this->error='对不起!数据写入失败!';
			return false;
		}
	}
	
	//UC使用
	function InsertMember($post=array()){
		if($this->create($post)){
			$newuid=$this->add();
		}else{
			return false;
		}
	}
	
	//检测注册
	function CheckRegister(){
		
		if($_POST['regtype']=='mobile'){
			//检查手机暂用
			if(!$this->CheckMobile()){
				return false;
			}
		}else{
			//检查EMail暂用
			if(!$this->CheckEMail()){
				return false;
			}
		}
		
		//检查暂用用户名
		if(!$this->CheckUserName()){
			return false;
		}
		
		if(!$this->CheckPassword()){
			return false;
		}
		
		return true;

	}
	
	function CheckPassword(){
		if(preg_match("/^[a-zA-Z0-9\%\@\#\!]+$/is",I('post.password'))){
			return true;
		}
		$this->error='对不起!密码格式支持英文大小字母和数字和符号%@#!组合';
		return false;
	}
	
	//检查手机暂用
	function CheckMobile(){
		
		$mobile=IsNum($_POST['mobile'])? $_POST['mobile'] : 0;
 
		if($mobile){   
 
			$mobilecertificate=new \MemberCertificate\Model\MemberCertificateModel();
			if($mobilecertificate->IsMobileCertificate()){
				$this->error='对不起!您输入的手机号码已经被注册!';
				return false;
			}else{
				return true;
			}
		}else{
			$this->error='对不起!您输入的手机号码格式有误!';
			return false;
		}
		
		return true;
	}
	
	
	function IsUserName($username) {
		
		$guestexp = '\xA1\xA1|\xAC\xA3|^\xD3\xCE\xBF\xCD|\xB9\x43\xAB\xC8'; 
		if(preg_match("/\s+|^c:\\con\\con|[%,\*\"\s\<\>\&]|$guestexp/is", $username)) {
			return false;
		}
			
		$str= @preg_replace_callback("/[a-zA-Z0-9]/",
		function ($matches) {
            return @$matches[1];
        }
		, $username);
		
		if($str){
			if (preg_match("/^[\x{4e00}-\x{9fa5}]+$/u",$str)) {
				return true;	
			}else{
				return false;
			} 
		
		}else{
			return true;
		}
	}
	
	//检查暂用用户名
	function CheckUserName(){
        

		$username=I('post.username');
		
		if(preg_match("/^[0-9]+$/",$username)) {
			$this->error='对不起!用户名不能纯数字!';
			return false;
		}
		
		if(preg_match("/\s/",$username)) {
			$this->error='对不起!用户名格式有误!!';
			return false;
		}
		
		if(!$this->IsUserName($username)){
			$username='';
		}

		if(!$username){
			$this->error='对不起!用户名格式有误!';
			return false;
		}
		
		if(!$this->AllowRegisterUserName($username)){
			$this->error='对不起!用户名已注册!';
			return false;
		}
		
		$username=I('post.username');
				
		
		if($uclient=GetClient(array('username'=>$username))){
		 
			$ucreturn = $uclient->checkename();
			if($ucreturn>0) {
				return true;
			}elseif($ucreturn == -1) {
				$this->error='对不起!昵称不合法';
				return false;
			}elseif($ucreturn == -2) {
				$this->error='对不起!昵称包含要允许注册的词语';
				return false;
			}elseif($ucreturn == -3) {
				$this->error='对不起!用户名已经注册!';
				return false;
			}

		}else{
			
			if($this->IsUserNameMember($username)){
				$this->error='对不起!用户名已经注册!';
				return false;
			}
		}
		
		return true;

	}
	
	
	//检查暂用EMail
	function CheckEMail(){
		
		$email=I('post.email','','email');
		
		if(!$this->IsEmail($email)){
			$this->error='对不起!邮箱格式有误!';
			return false;
		}
		

		if($uclient=GetClient(array('email'=>$email))){

			$ucreturn = $uclient->checkemail();

			if($ucreturn>0) {
				return true;
			}elseif($ucreturn==-4) {
				$this->error='对不起!您输入的电子邮箱格式有误!';
				return false;
			}elseif($ucreturn == -5) {
				$this->error='对不起!您输入的电子邮箱系统不允许注册!';
				return false;
			}elseif($ucreturn == -6) {
				$this->error='对不起!您输入的电子邮箱已经被注册!';
				return false;
			}
			
		}else{
	
			$mobilecertificate=new \MemberCertificate\Model\MemberCertificateModel();
			if($mobilecertificate->IsEMailCertificate()){
				$this->error='对不起!您输入的电子邮箱已经被注册!';
				return false;
			}else{
				return true;
			}
			
		}
		
		return true;

	}
	
	//检测Email
	function IsEmail($email){

		if(!preg_replace('/[\w]+|\@|\./','',$email)){

			if(preg_match('/([\w]+)(\@)([\w]+)(\.)([\w]+)/',$email)){
				return true;
			}else{
				return false;
			}
		}else{
			return false;
		}
	}
}

?>