<?php
/************************FoxPHP威客系统************************/
/*                                                            */
/*  FoxPHP.Com (C)2006-2016 FoxPHP Inc.                       */
/*  This is NOT a freeware, use is subject to license terms   */
/*  FoxPHP威客系统是商业软件,使用于商业用途请购买授权         */
/*  V3.0 2016.3                                               */
/*  foxphp@aliyun.com                                         */
/*  http://www.foxphp.com                                     */
/*                                                            */
/**************************************************************/


namespace Register\Model;
use Think\Model;

class MemberVerifyModel extends Model {
	
	protected $insertFields = array('uid','username','password','passwordtrue','powercode','dateline','regtype','verifytype','regip','email','mobile','code','unionid','uniontime','unionname');
	
	protected $_validate = array(
		//array('username','/^[\x{4e00}-\x{9fa5}]+|[a-zA-Z0-9]+$/u','用户名格式有误！',1,'regex'), 
		array('email','email','邮箱格式有误',2), 
		array('mobile','/^[0-9]+$/','手机号码格式有误',2,'regex'), 
	);

	
	function IsMemberVerify($sqlwhere){
		return $this->token(false)->where($sqlwhere)->find();
	}

	function CreateMemberVerify($data){
		if ($this->token(false)->create($data)){
			return $this->token(false)->add();
		}else{
			return false;
		}
	}
	
	function UpdateMemberVerify($data,$sqlwhere){
		if ($this->token(false)->where($sqlwhere)->save($data)){
			return true;
		}else{
			//exit($this->getError());
			return false;
		}
	}
	
	//删除数据
	function DeleteMemberVerify($sqlwhere){
		if ($this->token(false)->where($sqlwhere)->delete()){
			return true;
		}else{
			return false;
		}
	}
	
	
	//发送激活码
	function SendCode($id=0){
		$id=intval($id);
		if(!$id){
			
			if (!$this->autoCheckToken($_POST)){
				$this->error='表单验证失败！刷新页面后重试！';
				return false;
			}
			
			$id=intval($_POST['id']);
		}
		
		$member_verify = $this->IsMemberVerify(" id=$id ");
		if($member_verify['id']>0){

			if($member_verify['sendnum']>=6){
				$this->error='对不起!系统检测到您恶意发送次数太多，系统已列入黑名单禁用该帐号!';
				return false;
			}
			
			if($member_verify['sendnum']>0){
				//判断时间是否未到达 1 分钟
				if(NowTime() < ($member_verify['dateline']+60)){
					$this->error='对不起!您操作太快了,请休息一下再操作!';
					return false;
				}
				//每天发送次数
				if(!$this->IsMemberVerify(" id=$id AND dateline< (UNIX_TIMESTAMP()-7200) ")){
					$this->error='对不起!请两小时后再操作!';
					return false;
				}
			}
			
			if($member_verify['regtype']=='mobile'){
				$sendcode=RandomText(6,2);
			}else{
				$sendcode=RandomText(16,1);
			}
			
			//更新次数
			$this->token(false)->where("id=$id ")->save(array('dateline'=>NowTime(),'code'=>$sendcode,'sendnum'=>$member_verify['sendnum']+1));
			
			//发送验证码
			if($member_verify['regtype']=='mobile'){
				//手机模块
				$sendsms=array(
			          
					//接收
					'smsuid'=>0,
					
					//接收用户名
					'smsusername'=>$member_verify['username'],
					
					//接收手机
					'smsmobile'=>$member_verify['mobile'],
					
					//手机内容
					'smscontent'=>'感谢您进行'.C('sitename').'手机认证,验证码为：'.$sendcode.' 请在页面上输入验证码完成手机认证。非本人操作,请忽略本信息。'

				);
				
				//require_once(C('S_APPS')."/Hook/SendSMS/FoxSendSMS.php");
				//$sendsms = new \MobileSMS($sendsms);		
				//$sendsms->SendSMS();
				
				tag('SendSMS',$sendsms);

			}else{
				//邮箱模块
				if(!$this->uid){
					if($member_verify['verifytype']!=3){
						$mailcontent='<h1><a href="'.C('S_URL').'/register/verify/id/'.$id.'" target="_blank">'.C('sitename').'激活地址</a></h1><p>'.C('S_URL').'/register/verify/id/'.$id.'</p>';
					}
				}
				$sendmail=array(
			          
					//接收邮箱
					'mailto'=>$member_verify['email'],
					//邮件标题
					'mailsubject'=>C('sitename').'邮箱认证',
					//邮件内容
					'mailcontent'=>$mailcontent.'<h2>激活码</h2><p><b>'.$sendcode.'</b></p> <p>手动复制以上激活码打开浏览器</p><p>输入激活码提交验证</p>'

				);
				
				tag('SendMail',$sendmail);

			}
			
				 
			$this->success='发送成功！请注意查收！';
			return true;


		}else{
			$this->error='对不起!数据不存在!';
			return false;
		}
	}
	
	//提交验证
	function PostVerify($manage){
		if (IS_POST && $manage){
			if(preg_match("/^[a-z0-9]+$/i",trim($_POST['code'])) && $_POST['code']){ 
				$code=$manage['code'];
				if(trim($_POST['code'])==$code){			
					if(NowTime() > ($manage['dateline']+86400)){
						$this->where(" code='$code' AND id='$id' ")->save(array('status'=>2));
						//失败
						$this->error='激活码已过期!请重新发送激活码!';
						return false;
					}else{
						//注册模块
						$member=new \Register\Model\MemberModel();
						if($member->RegisterMember($manage)){	
							$this->success='恭喜您,激活成功！';
							return true;
						}else{
							$this->error=$member->getError();
							return false;
						}
					}
				}else{
					$this->error='您输入的激活码有误！请重新输入！';
					return false;
				}
			}else{
				$this->error='您输入的激活码格式有误！';
				return false;
			}
		}else{
			$this->error='没有数据提交！';
			return false;
		}
	}
	
	//找回密码
	function Forgotpassword(){
		
		require(FOXPHP_PATH."/Apps/Hook/GeeTest/geetest.php");
		$geetest = new \Geetest();
		$geetest->set_privatekey(C('Geetest_Key'));
				
		if(isset($_POST['geetest_challenge']) && isset($_POST['geetest_validate']) && isset($_POST['geetest_seccode'])) {
			$result = $geetest->validate($_POST['geetest_challenge'], $_POST['geetest_validate'], $_POST['geetest_seccode']);
			if ($result == FALSE) {
				$this->error='对不起!验证码有误！';
				return false;
			} 
		}
		
		$mobile=IsNum($_POST['mobile'])? $_POST['mobile'] : 0;
		$_POST['email']=I('post.email','','email');
		$email=I('post.email','email');
		
		$certificate=new \MemberCertificate\Model\MemberCertificateModel();
		if($_POST['tooltype']==2){
			$sqlwhere=" mobile='$mobile' AND verifytype=3 ";
			$sendcode=RandomText(6,2);
			$regtype='mobile';
			if(!$certificate->IsMobileCertificate($mobile)){
				$this->error='手机不存在或未认证！';
				return false;
			}
			
			$certificatearray=M('MemberCertificate')->where(" mobile=%d AND type=2 AND status=5 ",$mobile)->find();
			
		}else{
			$sqlwhere=" email='$email' AND verifytype=3 ";
			$sendcode=RandomText(16,1);
			$regtype='email';
			
			if(!preg_match('/([\w]+)(\@)([\w]+)(\.)([\w]+)/',$email)){
				$this->error='邮箱格式有误！';
				return false;
			}
			
			if(!$certificate->IsEMailCertificate($email)){
				$this->error='邮箱不存在或未认证！';
				return false;
			}
			
			$certificatearray=M('MemberCertificate')->where(" email='%s' AND type=1 AND status=5 ",$email)->find();
		}
		
		$postarray=array('uid'=>$certificatearray['uid'],'verifytype'=>3,'regip'=>GetClientIp(),'dateline'=>NowTime(),'code'=>$sendcode,'regtype'=>$regtype,'mobile'=>$mobile,'email'=>$email);
		
		$manage=$this->IsMemberVerify($sqlwhere);
		
		if($manage['id']){
			if($this->SendCode($manage['id'])){
				return $manage['id'];
			}else{
				$this->error=$this->getError();
				return false;
			}
		}else{
			$id=$this->CreateMemberVerify($postarray);
			$this->SendCode($id);
			return $id;
		}
	}
	
	//验证找回密码
	function ForgotVerify(){
		require(FOXPHP_PATH."/Apps/Hook/GeeTest/geetest.php");
		$geetest = new \Geetest();
		$geetest->set_privatekey(C('Geetest_Key'));
				
		if(isset($_POST['geetest_challenge']) && isset($_POST['geetest_validate']) && isset($_POST['geetest_seccode'])) {
			$result = $geetest->validate($_POST['geetest_challenge'], $_POST['geetest_validate'], $_POST['geetest_seccode']);
			if ($result == FALSE) {
				$this->error='对不起!验证码有误！';
				return false;
			} 
		}
		
		$id=intval($_POST['id']);
		if($id){
			$manage=M('MemberVerify')->token(false)->where(" id=$id AND status!=1 AND verifytype=3 ")->find();
			if(empty($manage['id'])){
				$this->error='数据不存在!';
				return false;
			}
		}else{
			$this->error='数据不存在!!';
			return false;
		}
		
		if(preg_match("/^[a-z0-9]+$/i",trim($_POST['code'])) && $_POST['code']){ 
			$code=$manage['code'];
			if(trim($_POST['code'])==$code){			
				if(NowTime() > ($manage['dateline']+86400)){
					//失败
					$this->error='激活码已过期!请重新发送激活码!';
					return false;
				}else{
					
					if($manage['regtype']=='mobile'){
						$password=RandomText(6,2);
					}else{
						$password=RandomText(16,1);
					}
					//修改密码
					$model=new \Member\Model\MemberModel();
					if(!$model->ChangePassword($manage['uid'],$password)){
						$this->error='找回密码错误!';
						return false;
					}

					if($manage['regtype']=='mobile'){
						
						//手机模块
						$sendsms=array(
							  
							//接收
							'smsuid'=>0,
							
							//接收用户名
							'smsusername'=>null,
							
							//接收手机
							'smsmobile'=>$manage['mobile'],
							
							//手机内容
							'smscontent'=>C('sitename').'手机找回密码,新密码为：'.$password.' 。非本人操作,请忽略本信息。'

						);
						
						require_once(C('S_APPS')."/Hook/SendSMS/FoxSendSMS.php");
						$sendsms = new \MobileSMS($sendsms);		
						$sendsms->SendSMS();

					}else{
						
						//邮箱模块
						$sendmail=array(
							  
							//接收邮箱
							'mailto'=>$manage['email'],
							//邮件标题
							'mailsubject'=>C('sitename').'找回密码',
							//邮件内容
							'mailcontent'=>'<h2>新密码</h2><p><b>'.$password.'</b></p>'

						);
						
						require_once(C('S_APPS')."/Hook/SendMail/FoxSendMail.php");
						$sendmail = new \SendMail($sendmail['mailto'],$sendmail['mailsubject'],$sendmail['mailcontent']);			
						$sendmail->FoxPHPSendMail();

					}
					
					$this->DeleteMemberVerify(" id=$id ");
					$this->success='认证成功！';
					return true;
				}
			}else{
				$this->error='您输入的激活码有误！请重新输入！';
				return false;
			}
		}else{
			$this->error='您输入的激活码格式有误！';
			return false;
		}
	}
}

?>