<?php
/************************FoxPHP威客系统************************/
/*                                                            */
/*  FoxPHP.Com (C)2006-2016 FoxPHP Inc.                       */
/*  This is NOT a freeware, use is subject to license terms   */
/*  FoxPHP威客系统是商业软件,使用于商业用途请购买授权         */
/*  V3.0 2016.3                                               */
/*  foxphp@aliyun.com                                         */
/*  http://www.foxphp.com                                     */
/*                                                            */
/**************************************************************/

if(!defined('IN_FOXPHP')) {
	exit('Data error');
}

//UC配置参数

//应用的UCenter配置信息(可以到UCenter后台->应用管理->查看本应用->复制里面对应的配置信息进行替换)
define('UC_CONNECT',C('uc_linktype')); // 连接 UCenter 的方式: mysql/NULL, 默认为空时为 fscoketopen(), mysql 是直接连接的数据库, 为了效率, 建议采用 mysql
define('UC_DBHOST', C('uc_dbhost')); // UCenter 数据库主机
define('UC_DBUSER', C('uc_dbuser')); // UCenter 数据库用户名
define('UC_DBPW', C('uc_dbpw')); // UCenter 数据库密码
define('UC_DBNAME', C('uc_dbname')); // UCenter 数据库名称
define('UC_DBCHARSET',C('uc_dbcharset')); // UCenter 数据库字符集
define('UC_DBTABLEPRE', '`'.C('uc_dbname').'`.'.C('uc_dbpre')); // UCenter 数据库表前缀
define('UC_DBCONNECT',0); // UCenter 数据库持久连接 0=关闭, 1=打开
define('UC_KEY', C('uc_key')); // 与 UCenter 的通信密钥, 要与 UCenter 保持一致
define('UC_API', C('uc_api')); // UCenter 的 URL 地址, 在调用头像时依赖此常量
define('UC_CHARSET', C('uc_charset')); // UCenter 的字符集
define('UC_IP', C('uc_ip')); // UCenter 的 IP, 当 UC_CONNECT 为非 mysql 方式时, 并且当前应用服务器解析域名有问题时, 请设置此值
define('UC_APPID', C('uc_appid')); // 当前应用的 ID
define('UC_PPP', 20);

@include_once(C('S_APPS').'/Ucclient/uc_client/client.php');

class UserClientAPI{
	
	   public $username;  
	
       public $password; 
   
       public $usermail;  
	   
	   public $db;
	  
	   function __construct($post=array()){
		   if(!empty($post['username'])){
			    $this->username=$post['username'];
		   }
		  
		   if(!empty($post['passwordtrue'])){
				$this->password=McryptDecrypt($post['passwordtrue']);
		   }else{
			    $this->password=$post['password'];
		   }
		   
		   if(!empty($post['email'])){
			    $this->usermail=$post['email'];  
		   }
		  
	   }
	
	   function register(){   
		   return uc_user_register($this->username,$this->password,$this->usermail);         
	   }
	   
	   function get_user($userid='',$type=0){ 
	        return  uc_get_user($userid,$type);
	   }
	   
	   function checkename(){   
		   return uc_user_checkname($this->username);         
	   }
	   
	   function checkemail(){
	       return uc_user_checkemail($this->usermail);
	   }
	
	   function logout(){
	       return uc_user_synlogout();
	   }
	   
	   function user_login($isuid=0){
	       $APIuser=array();
	       list($APIuser['uid'], $APIuser['name'], $APIuser['password'],$APIuser['email']) = uc_user_login($this->username,$this->password,$isuid);
	       return $APIuser;
	   }
	   
	   function login($userid){
	       return uc_user_synlogin($userid);
	   }
	   
	   
	   function user_delete($username=''){
		   
		    return uc_user_delete($username);
		   
	   }
	   
	   function getavatar($userid,$type){
		   
		   if($type==200){
			    $avatar='<img src="'.UC_API.'/avatar.php?uid='.$userid.'&type=virtual&size=big" />';
		   }elseif($type==120){
		        $avatar='<img src="'.UC_API.'/avatar.php?uid='.$userid.'&type=virtual&size=middle" />';
		   }else{
			    $avatar='<img src="'.UC_API.'/avatar.php?uid='.$userid.'&type=virtual&size=small" />';
		   }
		   
		   return $avatar;
		   
	   }
	   
	   function avatar($userid){
	       return uc_avatar($userid,'virtual',1);
	   }
	   
	   function credit_exchange_request($uid,$creditsrc,$tocredits, $toappid, $netamount){
	        return uc_credit_exchange_request($uid,$creditsrc,$tocredits, $toappid, $netamount);
	   }
     
       function user_edit($newpassword='',$ignoreoldpw=0){ 
		    return @uc_user_edit($this->username,$this->password,$newpassword,$this->usermail,$ignoreoldpw);
       }
	   
	   function feed_add($feed){
	        return uc_feed_add($feed['icon'],$feed['uid'],$feed['username'], $feed['title_template'], $feed['title_data'], $feed['body_template'], $feed['body_data'], '', '', $feed['images']);
	   }
      
	  
	   function send_sms($fromuid=0,$msgto=0,$subject='',$message=''){
	        return  uc_pm_send($fromuid,$msgto,$subject,$message);
	   }
	   
	   
	   function get_creditsettings(){
		   
		    if(file_exists(C('S_APPS').'/Ucclient/uc_client/data/cache/creditsettings.php')){
	             @include_once(C('S_APPS').'/Ucclient/uc_client/data/cache/creditsettings.php');
			     return $_CACHE['creditsettings'];
		    }
	   }

}
	
	



?>