<?php
// +----------------------------------------------------------------------
// | FoxPHP 
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2015 http://www.foxphp.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: FoxPHP
// +----------------------------------------------------------------------
namespace Think\Template\Driver;
/**
 * FoxPHP模板引擎驱动 
 */
class FoxEngine {

    public function fetch($templateFile,$var) {
		vendor('FoxTemplate.template#class');
		$templateFile   =   substr($templateFile,strlen(THEME_PATH));
		$tpl = new \FoxTemplate();

		$tpl->cache_time=C('TMPL_CACHE_TIME');
		$tpl->caching=C('TMPL_CACHE_OPEN');
		$tpl->template_dir=THEME_PATH;
		$tpl->cache_dir = CACHE_PATH ;  
 
		$tpl->language='';

		// 是否开启语言包功能
		if(C('LANG_SWITCH_ON')){

			$langSet = cookie('_language');
			$langList = C('LANG_LIST',null,'zh-cn'); 
			//语言
			if(false === stripos($langList,$langSet)) { // 非法语言参数
				$langSet = C('DEFAULT_LANG');
			}
			$template->language=$langSet;
		}

		//缓存KEY
		$tpl->cache_key=C('TMPL_CACHE_KEY');

		if(!is_dir(CACHE_PATH)) {
			@mkdir(CACHE_PATH,0777);
		}

		$tpl->assign($var);
		$tpl->display($templateFile);
    }
}