<?php


/*
 *
 *异新优商城
 *版权所有 长沙异新优网络科技有限责任公司
 *官方网站：http://www.yixinu.com
 *开发文档：http://demo.yixinu.com/doc/
 *@author:青竹丹枫 , 微信 : xianglu , QQ : 316686606
 */



/**
 * 系统基础函数库
 */

/**
 * 读取框架语言,如果$name为空则返回整个数组，默认读取中文
 */
function Lsys($name = null) {
    $lang = include ICONF . 'lang.php';
    if (empty($name)) {
        return $lang[LANG];
    } else {
        return $lang[LANG][$name];
    }
}

/**
 * 读取配置
 * @param type $name
 * @return type
 */
function cfg($name = null) {
    $_cfg = array();
    $core_cfg = include ICONF . 'config.php';
    $_cfg = array_merge($_cfg, $core_cfg);

    $app_cfg = include CONF_PATH . 'config.php';
    if (is_array($app_cfg)):
        $_cfg = array_merge($_cfg, $app_cfg);
    else:
        exit(Lsys('appcfg_error'));
    endif;

    if (empty($name)) {
        return $_cfg;
    } else {
        return $_cfg[$name];
    }
}

/**
 * 打印 消息 
 * 
 * @param type $content     内容 
 * @param type $url     跳 转的链接  
 * @param type $urltitle    链接 标题
 * @param type $waitSecond    多少秒钟 之后自动 跳 转
 */
function msg($content = '', $url = __ROOT__, $urltitle = '[默认链接]', $waitSecond = 300) {
    //为了ERROR信息不会出现多次    begin
    $errorTime = time();
    $errorTime_ = $_SESSION['errorTime'];
    $_SESSION['errorTime'] = $errorTime;
    if( isset($_SESSION['errorTime']) && $_SESSION['errorTime'] ){
        if($errorTime==$errorTime_){
            exit();
        }
    }
    //  end
    
    //检测项目中是否定义了  message函数
    if (function_exists('message')) {
        message($content);
    }

    if (judgeMobileBrowse()) {
        include IVIEW . 'msg_1.php';
    } else {
        include IVIEW . 'msg.php';
    }
    exit();
}

/**
 * 模拟IE浏览器 抓取网页
 * @param type $from_url   表示这个访问 是从 $form_url 这个链接点过去的。
 * @param type $url   要获取的网页 url
 * @return type 
 */
function gethtml($from_url, $url, $data = array()) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_REFERER, $from_url); //设置来路，这个很重要，表示这个访问 是从 $form_url 这个链接点过去的。
    curl_setopt($ch, CURLOPT_URL, $url); //获取 的url地址 
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); //设置返回原生的（Raw）输出
    //如果有数据提交
    if ($data && count($data) > 0) {
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    }
    curl_setopt($ch, CURLOPT_POST, 1);
    //模拟浏览器发送报文 ，这里模拟 IE6 浏览器访问 
    curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; .NET CLR 1.1.4322; .NET CLR 2.0.50727)");
    $res = curl_exec($ch);
    curl_close($ch);
    return $res;
}

/**
 * 远程获取数据，POST模式
 * 
 * @param type $url  指定URL完整路径地址
 * @param type $param  请求的数据
 */
function curl_post($url,$param){
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    if ( is_array($param) && count($param) > 0) {
        curl_setopt($ch, CURLOPT_POSTFIELDS, $param);
    }
    curl_setopt($ch, CURLOPT_POST, 1);
    $res = curl_exec($ch);
    curl_close($ch);
    return $res;
}

/**
 * 远程获取数据，GET模式
 * 
 * @param type $url  指定URL完整路径地址
 * @param type $param  请求的数据
 */
function curl_get($url){
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    $res = curl_exec($ch);
    curl_close($ch);
    return $res;
}

/**
 * 保存和读取缓存数据，自动判断 是保存还是读取
 * @param type $arr   数组;
 * @param type $key  键值 也是文件名
 * @param type $time  缓存时间，是在读取的时候 设置 的 
 * @return array  如果 是读取缓存  ，则返回 的是数组;
 */
function s($key, $arr = null, $time = 200) {
    $filename = md5($key) . '.php';
    $write = false;   //是否要写缓存 
    //检查缓存是否存在
    if (file_exists(CACHE_PATH . $filename)) {
        $time_ = $time + filemtime(CACHE_PATH . $filename);
        //如果缓存已经过期
        if ($time_ < time()) {
            //如果写缓存数据存在
            if (is_array($arr)) {
                $write = true;
            } else {  //如果缓存已经过期，并且写缓存数据也没有。
                return false;
            }
        } else {
            if (is_array($arr))
                $write = true;
        }
    }else {
        //如果写缓存数据存在
        if (is_array($arr)) {
            $write = true;
        } else {  //如果缓存文件不存在，并且写缓存数据也没有。
            return false;
        }
    }

    //如果需要写缓存 ，否则读取
    if ($write) {
        file_put_contents(CACHE_PATH . $filename, serialize($arr));
        return $arr;
    } else {
        return unserialize(file_get_contents(CACHE_PATH . $filename));
    }
}

/**
 * 判断是否用手机或电脑浏览
 * @return boolean 如果是用手机或微信浏览则返回true，如果用电脑浏览则返回false
 */
function judgeMobileBrowse() {
    $user_agent = $_SERVER['HTTP_USER_AGENT'];
    if (strpos($user_agent, 'MicroMessenger') || strpos($user_agent, 'Android') || strpos($user_agent, 'Android') || strpos($user_agent, 'iPhone')) {
        return true;
    } else {
        return false;
    }
}

/**
 * 判断是否在微信环境下
 * 
 * @return boolean  如果 是 返回 true
 */
function judgeMicroMessenger() {
    $user_agent = $_SERVER['HTTP_USER_AGENT'];
    if (strpos($user_agent, 'MicroMessenger')) {
        return true;
    } else {
        return false;
    }
}

/**
 * 判断是不是用ajax的方式请求，如果是返回 true;
 * @return boolean
 */
function judgeAjaxRequest() {
    if (isset($_SERVER["HTTP_X_REQUESTED_WITH"]) && strtolower($_SERVER["HTTP_X_REQUESTED_WITH"]) == "xmlhttprequest") {
        return true;
    } else {
        return false;
    }
}

/**
 * 上传图片 
 * @param type $file   表单的files ，填写：$_FILES['upfile']
 * @param type $path   图片存放的路径
 * @param type $newfilename 新生成图片的文件名
 * @return array 返回新的文件名和图片的在服务器上的全路径、图片扩展名 ,  $data['name'] 和 $data['path'] 、$data['type']。
 */
function uploadImage($file = null, $path = './image', $newfilename = null) {
    if (!empty($file) and is_uploaded_file($file['tmp_name'])) {
        $photo_types = array('image/jpg', 'image/jpeg', 'image/png', 'image/pjpeg', 'image/gif', 'image/x-png'); //定义上传格式
        $max_size = 1024000;    //上传照片大小限制,默认1M
//        $name = $file['name'];
//        $type = $file['type'];
//        $size = $file['size'];
        $photo_name = $file["tmp_name"];
//            $photo_size = getimagesize($photo_name);
        //检查文件大小
        if ($max_size < $file["size"]) {
            return 401;       //echo "<script>alert('对不起，文件超过规定大小!');history.go(-1);</script>";
        }
        //检查文件类型
        if (!in_array($file["type"], $photo_types)) {
            return 402;       //echo "<script>alert('对不起，文件类型不符!');history.go(-1);</script>";
        }
        //服务器存放图片的路径
        $photo_folder = $path . DIRECTORY_SEPARATOR;
        //////  开始处理上传
        if (!file_exists($photo_folder)) {  //检查照片目录是否存在
            mkdir($photo_folder, 0770, true);  //mkdir("temp/sub, 0777, true);
        }
        $pinfo = pathinfo($file["name"]);
        $photo_type = $pinfo['extension']; //上传文件扩展名
        $time = time();
        $newFilename = $time . "." . $photo_type;  //图片文件名
        //如果有新的文件名
        if (!empty($newfilename)):
            $newFilename = $newfilename . "." . $photo_type;  //图片文件名
        endif;
        $imagePath = $photo_folder . $newFilename; //原图文件名，这里是加了路径的 
        //移动文件
        if (!move_uploaded_file($photo_name, $imagePath)) {
            return 403; //echo "移动文件出错";
        }
        //如果出错了，则返回错误
        $data['name'] = $newFilename;
        $data['path'] = $imagePath;
        $data['type'] = $photo_type;
        return $data;
    } else {
        return false;
    }
}

/**
 * 生成缩略图
 * @param type $filename  原文件 ，这里是全路径 
 * @param type $dst  目标文件 ，这里是全路径 
 * @param type $width  生成 缩略 图的宽度
 * @param type $height  生成 缩略 图的高度
 * @return boolean
 */
function makeThumb($filename, $dst, $width = 250, $height = 200) {
    $thumb_width = $width;
    $thumb_height = $height;

    //取得图片信息
    list($width_orig, $height_orig, $mime_type) = getimagesize($filename);
    //如果图片尺寸小于生成的尺寸则使用图片原尺寸缩放
    if ($width_orig < $width && $height_orig < $height) {
        $width = $width_orig;
        $height = $height_orig;
    }
    //算出缩放比例
    if ($width && ($width_orig < $height_orig)) {
        $width = ($height / $height_orig) * $width_orig;
    } else {
        $height = ($width / $width_orig) * $height_orig;
    }

    //创建一张图片
    $image_p = imagecreatetruecolor($thumb_width, $thumb_height);
    //用白色填充背景
    $clr = imagecolorallocate($image_p, 253, 253, 253);
    imagefilledrectangle($image_p, 0, 0, $thumb_width, $thumb_height, $clr);
    switch ($mime_type) {
        case 1:
        case 'image/gif':
            $image = imagecreatefromgif($filename);
            break;

        case 2:
        case 'image/pjpeg':
        case 'image/jpeg':
            $image = imagecreatefromjpeg($filename);
            break;

        case 3:
        case 'image/x-png':
        case 'image/png':
            $image = imagecreatefrompng($filename);
            break;

        default:
            return false;
    }
    //算出复制图片居中的坐标
    $dst_x = ($thumb_width - $width) / 2;
    $dst_y = ($thumb_height - $height) / 2;
    //完成复制
    imagecopyresampled($image_p, $image, $dst_x, $dst_y, 0, 0, $width, $height, $width_orig, $height_orig);

    // 输出图片
    switch ($mime_type) {
        case 1:
        case 'image/gif':
            imagegif($image_p, $dst);
            break;

        case 2:
        case 'image/pjpeg':
        case 'image/jpeg':
            imagejpeg($image_p, $dst, 85);
            break;

        case 3:
        case 'image/x-png':
        case 'image/png':
            imagepng($image_p, $dst);
            break;
        default:
            return false;
    }
}

/**
 * 递归处理数据
 * @param type $id
 * @param type $data
 * @return type
 */
function RecursionData($id = 0, $data) {
    $arr = null;
    foreach ($data as $key => $value) {
        if ($value['parentId'] == $id) {
            $arr[$value['id']] = $value;
            $arr[$value['id']]['son'] = RecursionData($value['id'], $data);
        }
    }
    return $arr;
}

/**
 * 生成 链接 。
 * 
 * @param type $action 控制器/方法名,中间用 / 隔开 ，如果没有 / 符号，则默认取当前 控制 器 加 传入的参数 作方法 
 * @param type $vars  传入 要生成 的GET变量 
 * @param type $hideindex  是否要隐藏 index.php 文件 名，使用伪静态
 */
function createLink($controllerAction = null, $vars = array(), $hideindex = false) {
    $controller = null;
    $action = null;
    $url = null;
    if (strstr($controllerAction, '/') != false) {
        list($controller, $action) = explode('/', $controllerAction);
    } else {
        $controller = CONTROLLER_NAME;
        $action = $controllerAction;
    }

    $GET = NULL;
    if (is_array($vars) and count($vars) > 0) {
        $GET = '/';
        foreach ($vars as $key => $value) {
            if ($value)
                $GET .= "$key" . '_' . "$value" . "_";
        }
        $GET = substr($GET, 0, -1);
    }
    //如果隐藏  index.php  文件 名
    if (!$hideindex) {
        $GET = substr($GET, 1);
        $url = __ROOT__ . 'index.php?v=/' . "$controller/$action/" . $GET;
    } else {
        $url = __ROOT__ . "$controller/$action" . $GET . '.html';
    }
    return $url;
}

//开启伪静态下的get
function rget($var = null) {
    return \core\url::_get($var);
}

/**
 * 随机返回一串指定长度的 小写字母组成的字符串
 * 
 * @param type $len
 * @return type
 */
function getabc($len = 0) {
    $str = '';
    $length = 10;
    if ($len == 0) {
        $length = rand(5, 25);
    } else {
        $length = $len;
    }
    for ($i = 0; $i < $length; $i++) {
        $h = rand(97, 122);
        $str.=chr($h);
    }
    return $str;
}
