<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class googleplus
{
    private $param;
            
    public function SetConfig($param)
    {
        $this->param = $param;
        global $apiConfig;
        $apiConfig = array(
            // True if objects should be returned by the service classes.
            // False if associative arrays should be returned (default behavior).
            'use_objects' => false,
            // The application_name is included in the User-Agent HTTP header.
            'application_name' => $this->param['exp_googleplus_application_name'],
            // OAuth2 Settings, you can get these keys at https://code.google.com/apis/console
            'oauth2_client_id' => $this->param['exp_googleplus_client_id'],
            'oauth2_client_secret' => $this->param['exp_googleplus_client_secret'],
            'oauth2_redirect_uri' => $this->param['exp_googleplus_redirect_uri'],
            // The developer key, you get this at https://code.google.com/apis/console
            'developer_key' => '',
            // OAuth1 Settings.
            // If you're using the apiOAuth auth class, it will use these values for the oauth consumer key and secret.
            // See http://code.google.com/apis/accounts/docs/RegistrationForWebAppsAuto.html for info on how to obtain those
            'oauth_consumer_key' => $this->param['exp_googleplus_consumer_key'],
            'oauth_consumer_secret' => $this->param['exp_googleplus_consumer_secret'],
            // Site name to show in the Google's OAuth 1 authentication screen.
            'site_name' => $this->param['exp_googleplus_site_name'],
            // Which Authentication, Storage and HTTP IO classes to use.
            'authClass' => 'apiOAuth2',
            'ioClass' => 'apiCurlIO',
            'cacheClass' => 'apiFileCache',
            // If you want to run the test suite (by running # phpunit AllTests.php in the tests/ directory), fill in the settings below
            'oauth_test_token' => '', // the oauth access token to use (which you can get by runing authenticate() as the test user and copying the token value), ie '{"key":"foo","secret":"bar","callback_url":null}'
            'oauth_test_user' => '', // and the user ID to use, this can either be a vanity name 'testuser' or a numberic ID '123456'
            // Don't change these unless you're working against a special development or testing environment.
            'basePath' => 'https://www.googleapis.com',
            // IO Class dependent configuration, you only have to configure the values for the class that was configured as the ioClass above
            'ioFileCache_directory' =>
            (function_exists('sys_get_temp_dir') ?
                    sys_get_temp_dir() . '/apiClient' :
                    '/tmp/apiClient'),
            'ioMemCacheStorage_host' => '127.0.0.1',
            'ioMemcacheStorage_port' => '11211',
            // Definition of service specific values like scopes, oauth token URLs, etc
            'services' => array(
                'analytics' => array('scope' => 'https://www.googleapis.com/auth/analytics.readonly'),
                'calendar' => array(
                    'scope' => array(
                        "https://www.googleapis.com/auth/calendar",
                        "https://www.googleapis.com/auth/calendar.readonly",
                    )
                ),
                'books' => array('scope' => 'https://www.googleapis.com/auth/books'),
                'latitude' => array(
                    'scope' => array(
                        'https://www.googleapis.com/auth/latitude.all.best',
                        'https://www.googleapis.com/auth/latitude.all.city',
                    )
                ),
                'moderator' => array('scope' => 'https://www.googleapis.com/auth/moderator'),
                'oauth2' => array(
                    'scope' => array(
                        'https://www.googleapis.com/auth/userinfo.profile',
                        'https://www.googleapis.com/auth/userinfo.email',
                    )
                ),
                'plus' => array('scope' => 'https://www.googleapis.com/auth/plus.me'),
                'siteVerification' => array('scope' => 'https://www.googleapis.com/auth/siteverification'),
                'tasks' => array('scope' => 'https://www.googleapis.com/auth/tasks'),
                'urlshortener' => array('scope' => 'https://www.googleapis.com/auth/urlshortener')
            )
        );
    }

    public function redirectURL()
    {
        global $apiConfig;
        require_once APP_ROOT . 'api/login/googleplus/package/apiClient.php';
        require_once APP_ROOT . 'api/login/googleplus/package/contrib/apiOauth2Service.php';
        //@session_start();

        $client = new apiClient();
        $client->setApplicationName($this->param['exp_googleplus_application_name']);
        // Visit https://code.google.com/apis/console?api=plus to generate your
        // oauth2_client_id, oauth2_client_secret, and to register your oauth2_redirect_uri.
        // $client->setClientId('insert_your_oauth2_client_id');
        // $client->setClientSecret('insert_your_oauth2_client_secret');
        // $client->setRedirectUri('insert_your_redirect_uri');
        // $client->setDeveloperKey('insert_your_developer_key');
        $oauth2 = new apiOauth2Service($client);
        return $authUrl = $client->createAuthUrl();
    }

    public function callBack()
    {
        global $apiConfig;
        require_once APP_ROOT . 'api/login/googleplus/package/apiClient.php';
        require_once APP_ROOT . 'api/login/googleplus/package/contrib/apiOauth2Service.php';
        session_start();

        $client = new apiClient();
        $client->setApplicationName("Google UserInfo PHP Starter Application");
// Visit https://code.google.com/apis/console?api=plus to generate your
// oauth2_client_id, oauth2_client_secret, and to register your oauth2_redirect_uri.
// $client->setClientId('insert_your_oauth2_client_id');
// $client->setClientSecret('insert_your_oauth2_client_secret');
// $client->setRedirectUri('insert_your_redirect_uri');
// $client->setDeveloperKey('insert_your_developer_key');
        $oauth2 = new apiOauth2Service($client);

        if (isset($_GET['code']))
        {
            $client->authenticate();
            $_SESSION['token'] = $client->getAccessToken();
            $redirect = SITE_PROTOCOL . $_SERVER['HTTP_HOST'] . $_SERVER['REDIRECT_URL'];
            header('Location: ' . filter_var($redirect, FILTER_SANITIZE_URL));
            //$redirect = 'http://' . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'];
            //header('Location: ' . filter_var($redirect, FILTER_SANITIZE_URL));
        }

        if (isset($_SESSION['token']))
        {
            $client->setAccessToken($_SESSION['token']);
        }

        if (isset($_REQUEST['logout']))
        {
            unset($_SESSION['token']);
            $client->revokeToken();
        }

        if ($client->getAccessToken())
        {
            $user = $oauth2->userinfo->get();

            // These fields are currently filtered through the PHP sanitize filters.
            // See http://www.php.net/manual/en/filter.filters.sanitize.php
            $email = filter_var($user['email'], FILTER_SANITIZE_EMAIL);
            $img = filter_var($user['picture'], FILTER_VALIDATE_URL);
            $return = array(
                'api_id' => $user['id'],
                'api_type' => 'googleplus',
                'user_email' => $user['email'],
            );
            // The access token may have been updated lazily.
            $_SESSION['token'] = $client->getAccessToken();
            return $return;
        }
        else
        {
            $authUrl = $client->createAuthUrl();
            header('Location: ' . $authUrl);
            return;
        }
    }

}

?>
