<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

require_once(APP_ROOT . 'api/login/yahoo/package/globals.php');
require_once(APP_ROOT . 'api/login/yahoo/package/oauth_helper.php');
require_once(APP_ROOT . 'api/login/yahoo/package/Yahoo.php');
class Yahoo {

    private $param;	
    public function SetConfig($param) {
        $this->param = $param;
    }

    public function redirectURL() {
		$yahoo_key = $this->param['exp_yahoo_key'];
		$yahoo_secret = $this->param['exp_yahoo_secret'];	
		$callback='http://'.$_SERVER['SERVER_NAME'].'/sns-callback-yahoo.html';
		// Get the request token using HTTP GET and HMAC-SHA1 signature
		$retarr = $this->get_request_token($yahoo_key, $yahoo_secret,$callback, false, true, true);
		if (! empty($retarr)) {
		  list($info, $headers, $body, $body_parsed) = $retarr;
		  if ($info['http_code'] == 200 && !empty($body)) {
			  //print "Have the user go to xoauth_request_auth_url to authorize your app\n" .
				//  rfc3986_decode($body_parsed['xoauth_request_auth_url']) . "\n";
				$auth_url=rfc3986_decode($body_parsed['xoauth_request_auth_url']);				
				return $auth_url;
		  }
		}
    }

    public function callBack() {
		$Gets = _g();
		$yahoo_key = $this->param['exp_yahoo_key'];
		$yahoo_secret = $this->param['exp_yahoo_secret'];
		$app_id =$this->param['exp_yahoo_appid'];		
		$session = YahooSession::requireSession($yahoo_key, $yahoo_secret, $app_id);
		if($session) {
			// Get the currently sessioned user.
			$user = $session->getSessionedUser();
			$return = array(
				'api_id' => $user->session->guid,
				'api_type' => 'yahoo',
				'api_key' => $yahoo_key,
				'user_email' => '',
			);		
			return $return;	
		}else{
			echo "REQUIRESESSION Error";
			exit;
		}
			
    }
	/**
	 * Get a request token.
	 * @param string $consumer_key obtained when you registered your app
	 * @param string $consumer_secret obtained when you registered your app
	 * @param string $callback callback url can be the string 'oob'
	 * @param bool $usePost use HTTP POST instead of GET
	 * @param bool $useHmacSha1Sig use HMAC-SHA1 signature
	 * @param bool $passOAuthInHeader pass OAuth credentials in HTTP header
	 * @return array of response parameters or empty array on error
	 */
	private function get_request_token($consumer_key, $consumer_secret, $callback, $usePost=false, $useHmacSha1Sig=true, $passOAuthInHeader=false)
	{
	  $retarr = array();  // return value
	  $response = array();

	  $url = 'https://api.login.yahoo.com/oauth/v2/get_request_token';
	  $params['oauth_version'] = '1.0';
	  $params['oauth_nonce'] = mt_rand();
	  $params['oauth_timestamp'] = time();
	  $params['oauth_consumer_key'] = $consumer_key;
	  $params['oauth_callback'] = $callback;

	  // compute signature and add it to the params list
	  if ($useHmacSha1Sig) {
		$params['oauth_signature_method'] = 'HMAC-SHA1';
		$params['oauth_signature'] =
		  oauth_compute_hmac_sig($usePost? 'POST' : 'GET', $url, $params,
								 $consumer_secret, null);
	  } else {
		$params['oauth_signature_method'] = 'PLAINTEXT';
		$params['oauth_signature'] =
		  oauth_compute_plaintext_sig($consumer_secret, null);
	  }

	  // Pass OAuth credentials in a separate header or in the query string
	  if ($passOAuthInHeader) {
		$query_parameter_string = oauth_http_build_query($params, true);
		$header = build_oauth_header($params, "yahooapis.com");
		$headers[] = $header;
	  } else {
		$query_parameter_string = oauth_http_build_query($params);
	  }

	  // POST or GET the request
	  if ($usePost) {
		$request_url = $url;
		logit("getreqtok:INFO:request_url:$request_url");
		logit("getreqtok:INFO:post_body:$query_parameter_string");
		$headers[] = 'Content-Type: application/x-www-form-urlencoded';
		$response = do_post($request_url, $query_parameter_string, 443, $headers);
	  } else {
		$request_url = $url . ($query_parameter_string ?
							   ('?' . $query_parameter_string) : '' );
		logit("getreqtok:INFO:request_url:$request_url");
		$response = do_get($request_url, 443, $headers);
	  }

	  // extract successful response
	  if (! empty($response)) {
		list($info, $header, $body) = $response;
		$body_parsed = oauth_parse_str($body);
		if (! empty($body_parsed)) {
		  logit("getreqtok:INFO:response_body_parsed:");
		  //print_r($body_parsed);
		}
		$retarr = $response;
		$retarr[] = $body_parsed;
	  }

	  return $retarr;
	}	
}

?>
