<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of ecpaypal
 *
 * @author xrx <QQ:1251679791 www.35zh.com>
 */
class ecpaypal extends BasePaymentInterface
{
  public $_setting = array(
      'API_USERNAME' => '',
      'API_PASSWORD' => '',
      'API_SIGNATURE' => '',
      'SUBJECT' => '',
      'AUTH_TOKEN' => '',
      'AUTH_SIGNATURE' => '',
      'AUTH_TIMESTAMP' => '',
      'API_ENDPOINT' => 'https://api-3t.paypal.com/nvp', //  这是，你必须提交您的API请求连接服务器的URL。
      'PAYPAL_URL' => 'https://www.paypal.com/webscr&cmd=_express-checkout&token=',
      /*
         对于测试，网址是
       * https://api-3t.sandbox.paypal.com/nvp
         https://www.sandbox.paypal.com/webscr&cmd=_express-checkout&token=
         对于正式，网址是
       * https://api-3t.paypal.com/nvp
         https://www.paypal.com/webscr&cmd=_express-checkout&token=
       */
      'USE_PROXY' => FALSE, //    将此变量设置为TRUE路由所有的API请求通过代理服务器。
      'PROXY_HOST' => '127.0.0.1', //  设置代理服务器的主机名或IP地址。
      'PROXY_PORT' => '808', //  设置代理服务器的端口。
      'VERSION' => '65.1',
      'ACK_SUCCESS' => 'SUCCESS', //ACK相关参数
      'ACK_SUCCESS_WITH_WARNING' => 'SUCCESSWITHWARNING', //ACK相关参数 
      'APIError' => '/h-order-apierror.html',
      'callbackurl' => '',
      'returnurl' => '/h-order-eCStep2.html',
      'cancelurl' => '/h-order-eCCancel.html',
      'paymentType' => 'Sale', //  Sale  Authorization Order 
      'payment_id'  => 0,
  );
  /**
   * 快捷支付
   * @param type $nvpStr
   * @return type 
   */
  public function ecpay($nvpStr)
  {
    return $this->hash_call("SetExpressCheckout", $this->setarraykv($nvpStr));
  }
  /**
   * 快捷支付回传
   * @param type $token
   * @return type 
   */
  public function ectokenpay($token)
  {
    $nvpHeader = '';
    $nvpstr = "&TOKEN=" . $token;
    $nvpstr = $nvpHeader . $nvpstr;
    return $this->hash_call("GetExpressCheckoutDetails", $nvpstr);
  }
  /**
   * 支付
   * @param type $nvpstr
   * @return type 
   */
  public function ecPayment($nvpstr)
  {
    return $this->hash_call("DoExpressCheckoutPayment",$nvpstr);
  }

  /**
   * hash_call: Function to perform the API call to PayPal using API signature
   * @methodName is name of API  method.
   * @nvpStr is nvp string.
   * returns an associtive array containing the response from the server.
   */
  private function hash_call($methodName, $nvpStr)
  {
    $API_UserName = $this->_setting['API_USERNAME'];
    $API_Password = $this->_setting['API_PASSWORD'];
    $API_Signature = $this->_setting['API_SIGNATURE'];

    $subject = $this->_setting['SUBJECT'];
    $AUTH_token = $this->_setting['AUTH_TOKEN'];
    $AUTH_signature = $this->_setting['AUTH_SIGNATURE'];
    $AUTH_timestamp = $this->_setting['AUTH_TIMESTAMP'];

    $API_Endpoint = $this->_setting['API_ENDPOINT'];
    $version = $this->_setting['VERSION'];
    // form header string
    $nvpheader = $this->nvpHeader();
    //declaring of global variables   
    //setting the curl parameters.

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $API_Endpoint);
    curl_setopt($ch, CURLOPT_VERBOSE, 1);

    //turning off the server and peer verification(TrustManager Concept).
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
    curl_setopt($ch, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);

    //in case of permission APIs send headers as HTTPheders
    if (!empty($AUTH_token) && !empty($AUTH_signature) && !empty($AUTH_timestamp))
    {
      $headers_array[] = "X-PP-AUTHORIZATION: " . $nvpheader;

      curl_setopt($ch, CURLOPT_HTTPHEADER, $headers_array);
      curl_setopt($ch, CURLOPT_HEADER, false);
    }
    else
    {
      $nvpStr = $nvpheader . $nvpStr;
    }
    //if USE_PROXY constant set to TRUE in Constants.php, then only proxy will be enabled.
    //Set proxy name to PROXY_HOST and port number to PROXY_PORT in constants.php 
    if ($this->_setting['USE_PROXY'])
      curl_setopt($ch, CURLOPT_PROXY, PROXY_HOST . ":" . PROXY_PORT);

    //check if version is included in $nvpStr else include the version.
    if (strlen(str_replace('VERSION=', '', strtoupper($nvpStr))) == strlen($nvpStr))
    {
      $nvpStr = "&VERSION=" . urlencode($version) . $nvpStr;
    }

    $nvpreq = "METHOD=" . urlencode($methodName) . $nvpStr;

    //setting the nvpreq as POST FIELD to curl
    curl_setopt($ch, CURLOPT_POSTFIELDS, $nvpreq);


    //getting response from server
    $response = curl_exec($ch);

    //convrting NVPResponse to an Associative Array
    $nvpResArray = $this->deformatNVP($response);
    $nvpReqArray = $this->deformatNVP($nvpreq);
    $_SESSION['nvpReqArray'] = $nvpReqArray;

    if (curl_errno($ch))
    {
      // moving to display page to display curl errors
      $nvpResArray['error_no'] = curl_errno($ch);
      $nvpResArray['error_msg'] = curl_error($ch);
    }
    else
    {
      //closing the curl
      curl_close($ch);
    }
    return $nvpResArray;
  }

  private function nvpHeader()
  {
    $API_UserName = $this->_setting['API_USERNAME'];
    $API_Password = $this->_setting['API_PASSWORD'];
    $API_Signature = $this->_setting['API_SIGNATURE'];

    $subject = $this->_setting['SUBJECT'];
    $AUTH_token = $this->_setting['AUTH_TOKEN'];
    $AUTH_signature = $this->_setting['AUTH_SIGNATURE'];
    $AUTH_timestamp = $this->_setting['AUTH_TIMESTAMP'];

    $API_Endpoint = $this->_setting['API_ENDPOINT'];
    $version = $this->_setting['VERSION'];
    $nvpHeaderStr = "";

    if (defined('AUTH_MODE'))
    {
      //$AuthMode = "3TOKEN"; //Merchant's API 3-TOKEN Credential is required to make API Call.
      //$AuthMode = "FIRSTPARTY"; //Only merchant Email is required to make EC Calls.
      //$AuthMode = "THIRDPARTY";Partner's API Credential and Merchant Email as Subject are required.
      $AuthMode = "AUTH_MODE";
    }
    else
    {

      if ((!empty($API_UserName)) && (!empty($API_Password)) && (!empty($API_Signature)) && (!empty($subject)))
      {
        $AuthMode = "THIRDPARTY";
      }
      else if ((!empty($API_UserName)) && (!empty($API_Password)) && (!empty($API_Signature)))
      {
        $AuthMode = "3TOKEN";
      }
      elseif (!empty($AUTH_token) && !empty($AUTH_signature) && !empty($AUTH_timestamp))
      {
        $AuthMode = "PERMISSION";
      }
      elseif (!empty($subject))
      {
        $AuthMode = "FIRSTPARTY";
      }
    }
    switch ($AuthMode)
    {

      case "3TOKEN" :
        $nvpHeaderStr = "&PWD=" . urlencode($API_Password) . "&USER=" . urlencode($API_UserName) . "&SIGNATURE=" . urlencode($API_Signature);
        break;
      case "FIRSTPARTY" :
        $nvpHeaderStr = "&SUBJECT=" . urlencode($subject);
        break;
      case "THIRDPARTY" :
        $nvpHeaderStr = "&PWD=" . urlencode($API_Password) . "&USER=" . urlencode($API_UserName) . "&SIGNATURE=" . urlencode($API_Signature) . "&SUBJECT=" . urlencode($subject);
        break;
      case "PERMISSION" :
        $nvpHeaderStr = $this->formAutorization($AUTH_token, $AUTH_signature, $AUTH_timestamp);
        break;
    }
    return $nvpHeaderStr;
  }

  /** This function will take NVPString and convert it to an Associative Array and it will decode the response.
   * It is usefull to search for a particular key and displaying arrays.
   * @nvpstr is NVPString.
   * @nvpArray is Associative Array.
   */
  private function deformatNVP($nvpstr)
  {

    $intial = 0;
    $nvpArray = array();

    while (strlen($nvpstr))
    {
      //postion of Key
      $keypos = strpos($nvpstr, '=');
      //position of value
      $valuepos = strpos($nvpstr, '&') ? strpos($nvpstr, '&') : strlen($nvpstr);

      /* getting the Key and Value values and storing in a Associative Array */
      $keyval = substr($nvpstr, $intial, $keypos);
      $valval = substr($nvpstr, $keypos + 1, $valuepos - $keypos - 1);
      //decoding the respose
      $nvpArray[urldecode($keyval)] = urldecode($valval);
      $nvpstr = substr($nvpstr, $valuepos + 1, strlen($nvpstr));
    }
    return $nvpArray;
  }

  private function formAutorization($auth_token, $auth_signature, $auth_timestamp)
  {
    $authString = "token=" . $auth_token . ",signature=" . $auth_signature . ",timestamp=" . $auth_timestamp;
    return $authString;
  }

  private function setarraykv($arr)
  {
    $cache = '';
    foreach ($arr as $k => $v)
    {
      $cache.='&' . $k . '=' . $v;
    }
    return $cache;
  }

  private function set_arr2($arr)
  {
    $cache = array();
    if ($arr)
    {
      foreach ($arr as $k => $v)
      {
        if (is_array($v))
        {
          foreach ($v as $vk => $vv)
          {
            $cache[$vk][$k] = $vv;
          }
        }
      }
    }
    return $cache;
  }

}

?>
