<?php

/*
 * Copyright 2012 35zh Systems, Inc.
 */
ob_start();

if(@$_GET['session_id'])
{
	session_id($_GET['session_id']);	
}
session_start();
if (!defined('IN_ZHTX'))
{
    exit('Access Denied');
}
if (defined('PHP_TIME_OUT'))
{
  ini_set("max_execution_time", PHP_TIME_OUT); 
  set_time_limit(PHP_TIME_OUT);

}
// 定义php错误提示级别
if (isset($_GET['debug']) || XDEBUG || isset($_SESSION['sql_debug']))
{
    ini_set('display_errors', 'On');
	error_reporting(E_ALL & ~E_NOTICE);
    
}
else
{
    ini_set('error_reporting', E_ERROR);
    ini_set('display_errors', 'Off');
}
require_once(APP_ROOT . 'conf/rewriteRule.conf.php');
require_once(APP_ROOT . 'app/RewriteCore.php');
require_once(APP_ROOT . 'libary/Core.php');
require_once(APP_ROOT . 'libary/baseApiSns.php');

class IndexCore extends Core
{

    /**
     * core路由启动
     */
    public function __construct()
    {
        self::$site = "front";
        self::$module = "home";
        self::config();
        self::rewriteInit();
        self::setCtlAct();
        self::setRoot();
        self::init();
        self::run();
    }

    public static function rewriteInit()
    {
        global $cfg, $rule, $site_info, $page_code;
        $site_info = AppController::getLang();
        $rewrite_type = isset($cfg['sites'][$site_info['language_id']]['rewrite_type']) ? $cfg['sites'][$site_info['language_id']]['rewrite_type'] : 0;
        if ((!self::$module || self::$module == 'home') && $site_info['is_mobile'])
        {
            self::$module = 'wap';
        }
        new RewriteCore($rule, $rewrite_type);
    }

    public static function init()
    {
        global $cfg, $authorize_shop, $current_currency, $site_info;
        Inputer::init();
        $language_id = $site_info['language_id'];
        $real_language_id = $site_info['real_language_id'];

        $rewrite_type = isset($cfg['sites'][$language_id]['rewrite_type']) ? $cfg['sites'][$language_id]['rewrite_type'] : 0;
        $current_currency = $site_info['currency'];
        $limit1 = isset($cfg['sites'][$language_id]['disp_switch_number1']) ? $cfg['sites'][$language_id]['disp_switch_number1'] : 24;
        $limit2 = isset($cfg['sites'][$language_id]['disp_switch_number2']) ? $cfg['sites'][$language_id]['disp_switch_number2'] : 48;
        $limit3 = isset($cfg['sites'][$language_id]['disp_switch_number3']) ? $cfg['sites'][$language_id]['disp_switch_number3'] : 54;
        $limit4 = isset($cfg['sites'][$language_id]['disp_switch_number4']) ? $cfg['sites'][$language_id]['disp_switch_number4'] : 60;
        $decimal = $current_currency['decimal_num']; //小数点位数
        $prev = isset($cfg['sites'][0]['home_price_peri']) ? $cfg['sites'][0]['home_price_peri'] : 0; //进位
        $authorize_shop = $cfg['sites'][0]['authorize_shop'];
        //$userId = _c('user_id') ? _c('user_id') : _s('user_id');
        $userId = AppController::checkLogin();
        $username = _c('user_base_name') ? _c('user_base_name') : _s('user_base_name');
		
		//--  读取DIY_config
		$diy_config =  AppController::load('DiyConfig');
		$theme_name = $site_info['theme_name'] ? $site_info['theme_name'] : 'default'; 
		if(is_file(THEME_ROOT.$theme_name.'/template.conf.php'))
		{
			require THEME_ROOT.$theme_name.'/template.conf.php';       
		}
		if(is_file(THEME_ROOT.$theme_name.'/diy.conf.php'))
		{
			require THEME_ROOT.$theme_name.'/diy.conf.php';       
		}
		//$diy_key替换默认值
		$res = $diy_config->getAll((int)$site_info['real_language_id']);
		if($res)
		{
			foreach($res as $value)
			{
				foreach($diy_key as $key => $diyvalue)
				{
					if($value['value']!='' && $diy_key[$key]['name']==$value['name'])
					$diy_key[$key]['value'] = $value['value'];
				}
			}
		}
		$return = '';
		$diy_cfg = array();
		foreach($diy_key as $key => $diyvalue)
		{
			$diy_cfg[$diyvalue['name']] = $diyvalue['value'] ;
		}
		Core::$tpl->set('diy_cfg', $diy_cfg);
		//--  读取结束
		
		//-- 读取全部分类
		//$cate_logic = AppController::load('goodsCategoryJoinLang');
       // $categories = $cate_logic->getAllByLanguageId($language_id);
		//Core::$tpl->set('categories', $categories);
		//-- 读取缓存配置
		if (file_exists(APP_ROOT . 'conf/cache.conf.php'))
        	require_once(APP_ROOT . 'conf/cache.conf.php');
		if ($cache_cfg['sites'][1]['status'] == 1) 
		{
            $cache_id = $site_info['language_id'] . "_" . $current_currency['id'] ;
			$CacheTime = (int)$cache_cfg['sites'][1]['domain_name'];
			$cache_lifetime = $CacheTime * 3600 ;
           	Core::$tpl->set('cache_id', $cache_id);
        	Core::$tpl->set('cache_lifetime', $cache_lifetime);
        }
		else
		{
			Core::$tpl->set('cache_lifetime', 0);
		}
		
        AppController::setSource();
        AppController::setUserSource(15);
        AppController::setDeviceSource();
        AppController::initUserCountry();
        Core::$tpl->set('user_name', $username);
        Core::$tpl->set('user_id', $userId);
        Core::$tpl->set('language_id', $language_id);
        Core::$tpl->set('real_language_id', $real_language_id);
        Core::$tpl->set('rewrite_type', $rewrite_type);
        Core::$tpl->set('currency', $current_currency);
        Core::$tpl->set('lcoin', $current_currency['symbol_left']);
        Core::$tpl->set('rcoin', $current_currency['symbol_right']);
        Core::$tpl->set('disp_switch_number1', $limit1);
        Core::$tpl->set('disp_switch_number2', $limit2);
        Core::$tpl->set('disp_switch_number3', $limit3);
        Core::$tpl->set('disp_switch_number4', $limit4);
        Core::$tpl->set('decimal', $decimal);
        Core::$tpl->set('decimal_pow', pow(10, $decimal)); //便于js小数点处理
        Core::$tpl->set('price_prev', $prev);
        Core::$tpl->set('shop_name', @$cfg['sites'][$language_id]['shop_name']);
        Core::$tpl->set('authorize_shop', $authorize_shop);
        Core::$tpl->set('folder', FOLDER_ROOT);
//        if(strtolower(self::$controller)!='task' && strtolower(self::$controller)!='email')
//        {
//            AppController::triggerEvent();
//        }
        if(!$_SESSION["admin_id"])
        AppController::checkVisitRight();
    }

}

?>