<?php

/**
 * Description of AdminController
 *
 * @author yqc
 */
class AdminController extends AppController {

    private $admin_logic;
    private $role_logic;
    private $languageLogic;
    private $menuLogic;
    private $roleMenuLogic;

    public function __construct() {
        parent::__construct();
        $this->admin_logic = $this->load("admin");
        $this->role_logic = $this->load("role");
        $this->languageLogic = $this->load("language");
        $this->menuLogic = $this->load('adminMenu');
        $this->roleMenuLogic = $this->load('adminRolePriv');
    }

    /**acti
     * 管理员登陆页面 
     */
    public function actionLogin() {
        if (_g('dosubmit')) {
            $user_name = _p("user_name");
            $password = _p("password");
            if (!$user_name) {
                return $this->showMessage('nameerror', ADMIN_LOGIN_URL);
            }
            if (!_p('checkcode') || strtolower(_p('checkcode')) != strtolower(_s('validate_code'))) {
                return $this->showMessage('code_error_tips');
            }
            $ip = Common::_ip2long(Common::ip());
            $login_log = array(
                'base_name' => $user_name,
                'create_time' => SYS_TIME,
                'user_agent' => Common::strEscape($_SERVER['HTTP_USER_AGENT']),
                'ip' => $ip,
                'os_type' => Common::strEscape(Common::getOS()),
                'browser_soft' => Common::strEscape(Common::getBrowser()),
            );

            $loginlog = $this->load('adminLoginLog');
            $user = $this->admin_logic->login($user_name);
            if (!$user) {
                $loginlog->save($login_log);
                return $this->showmessage('user_not_exist', ADMIN_LOGIN_URL);
            }

            $password = md5(md5(trim($password)) . $user['encrypt']);
            if ($user['password'] != $password) {
                $loginlog->save($login_log);
                return $this->showmessage('password_error', ADMIN_LOGIN_URL);
            }
            $cond = 'id =' . $user['role_id'] . ' and disabled = 1';
            $role = $this->role_logic->getOne($cond);
            if (!$role) {
                return $this->showmessage('not_permissions');
            }
            /**
             * 更新最后登陆信息 
             */
            $admin_data = array(
                'last_login_ip' => $ip,
                'last_login_time' => SYS_TIME,
            );
            $login_log['status'] = 1;
            $this->admin_logic->save($admin_data, $user['id']);
            $loginlog->save($login_log);
            if (_p('remember') && _p('remember') == 1) {
                setcookie('admin_id', $user['id'], time() + 86400 * 7);
                setcookie('admin_name', $user['user_name'], time() + 86400 * 7);
                setcookie('role_id', $user['role_id'], time() + 86400 * 7);
                setcookie('lang', $user['lang'], time() + 86400 * 7);
                setcookie('admin_password', $password, time() + 86400 * 7);
            } else {
                setcookie('admin_id', $user['id']);
                setcookie('admin_name', $user['user_name']);
                setcookie('role_id', $user['role_id']);
                setcookie('lang', $user['lang']);
                setcookie('admin_password', $password);
            }
            _setSession('admin_password', $password);
            unset($user['password']);
            unset($user['encrypt']);
            Zhtx::setSession($user);
            if (!_p('redirect'))
                $this->_redirect(Common::adminURL());
            else
                $this->_redirect(Common::adminURL() . "&redirect=" . urlencode(_p('redirect')));
        }
        else {
            global $version;
			  global $sys_auth,$version; 
            Core::$tpl->set('cur_version', $version);
					Core::$tpl->set('sys_auth', $sys_auth);

            //$auth = json_decode(ZhCurl::getDomainAuth($_SERVER["HTTP_HOST"]), TRUE);
            Core::$tpl->set('cur_auth', $auth);
        }
    }

    public function actionLogOut() {
        Zhtx::unSetSession();
        setcookie('admin_id', '');
        setcookie('admin_name', '');
        setcookie('role_id', '');
        setcookie('lang', '');
        setcookie('admin_password', '');
        return $this->_redirect(ADMIN_LOGIN_URL);
    }



    public function actionDefault() {
		     global $sys_auth,$version; 

        $role_id = _c('role_id') ? _c('role_id') : _s('role_id');
        $alias_name = _c('lang') ? _c('lang') : _s('lang');
        $admin_name = _c('admin_name') ? _c('admin_name') : _s('user_name');
        $role = $this->role_logic->getOneById($role_id);
        if (!$role) {
            return $this->showMessage('illegal_operation', ADMIN_LOGIN_URL);
        }
        $language = $this->languageLogic->getOneByAliasName($alias_name);
        setcookie('language_id', $language['id'], time() + 3600 * 24, '/');
        //检测权限菜单是否缓存json_decode(ZhCurl::getNextVersion($version['sys_version']), TRUE)
        $this->admin_logic->checkMenuCache($role_id);
        $privMenuLogic = $this->load('adminPrivMenu');
        $menus = $privMenuLogic->getMenusByRoleId($role_id);
        Core::$tpl->set('username', $admin_name);
        Core::$tpl->set('menus', $menus);
        Core::$tpl->set('role', $role);
        $diyUrlLogic = $this->load('diyUrl');
        $diyurl = $diyUrlLogic->getList('admin_id=' . $_SESSION["id"] . ' order by listorder desc');
        Core::$tpl->set('diyurl', $diyurl['list']);
        global $version;
        //print_r($version);
        //$cur_version = json_decode(ZhCurl::getVersionByN($version['sys_version']), TRUE);
        //$auth = json_decode(ZhCurl::getDomainAuth($_SERVER["HTTP_HOST"]), TRUE);
		$cur_version = $auth['version_json'] ;
        //$next_version = trim(ZhCurl::getNextVersion($version['sys_version']));
        $next_version = "lastversion" ;
		//print_r($cur_version);
		//print_r($auth);
		//print_r($next_version);
		
        if ($next_version == 'lastversion' || $next_version == 'nofindversion') {
            $next_version = '';
        } else {
            $next_version = json_decode($next_version, TRUE);
        }
        if (!is_file(APP_ROOT . 'cache/open_shop.lock')) {
            Core::$tpl->set('show_guide', 1);
        }
        Core::$tpl->set('cur_version', $cur_version);
        Core::$tpl->set('md5_key', $version['sys_codeno']);
        Core::$tpl->set('cur_auth', $auth);
		Core::$tpl->set('sys_auth', $sys_auth);
		Core::$tpl->set('diy_system', IS_DIY_SYS);
        Core::$tpl->set('next_version', $next_version);
    }

    public function actionChangeGuideShow() {
        $status = Common::queryInt(_g('status'), 0);
        if ($status) {
            file_put_contents(APP_ROOT . 'cache/open_shop.lock', 'lock');
        } else {
            if (is_file(APP_ROOT . 'cache/open_shop.lock')) {
                unlink(APP_ROOT . 'cache/open_shop.lock');
            }
        }
    }

    public function actionList() {
        //分页用的参数
        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);
        //分页
        $count = $this->admin_logic->getCount();
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $admin_role_rel = $this->load('adminJoinRole');
        //获取数据
        $where = '';
        if (_p('search_value') && _p('search_cond')) {
            $where .= " a." . _p('search_cond') . " = '" . _p('search_value') . "' ";
        }
        $res = $admin_role_rel->getCurrentDatas($where, $page_size, $curr_page);
        Core::$tpl->set("res", $res);
        Core::$tpl->set("pages", $page_data);
    }

    public function actionEdit() {
        if (_p()) {
            $userId = Common::queryInt(_p('id'));
            $adminName = _p('user_name');
            $cond = 'id != ' . $userId . ' AND user_name = "' . $adminName . '"';
            $admin = $this->admin_logic->getOne($cond);
            if (!$admin) {
                $admin_map = Zhtx::createDataMap();
                $password = trim(_p('password'));
                $repassword = trim(_p('repassword'));
                $admin_map->addEntry('user_name', Common::strEscape($adminName), DB::VARCHAR);
                if ($password) {
                    if ($repassword !== $password) {
                        $this->showMessage('passwords_not_match');
                    }
                    $user = $this->admin_logic->getOne('id=' . $userId);
                    $admin_map->addEntry('password', md5(md5($password) . $user['encrypt']), DB::VARCHAR);
                }
                if ($userId != 1) {
                    $admin_map->addEntry('role_id', _p('role_id'), DB::INT);
                }
                $admin_map->addEntry('email', Common::strEscape(_p('email')), DB::VARCHAR);
                $admin_map->addEntry('real_name', Common::strEscape(_p('real_name')), DB::VARCHAR);
                $admin_map->addEntry('last_login_ip', Common::_ip2long(Common::ip()), DB::INT);
                $admin_map->addEntry('last_login_time', SYS_TIME, DB::VARCHAR);
                $admin_map->addEntry('lang', trim(_p('lang')), DB::VARCHAR);
                $admin_map->addEntry('status', Common::queryInt(_p('status')), DB::INT);
                $res = $this->admin_logic->update($admin_map, 'id=' . $userId);
                return $res ? $this->success('save_success', Common::adminURL('admin', 'admin', 'list')) : $this->showMessage('save_failure');
            } else {
                $this->error('name_saved');
            }
        } else {
            $id = Common::queryInt(_g('id'));
            $cond = 'id = ' . $id;
            $user = $this->admin_logic->getOne($cond);
            if (!$user) {
                return $this->error('id_error', Common::adminURL('admin', 'admin', 'list'));
            }
            $where = 'disabled = 1 order by listorder asc';
            $roles = $this->role_logic->getList($where);
            Core::$tpl->set('roles', $roles['list']);
            Core::$tpl->set('user', $user);
            $language_config = Common::get_language();
            Core::$tpl->set('langs', $language_config);
            Core::$htmlFile = 'admin/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    public function actionAdd() {
        if (_p()) {
            $adminName = $_POST['user_name'];
            $cond = 'user_name = "' . $adminName . '"';
            $admin = $this->admin_logic->getOne($cond);

            if (!trim(_p('password'))) {
                $this->showMessage('passwords_empty');
            }
            if (!$admin) {

                $password = trim(_p('password'));
                $repassword = trim(_p('repassword'));
                if ($repassword !== $password) {
                    $this->showMessage('passwords_not_match');
                }
                $admin_map = Zhtx::createDataMap();
                $encrypt = Common::random(4);
                $admin_map->addEntry('user_name', Common::strEscape($adminName), DB::VARCHAR);
                $admin_map->addEntry('password', md5(md5($password) . $encrypt), DB::VARCHAR);
                $admin_map->addEntry('encrypt', $encrypt, DB::VARCHAR);
                $admin_map->addEntry('real_name', Common::strEscape(_p('real_name')), DB::VARCHAR);
                $admin_map->addEntry('role_id', _p('role_id'), DB::INT);
                $admin_map->addEntry('email', _p('email'), DB::VARCHAR);
                $admin_map->addEntry('last_login_ip', Common::_ip2long(Common::ip()), DB::INT);
                $admin_map->addEntry('last_login_time', SYS_TIME, DB::INT);
                $admin_map->addEntry('status', Common::queryInt(_p('status')), DB::INT);
                $admin_map->addEntry('lang', 'zh-cn', DB::VARCHAR);
                $res = $this->admin_logic->insert($admin_map);
                return $res ? $this->success('save_success', Common::adminURL('admin', 'admin', 'list')) : $this->showMessage('save_fail');
            } else {
                $this->error('name_saved');
            }
        } else {
            $language_config = Common::get_language();
            Core::$tpl->set('langs', $language_config);
            $where = 'disabled = 1';
            $roles = $this->role_logic->getList($where);
            Core::$tpl->set('roles', $roles['list']);
            Core::$htmlFile = 'admin/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    /**
     * ajax
     * 获取菜单 
     */
    public function actionPublicGetMenus() {
        $status = 0;
        $parent_id = Common::queryInt(_g('parent_id'));
        $role_id = _s('role_id');
        $menus = array();
        $html = '';
        if ($parent_id && $role_id) {
            $privMenuLogic = $this->load('adminPrivMenu');
            $menus = $privMenuLogic->getMenusByRoleId($role_id, $parent_id);
            foreach ($menus as $list) {
                if ($list['menu_name']) {
                    $html .= '<dt><a href="###" data_id="' . $list['id'] . '" class="menu_leve2">' . $list['menu_name'] . '</a></dt>';
                }
            }
            $status = 1;
        }

        $return = array(
            'status' => $status,
            'menuhtml' => $html,
        );
        echo json_encode($return);
    }

    public function actionPublicGetChilds() {
        $status = 0;
        $parent_id = Common::queryInt(_g('parent_id'));
        $role_id = _s('role_id');
        $menus = array();
        $html = '<dd style="display:block;">';
        if ($parent_id && $role_id) {
            $privMenuLogic = $this->load('adminPrivMenu');
            $menus = $privMenuLogic->getMenusByRoleId($role_id, $parent_id);
            foreach ($menus as $value) {
                if ($value['menu_name']) {
                    $url = 'admin.php?m=' . $value['m'] . '&c=' . $value['c'] . '&a=' . $value['a'] . $value['data'];
                    $html .= '<a href="' . $url . '" target="main">' . $value['menu_name'] . '</a>';
                }
            }
            $html .= '</dd>';
            $status = 1;
        }

        $return = array(
            'status' => $status,
            'menuhtml' => $html,
        );
        echo json_encode($return);
    }

    public function actionPublicNotRight() {
        $this->showMessage('not_permissions', Common::adminURL('admin', 'admin', 'panel'));
    }

    /**
     * 面板 
     */
    public function actionPanel() {
        $orderLogic = $this->load('order');
        $userLogic = $this->load('user');
        $userFavoriteLogic = $this->load('userFavorite');
        $newsletterLogic = $this->load('newsletter');
        $year = mktime(0, 0, 0, 1, 1, date("Y"));
        $month = mktime(0, 0, 0, date("m"), 1, date("Y"));
        $lastmonth = mktime(0, 0, 0, date("m") - 1, 1, date("Y"));
        $today = strtotime(date('Ymd', time()));
        $yesterday = $today - 86400;
        //订单总量
        $order_count = $orderLogic->getCount();
        $paid_order_count = $orderLogic->getCount('order_status between 200 and 204');
        $today_order_count = $orderLogic->getCount('create_time >' . $today);
        $today_paid_count = $orderLogic->getCount('create_time >' . $today . ' and order_status between 200 and 204');
        $yesterday_order_count = $orderLogic->getCount('create_time between ' . $yesterday . ' and ' . $today);
        $yesterday_paid_count = $orderLogic->getCount('order_status between 200 and 204 and create_time between ' . $yesterday . ' and ' . $today);
        $month_order_count = $orderLogic->getCount('create_time >' . $month);
        $month_paid_count = $orderLogic->getCount('create_time >' . $month . ' and order_status between 200 and 204');
        $year_order_count = $orderLogic->getCount('create_time >' . $year);
        $year_paid_count = $orderLogic->getCount('create_time >' . $year . ' and order_status between 200 and 204');
        $lastmonth_order_count = $orderLogic->getCount('create_time between ' . $lastmonth . ' and ' . $month);
        $lastmonth_paid_count = $orderLogic->getCount('create_time between ' . $lastmonth . ' and ' . $month . ' and order_status between 200 and 204');
        $average_order_count = ceil($lastmonth_order_count / 30);
        $average_paid_count = ceil($lastmonth_paid_count / 30);
        //会员总量
        $user_count = $userLogic->getCount();
        $added_today_user_count = $userLogic->getCount('create_time >' . $today);
        $added_yesterday_user_count = $userLogic->getCount('create_time between ' . $yesterday . ' and ' . $today);
        $added_month_user_count = $userLogic->getCount('create_time >' . $month);
        $added_year_user_count = $userLogic->getCount('create_time >' . $year);
        $added_lastmonth_user_count = $userLogic->getCount('create_time between ' . $lastmonth . ' and ' . $month);
        $added_average_user_count = ceil($added_lastmonth_user_count / 30);
        //订阅总量
        $newsletter_count = $newsletterLogic->getCount();
        $today_newsletter_count = $newsletterLogic->getCount('create_time >' . $today);
        $yesterday_newsletter_count = $newsletterLogic->getCount('create_time between ' . $yesterday . ' and ' . $today);
        $month_newsletter_count = $newsletterLogic->getCount('create_time >' . $month);
        $year_newsletter_count = $newsletterLogic->getCount('create_time >' . $year);
        $lastmonth_newsletter_count = $newsletterLogic->getCount('create_time between ' . $lastmonth . ' and ' . $month);
        $average_newsletter_count = ceil($lastmonth_newsletter_count / 30);
        //收藏总量
        $wishlist_count = $userFavoriteLogic->getCount();
        $today_wishlist_count = $userFavoriteLogic->getCount('create_time >' . $today);
        $yesterday_wishlist_count = $userFavoriteLogic->getCount('create_time between ' . $yesterday . ' and ' . $today);
        $month_wishlist_count = $userFavoriteLogic->getCount('create_time >' . $month);
        $year_wishlist_count = $userFavoriteLogic->getCount('create_time >' . $year);
        $lastmonth_wishlist_count = $userFavoriteLogic->getCount('create_time between ' . $lastmonth . ' and ' . $month);
        $average_wishlist_count = ceil($lastmonth_wishlist_count / 30);

        Core::$tpl->set('order_count', $order_count);
        Core::$tpl->set('paid_order_count', $paid_order_count);
        Core::$tpl->set('today_order_count', $today_order_count);
        Core::$tpl->set('today_paid_count', $today_paid_count);
        Core::$tpl->set('yesterday_order_count', $yesterday_order_count);
        Core::$tpl->set('yesterday_paid_count', $yesterday_paid_count);
        Core::$tpl->set('month_order_count', $month_order_count);
        Core::$tpl->set('month_paid_count', $month_paid_count);
        Core::$tpl->set('lastmonth_order_count', $lastmonth_order_count);
        Core::$tpl->set('lastmonth_paid_count', $lastmonth_paid_count);
        Core::$tpl->set('year_order_count', $year_order_count);
        Core::$tpl->set('year_paid_count', $year_paid_count);
        Core::$tpl->set('average_order_count', $average_order_count);
        Core::$tpl->set('average_paid_count', $average_paid_count);

        Core::$tpl->set('user_count', $user_count);
        Core::$tpl->set('added_today_user_count', $added_today_user_count);
        Core::$tpl->set('added_yesterday_user_count', $added_yesterday_user_count);
        Core::$tpl->set('added_month_user_count', $added_month_user_count);
        Core::$tpl->set('added_lastmonth_user_count', $added_lastmonth_user_count);
        Core::$tpl->set('added_year_user_count', $added_year_user_count);
        Core::$tpl->set('added_average_user_count', $added_average_user_count);

        Core::$tpl->set('newsletter_count', $newsletter_count);
        Core::$tpl->set('today_newsletter_count', $today_newsletter_count);
        Core::$tpl->set('yesterday_newsletter_count', $yesterday_newsletter_count);
        Core::$tpl->set('month_newsletter_count', $month_newsletter_count);
        Core::$tpl->set('lastmonth_newsletter_count', $lastmonth_newsletter_count);
        Core::$tpl->set('year_newsletter_count', $year_newsletter_count);
        Core::$tpl->set('average_newsletter_count', $average_newsletter_count);

        Core::$tpl->set('wishlist_count', $wishlist_count);
        Core::$tpl->set('today_wishlist_count', $today_wishlist_count);
        Core::$tpl->set('yesterday_wishlist_count', $yesterday_wishlist_count);
        Core::$tpl->set('month_wishlist_count', $month_wishlist_count);
        Core::$tpl->set('lastmonth_wishlist_count', $lastmonth_wishlist_count);
        Core::$tpl->set('year_wishlist_count', $year_wishlist_count);
        Core::$tpl->set('average_wishlist_count', $average_wishlist_count);
    }

    public function actionPassword() {
        if (_p()) {
            $userId = Common::queryInt(_s('id'));
            $admin_map = Zhtx::createDataMap();
            $password = trim(_p('password'));
            $repassword = trim(_p('repassword'));
            $user = $this->admin_logic->getOne('id=' . $userId);
            if (!$user) {
                return $this->showMessage('illegal_operation');
            }
            if ($password) {
                if ($repassword !== $password) {
                    $this->showMessage('passwords_not_match');
                }
                $admin_map->addEntry('password', md5(md5($password) . $user['encrypt']), DB::VARCHAR);
            }
            $admin_map->addEntry('email', Common::strEscape(_p('email')), DB::VARCHAR);
            $admin_map->addEntry('real_name', Common::strEscape(_p('real_name')), DB::VARCHAR);
            $admin_map->addEntry('lang', trim(_p('lang')), DB::VARCHAR);
            $res = $this->admin_logic->update($admin_map, 'id=' . $userId);
            return $res ? $this->success('save_success', Common::adminURL('admin', 'admin', 'list')) : $this->showMessage('edit_failure');
        } else {
            $id = Common::queryInt(_s('id'));
            $cond = 'id = ' . $id;
            $user = $this->admin_logic->getOne($cond);
            if (!$user) {
                return $this->showMessage('illegal_operation', ADMIN_ROOT . '?m=admin&c=admin&a=list');
            }
            $language_config = Common::get_language();
            Core::$tpl->set('langs', $language_config);
            Core::$tpl->set('user', $user);
        }
    }

    public function actionDel() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if (!empty($ids)) {
            $num = 0;
            foreach ($ids as $id) {
                if ($id != 1) {
                    $res = $this->admin_logic->delete('id=' . $id);
                    if ($res) {
                        $num++;
                    }
                }
            }
            $staus = 1;
            $flag = $lang['success_delete'] . $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

    public function actionPublicEditStatus() {
        $id = Common::queryInt(_g('id'));
        $status = _g('currentStatus') ? 1 : 0;
        $map = Zhtx::createDataMap();
        $map->addEntry('status', $status, DB::INT);
        $res = $this->admin_logic->updateById($map, $id);
        echo $res ? 1 : 0;
    }

    /**
     * 后台登陆日记列表 
     */
    public function actionPublicLoginLog() {
        $loginLog = $this->load('adminLoginLog');
        $where = '';
        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);
        $count = $loginLog->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $where .= 'order by create_time desc';
        $res = $loginLog->getCurrentDatas($where, $page_size, $curr_page);
        Core::$tpl->set("res", $res);
        Core::$tpl->set("pages", $page_data);
        Core::$htmlFile = 'admin/loglist';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

    /**
     * 清除后台登陆日记 
     */
    public function actionLogDel() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        $loginLog = $this->load('adminLoginLog');
        if (!empty($ids)) {
            $num = 0;
            foreach ($ids as $id) {
                $res = $loginLog->delete('id=' . $id);
                if ($res) {
                    $num++;
                }
            }
            $staus = 1;
            $flag = $lang['success_delete'] . $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

    /**
     * 清空缓存 
     */
    public function actionPublicClearCache() {
        echo '正在清理......';
        _crearCahce('goods_list');
        _crearCahce('goods_info');
        _crearCahce('category');
        _crearCahce('brand');
        _crearCahce('promotions');
        _crearCahce('navpage');
        _crearCahce('nav');
        _crearCahce('address');
        _crearCahce('user_group');
        _crearCahce('config');
        $this->clearTplCache(); //清除smarty编译文件
        echo '清理完成！';
        return $this->success('cache_crear_finish');
    }

    public function clearTplCache() {
        $cache_dir = APP_ROOT . 'cache/tpl/';
        Dir::delDirAndFile($cache_dir);
    }

}
?>

