<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Payment
 *
 * @author huangjp@35zh.cn
 */
class ApisnsController extends AppController
{
    private $apisnslogic;
    public function __construct()
    {
        parent::__construct();
        $this->apisnslogic = $this->load("apisns");
    }
    
    public function actionList()
    {
        $cond = '';
        $res = $this->apisnslogic->getList($cond);
        Core::$tpl->set('res', $res['list']);
		$cols = array('id','base_name');
        $languages = $this->load('language')->findAll('1=1',true);
        Core::$tpl->set('languages', $languages);
    }
    
    public function actionAdd()
    {
        if(_p())
        {
            $base_name = _p('base_name');
			$api_param = array();
			foreach ($_POST as $key => $value)
			{
				if (strpos($key, "exp_") !== false)
				{
					$api_param[$key] = $value;
				}
			}
			$api_param = json_encode($api_param);
			$apisns_map = Zhtx::createDataMap();
			$apisns_map->addEntry('base_name', Common::strEscape($base_name), DB::VARCHAR);
			$apisns_map->addEntry('image', Common::strEscape(_p('image')), DB::VARCHAR);
			$apisns_map->addEntry('status', Common::queryInt(_p('status')), DB::INT);
			$apisns_map->addEntry('create_time', SYS_TIME, DB::INT);
			$apisns_map->addEntry('api_type', _p('api_type'), DB::VARCHAR);
			$apisns_map->addEntry('api_param', Common::strEscape($api_param,false), DB::VARCHAR);
			$apisns_map->addEntry('language_id', Common::queryInt(_p('language_id')), DB::INT);
                        $apisns_map->addEntry('listorder', Common::queryInt(_p('listorder'),0), DB::INT);
			$res = $this->apisnslogic->insert($apisns_map);
			if($res)
			{
                                if(!_p('listorder')){
                                    $map = Zhtx::createDataMap(); 
                                    $map->addEntry('listorder', 10*$res, DB::INT);
                                    $this->apisnslogic->update($map, 'id='.$res);
                                }
				return $this->success('add_success', Common::adminURL('admin', 'apisns', 'list'));
			}
			else
			{
				return $this->error('add_failure', Common::adminURL('admin', 'apisns', 'list'));
			}
        }
		else
		{
            $languages = $this->load('language')->findAll('1=1');
			Core::$tpl->set('api_type_list', $this->getApiType());
            Core::$tpl->set('languages', $languages);
		}
    }
    
    public function actionEdit()
    {
        if(_p())
        {
            $id = intval(_p('id'));
            $base_name = _p('base_name');
			$api_param = array();
			foreach ($_POST as $key => $value)
			{
				if (strpos($key, "exp_") !== false)
				{
					$api_param[$key] = $value;
				}
			}
			$api_param = json_encode($api_param);
			$apisns_map = Zhtx::createDataMap();
			$apisns_map->addEntry('base_name', Common::strEscape($base_name), DB::VARCHAR);
			$apisns_map->addEntry('api_type', _p('api_type'), DB::VARCHAR);
			$apisns_map->addEntry('image', Common::strEscape(_p('image')), DB::VARCHAR);
			$apisns_map->addEntry('status', Common::queryInt(_p('status')), DB::INT);
			$apisns_map->addEntry('api_param', Common::strEscape($api_param,false), DB::VARCHAR);
                        $apisns_map->addEntry('language_id', Common::queryInt(_p('language_id')), DB::INT);
                        $apisns_map->addEntry('listorder', Common::queryInt(_p('listorder'),0), DB::INT);
			$res = $this->apisnslogic->update($apisns_map, 'id='.$id);
			if($res)
			{
				return $this->success('edit_success', Common::adminURL('admin', 'apisns', 'list'));
			}
			else
			{
				return $this->error('edit_failure', Common::adminURL('admin', 'apisns', 'list'));
			}
        }
        else
        {
            $id = Common::queryInt(_g('id'));
            $apisns = $this->apisnslogic->getOne('id='.$id);
            if(!$apisns)
			{
                return $this->error('id_error', Common::adminURL('admin', 'apisns', 'list'));
            }
            $languages = $this->load('language')->findAll('1=1');
			Core::$tpl->set('api_type_list', $this->getApiType());
            Core::$tpl->set('apisns', $apisns);
            Core::$tpl->set('languages', $languages);
        }
    }
    
    public function actionPublicQuickEdit() {
        $id = Common::queryInt(_p('id'));
        $map = Zhtx::createDataMap();
        if (!$id) {
            echo 0;
            return;
        }
        if (_p('listorder')) {
            if (!is_numeric(_p('listorder'))) {
                echo 0;
                return;
            }
            $map->addEntry('listorder', Common::queryInt(_p('listorder')), DB::INT);
        }
        $res = $this->apisnslogic->update($map, 'id=' . $id);
        echo $res ? 1 : 0;
    }
    
    public function actionDel() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
		$user_api = $this->load("userapi");
		
        if(!empty($ids))
        {
          $num = 0;
          foreach ($ids as $id)
          {
            $res  = $this->apisnslogic->delete('id=' . $id);
			$user_api->delete('api_id='.$id);
            if($res)
            {             
              $num++;
            }
          }
          $staus = 1;
          $flag = $lang['success_delete']. $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }
	
	 private function getApiType()
    {
        $formula = array();
        $fp = opendir('./api/login/');
        while ($file = readdir($fp))
        {
            if ($file != '.' && $file != '..'&& $file != '.svn')
            {
               if( is_dir( './api/login/'.$file ) )
			   {
				   $formula_item = array();
				   $formula_item["name"] = trim(file_get_contents('./api/login/' . $file . '/readme.txt'));
				   $formula_item["type"] = trim($file);
				   $formula[] = $formula_item;
			   }
			}
        }
        closedir($fp);
        return $formula;
    }
	
	public function actionPublicGetParamForm()
    {
		$id =  _g("id");
        $folder =  _g("folder");
		$cond="id={$id}";
        $apisns = $this->apisnslogic->getOne($cond);
		if($apisns)
        {
            $param=array();
			if($apisns["api_param"]!="")
            {
                $param = json_decode($apisns["api_param"],true);
            }
        }
		if(is_file(APP_ROOT.'api/login/'.$folder.'/form.php'))
		{
			require_once APP_ROOT.'api/login/'.$folder.'/form.php';
		}
		exit();
    }
}
?>
