<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of ArticleController
 * 新闻
 *
 * @author czy
 */
class ArticleController extends AppController
{

    private $articleLogic; //新闻
//    private $articlejoincategoryLogic; //新闻关联新闻分类
    private $articlecategoryLogic; //新闻分类
    private $articlelanguageLogic; //新闻多语言
    private $langJoinCountryLogic; //语言关联国家
    private $articleCateRelLogic; //新闻与新闻分类关系表

    public function __construct()
    {
        parent::__construct();
        $this->articleLogic = $this->load('article');
//        $this->articlejoincategoryLogic = $this->load('articleJoinCategory');
        $this->articlecategoryLogic = $this->load('articleCategory');
        $this->articlelanguageLogic = $this->load('articleLanguage');
        $this->langJoinCountryLogic = $this->load('languageJoinCountry');
        $this->articleCateRelLogic = $this->load('articleCategoryRelation');
		$this->languageLogic = $this->load('language');
		
		
    }

    public function actionList()
    {
        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);		
		$where = '1=1';
        if(_g('base_name'))
        {
            $where .= " and base_name like '%" . _g('base_name') . "%'";
        }
        //关联新闻分类表，取出分类
        $count = $this->articleLogic->getCount($where);
        $page_list = Common::getPages($count, $curr_page, $page_size);
		$where .= " ORDER BY id DESC";
        $res = $this->articleLogic->getCurrentDatas($where, $page_size, $curr_page);        
        Core::$tpl->set("articlelist", $res);
        Core::$tpl->set("pages", $page_list);
    }

    public function actionAdd()
    {
        global $default_select_name;
        if (_p())
        {
            $base_site_id = Common::validSiteConfig();
			$catName = _p('lang_base_name'.$base_site_id);
            if (!$catName)
            {
                return $this->showMessage('name_not_empty');
            }
            $cat_map = Zhtx::createDataMap();            
            $path_id = _p('path_id');
            $cat_map->addEntry('category_url', $path_id, DB::VARCHAR); //所属分类url
            $cat_map->addEntry('base_name', Common::strEscape($catName), DB::VARCHAR); //新闻名称
            $cat_map->addEntry('create_time', SYS_TIME, DB::INT); //创建时间
            $cat_map->addEntry('visit_counts', Common::strEscape(_p("visit_counts")), DB::INT); //浏览量
            $res = $this->articleLogic->insert($cat_map);
            if ($res)
            {
                if ($path_id)
                {//有选择分类，同步article_category_rel关系表
                    $new_cat_map = Zhtx::createDataMap();
                    $new_cat_map->addEntry('article_id', $res, DB::INT); //新闻ID
                    $new_cat_map->addEntry('article_category_path', $path_id, DB::VARCHAR); //新闻分类url集合
                    $this->articleCateRelLogic->insert($new_cat_map);
                }
                //多语言处理
				$languages = $this->languageLogic->findALL('status=1', true);
				//更新选中的信息
				foreach ($languages as $item)
				{
					$articleLanguage = Zhtx::createDataMap();
					$articleLanguage->addEntry('article_id', $res, DB::INT);
					$articleLanguage->addEntry('language_id', $item["id"], DB::INT);
					$articleLanguage->addEntry('base_name', Common::strEscape(_p('lang_base_name'.$item["id"])), DB::VARCHAR);
					$articleLanguage->addEntry('title', Common::strEscape(_p('title'.$item["id"])), DB::VARCHAR);
					$articleLanguage->addEntry('keywords', Common::strEscape(_p('keywords'.$item["id"])), DB::VARCHAR);
					$articleLanguage->addEntry('descript', Common::strEscape(_p('descript'.$item["id"])), DB::VARCHAR);
					$articleLanguage->addEntry('detail', Common::strEscape(Inputer::getOrgPost('detail'.$item["id"]),false), DB::VARCHAR);
                    $articleLanguage->addEntry('status', Common::queryInt(_p('is_display-'.$item["id"])), DB::VARCHAR);
                    $this->articlelanguageLogic->insert($articleLanguage);
                }                
                 $diy_url_flag = TRUE;
                 if (_p('page_url'))
                {
                    $diyUrlLogic = $this->load('urlAlisa');
                    $true_url    = Common::frontURL('home', 'article', 'detail', array('id' => $res), FALSE);
                    $page_url = str_replace(array('?', '&', '%'), '-', _p('page_url'));
                    $diy_res     = $diyUrlLogic->createDiyUrl($page_url, $true_url);
                    if ($diy_res)
                    {
                        $new_cat_map = Zhtx::createDataMap(); 
                        $new_cat_map->addEntry('page_url', Common::strEscape($page_url), DB::VARCHAR);
                        $this->articleLogic->update($new_cat_map,"id=".$res);
                    }
                    else
                    {
                       $diy_url_flag = FALSE;
                    }                    
                }
            
            return $diy_url_flag ? $this->success('add_success', Common::adminURL('admin', 'article', 'list')) : $this->showMessage('diy_url_already_exists');   
            }
			else
            {
				return $this->error('add_failure');
            }
        } 
		else
        {
            //显示
            $cond = array("base_name", "path_id", "parent_id", "id");
            $categorys = $this->articlecategoryLogic->getList('1=1 order by parent_id and listorder asc', "", $cond);
            $category_tree = array();
            $cates = Common::setTreeData($categorys['list']);
            Common::getTree($cates, $tree, 0);
            foreach ($tree as $item)
            {
                $category_tree[$item['id']] = array(
                    'id' => $item['path_id'], //option中的value值
                    'base_name' => str_repeat('　', $item['level']) . $item['base_name'],
                );
            }            
            Core::$tpl->set("cateSelect", $category_tree);
            //多语言
            $languages = $this->langJoinCountryLogic->getList('l.status=1');
            core::$tpl->set('languages', $languages['list']);
            Core::$htmlFile  = 'article/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    public function actionEdit()
    {
        global $default_select_name;
        if (_p())
        {
            $id = _p('id') ? intval(_p('id')) : 0;
            $base_site_id = Common::validSiteConfig();
			$catName = _p('lang_base_name'.$base_site_id);
            if (!$catName)
            {
                return $this->showMessage('name_not_empty');
            }
            $cat_map = Zhtx::createDataMap();            
            $path_id = _p('path_id');
            $cat_map->addEntry('category_url', $path_id, DB::VARCHAR); //所属分类url
            $cat_map->addEntry('base_name', Common::strEscape($catName), DB::VARCHAR); //新闻名称
            $cat_map->addEntry('create_time', SYS_TIME, DB::INT); //创建时间
            $res = $this->articleLogic->update($cat_map, "id='{$id}'");
            if ($res)
            {
                if ($path_id)
                {//有选择分类，同步article_category_rel关系表
                    $new_cat_map = Zhtx::createDataMap();
                    $new_cat_map->addEntry('article_id', $id, DB::INT);
                    $new_cat_map->addEntry('article_category_path', $path_id, DB::VARCHAR); //新闻分类url集合
                    $this->articleCateRelLogic->replaceByCond($new_cat_map, "article_id='{$id}'");
                }
				$languages = $this->languageLogic->findALL('status=1', true);
				//更新选中的信息
				foreach ($languages as $item)
				{
					$articleLanguage = Zhtx::createDataMap();
					$articleLanguage->addEntry('article_id', $id, DB::INT);
					$articleLanguage->addEntry('language_id', $item["id"], DB::INT);
					$articleLanguage->addEntry('base_name', Common::strEscape(_p('lang_base_name'.$item["id"])), DB::VARCHAR);
					$articleLanguage->addEntry('title', Common::strEscape(_p('title'.$item["id"])), DB::VARCHAR);
					$articleLanguage->addEntry('keywords', Common::strEscape(_p('keywords'.$item["id"])), DB::VARCHAR);
					$articleLanguage->addEntry('descript', Common::strEscape(_p('descript'.$item["id"])), DB::VARCHAR);
					$articleLanguage->addEntry('detail', Common::strEscape(Inputer::getOrgPost('detail'.$item["id"]),false), DB::VARCHAR);
                    $articleLanguage->addEntry('status', Common::queryInt(_p('is_display-'.$item["id"])), DB::VARCHAR);
                    $values = $item["id"];
					if ($this->articlelanguageLogic->getOne("article_id = {$id} AND language_id = {$values}"))
					{
						$this->articlelanguageLogic->update($articleLanguage, "article_id = {$id} AND language_id = {$values}");
					}
					else
					{
						$this->articlelanguageLogic->insert($articleLanguage);
					}
                }
                //自定义URL
                $diy_url_flag = TRUE;            
                $diyUrlLogic = $this->load('urlAlisa');
                $true_url    = Common::frontURL('home', 'article', 'detail', array('id' => $id), FALSE);
                $page_url = str_replace(array('?', '&', '%'), '-', _p('page_url'));
                $diy_res     = $diyUrlLogic->createDiyUrl($page_url, $true_url);
                if ($diy_res)
                {
                    $new_cat_map = Zhtx::createDataMap(); 
                    $new_cat_map->addEntry('page_url', Common::strEscape($page_url), DB::VARCHAR);
                    $this->articleLogic->updateById($new_cat_map, $id);
                }
                else
                {
                    $diy_url_flag = FALSE;
                }                    
                
            
               return $diy_url_flag ? $this->success('edit_success', Common::adminURL('admin', 'article', 'list')) : $this->showMessage('diy_url_already_exists');
            }
			else
            {
				return $this->error('edit_failure');
            }
        } 
		else
        {
            //显示
            $id = _g('id') ? intval(_g('id')) : 0;
            //获取记录
            $article = $this->articleLogic->getOne('id=' . $id);
            if (!$article)
            {
                return $this->showMessage('not_found_record');
            }
            Core::$tpl->set("article", $article);
            //获取分类
            $cond = array("base_name", "path_id", "parent_id", "id");
            $categorys = $this->articlecategoryLogic->getList('1=1 order by parent_id and listorder asc', "", $cond);
            $category_tree = array();
            $cates = Common::setTreeData($categorys['list']);
            Common::getTree($cates, $tree, 0);
            foreach ($tree as $item)
            {
                $category_tree[$item['id']] = array(
                    'id' => $item['path_id'], //option中的value值
                    'base_name' => str_repeat('　', $item['level']) . $item['base_name'],
                );
            }
            Core::$tpl->set("cateSelect", $category_tree);
            //多语言
			$languages = $this->langJoinCountryLogic->getList('l.status=1');
			$cond = 'article_id = ' . $id;
			$articlelang = $this->articlelanguageLogic->getList($cond);
			$articlelang_arr = array();
			foreach ($articlelang['list'] as $value)
			{
				$articlelang_arr[$value['language_id']] = $value;
			}
		    Core::$tpl->set('articleLanguage', $articlelang_arr);
            Core::$tpl->set('languages', $languages["list"]);
            Core::$htmlFile  = 'article/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    /**
     * 删除新闻，同步删除三张表记录
     * @return type
     */
    public function actionDel()
    {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if(!empty($ids))
        {
          $num = 0;
          foreach ($ids as $id)
          {
                $article = $this->articleLogic->getOne('id='.$id);
                $this->load('urlAlisa')->deleteDiyUrl($article['page_url']);
                $res  = $this->articleLogic->delete('id=' . $id);
                if($res)
                {    
                  $this->articleCateRelLogic->delete('article_id='.$id);
                  $this->articlelanguageLogic->delete('article_id='.$id);
                  $num++;
                }
          }
          $staus = 1;
          $flag = $lang['success_delete']. $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }
	
	 public function actionPublicEditStatus()
    {
        $id     = Common::queryInt(_g('id'));
        $status = _g('currentStatus') ? 1 : 0;
        $map    = Zhtx::createDataMap();
        $map->addEntry('status', $status, DB::INT);
        $res   =  $this->articleLogic->updateById($map, $id);
        echo $res ? 1 : 0;
    }
	
}

?>
