<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of ArticlecategoryController
 * 新闻分类
 *
 * @author czy
 */
class ArticlecategoryController extends AppController
{

    private $articlecategoryLogic; //新闻分类
    private $languageLogic; //语言包
    private $artcatelangLogic; //新闻分类多语言表
    private $langJoinCountryLogic; //语言关联国家
    private $art_cate_rel_logic; //新闻分类与新闻关系表
    private $article; //新闻

    public function __construct()
    {
        parent::__construct();
        $this->articlecategoryLogic = $this->load('articleCategory');
        $this->languageLogic = $this->load('language');
        $this->artcatelangLogic = $this->load('articleCategoryLanguage');
        $this->langJoinCountryLogic = $this->load('languageJoinCountry');
        $this->article = $this->load("article");
    }

    public function actionList()
    {
      
		$category_list     = $this->articlecategoryLogic->getList('1=1 order by parent_id asc,listorder desc');
		foreach($category_list['list'] as $key => $value)
		{
			$category_list['list'][$key]["level"] = substr_count( $value["path_id"] , ',');
		}
        $cates = Common::setTreeData($category_list['list']);
		Common::getTree($cates,$cat_tree,0);       
        Core::$tpl->set('category', $cat_tree);
	}

    /**
     * 多语言未处理
     * @return type 
     */
    public function actionAdd()
    {
        if (_p())
        {
            $base_site_id = Common::validSiteConfig();
			$base_name = _p('base_name'.$base_site_id);
            if(!$base_name)
            {
              return $this->error('default_site_required');
            }
            $cat_map = Zhtx::createDataMap();
            $parent_id = intval(_p('parent_id'));
            $cat_map->addEntry('parent_id', $parent_id, DB::INT);
            $cat_map->addEntry('base_name', Common::strEscape($base_name), DB::VARCHAR);
            $cat_map->addEntry('listorder', _p('listorder') ? _p('listorder') : 1, DB::INT);
            $cat_map->addEntry('create_time', SYS_TIME, DB::INT);
			$cat_map->addEntry('status', _p('status'), DB::INT);
			$cat_map->addEntry('page_url', Common::strEscape(_p('page_url')), DB::VARCHAR);
            $cat_map->addEntry('path_id', '', DB::VARCHAR);
            $res = $this->articlecategoryLogic->insert($cat_map);
			if ($res)
            {
                if ($parent_id)
                {//有选择上级
                    $cat = $this->articlecategoryLogic->getOne('id=' . $parent_id);
                    $newpath_id = $cat['path_id'] . $res . ",";
                }
				else
                {
                    $newpath_id = $res . ",";
                }
                // $path_id[]=$res;
                $new_cat_map = Zhtx::createDataMap();
                $new_cat_map->addEntry('path_id', $newpath_id, DB::VARCHAR);
                
                //自定义路径
                $diy_url_flag = TRUE;          
                $diyUrlLogic = $this->load('urlAlisa');
                $newpath_id = explode(',', substr($newpath_id, 0, -1));
                $path_count = count($newpath_id);
                $true_url    = Common::frontURL('home', 'article', 'list', array('article_category_id' => $newpath_id[$path_count-1]), FALSE);
                $diy_res     = $diyUrlLogic->createDiyUrl(_p('page_url'), $true_url);
                if ($diy_res)
                {                   
                    $update_goods_data['page_url'] = Common::strEscape(_p('page_url'));
                }
                else
                {
                    $diy_url_flag = FALSE;
                    return $this->showMessage('diy_url_already_exists');
                }
            
                $this->articlecategoryLogic->update($new_cat_map, 'id=' . $res);
                //多语言处理                
				$languages = $this->languageLogic->findALL('status=1', true);
				//更新选中的信息
				foreach ($languages as $item)
				{
					$articlecategoryLanguage = Zhtx::createDataMap();
					$articlecategoryLanguage->addEntry('article_category_id', $res, DB::INT);
					$articlecategoryLanguage->addEntry('language_id', $item["id"], DB::INT);
					$articlecategoryLanguage->addEntry('base_name', Common::strEscape(_p('base_name'.$item["id"])), DB::VARCHAR);
					$articlecategoryLanguage->addEntry('title', Common::strEscape(_p('title'.$item["id"])), DB::VARCHAR);
					$articlecategoryLanguage->addEntry('keywords', Common::strEscape(_p('keywords'.$item["id"])), DB::VARCHAR);
					$articlecategoryLanguage->addEntry('descript', Common::strEscape(_p('descript'.$item["id"])), DB::VARCHAR);
					$articlecategoryLanguage->addEntry('detail', Common::strEscape(Inputer::getOrgPost('detail'.$item["id"]),false), DB::VARCHAR);
					$this->artcatelangLogic->insert($articlecategoryLanguage);
				} 
                return $this->success('add_success', Common::adminURL('admin', 'articlecategory', 'list'));
            }
			else
				return $this->error('add_failure');
        } 
		else
        {
			$parent_id = Common::queryInt(_g('parent_id'));
            Core::$tpl->set('parent_id', $parent_id);
            $category_list = $this->articlecategoryLogic->getList("1=1 order by parent_id and listorder asc");
	    $category_tree = array();
                        $category_list = Common::setTreeData($category_list["list"]);
			Common::getTree($category_list,$category_tree,0);
            foreach ($category_tree as $item) {     
                $category_tree[$item['id']] = str_repeat('　', $item['level']) . $item['base_name']; 
            }
			Core::$tpl->set('category_tree', $category_tree);
            $languages = $this->langJoinCountryLogic->getList('l.status=1');
            core::$tpl->set('languages', $languages['list']);
            
        }
    }

    public function actionEdit()
    {
        if (_p())
        {
            $id = _p('id') ? intval(_p('id')) : 0;
			$parent_id = intval(_p('parent_id'));
//            $catinfo = $this->articlecategoryLogic->getOne("id='{$id}'"); //该条分类信息
            $base_site_id = Common::validSiteConfig();
			$base_name = _p('base_name'.$base_site_id);
            if(!$base_name)
            {
              return $this->error('default_site_required');
            }
            $cat_map = Zhtx::createDataMap();
            $parent_id = intval(_p('parent_id'));
            $cat_map->addEntry('base_name', Common::strEscape($base_name), DB::VARCHAR);
            $cat_map->addEntry('listorder', _p('listorder') , DB::INT);
            $cat_map->addEntry('create_time', SYS_TIME, DB::INT);
			$cat_map->addEntry('status', _p('status'), DB::INT);
			$cat_map->addEntry('parent_id', _p('parent_id'), DB::INT);
			$cat_map->addEntry('page_url', Common::strEscape(_p('page_url')), DB::VARCHAR);
            $cat_map->addEntry('path_id', '', DB::VARCHAR);
            $res = $this->articlecategoryLogic->update($cat_map, 'id=' . $id); //更新分类表
          
			if ($res)
            {
				if ($parent_id)
                {
                    $cat = $this->articlecategoryLogic->getOne('id=' . $parent_id);
                    $newpath_id = $cat['path_id'] . $id . ","; //新分类url
                } 
				else
                {
                    $newpath_id = $id . ",";
                }
                
                    //更新分类
				$new_cat_map = Zhtx::createDataMap();
                $new_cat_map->addEntry('path_id', $newpath_id, DB::VARCHAR);
                //自定义路径
                $diy_url_flag = TRUE;          
                $diyUrlLogic = $this->load('urlAlisa');
                $newpath_id = explode(',', substr($newpath_id, 0, -1));
                $path_count = count($newpath_id);
                $true_url    = Common::frontURL('home', 'article', 'list', array('article_category_id' => $newpath_id[$path_count-1]), FALSE);
                $diy_res     = $diyUrlLogic->createDiyUrl(_p('page_url'), $true_url);
                if ($diy_res)
                {                   
                    $update_goods_data['page_url'] = Common::strEscape(_p('page_url'));
                }
                else
                {
                    $diy_url_flag = FALSE;
                    return $this->showMessage('diy_url_already_exists');
                }
                $this->articlecategoryLogic->update($new_cat_map, "id='$id'");
               	 //多语言处理
				$languages = $this->languageLogic->findALL('status=1', true);
				//更新选中的信息
				foreach ($languages as $item)
				{
					$articlecategoryLanguage = Zhtx::createDataMap();
					$articlecategoryLanguage->addEntry('article_category_id', $id, DB::INT);
					$articlecategoryLanguage->addEntry('language_id', $item["id"], DB::INT);
					$articlecategoryLanguage->addEntry('base_name', Common::strEscape(_p('base_name'.$item["id"])), DB::VARCHAR);
					$articlecategoryLanguage->addEntry('title', Common::strEscape(_p('title'.$item["id"])), DB::VARCHAR);
					$articlecategoryLanguage->addEntry('keywords', Common::strEscape(_p('keywords'.$item["id"])), DB::VARCHAR);
					$articlecategoryLanguage->addEntry('descript', Common::strEscape(_p('descript'.$item["id"])), DB::VARCHAR);
					$articlecategoryLanguage->addEntry('detail', Common::strEscape(Inputer::getOrgPost('detail'.$item["id"]),false), DB::VARCHAR);
					$values = $item["id"];
					if ($this->artcatelangLogic->getOne("article_category_id = {$id} AND language_id = {$values}"))
					{
						$this->artcatelangLogic->update($articlecategoryLanguage, "article_category_id = {$id} AND language_id = {$values}");
					}
					else
					{
						$this->artcatelangLogic->insert($articlecategoryLanguage);
					}
				}
				return $this->success('edit_success', Common::adminURL('admin', 'articlecategory', 'list'));
           }
		   else
           		return $this->error('edit_failure', Common::adminURL('admin', 'articlecategory', 'list'));
        } 
		else
        {
			$id = Common::queryInt(_g('id'));
            $category = $this->articlecategoryLogic->getOne('id=' . $id);
            if (!$category)
            {
                return $this->error('id_error', Common::adminURL('admin', 'articlecategory', 'list'));
            }

			$categoryAll = $this->articlecategoryLogic->getList("1=1 order by parent_id and listorder asc");
			$category_tree = array();
            foreach (Common::getTree($categoryAll['list']) as $item) {     
                $category_tree[$item['id']] = str_repeat('　', $item['level']) . $item['base_name']; 
            }
			Core::$tpl->set('category_tree', $category_tree);
            Core::$tpl->set('parentid', $category['parent_id']);
            //还需要查询多语言
            Core::$tpl->set('category', $category);
            //生成select start
            $languages = $this->langJoinCountryLogic->getList('l.status=1');
			$cond = 'article_category_id = ' . $id;
			$categorylang = $this->artcatelangLogic->getList($cond);
			$categorylang_arr = array();
			foreach ($categorylang['list'] as $value)
			{
				$categorylang_arr[$value['language_id']] = $value;
			}
			 core::$tpl->set('categoryLanguage', $categorylang_arr);
            //生成select end
            Core::$tpl->set('languages', $languages["list"]);
        }
    }
    /**
     * 删除
     * @return type 
     */
    public function actionDel()
    {
        $cat_id = Common::queryInt(_g('id'));
        $cat    = $this->articlecategoryLogic->getOneById($cat_id);
        if(!$cat)
        {
          return $this->showMessage('illegal_parameters');
        }
        $cond  = 'path_id like "' . $cat['path_id'] . '%"';
        $count = $this->articlecategoryLogic->getCount($cond);
        if ($count > 1)
        {            
            return $this->showMessage('has_child_not_delete');
        }
        $this->load('urlAlisa')->deleteDiyUrl($cat['page_url']);
        $res = $this->articlecategoryLogic->delete('id=' . $cat_id);
        if($res)
        {
//          $this->artcatelangLogic->delete('article_category_id=' . $cat_id);
//          $relationLogic = $this->load('articleCategoryRelation');
//          $this->$relationLogic->delete('article_category_path=' . $cat['path_id']);
        }
        return $this->success('delete_success');
    }
	
	 public function actionPublicEditSort()
    {
      $id        = Common::queryInt(_p('id'));
      if(!$id)
      {
        echo 0;return;
      }
	  if(!is_numeric(_p('listorder')))
      {
			echo 0;return;  
	  }
      $map = Zhtx::createDataMap();
      $map->addEntry('listorder', Common::queryInt(_p('listorder')), DB::INT);
      $res = $this->articlecategoryLogic->update($map, 'id=' . $id);
      echo $res ? 1 : 0;
    } 
}

?>
