<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of BannerController
 *
 * @author cx
 */
class BannerController extends AppController
{
    private $bannerLogic;
    private $bannerItemLogic;
    private $bannerJoinBannerItemLogic;
    private $languageLogic;
    public function __construct()
    {
        parent::__construct();
        $this->bannerLogic = $this->load('banner');
        $this->bannerItemLogic = $this->load('bannerItem');
        $this->bannerJoinBannerItemLogic = $this->load('bannerJoinBannerItem');
        $this->languageLogic  = $this->load('language');
    }
    public function actionList()
    {
        $page_size = 20;
        $cond = "1=1 Order by id desc";
        //获取数据
        $res = $this->bannerLogic->getList($cond);
       
        Core::$tpl->set('res', $res['list']);
    }
    public function actionAdd()
    {
        if(_p())
        {
            $base_name = _p('base_name');
            $codeno    = _p('codeno');
            if(!$base_name || !$codeno)
            {
              return $this->showMessage('required_item');
            }
			$banner_map = Zhtx::createDataMap();
			$banner_map->addEntry('base_name', Common::strEscape($base_name), DB::VARCHAR);
			$banner_map->addEntry('codeno', Common::strEscape($codeno), DB::VARCHAR);
			$banner_map->addEntry('create_time', SYS_TIME, DB::INT);
			$banner_map->addEntry('descript', Common::strEscape(_p('descript')), DB::VARCHAR);
			$res = $this->bannerLogic->insert($banner_map);
			if($res)
				return $this->success('add_success', Common::adminURL('admin', 'banner', 'list'));
			else
				return $this->error('add_failure', Common::adminURL('admin', 'banner', 'list')); 
        }
		else
		{
			Core::$htmlFile  = 'banner/form';
			Core::$isdisplay = 0;
			Core::$tpl->render(Core::$htmlFile . '.htm');
		}
    }
    public function actionEdit()
    {
        if(_p())
        {
            $base_name = _p('base_name');
            $codeno    = _p('codeno');
            if(!$base_name || !$codeno)
            {
              return $this->showMessage('required_item');
            }
            $id = Common::queryInt(_p('id'));
            $banner = $this->bannerLogic->getOne($cond);
			$banner_map = Zhtx::createDataMap();
			$banner_map->addEntry('base_name', Common::strEscape($base_name), DB::VARCHAR);
			$banner_map->addEntry('codeno', Common::strEscape($codeno), DB::VARCHAR);
			$banner_map->addEntry('create_time', SYS_TIME, DB::INT);
			$banner_map->addEntry('descript', Common::strEscape(_p('descript')), DB::VARCHAR);
			$res = $this->bannerLogic->update($banner_map, 'id='.$id);
			if($res)
				return $this->success('edit_success', Common::adminURL('admin', 'banner', 'list'));
			else
				return $this->error('edit_failure', Common::adminURL('admin', 'banner', 'list')); 
           
        }
        else
        {
            $id = Common::queryInt(_g('id'));
            $where = 'id = ' . $id;
            $banner = $this->bannerLogic->getOne($where);
            if(!$banner)
            {
            	return $this->error('id_error', Common::adminURL('admin', 'banner', 'list')); 
            }
            Core::$tpl->set('banner', $banner);
            Core::$htmlFile  = 'banner/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
        
    }
    /**
     * 数据删除 
     */
    public function actionDel()
    {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if(!empty($ids))
        {
          $num = 0;
          foreach ($ids as $id)
          {            
                $res  = $this->bannerLogic->delete('id=' . $id);
                if($res)
                {   
                  $this->bannerItemLogic->delete('banner_id=' . $id);
                  $num++;
                }            
          }
          $staus = 1;
          $flag = $lang['success_delete']. $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }
    public function actionItemList()
    {
		$bid = Common::queryInt(_g('bid'));
		$cond = 'id=' . $bid;
		$cols = array('id', 'base_name');
		$banner = $this->bannerLogic->getCols($cond, $cols);
		if(!$banner)
		{
			return $this->error('id_error', Common::adminURL('admin', 'banner', 'list')); 
		}
		Core::$tpl->set('banner', $banner[0]);
		$where = "banner_id = $bid Order by listorder desc,id DESC";
		
	
		//获取数据
		$res = $this->bannerItemLogic->getList($where);
		//分页
		Core::$tpl->set('res', $res['list']);
		$cols = array('id','base_name');
		$languages = $this->languageLogic->getCols('1=1', $cols, TRUE);
		Core::$tpl->set('languages', $languages);
       
    }
    public function actionItemAdd()
    {
        if(_p())
        {
            $title = _p('title');
            $banner_id = _p('banner_id');
            $banner_item_map = Zhtx::createDataMap();
            $banner_item_map->addEntry('banner_id', $banner_id, DB::INT);
            $banner_item_map->addEntry('title', Common::strEscape($title), DB::VARCHAR);
            $banner_item_map->addEntry('image', Common::strEscape(_p('image')), DB::VARCHAR);
			$banner_item_map->addEntry('url', Common::strEscape(_p('url')), DB::VARCHAR);
            $banner_item_map->addEntry('language_id', Common::queryInt(_p('language_id')), DB::INT);       
            $banner_item_map->addEntry('descript', Common::strEscape(_p('descript')), DB::VARCHAR);
            $banner_item_map->addEntry('listorder', Common::queryInt(_p('listorder')), DB::INT);
            $res = $this->bannerItemLogic->insert($banner_item_map);
			if($res)
				return $this->success('add_success', Common::adminURL('admin', 'banner', 'list', array('bid'=>$banner_id)));
			else
				return $this->error('add_failure', Common::adminURL('admin', 'banner', 'list', array('bid'=>$banner_id))); 
        }
        else
        {
			$bid = Common::queryInt(_g('bid'));
			$where = 'id=' . $bid;
			$banner = $this->bannerLogic->getOne($where);
			if(!$banner)
				 return $this->error('id_error', Common::adminURL('admin', 'banner', 'list')); 
			Core::$tpl->set('banner', $banner);
			$cols = array('id','base_name');
			$languages = $this->languageLogic->getCols('1=1', $cols);
			Core::$tpl->set('languages', $languages);
        }
    }
    public function actionItemEdit()
    {
        if(_p())
        {
            $title = _p('title');
            $bid =  Common::queryInt(_p('banner_id'));
            $biid = Common::queryInt(_p('id'));
            $banner_item_map = Zhtx::createDataMap();
            $banner_item_map->addEntry('banner_id', $bid, DB::INT);
           	$banner_item_map->addEntry('title', Common::strEscape($title), DB::VARCHAR);
			$banner_item_map->addEntry('url', Common::strEscape(_p('url')), DB::VARCHAR);
         	$banner_item_map->addEntry('image', Common::strEscape(_p('image')), DB::VARCHAR);
         	$banner_item_map->addEntry('language_id', Common::queryInt(_p('language_id')), DB::INT);       
          	$banner_item_map->addEntry('descript', Common::strEscape(_p('descript')), DB::VARCHAR);
          	$banner_item_map->addEntry('listorder', Common::queryInt(_p('listorder')), DB::INT);
          	$res = $this->bannerItemLogic->update($banner_item_map, 'id='.$biid);
			if($res)
				return $this->success('edit_success', Common::adminURL('admin', 'banner', 'list'));
			else
				return $this->error('edit_failure', Common::adminURL('admin', 'banner', 'list')); 
           
        }
        else
        {   
            $biid = Common::queryInt(_g('biid'));
			$cond = 'id=' . $biid;
			$banner_item = $this->bannerItemLogic->getOne($cond);
			if(!$banner_item)
				return $this->error('id_error', Common::adminURL('admin', 'banner', 'list'));
			Core::$tpl->set('banner_item', $banner_item);
			$cond = 'id=' . $banner_item['banner_id'];
			$cols = array('id', 'base_name');
			$banner = $this->bannerLogic->getOne($cond, $cols);
			Core::$tpl->set('banner', $banner);
			$cols = array('id','base_name');
			$languages = $this->languageLogic->getCols('1=1', $cols, TRUE);
			Core::$tpl->set('languages', $languages);               
              
        }
    }
    public function actionItemDel()
    {
        if(_P())
        {
            $bid = _p('bid');
            $biidArr = _p('biid');
            foreach($biidArr as $k=>$v)
            {
                $res = $this->bannerItemLogic->delete("id='$v'");
            }
			return $this->success('delete_success', Common::adminURL('admin', 'banner', 'itemlist', array('bid'=>$bid)));
        }
        else
        {
            $this->showMessage('please_select_at_least_one');
        }
    }
     public function actionPublicEditSort()
    {
      $id        = Common::queryInt(_p('id'));
      if(!$id)
      {
        echo 0;return;
      }
	  if(!is_numeric(_p('listorder')))
      {
			echo 0;return;  
	  }
      $map = Zhtx::createDataMap();
      $map->addEntry('listorder', Common::queryInt(_p('listorder')), DB::INT);
      $res = $this->bannerItemLogic->update($map, 'id=' . $id);
      echo $res ? 1 : 0;
    } 
}
?>
