<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Payment
 *
 * @author huangjp@35zh.cn
 */
class CacheMgrController extends AppController {

    private $cacheConfig;
    private $cacheFile;

    public function __construct() {
        parent::__construct();
        $this->cacheConfig = APP_ROOT . 'conf/cache.conf.php';
        $this->cacheFile = APP_ROOT . 'cache/pageCache/';
        if (!is_dir($this->cacheFile)) {
            mkdir($this->cacheFile);
        }
        if (!file_exists($this->cacheConfig)) {
            fopen($this->cacheConfig, "w+");
        }
    }
	
	public function actionDelUpgrade()
	{
		Dir::delDirAndFile('upgrade/');
		return $this->success('operation_success', Common::adminURL('admin', 'cacheMgr', 'default'));
	}
	
    public function actionDefault() {
        global $current_currency, $site_info;

        $language_id = $site_info['currency']['id'];
        $p = _p();
        if ($p) {
            $status = $p['status'];
            $domain_name = $p['domain_name'];
            $string = '<?php ' . "\n";
            foreach (_p() as $key => $cfg_val) {
                $string .= '$cache_cfg[\'sites\'][1]' . "['" . $key . "']=" . '"' . str_replace("\"", "\\\"", $cfg_val) . '"' . ";\n";
            }
            $string .= '?>';
            @file_put_contents($this->cacheConfig, $string);
			$smarty = new Smarty();
        	$smarty->clearAllCache();
            die(json_encode(array("status" => true, 'data' => $status)));
        } else {
            global $cfg;
            require_once $this->cacheConfig;
            if (is_readable($this->cacheFile) == true) {
                $array = $this->traverse($this->cacheFile);
                if (count($array) > 0) {
                    Core::$tpl->set('array', $array);
                }
            }
            Core::$tpl->set('sites', $cfg['sites']);
            Core::$tpl->set('sites', $cache_cfg['sites']);
        }
    }

// 清除
    public function actionClean() {
        $p = _p();
        if ($p) {
            if ($p['type'] == 'all') {
                $current_dir = opendir($this->cacheFile);
                while (($file = readdir($current_dir)) !== false) {    //readdir()返回打开目录句柄中的一个条目
                    $sub_dir = $path . DIRECTORY_SEPARATOR . $file;    //构建子目录路径
                    if ($file == '.' || $file == '..') {
                        continue;
                    } else {    //如果是文件,直接输出
                        $dir = $this->cacheFile . $file;
                        @unlink($dir);
                    }
                }
                die(json_encode(array('status' => true)));
            } else {
                $dir = $this->cacheFile . $p['dir'];
                if (file_exists($dir) == false) {
                    die(json_encode(array('status' => false, 'msg' => '文件不存在')));
                } else {
                    @unlink($dir);
                    die(json_encode(array('status' => true)));
                }
            }
        }
    }

    //清除首页缓存
    public function actionCleanHome() {
        $is_exist = is_file(APP_ROOT . 'cache/open_shop.lock');
        $smarty = new Smarty();
        $smarty->clearAllCache();
        if($is_exist){//一键清空缓存不清空open_shop.lock
            file_put_contents(APP_ROOT . 'cache/open_shop.lock', 'lock');
        }
        return $this->success('operation_success', Common::adminURL('admin', 'cacheMgr', 'default'));
    }

    // 遍历所有缓存文件
    public function traverse($path = '.') {
        $current_dir = opendir($path);    //opendir()返回一个目录句柄,失败返回false
        $array = array();
        while (($file = readdir($current_dir)) !== false) {    //readdir()返回打开目录句柄中的一个条目
            $sub_dir = $path . DIRECTORY_SEPARATOR . $file;    //构建子目录路径
            if ($file == '.' || $file == '..') {
                continue;
            } else if (is_dir($sub_dir)) {    //如果是目录,进行递归
                $this->traverse($sub_dir);
            } else {    //如果是文件,直接输出
                $dir = $path . $file;
                $size = filesize($dir);
                $size = $this->c_size($size);
                $createTime = filemtime($dir);
                array_push($array, array('path' => $file, 'size' => $size, 'createTime' => $createTime));
                //echo 'File in Directory ' . $path . ': ' . $file . '<br>';
            }
        }
        return $array;
    }

    //单位换算
    function c_size($int) {          //这里注意:我们不用直接传路径的,我们$int的值是直接为标量的值,就是只有大小
        if ($int > pow(1024, 3)) {
            return round($int / pow(1024, 3), 2) . 'G';     //这里一定要注意:round($i,2)后面的2千万不要忘了,后则会出错的
        } elseif ($int > pow(1024, 2)) {
            return round($int / pow(1024, 2), 2) . 'M';     //我们写好一行复制就可以了
        } elseif ($int > pow(1024, 1)) {
            return round($int / pow(1024, 1), 2) . 'K';
        } else {
            return round($int / pow(1024, 0), 2) . 'bytes';
        }
    }

}

?>
