<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Category
 *
 * @author xrx
 */
class CategoryNavPageController extends AppController {

    private $catLogic;
    private $languageLogic;
    private $langLogic;
    private $goodsCatLangLogic;
    private $navPageLogic;
    private $navPageLanguageLogic;

    public function __construct() {

        parent::__construct();

        $this->catLogic = $this->load('goodsCategory');

        $this->languageLogic = $this->load('language');
        $this->goodsCatLangLogic = $this->load('goodsCategoryLanguage');
        $this->navPageLogic = $this->load('navPage');
        $this->navPageLanguageLogic = $this->load('navPageLanguage');

        ignore_user_abort(true);

        set_time_limit(0);
    }

    public function actionList() {
        $where = '1=1';
        $search = array();
        if (_g('search_value') && _g('search_cond')) {
            if (_g('search_cond') == 'base_name') {
                $where .= ' and ' . _g('search_cond') . " like '%" . _g('search_value') . "%' ";
            } else {
                $where .= ' and ' . _g('search_cond') . " =" . _g('search_value');
            }
            $search['search_value'] = _g('search_value');
            $search['search_cond'] = _g('search_cond');
            $category_show = $this->catLogic->findALL($where . ' order by parent_id asc,listorder desc,id DESC', true);
            foreach ($category_show as $key => $value) {
                $value["has_son"] = 0;
                $value["level"] = 1;
                $category_show[$key] = $value;
            }
        } else {
            $category_id = _g('id') ? intval(_g('id')) : 0;
            $categories = $this->catLogic->findALL($where . ' order by parent_id asc,listorder desc,id DESC');
            $categories = Common::setTreeData($categories);
            Common::getTree($categories, $category_tree, 0);
            $category_show = $this->actionPublicGetCategoryTree($category_tree, $category_id);
        }
        Core::$tpl->set('res', $category_show);
        Core::$tpl->set('search', $search);
        $goods_types = $this->load('goodsType')->findAll('1=1', true);
        Core::$tpl->set("types", $goods_types);
        Core::$tpl->set('nav_page', $this->load('navPage')->findAll('', TRUE));
    }

    /**

     * 

     * @return type 

     */
    public function actionEditrel() {
        if (_p()) {
            $arr_page_id = _p('page_id');
            $cat_id = _p('cat_id');
            if (count($arr_page_id) > 0) {
                foreach ($arr_page_id as $value) {
                    $tmp_title = _p('page_title' . $value) ? _p('page_title' . $value) : '';
                    $tmp_comtent = _p('page_content' . $value) ? _p('page_content' . $value) : '';
                    $navpage_map = Zhtx::createDataMap();
                    $navpage_map->addEntry('base_name', $tmp_title, DB::VARCHAR);
                    $res = $this->navPageLogic->update($navpage_map, ' id=' . $value);
                    $navpage_language_map = Zhtx::createDataMap();
                    $navpage_language_map->addEntry('base_name', $tmp_title, DB::VARCHAR);
                    $navpage_language_map->addEntry('detail', $tmp_comtent, DB::TEXT);
                    $res = $this->navPageLanguageLogic->update($navpage_language_map, ' nav_page_id=' . $value);
                }
                $res ? $this->success('add_success', Common::adminURL('admin', 'categoryNavPage', 'Editrel', array('cid' => $cat_id))) : $this->showMessage('保存数据失败!');
            }
        } else {
            $id = Common::queryInt($_GET['cid']);
            $cur_cat = $this->catLogic->getOneById($id);
            $str_pages = $cur_cat['nav_page_id'] ? $cur_cat['nav_page_id'] : 0;
            $NavPageJoinLanguageLogic = $this->load('navPageJoinLanguage');
            global $cfg;
            $nav_page = $NavPageJoinLanguageLogic->findAll('n.id in (' . $str_pages . ') and ' . ' l.language_id=' . $cfg['sites'][0]['base_site']);
            Core::$tpl->set('nav_page', $nav_page);
            Core::$tpl->set('curcat', $cur_cat);
        }
    }

    /**
     * 添加分类关联页面
     */
    public function ActionAddRelPage() {
        if (_p()) {
            $cat_id = _p('cat_id');
            $cat = $this->catLogic->getOneById($cat_id);
            $page_title = Common::strEscape(_p('page_title'));
            $page_id = _p('page_id');
            $disc_sub_category = _p('disc_sub_category');
            if ($cat_id && $page_id) {
                $str_nav_page = $cat['nav_page_id'] ? $page_id . ',' . $cat['nav_page_id'] : $page_id;
                $cat_data = array(
                    'nav_page_id' => $str_nav_page
                );
                $result = $this->catLogic->save($cat_data, $cat_id);
                if ($disc_sub_category == 1) {
                    $cond = "path_id like '" . $cat['path_id'] . "%' and nav_page_id=0";
                    $map = Zhtx::createDataMap();
                    $map->addEntry('nav_page_id', $str_nav_page, DB::VARCHAR);
                    $this->catLogic->update($map, $cond);
                } else if ($disc_sub_category == 2) {
                    $cond = "path_id like '" . $cat['path_id'] . "%'";
                    $map = Zhtx::createDataMap();
                    $map->addEntry('nav_page_id', $str_nav_page, DB::VARCHAR);
                    $this->catLogic->update($map, $cond);
                }
            }
            if ($cat_id && $page_title) {
                $navpage_map = Zhtx::createDataMap();
                $navpage_map->addEntry('base_name', $page_title, DB::VARCHAR);
                $navpage_map->addEntry('type', 1, DB::INT);
                $navpage_map->addEntry('status', 1, DB::INT);
                $res = $this->navPageLogic->insert($navpage_map);
                if ($res) {
                    $languages = $this->languageLogic->findALL('status=1', true);
                    //更新选中的信息
                    foreach ($languages as $item) {
                        $data = array(
                            'nav_page_id' => $res,
                            'language_id' => $item["id"],
                            'base_name' => $page_title,
                        );
                        $this->navPageLanguageLogic->save($data);
                    }
                    $str_nav_page = $cat['nav_page_id'] ? $res . ',' . $cat['nav_page_id'] : $res;
                    $cat_data = array(
                        'nav_page_id' => $str_nav_page
                    );
                    $result = $this->catLogic->save($cat_data, $cat_id);
                    if ($disc_sub_category == 1) {
                        $cond = "path_id like '" . $cat['path_id'] . "%' and nav_page_id=0";
                        $map = Zhtx::createDataMap();
                        $map->addEntry('nav_page_id', $str_nav_page, DB::VARCHAR);
                        $this->catLogic->update($map, $cond);
                    } else if ($disc_sub_category == 2) {
                        $cond = "path_id like '" . $cat['path_id'] . "%'";
                        $map = Zhtx::createDataMap();
                        $map->addEntry('nav_page_id', $str_nav_page, DB::VARCHAR);
                        $this->catLogic->update($map, $cond);
                    }
                }
            }
            if ($result) {
                $nav_page_id = $res ? $res : $page_id;
                $this->success("操作成功", Common::adminURL('admin', 'categoryNavPage', 'AddRelPage', array('cid' => $cat_id, 'nav_page_id' => $nav_page_id)));
            }
        } else {
            $cat_id = _g('cid');
            $nav_page_id = _g('nav_page_id');
            if ($cat_id) {
                $cur_cat = $this->catLogic->getOneById($cat_id);
                $where = '1=1 and status=1 ORDER BY id DESC';
                $navpages = $this->navPageLogic->findAll($where);
                Core::$tpl->set('navpages', $navpages);
                Core::$tpl->set('curcat', $cur_cat);
                if ($nav_page_id) {
                    $nav_page = $this->navPageLogic->getOneById($nav_page_id);
                    Core::$tpl->set('nav_page', $nav_page);
                }
            } else {
                $this->showMessage("您访问的页面参数有误", Common::adminURL('admin', 'categoryNavPage', 'list'));
            }
        }
    }

    /**
     * 解除页面与分类的关联
     */
    public function actionRelease() {
        $cat_id = _g('cat_id');
        $page_id = _g('page_id');
        if ($cat_id && $page_id) {
            $cat = $this->catLogic->getOneById($cat_id);
            if (strpos($cat['nav_page_id'], $page_id) !== false) {
                $arr_page = explode(',', $cat['nav_page_id']);
                unset($arr_page[array_search($page_id, $arr_page)]);
                $str_nav_page = implode(',', $arr_page);
            } else {
                $str_nav_page = $cat['nav_page_id'];
            }
            $cat_data = array(
                'nav_page_id' => $str_nav_page
            );
            $result = $this->catLogic->save($cat_data, $cat_id);
            if (!_g('current')) {
                $cond = "path_id like '" . $cat['path_id'] . "%'";
                $map = Zhtx::createDataMap();
                $map->addEntry('nav_page_id', $str_nav_page, DB::VARCHAR);
                $result = $this->catLogic->update($map, $cond);
            }
            if ($result) {
                $this->success("解除成功", Common::adminURL('admin', 'categoryNavPage', 'editrel', array('cid' => $cat_id)));
            } else {
                $this->error("解除失败", Common::adminURL('admin', 'categoryNavPage', 'editrel', array('cid' => $cat_id)));
            }
        } else {
            $this->showMessage("页面参数有误", Common::adminURL('admin', 'categoryNavPage', 'editrel', array('cid' => $cat_id)));
        }
    }

    public function actionAdd() {

        if (_p()) {

            $base_site_id = Common::validSiteConfig();

            $catName = _p('base_name');

            $goods_type_id = _p('goods_type_id');

            $parentId = Common::queryInt(_p('parent_id'));

            $base_name = $catName[$base_site_id];

            if (!$base_name) {

                return $this->showMessage('name_not_empty');
            }

            if (!$goods_type_id) {

                return $this->showMessage('please_select_goods_type');
            }

            $cond = 'base_name = "' . $base_name . '" AND parent_id=' . $parentId;

            $cat = $this->catLogic->getCount($cond);

            if ($cat) {

                return $this->showMessage('name_already_exists');
            }

            $cat_data = array(
                'base_name' => Common::strEscape($base_name),
                'parent_id' => $parentId,
                'goods_type_id' => $goods_type_id,
                'page_url' => _p('page_url'),
                'sort_weight' => Common::queryInt(_p('sort_weight')),
                'listorder' => Common::queryInt(_p('listorder')),
                'create_time' => SYS_TIME,
                'special_css_class' => _p('special_css_color') ? _p('special_css_color') . '' : '',
            );

            $res = $this->catLogic->save($cat_data);

            if ($res) {

                //多语言处理              

                $details = _p('detail');

                $seo_title = _p('title');

                $seo_keywords = _p('keywords');

                $seo_descript = _p('descript');

                $list_template = _p('list_template');

                $goods_template = _p('goods_template');

                $cat_image = _p('image');

                foreach ($catName as $key => $value) {

                    $detail = isset($details[$key]) ? $details[$key] : '';

                    $lang_data = array(
                        'base_name' => Common::strEscape($value),
                        'goods_category_id' => $res,
                        'language_id' => $key,
                        'list_template' => isset($list_template[$key]) ? $list_template[$key] : '',
                        'goods_template' => isset($goods_template[$key]) ? $goods_template[$key] : '',
                        'detail' => Common::strEscape($detail, FALSE),
                        'image' => isset($cat_image[$key]) ? Common::strEscape($cat_image[$key]) : '',
                        'title' => isset($seo_title[$key]) ? $seo_title[$key] : '',
                        'keywords' => isset($seo_keywords[$key]) ? $seo_keywords[$key] : '',
                        'descript' => isset($seo_descript[$key]) ? $seo_descript[$key] : '',
                        'status' => Common::queryInt(_p('is_display-' . $key)),
                    );



                    $this->goodsCatLangLogic->save($lang_data);

                    //更新缓存

                    $this->catLogic->updateListCache($key);
                }

                $path_id = $res . ',';

                if ($parentId) {

                    $path_id = $parentId . ',' . $path_id;

                    while ($parentId) {

                        $cat = $this->catLogic->getOne('id=' . $parentId);

                        if ($cat['parent_id']) {

                            $path_id = $cat['parent_id'] . ',' . $path_id;
                        }

                        $parentId = $cat['parent_id'];
                    }
                }



                $new_cat_map = Zhtx::createDataMap();

                $new_cat_map->addEntry('path_id', $path_id, DB::VARCHAR);

                $diy_url_flag = TRUE;

                if (_p('page_url')) {

                    $diyUrlLogic = $this->load('urlAlisa');

                    $true_url = Common::frontURL('home', 'product', 'list', array('category_id' => $res), FALSE);

                    $diy_res = $diyUrlLogic->createDiyUrl(_p('page_url'), $true_url, true);

                    if ($diy_res) {

                        $new_cat_map->addEntry('page_url', Common::strEscape(_p('page_url')), DB::VARCHAR);
                    } else {

                        $diy_url_flag = FALSE;
                    }
                }



                $result = $this->catLogic->update($new_cat_map, 'id=' . $res);

                if ($result) {

                    $this->catLogic->updateCache($path_id);
                }

                return $diy_url_flag ? $this->success('add_success', Common::adminURL('product', 'category', 'list')) : $this->showMessage('url_already_exists');
            }

            return $this->showMessage('add_failure');
        } else {

            $themes = $this->load('theme')->findAll('', true);

            $tplConf = Common::getTplConf();

            $parentId = _g('pid') ? intval(_g('pid')) : 0;

            $categorys = $this->catLogic->getList();

            $parents = array();

            $goods_type_id = 0;

            foreach (Common::getTree($categorys['list']) as $item) {

                if ($item['id'] == $parentId) {

                    $goods_type_id = $item['goods_type_id'];
                }

                $parents[$item['id']] = str_repeat('　', $item['level']) . $item['base_name'];
            }

            $languages = $this->languageLogic->findAll('status=1');

            $typeLogic = $this->load('goodsType');

            $types = $typeLogic->getList('status=1 order by listorder asc');

            $template = array();

            foreach ($languages as $key => $value) {

                $template[$value['id']] = $tplConf[$themes[$value['theme_id']]['theme_dir']];
            }

            Core::$tpl->set('parentid', $parentId);

            Core::$tpl->set('goods_type_id', $goods_type_id);

            Core::$tpl->set('cats', $parents);

            core::$tpl->set('languages', $languages);

            core::$tpl->set('types', $types['list']);

            core::$tpl->set('template', $template);

            Core::$htmlFile = 'category/form';

            Core::$isdisplay = 0;

            Core::$tpl->render(Core::$htmlFile . ".htm");
        }
    }



    public function actionPublicGetList() {

        $categorys = $this->catLogic->findAll();

        $parents = array();

        foreach (Common::getTree($categorys) as $item) {

            $parents[$item['id']] = str_repeat('　', $item['level']) . $item['base_name'];
        }

        echo json_encode($parents);
    }

    public function actionPublicGetCategoryTree($arr_category, $id) {

        $path_id = split(',', $arr_category[$id]["path_id"]);

        unset($path_id[count($path_id) - 1]);

        $path_id_level = substr_count($arr_category[$id]["path_id"], ",");

        $new_category = array();

        foreach ($arr_category as $key => $value) {

            $level = substr_count($arr_category[$key]["path_id"], ",");

            $value["level"] = $level;

            $cur_path_id = $arr_category[$key]["path_id"];

            if ($value["parent_id"] != 0)
                $value[$value["parent_id"]]["has_son"] = 1;

            if ($level >= 2 && $id != 0 && $level <= $path_id_level + 1) {

                $path_now = join(',', array_slice($path_id, 0, $level - 1)) . ",";

                if (strpos($cur_path_id, $path_now) === 0) {

                    //print($cur_path_id." " . $path_now."\n");

                    $new_category[$value["parent_id"]]["straight_root"] = "yes";

                    $new_category[$key] = $value;
                }
            } else if ($level < 2 && $id != 0) {

                if ($path_id[0] == $value["id"])
                    $value["straight_root"] = "yes";

                $new_category[$key] = $value;
            }

            else if ($id == 0 && $level < 2) {

                $new_category[$key] = $value;
            }
        }

        return $new_category;
    }

    public function actionPublicAjax() {

        $categorys = $this->catLogic->getList('parent_id=0 order by listorder asc');

        Core::$tpl->set('list', $categorys['list']);
    }

    public function actionPublicAjaxcategory() {

        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);

        $fun = _g("fun");

        $id = _g("id");

        $mid = _g("mid");

        $expt_id = Common::queryInt(_g('expt_id'));

        $html = "<div style=\"width:180px\"><div class=\"bwSelect\">";

        $html .= "<input type=\"text\" class=\"bwSelectText\" readonly=\"readonly\" value=\"" . $lang["top_category"] . "\" />";

        $html .= "<input type=\"hidden\" class=\"bwSelectValue\" value=\"0\" />";

        $html .= "<ul class=\"bwSelectOption\" >";

        $html .= "<li data=\"0\" onclick=\"getGoodsCategorySon" . $mid . "(this,$id,0,'$fun')\">" . $lang["top_category"] . "</li>";



        $categorys = $this->catLogic->getList("parent_id=$id and id<>$expt_id order by listorder desc");

        if (!$categorys["list"]) {

            echo "";

            die();
        }

        foreach ($categorys["list"] as $key => $value) {

            $html .= "<li data=\"0\" onclick=\"getGoodsCategorySon" . $mid . "(this," . $value["id"] . ",1,'$fun')\"> " . $value["base_name"] . "</li>";
        }

        $html .= "</ul>";

        $html .= "</div></div>";

        echo $html;
    }

   


 

    /**

     * 修改排序

     * ajax 

     */
    public function actionPublicEditSort() {

        $id = Common::queryInt(_p('id'));

        if (!$id) {

            echo 0;

            return;
        }

        $listorder = Common::queryInt(_p('listorder'));

        $sort_weight = Common::queryInt(_p('sort_weight'));

        $map = Zhtx::createDataMap();

        if ($listorder) {

            $map->addEntry('listorder', $listorder, DB::INT);
        }

        if ($sort_weight) {

            $map->addEntry('sort_weight', $sort_weight, DB::INT);
        }

        $res = $this->catLogic->update($map, 'id=' . $id);

        if ($res) {

            foreach ($this->languageLogic->findAll('status=1') as $value) {

                $this->catLogic->updateListCache($value['id']);
            }
        }

        echo $res ? 1 : 0;
    }

  

}

?>