<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Config
 *
 * @author xrx <www.35zh.com>
 */
class ConfigController extends AppController {

    private $conf_file;
    private $langLogic;
    private $currencyLogic;
    private $mailSenderLogic;
    private $countryLogic;

    public function __construct() {
        parent::__construct();
        $this->conf_file = APP_ROOT . 'conf/deploy.conf.php';
        $this->langLogic = $this->load('language');
        $this->currencyLogic = $this->load('currency');
        $this->mailSenderLogic = $this->load('mailSender');
        $this->countryLogic = $this->load('country');
    }


    public function actionSet() {
        if (_p()) {
            $string = '<?php ' . "\n";
            foreach (_p() as $key => $cfg_val) {
                if (strpos($key, "sites-") !== false) {
                    $arr_key = explode('-', $key);
                    //$tmp[$arr_key[1]][$arr_key[2]] = $cfg_val;
                    $string .= '$cfg[\'sites\'][' . $arr_key[1] . ']' . "['" . $arr_key[2] . "']=" . '"' . str_replace("\"", "\\\"", $cfg_val) . '"' . ";\n";
                }
            }
            $string .= '?>';
            @file_put_contents($this->conf_file, $string);
            return $this->success('edit_success', Common::adminURL('admin', 'config', 'set'));
        } else {
            global $cfg;
            $currencys = $this->currencyLogic->findAll('status=1');
            $languageJoinCountryLogic = $this->load('languageJoinCountry');
            $languages = $languageJoinCountryLogic->getList('l.status=1');
            $fonts = array();
            $fp = opendir('./upload/font/');
            while ($file = readdir($fp)) {
                if ($file != '.' && $file != '..' && $file != '.svn') {
                    if (!is_dir('./upload/font/' . $file)) {
                        $fonts[] = $file;
                    }
                }
            }
            closedir($fp);
            $all_languages = $languageJoinCountryLogic->getList();
            $navPage = $this->load('navPage');
            $navData = $navPage->findAll(' order by base_name asc');
            Core::$tpl->set('navData', $navData);
            Core::$tpl->set('all_languages', $all_languages["list"]);
            Core::$tpl->set('languages', $languages["list"]);
            Core::$tpl->set('sites', $cfg['sites']);
            Core::$tpl->set('fonts', $fonts);
            Core::$tpl->set('currencys', $currencys);
            Core::$htmlFile = 'config/newform';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    public function actionSmtpCheck() {
        global $cfg;
        $id = trim($_GET['id']);
        $admin_email = trim($_GET['email']);
        if ($id && $admin_email) {
            $this->mailSenderLogic = $this->load('mailSender');
            $this->mailSenderLogic->init($id);
            $title = '[' . $_SERVER['HTTP_HOST'] . ']' . "后台邮件设置成功！！ [Random number:" . SYS_TIME . "]";
            $sent_content = "这是一封后台邮箱设置的测试邮件，如果收到，说明邮箱设置成功。";
            $result = $this->mailSenderLogic->sendTo($admin_email, $title, $sent_content);
            if (!$result) {
                //return $this->showMessage('邮箱设置失败. ['..']', Common::adminURL('admin', 'config', 'set'));
            	echo '<strong>失败原因'.$this->mailSenderLogic->responseMsg().'</strong>';
			} else {
                return $this->success('邮箱设置成功', Common::adminURL('admin', 'config', 'set'));
            }
        }
    }

    public function actionLimitCountrys() {
        global $cfg;
        $has_checked_country = $cfg['sites'][0]['authorize_visit_countrys'];
        if(_g('country_str')){
            $has_checked_country = _g('country_str');
        }
        $has_checked_country_arr = explode(',', $has_checked_country);
        foreach ($has_checked_country_arr as $key => $value) {
          $has_checked_country_arr[$value]  =$value;
        }
        $all_country = $this->countryLogic->findAll("", false, "", array("base_name", 'country_code_2'));
        $countrys = array();
        foreach ($all_country as $data) {
            $firstchr = substr(ucfirst($data['base_name']), 0, 1);
            $firstord = ord($firstchr);
            if (($firstord >= 97 && $firstord <= 122) || ($firstord >= 65 && $firstord <= 90) || ($firstord >= 48 && $firstord <= 57)) {
                $countrys[$firstchr][] = $data;
            }
        }
        ksort($countrys);
        Core::$tpl->set("has_checked_country_arr", $has_checked_country_arr);
        Core::$tpl->set("countrys", $countrys);
    }

}

?>