<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Country
 *
 * @author xrx
 */
class CountryController extends AppController
{

    private $countryLogic;
    private $countryStateLogic;

    public function __construct()
    {
        parent::__construct();
        $this->countryLogic = $this->load('country');
        $this->countryStateLogic = $this->load('countryState');
    }

    public function actionList()
    {
        //分页用的参数
        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);
        //分页
        $where = '1=1';
        if (_g('base_name'))
        {
            $where .= " and base_name like '%" . _g('base_name') . "%'";
        }
        $where .= " ORDER BY listorder DESC,id DESC";
        $count = $this->countryLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);

        $countrys = $this->countryLogic->getCurrentDatas($where, $page_size, $curr_page);

        Core::$tpl->set("countrys", $countrys);
        Core::$tpl->set("pages", $page_data);
    }

    public function actionAdd()
    {
        if (_p())
        {
            $country_map = Zhtx::createDataMap();
            $country_map->addEntry('base_name', Common::strEscape(_p('base_name')), DB::VARCHAR);
            $country_map->addEntry('country_code_2', Common::strEscape(_p('country_code_2')), DB::VARCHAR);
            $country_map->addEntry('country_code_3', Common::strEscape(_p('country_code_3')), DB::VARCHAR);
            $country_map->addEntry('chinese_name', Common::strEscape(_p('chinese_name')), DB::VARCHAR);
            $country_map->addEntry('tel_area_code', Common::strEscape(_p('tel_area_code')), DB::VARCHAR);
            $country_map->addEntry('listorder', Common::queryInt(_p('listorder')), DB::INT);
            $country_map->addEntry('status', Common::queryInt(_p('status')), DB::INT);
            $res = $this->countryLogic->insert($country_map);
            if ($res){
                if(!_p('listorder')){
                    $map = Zhtx::createDataMap(); 
                    $map->addEntry('listorder', 10*$res, DB::INT);
                    $this->countryLogic->update($map, 'id='.$res);
                }
                return $this->success('add_success', Common::adminURL('admin', 'country', 'list'));
            }else
                return $this->error('add_failure', Common::adminURL('admin', 'country', 'list'));
        }
        else
        {
            Core::$htmlFile = 'country/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    public function actionEdit()
    {
        if (_p())
        {
            $id = Common::queryInt(_p('id'));
            $country_map = Zhtx::createDataMap();
            $country_map->addEntry('base_name', Common::strEscape(_p('base_name')), DB::VARCHAR);
            $country_map->addEntry('country_code_2', Common::strEscape(_p('country_code_2')), DB::VARCHAR);
            $country_map->addEntry('country_code_3', Common::strEscape(_p('country_code_3')), DB::VARCHAR);
            $country_map->addEntry('chinese_name', Common::strEscape(_p('chinese_name')), DB::VARCHAR);
            $country_map->addEntry('tel_area_code', Common::strEscape(_p('tel_area_code')), DB::VARCHAR);
            $country_map->addEntry('listorder', Common::queryInt(_p('listorder')), DB::INT);
            $country_map->addEntry('status', Common::queryInt(_p('status')), DB::INT);
            $res = $this->countryLogic->updateById($country_map, $id);
            if ($res)
                return $this->success('edit_success', Common::adminURL('admin', 'country', 'list'));
            else
                return $this->error('edit_failure', Common::adminURL('admin', 'country', 'list'));
        }
        else
        {
            $id = Common::queryInt(_g('id'));
            $country = $this->countryLogic->getOne('id=' . $id);
            if (!$country)
            {
                return $this->error('id_error', Common::adminURL('admin', 'country', 'list'));
            }
            Core::$tpl->set('country', $country);
            Core::$htmlFile = 'country/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    /**
     * 删除
     */
    public function actionDel()
    {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        $relationLogic = $this->load('ShippingAreaCountryRel');
        if (!empty($ids))
        {
            $num = 0;
            foreach ($ids as $id)
            {

                $res = $this->countryLogic->delete('id=' . $id);
                if ($res)
                {
                    $relationLogic->delete('country_id=' . $id);
                    $num++;
                }
            }
            $staus = 1;
            $flag = $lang['success_delete'] . $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

    public function actionPublicEditStatus()
    {
        $id = Common::queryInt(_g('id'));
        $status = _g('currentStatus') ? 1 : 0;
        $map = Zhtx::createDataMap();
        $map->addEntry('status', $status, DB::INT);
        $res = $this->countryLogic->updateById($map, $id);
        echo $res ? 1 : 0;
    }

    public function actionPublicQuickEdit()
    {
        $id = Common::queryInt(_p('id'));
        if (!$id)
        {
            echo 0;
            return;
        }
        if (!is_numeric(_p('listorder')))
        {
            echo 0;
            return;
        }
        $listorder = Common::queryInt(_p('listorder'));
        $map = Zhtx::createDataMap();
        if ($listorder)
            $map->addEntry('listorder', $listorder, DB::INT);
        $res = $this->countryLogic->update($map, 'id=' . $id);
        $this->countryLogic->delCache();
        echo $res ? 1 : 0;
    }

    public function actionListState()
    {
        //分页用的参数
        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);
        $country_id = Common::queryInt(_g('country_id'), 1);
        //分页
        $where = '1=1';
        $where .= ' and country_id=' . $country_id;
        if (_g('base_name'))
        {
            $where .= " and base_name like '%" . _g('base_name') . "%'";
        }
        $where .= " ORDER BY listorder DESC,id DESC";
        $count = $this->countryStateLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);

        $states = $this->countryStateLogic->getCurrentDatas($where, $page_size, $curr_page);
        $country = $this->countryLogic->getOne('id=' . $country_id);

        Core::$tpl->set("country", $country);
        Core::$tpl->set("states", $states);
        Core::$tpl->set("pages", $page_data);
    }

    public function actionAddState()
    {
        if (_p())
        {
            $state_map = Zhtx::createDataMap();
            $state_map->addEntry('base_name', Common::strEscape(_p('base_name')), DB::VARCHAR);
            $state_map->addEntry('state_code_2', Common::strEscape(_p('state_code_2')), DB::VARCHAR);
            $state_map->addEntry('state_code_3', Common::strEscape(_p('state_code_3')), DB::VARCHAR);
            $state_map->addEntry('chinese_name', Common::strEscape(_p('chinese_name')), DB::VARCHAR);
            $state_map->addEntry('listorder', Common::queryInt(_p('listorder')), DB::INT);
            $state_map->addEntry('status', Common::queryInt(_p('status')), DB::INT);
            $state_map->addEntry('country_id', Common::queryInt(_p('country_id'),1), DB::INT);
            $res = $this->countryStateLogic->insert($state_map);
            if ($res)
                return $this->success('add_success', Common::adminURL('admin', 'country', 'listState',array('country_id'=>_p('country_id'))));
            else
                return $this->error('add_failure', Common::adminURL('admin', 'country', 'listState',array('country_id'=>_p('country_id'))));
        }
        else
        {
            $country_id = Common::queryInt(_g('country_id'),1);
            $country = $this->countryLogic->getOne('id=' . $country_id);
            Core::$tpl->set("country", $country);
            Core::$htmlFile = 'country/formstate';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    public function actionEditState()
    {
        if (_p())
        {
            $id = Common::queryInt(_p('id'));
            $state_map = Zhtx::createDataMap();
            $state_map->addEntry('base_name', Common::strEscape(_p('base_name')), DB::VARCHAR);
            $state_map->addEntry('state_code_2', Common::strEscape(_p('state_code_2')), DB::VARCHAR);
            $state_map->addEntry('state_code_3', Common::strEscape(_p('state_code_3')), DB::VARCHAR);
            $state_map->addEntry('chinese_name', Common::strEscape(_p('chinese_name')), DB::VARCHAR);
            $state_map->addEntry('listorder', Common::queryInt(_p('listorder')), DB::INT);
            $state_map->addEntry('status', Common::queryInt(_p('status')), DB::INT);
            $res = $this->countryStateLogic->updateById($state_map, $id);
            if ($res)
                return $this->success('add_success', Common::adminURL('admin', 'country', 'listState',array('country_id'=>_p('country_id'))));
            else
                return $this->error('add_failure', Common::adminURL('admin', 'country', 'listState',array('country_id'=>_p('country_id'))));
        }
        else
        {
            $id = Common::queryInt(_g('id'));
            $state = $this->countryStateLogic->getOne('id=' . $id);
            if (!$state)
            {
                return $this->error('id_error', Common::adminURL('admin', 'country', 'list'));
            }
            $country = $this->countryLogic->getOne('id=' . $state['country_id']);
            Core::$tpl->set('country', $country);
            Core::$tpl->set('state', $state);
            Core::$htmlFile = 'country/formstate';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    /**
     * 删除
     */
    public function actionDelState()
    {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if (!empty($ids))
        {
            $num = 0;
            foreach ($ids as $id)
            {
                $res = $this->countryStateLogic->delete('id=' . $id);
                if ($res)
                {
                    $num++;
                }
            }
            $staus = 1;
            $flag = $lang['success_delete'] . $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

    public function actionEditStateStatus()
    {
        $id = Common::queryInt(_g('id'));
        $status = _g('currentStatus') ? 1 : 0;
        $map = Zhtx::createDataMap();
        $map->addEntry('status', $status, DB::INT);
        $res = $this->countryStateLogic->updateById($map, $id);
        echo $res ? 1 : 0;
    }

    public function actionStateQuickEdit()
    {
        $id = Common::queryInt(_p('id'));
        if (!$id)
        {
            echo 0;
            return;
        }
        if (!is_numeric(_p('listorder')))
        {
            echo 0;
            return;
        }
        $listorder = Common::queryInt(_p('listorder'));
        $map = Zhtx::createDataMap();
        if ($listorder)
            $map->addEntry('listorder', $listorder, DB::INT);
        $res = $this->countryStateLogic->update($map, 'id=' . $id);
        $this->countryStateLogic->delCache();
        echo $res ? 1 : 0;
    }
}

?>