<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Currency
 *
 * @author xrx
 */
class CurrencyController extends AppController
{
    private $currencyLogic;
    private $countryLogic;
    public function __construct()
    {
        parent::__construct();
        $this->currencyLogic = $this->load('currency');
        $this->countryLogic  = $this->load('country');
    }
    public function actionList()
    {
        $where = '';
        if (_p('search_value') && _p('search_cond'))
        {
            $where .= _p('search_cond') . " = '" . _p('search_value') . "' ";
        }
		$where .= " ORDER BY listorder desc,id DESC";
        //获取数据
        $res = $this->currencyLogic->getList($where);
       
        Core::$tpl->set('res', $res['list']);
        
    }
    public function actionAdd()
    {
        if($_POST)
        {
            $name = $_POST['base_name'];
			$currency_map = Zhtx::createDataMap();
			$currency_map->addEntry('base_name', Common::strEscape($name), DB::VARCHAR);
			$currency_map->addEntry('symbol_left', Common::strEscape(_p('symbol_left')), DB::VARCHAR);
			$currency_map->addEntry('symbol_right', Common::strEscape(_p('symbol_right')), DB::VARCHAR);
			$currency_map->addEntry('exchange_rate', _p('exchange_rate'), DB::DECIMAL);
			$currency_map->addEntry('decimal_num', _p('decimal_num'), DB::INT);
			$currency_map->addEntry('standard_code', Common::strEscape(_p('standard_code')), DB::VARCHAR);
			$currency_map->addEntry('country_code', Common::strEscape(_p('country_code')), DB::VARCHAR);
			$currency_map->addEntry('status', Common::queryInt(_p('status')), DB::INT);
			$currency_map->addEntry('listorder', Common::queryInt(_p('listorder')), DB::INT);
			$currency_map->addEntry('create_time', SYS_TIME, DB::INT);
			$res = $this->currencyLogic->insert($currency_map);
			if($res)
			{
                            if(!_p('listorder')){
                                $map = Zhtx::createDataMap(); 
                                $map->addEntry('listorder', 10*$res, DB::INT);
                                $this->currencyLogic->update($map, 'id='.$res);  
                            }
                            _crearCahce('currency');//清理缓存
                            return $this->success('add_success', Common::adminURL('admin', 'currency', 'list'));
			}
			else
			{
				return $this->error('add_failure', Common::adminURL('admin', 'currency', 'list'));
			}
            
        }
        else
        {
            $cols = array('base_name','country_code_2');
            $countrys = $this->countryLogic->getCols('', $cols);
            Core::$tpl->set('countrys', $countrys);
            Core::$htmlFile  = 'currency/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }
    public function actionEdit()
    {
        if($_POST)
        {
            $id   = Common::queryInt(_p('id'));
            $name = $_POST['base_name'];
			$currency_map = Zhtx::createDataMap();
			$currency_map->addEntry('base_name', Common::strEscape($name), DB::VARCHAR);
			$currency_map->addEntry('symbol_left', Common::strEscape($_POST['symbol_left']), DB::VARCHAR);
			$currency_map->addEntry('symbol_right', Common::strEscape($_POST['symbol_right']), DB::VARCHAR);
			$currency_map->addEntry('exchange_rate', $_POST['exchange_rate'], DB::DECIMAL);
			$currency_map->addEntry('decimal_num', $_POST['decimal_num'], DB::INT);
			$currency_map->addEntry('standard_code', Common::strEscape($_POST['standard_code']), DB::VARCHAR);
			$currency_map->addEntry('country_code', Common::strEscape(trim($_POST['country_code'])), DB::VARCHAR);
			$currency_map->addEntry('status', Common::queryInt(_p('status')), DB::INT);
			$currency_map->addEntry('listorder', Common::queryInt(_p('listorder')), DB::INT);
			$currency_map->addEntry('create_time', SYS_TIME, DB::INT);
			$res = $this->currencyLogic->update($currency_map, 'id='.$id);
			if($res)
			{
                            _setSession('decimal_num', '');
                _crearCahce('currency');//清理缓存
				return $this->success('edit_success', Common::adminURL('admin', 'currency', 'list'));
			}
			else
			{
				return $this->error('edit_failure', Common::adminURL('admin', 'currency', 'list'));
			}
        }
        else
        {
             $id = Common::queryInt(_g('id'));
             $cond = 'id = ' . $id;
             $currency = $this->currencyLogic->getOne($cond);
             if(!$currency)
             {
                 return $this->error('id_error', Common::adminURL('admin', 'currency', 'list'));
             }
             $cols = array('base_name','country_code_2');
             $countrys = $this->countryLogic->getCols('1=1', $cols);          
             Core::$tpl->set('currency', $currency);
             Core::$tpl->set('countrys', $countrys);
             Core::$htmlFile  = 'currency/form';
             Core::$isdisplay = 0;
             Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }
     /**
      * public
     * ajax 更新状态
     */
    public function actionPublicEditStatus()
    {
        $id     = Common::queryInt(_g('id'));        
        $status = _g('currentStatus');
        $map    = Zhtx::createDataMap();
        $map->addEntry('status', $status, DB::INT);
        $res   =  $this->currencyLogic->updateById($map, $id);
        _crearCahce('currency');//清理缓存
        echo $res ? 1 : 0;
    }
    public function actionPublicValidName()
    {
        $name = _p('base_name');
        $id   = Common::queryInt(_g('id'));
        $cond = "base_name ='" . $name . "'";
        if($id)
        {
            $cond .= " and id !=" . $id;
        }
        $count = $this->currencyLogic->getCount($cond);
        echo $count > 0 ? TRUE : FALSE;
    }
    /**
     * 注意基准站点的货币不可以删除 
     */
    public function actionDel()
    {      
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        $base_sites    = Common::validSiteConfig();
        $languageLogic = $this->load('language');
        $language      =  $languageLogic->getOneById($base_sites);
        if(!empty($ids))
        {
          $num = 0;$sid = 0;
          foreach ($ids as $id)
          {
            if($id == $language['currency_id'])
            {
              $sid = $id;
            }
            else
            {
              $res  = $this->currencyLogic->delete('id=' . $id);
              if($res)
              {             
                $num++;
              }
            }
          
          }
          $staus = 1;
          $flag = $lang['success_delete']. $num . $lang['num_records'];
          if($sid)
          {
            $flag .= ' ' .$lang['id']. '[' . $sid . ']' . $lang['base_currency_not_delete'];
          }
        }
        _crearCahce('currency');//清理缓存
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }
	
	public function actionPublicQuickEdit()
    {
      $id        = Common::queryInt(_p('id'));
	  $map = Zhtx::createDataMap();
      if(!$id)
      {
        echo 0;return;
      }
	  
	  if(_p('listorder'))
	  {
		  if(!is_numeric(_p('listorder')))
		  {
				echo 0;return;  
		  }
		  $map->addEntry('listorder', Common::queryInt(_p('listorder')), DB::INT);
	  }
	  
      if(_p('exchange_rate'))
	  {
		  if(!is_numeric(_p('exchange_rate')))
		  {
				echo 0;return;  
		  }
		  $map->addEntry('exchange_rate', _p('exchange_rate'), DB::DECIMAL);
	  }	  
      $res = $this->currencyLogic->update($map, 'id=' . $id);
      _crearCahce('currency');//清理缓存
      echo $res ? 1 : 0;
    }
}

?>
