<?php

/**
 * Description of shipping
 *
 * @author HHH
 */
class DeliveryController extends AppController {

    private $shippingLogic;
    private $shippingLanguageLogic;
    private $languageJoinCountryLogic;
    private $shippingCorpLogic;
    private $shippingAreaLogic;

    /**
     * 初始化程序
     */
    public function __construct() {
        parent::__construct();
        $this->orderDeliveryLogic = $this->load('orderDelivery');
        $this->orderLogic = $this->load('order');
    }

    /**
     * 列表
     */
    public function actionList() {
        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);
        $where = '1=1';
        //高级搜索 start
        $deliverno = _g('itemno');
        if ($deliverno) {
            $where = "itemno='" . $deliverno . "'";
            $order = $this->orderLogic->getOne($where);
            if ($order) {
                $where = "(delivery_no like '%" . $deliverno . "%' or order_id='" . $order['id'] . "')";
            } else {
                $where = "delivery_no like '%" . $deliverno . "%'";
            }
        }
        if (_g('country_id')) {
            $where .= ' and country_id=' . _g('country_id');
        }
        if (_g('companyid')) {
            $where .= ' and shipping_corp_id=' . _g('companyid');
        }
        if (_g('interface') or _g('interface')=='0') {
            if (_g('interface')==4) {
            $where .= ' and delivery_status!=2';
            }else{
            $where .= ' and delivery_status=' . _g('interface');
            }
        }
        
        $curTime = SYS_TIME;
        $curTimeLess7day = $curTime - 604800;
        $curTimeLess15day = $curTime - 1296000;
        $curTimeLess30day = $curTime - 2592000;
        $curTimeLess60day = $curTime - 5184000;
        $curTimeLess90day = $curTime - 7776000;
        if (_g('receipt') or _g('receipt')=='0') {
            if (_g('receipt') == "0") {       
                $where .= ' and create_time>' . $curTimeLess7day;
            }
            if (_g('receipt') == 1) {
                $where .= ' and create_time>' . $curTimeLess15day.' and create_time<'.$curTimeLess7day;
            }
            if (_g('receipt') == 2) {
                $where .= ' and create_time>' . $curTimeLess30day.' and create_time<'.$curTimeLess15day;
            }
            if (_g('receipt') == 3) {  
                $where .= ' and create_time>' . $curTimeLess60day.' and create_time<'.$curTimeLess30day;
            }
            if (_g('receipt') == 4) { 
                $where .= ' and create_time>' . $curTimeLess90day.' and create_time<'.$curTimeLess60day;
            }
             if (_g('receipt') == 5) { 
                $where .= ' and create_time<' . $curTimeLess90day;
            }
        }

        //高级搜索end
        $where .= ' ORDER BY id DESC';
        //分页
        $count = $this->orderDeliveryLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size, $prev, $next);
        $res = $this->orderDeliveryLogic->getCurrentDatas($where, $page_size, $curr_page);
        foreach ($res as $key => $value) {
            $obj = json_decode($value["delivery_data"], true);
            $last_content = $obj["data"][count($obj["data"]) - 1]["context"];
            $res[$key]["last_content"] = $last_content;
        }

        $order_ids = array();
        foreach ($res as $item) {
            $order_ids[] = $item['order_id'];
        }
        $cols = array('*');
        if($order_ids){
        $order_cond = 'id in (' . implode(',', $order_ids) . ')';
        $order_res = $this->load('order')->getCols($order_cond, $cols);
        $order = array();
        foreach ($order_res as $value) {
            $order[$value['id']] = $value;
        }
        }
        $shippingCorp = $this->load('shippingCorp')->findAll("1=1", true);
        Core::$tpl->set("shippingCorp", $shippingCorp);
        $country = $this->load('country')->findAll("1=1", true);
        $delivery_status = array(0 => "初始化", 1 => "配送中", 2 => "客户签收", 3 => "配送异常",4=>"客户未签收");
        $delivery_time = array(0 => "发货7天内", 1 => "发货7-15天", 2 => "发货15-30天", 3 => "发货30-60天", 4 => "发货60-90天", 5 => "超过90天");
        Core::$tpl->set("delivery_status", $delivery_status);
        Core::$tpl->set("delivery_time", $delivery_time);
        Core::$tpl->set("country", $country);
        Core::$tpl->set("res", $res);
        Core::$tpl->set("order", $order);
        Core::$tpl->set("pages", $page_data);
    }

    public function actionDetail() {

        if (_g('id')) {
            //获得基本信息
            $id = _g('id');
            $where = 'id = ' . $id;
            //获多语言
        } else {
            return $this->showMessage('illegal_operation', Common::adminURL('admin', 'shipping', 'list'));
        }
    }

}

?>
