<?php

/**
 * Description of DiyUrlController
 *
 * @author czy
 */
class DiyUrlController extends AppController {

    private $iplistLogic;
	private $languageLogic;
    public function __construct() {
        parent::__construct();
        $this->diyurlLogic = $this->load('diyUrl'); //引入iplistLogic.php，返回实例化对象
    }

    public function actionList() 
	{
		$cond = 'admin_id='. Common::queryInt($_SESSION["admin_id"]) .' ORDER BY listorder DESC';
        $res = $this->diyurlLogic->getList($cond);
		Core::$tpl->set("diyurl", $res['list']);
        Core::$tpl->set("pages", $page_data);
		
    }

    public function actionAdd() 
	{
        if (_p()) 
		{

			$map = Zhtx::createDataMap();
			$map->addEntry('admin_id', Common::queryInt($_SESSION["admin_id"]), DB::VARCHAR);
			$map->addEntry('name',Common::strEscape( _p('name')), DB::VARCHAR);
			$map->addEntry('url', Common::strEscape(_p('url')), DB::VARCHAR);
			$map->addEntry('target', Common::queryInt(_p('target'),0), DB::INT);
			$map->addEntry('listorder', Common::queryInt(_p('listorder'),0), DB::INT);
			$map->addEntry('create_time', SYS_TIME, DB::INT);
            $res = $this->diyurlLogic->insert($map);
            if($res)
			{
                                if(!_p('listorder')){
                                    $map = Zhtx::createDataMap(); 
                                    $map->addEntry('listorder', 10*$res, DB::INT);
                                    $this->diyurlLogic->update($map, 'id='.$res);
                                }
				return $this->success('add_success', Common::adminURL('admin', 'diyurl', 'list'));
			}
			else
			{
				return $this->error('add_failure', Common::adminURL('admin', 'diyurl', 'list'));
			}
        } 
		else 
		{
		  
        }
    }

    public function actionEdit() {
        if (_p()) 
		{
            $id = Common::queryInt(_p('id'),0) ;
            $map = Zhtx::createDataMap();
            //$map->addEntry('admin_id', $_SESSION["id"], DB::VARCHAR);
			$map->addEntry('name', Common::strEscape(_p('name')), DB::VARCHAR);
			$map->addEntry('url', Common::strEscape(_p('url')), DB::VARCHAR);
			$map->addEntry('target', Common::queryInt(_p('target'),0), DB::INT);
			$map->addEntry('listorder', Common::queryInt(_p('listorder'),0), DB::INT);
			$map->addEntry('create_time', SYS_TIME, DB::INT);
            $res = $this->diyurlLogic->update($map, 'id =' . $id);
            if($res)
			{
				return $this->success('edit_success', Common::adminURL('admin', 'diyurl', 'list'));
			}
			else
			{
				return $this->error('edit_failure', Common::adminURL('admin', 'diyurl', 'list'));
			}
        } 
		else 
		{
            $id = Common::queryInt(_g('id'),0) ;
            $diyurl = $this->diyurlLogic->getOne('id=' . $id, $cols);
            if (!$diyurl) 
			{
                return $this->error('id_error', Common::adminURL('admin', 'diyurl', 'list'));
            }
			
            Core::$tpl->set('diyurl', $diyurl);
        }
    }
	
    public function actionDel() 
	{
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if(!empty($ids))
        {
          $num = 0;
          foreach ($ids as $id)
          {
            $res  = $this->diyurlLogic->delete('id=' . $id);
            if($res)
            {             
              $num++;
            }
          }
          $staus = 1;
          $flag = $lang['success_delete']. $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }
	
	public function actionPublicQuickEdit()
    {
      $id        = Common::queryInt(_p('id'));
      if(!$id)
      {
        echo 0;return;
      }
	  if(!is_numeric(_p('listorder')))
      {
			echo 0;return;  
	  }
	  $listorder   = Common::queryInt(_p('listorder'));
      $map = Zhtx::createDataMap();
      if($listorder)
      	$map->addEntry('listorder', $listorder, DB::INT);
      $res = $this->diyurlLogic->update($map, 'id=' . $id);
      echo $res ? 1 : 0;
    }
}

?>
