<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Domain
 *
 * @author xrx
 */
class DomainController extends AppController
{
    private $domainLogic;
    private $langLogic;
    public function __construct() {
        parent::__construct();
        $this->domainLogic = $this->load('domain');
        $this->langLogic = $this->load('language');
    }
    public function actionList()
    {
        $domains = $this->domainLogic->getList('1=1');
        $languageIds = array();
        foreach ($domains['list'] as $domain)
        {
            $languageIds[] = $domain['language_id'];
        }
        $lang_cond = 'id in ('. implode(',', $languageIds) . ')';
        $languages = $this->langLogic->getList($lang_cond);
        $lang_arr = array();
        foreach ($languages['list'] as $value)
        { 
            $lang_arr[$value['id']] = $value['base_name'];
        }
        $res = array();
        foreach ($domains['list'] as $item)
        {
            if(isset($lang_arr[$item['language_id']]))
            {
                               
                $item['language_id'] = $lang_arr[$item['language_id']];
            }
            $res[] = $item;
        }
        Core::$tpl->set('res', $res);
    }
    public function actionAdd()
    {
        if($_POST)
        {
            $name = $_POST['name'];
            if(!$name)
            {
                return $this->showMessage('name_not_empty');
            }
            $cond = 'base_name = "'.$name.'"';
            $domain = $this->domainLogic->getOne($cond);
            if(!$domain)
            {
                $language_id = intval($_POST['language_id']);
                $domain_map = Zhtx::createDataMap();
                $domain_map->addEntry('name', $name, DB::VARCHAR);               
                $domain_map->addEntry('language_id', $language_id, DB::INT);
                $domain_map->addEntry('theme_id', _p('theme_id'), DB::INT);
                $domain_map->addEntry('status', 1, DB::INT);               
                $res = $this->domainLogic->insert($domain_map);
                if($res)
                {
                    $language_map = Zhtx::createDataMap();
                    $language_map->addEntry('domain_name', $name, DB::VARCHAR);
                    $lastres = $this->langLogic->update($language_map, 'id='.$language_id);
                    return $lastres ? $this->showMessage('success', Common::adminURL('admin', 'domain', 'list')) : $this->showMessage('failure');
                }
                
            }
            else
            {
                return $this->showMessage('lang_existed');
            }
        }
        else
        {
            $cols = array('id','base_name');
            $languages = $this->langLogic->getCols('1=1',$cols);          
            Core::$tpl->set('langs', $languages);
        }
    }
    public function actionEdit()
    {
        if($_POST)
        {
            $id = $_POST['id'] ? intval($_POST['id']) : 0;
            $name = $_POST['name'];
            if(!$name)
            {
                return $this->showMessage('name_not_empty');
            }
            $cond = 'id != '.$id .' AND base_name = "'.$name.'"';
            $domain = $this->domainLogic->getOne($cond);
            if(!$domain)
            {
                $language_id = intval($_POST['language_id']);
                $domain_map = Zhtx::createDataMap();
                $domain_map->addEntry('name', $name, DB::VARCHAR);               
                $domain_map->addEntry('language_id', $language_id, DB::INT);
                $domain_map->addEntry('theme_id', _p('theme_id'), DB::INT);
                $domain_map->addEntry('status', $_POST['status'], DB::INT);               
                $res = $this->domainLogic->update($domain_map, 'id='.$id);
                if($res)
                {
                    $language_map = Zhtx::createDataMap();
                    $language_map->addEntry('domain_name', $name, DB::VARCHAR);
                    $lastres = $this->langLogic->update($language_map, 'id='.$language_id);
                    return $lastres ? $this->showMessage('success', Common::adminURL('admin', 'domain', 'list')) : $this->showMessage('failure');
                }
                
            }
            else
            {
                return $this->showMessage('lang_existed');
            }
        }
        else
        {
            $id = $_GET['id'] ? intval($_GET['id']) : 0;
            $domain = $this->domainLogic->getOne('id='.$id);
            if(!$domain){
                return $this->showMessage('not_found_record');
            }
            $cols = array('id','base_name');
            $languages = $this->langLogic->getCols('1=1',$cols);
            Core::$tpl->set('domain', $domain);
            Core::$tpl->set('langs', $languages);
        }
    }
    
}

?>