<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Event
 *
 * @author xrx <QQ:1251679791 www.35zh.com>
 */
class EventController extends AppController
{
   private $eventLogic;
   private $eventCondLogic;
   private $eventCouponLogic;
   private $taskLogic;
   public function __construct()
   {
     parent::__construct();
     $this->eventLogic       = $this->load('event');
     $this->eventCondLogic   = $this->load('eventCond');
     $this->eventCouponLogic = $this->load('eventCoupon');
     $this->taskLogic        = $this->load('taskStage');
   }
   /**
    * 新增一个事件
    * @return type 
    */
   public function actionAdd()
   {
     if(_p())
     {
       $task_id = Common::queryInt(_p('task_id'));
       if(!$task_id)
       {
         return $this->showMessage('pease_select_task');
       }
       $codeno = _p('codeno');
       if(!$codeno)
       {
         return $this->showMessage('codeno_not_empty');
       }
       $count = $this->eventLogic->getCount('codeno ="' . $codeno . '"');
       if($count > 0)
       {
         return $this->showMessage('codeno_existed');
       }
       $is_order_cond = Common::queryInt(_p('is_order_cond'));
       $is_coupon     = Common::queryInt(_p('is_coupon'));
       $data = array(
           'task_id' => $task_id,
           'codeno'  => $codeno,
           'base_name'     => _p('base_name'),
           'is_order_cond' => $is_order_cond,
           'is_coupon'    => _p('is_coupon'),
           'create_time'  => SYS_TIME,
           'start_time'   => _p('start_time')? strtotime(_p('start_time')) : 0,
           'end_time'     => _p('end_time')? strtotime(_p('end_time')) : 0,
           'trigger_type' => _p('trigger_type'),
           'trigger_time' => SYS_TIME + _p('trigger_time')*60*60,
           'email_tpl_id' => Common::queryInt(_p('email_tpl_id')),
           'msg_tpl_id'   => Common::queryInt(_p('msg_tpl_id')),
           'sms_tpl_id'   => Common::queryInt(_p('sms_tpl_id')),
           'status'       => Common::queryInt(_p('status')),
       );
       $event_res = $this->eventLogic->save($data);       
       if($event_res)
       {
         if($is_order_cond)
         {
            $event_cond_data = array();
            $event_cond_type = _p('event_cond_type');
            switch ($event_cond_type)
            {
                case 1:
                  $event_cond_data = array(
                      'amount'  => _p('amount'),
                      'compare' => _p('compare'),     
                  );
                  break;
                case 2:
                    $event_cond_data = array(
                      'start_time' => _p('order_start_time')? strtotime(_p('order_start_time')) : 0,
                      'end_time'   => _p('order_end_time')? strtotime(_p('order_end_time')) : 0,     
                    );
                    break;
                  case 3:
                    $event_cond_data = array(
                      'start_time' => _p('pay_start_time')? strtotime(_p('pay_start_time')) : 0,
                      'end_time'   => _p('pay_end_time')? strtotime(_p('pay_end_time')) : 0,     
                    );
                    break;
                  case 4:
                    $event_cond_data = array(
                      'start_time' => _p('cart_start_time')? strtotime(_p('cart_start_time')) : 0,
                      'end_time'   => _p('cart_end_time')? strtotime(_p('cart_end_time')) : 0,     
                    );
                    break;
                default:break;
            }
            $event_cond_data['event_id']        = $event_res;
            $event_cond_data['event_cond_type'] = $event_cond_type;
            $this->eventCondLogic->save($event_cond_data);
         }
         if($is_coupon)
         {
           $event_coupon_data = array(
               'event_id'  => $event_res,
               'offer_id' => _p('offer_id'),
               'coupon_num' => Common::queryInt(_p('coupon_num'),1),
           );
           $this->eventCouponLogic->save($event_coupon_data);
         }
         return $this->success('save_success', Common::adminURL('admin', 'event', 'list'));
       }
       return $this->showMessage('save_failure');
     }
     else
     { 
        $offerLogic  = $this->load('offer');
        $tplLogic    = $this->load('mailTpl');
        $offer_cond  = 'offer_type=2' . ' and status=1 and start_time <' . SYS_TIME . ' and end_time >' . SYS_TIME;
        $offers   = $offerLogic->findAll($offer_cond, TRUE);         
        $emails   = $tplLogic->findAll();
        Core::$tpl->set('stages', $this->taskLogic->findAll('task_id =1 order by listorder desc'));
        Core::$tpl->set('offers', $offers);
        Core::$tpl->set('email_tpl', $emails);
        Core::$htmlFile  = 'event/form';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
     }    
   }
   /**
    * 编辑事件
    * @return type 
    */
   public function  actionEdit()
   {
     if(_p())
     {
       $event_id = Common::queryInt(_p('id'));
       $task_id  = Common::queryInt(_p('task_id'));
       if(!$task_id)
       {
         return $this->showMessage('pease_select_task');
       }
       $event = $this->eventLogic->getOneById($event_id); 
       if(!$event)
       {
         return $this->showMessage('illegal_parameters');
       }
        $codeno = _p('codeno');
       if(!$codeno)
       {
         return $this->showMessage('codeno_not_empty');
       }
       $count = $this->eventLogic->getCount('codeno ="' . $codeno . '" and id !=' . $event_id);
       if($count > 0)
       {
         return $this->showMessage('codeno_existed');
       }
       $is_order_cond = Common::queryInt(_p('is_order_cond'));
       $is_coupon     = Common::queryInt(_p('is_coupon'));
       $data = array(
           'task_id' => $task_id,
           'codeno'  => $codeno,
           'base_name' => Common::strEscape(_p('base_name')),
           'is_order_cond' => $is_order_cond,
           'is_coupon'    => _p('is_coupon'),
           'start_time'   => _p('start_time')? strtotime(_p('start_time')) : 0,
           'end_time'     => _p('end_time')? strtotime(_p('end_time')) : 0,
           'trigger_type' => _p('trigger_type'),
           'trigger_time' => SYS_TIME + _p('trigger_time')*60*60,
           'email_tpl_id' => Common::queryInt(_p('email_tpl_id')),
           'msg_tpl_id'   => Common::queryInt(_p('msg_tpl_id')),
           'sms_tpl_id'   => Common::queryInt(_p('sms_tpl_id')),
           'status'       => Common::queryInt(_p('status')),
       );       
       $event_res = $this->eventLogic->save($data, $event_id);       
       if($event_res)
       {
         $event_cond   = NULL;
         $event_coupon = NULL;
         if($event['is_order_cond'] == 1)
         {
           $event_cond = $this->eventCondLogic->getOne('event_id='.$event_id);
         }
         if($event['is_coupon'] == 1)
         {
           $event_coupon = $this->eventCouponLogic->getOne('event_id='.$event_id);
         }
         if($is_order_cond)
         {
            $event_cond_data = array();
            $event_cond_type = _p('event_cond_type');
             switch ($event_cond_type)
            {
                case 1:
                  $event_cond_data = array(
                      'amount'  => _p('amount'),
                      'compare' => _p('compare'),     
                  );
                  break;
                case 2:
                    $event_cond_data = array(
                      'start_time' => _p('order_start_time')? strtotime(_p('order_start_time')) : 0,
                      'end_time'   => _p('order_end_time')? strtotime(_p('order_end_time')) : 0,     
                    );
                    break;
                  case 3:
                    $event_cond_data = array(
                      'start_time' => _p('pay_start_time')? strtotime(_p('pay_start_time')) : 0,
                      'end_time'   => _p('pay_end_time')? strtotime(_p('pay_end_time')) : 0,     
                    );
                    break;
                  case 4:
                    $event_cond_data = array(
                      'start_time' => _p('cart_start_time')? strtotime(_p('cart_start_time')) : 0,
                      'end_time'   => _p('cart_end_time')? strtotime(_p('cart_end_time')) : 0,     
                    );
                    break;
                default:break;
            }
            $event_cond_data['event_id']        = $event_id;
            $event_cond_data['event_cond_type'] = $event_cond_type;
            $this->eventCondLogic->save($event_cond_data, $event_cond ? $event_cond['id'] : 0);
         }
         else if($event_cond)
         {
           $this->eventCondLogic->delete('id='. $event_cond['id']);
         }
         if($is_coupon)
         {
           $event_coupon_data = array(
               'event_id'  => $event_id,
               'offer_id' => _p('offer_id'),
               'coupon_num' => Common::queryInt(_p('coupon_num'),1),
           );
           $this->eventCouponLogic->save($event_coupon_data, $event_coupon ? $event_coupon['id'] : 0);
         }
         else if($event_coupon)
         {
           $this->eventCouponLogic->delete('id=' . $event_coupon['id']);
         }
         return $this->success('save_success', Common::adminURL('admin', 'event', 'list'));
       }
       return $this->showMessage('save_failure');
     }
     else
     {
        $event_id = Common::queryInt(_g('id'));
        $event = $this->eventLogic->getOneById($event_id);
        if(!$event)
        {
          return $this->showMessage('not_found_record');
        }
        $event_cond   = $this->eventCondLogic->getOne('event_id=' . $event_id);
        $event_coupon = $this->eventCouponLogic->getOne('event_id=' . $event_id);
        $offerLogic  = $this->load('offer');
        $tplLogic    = $this->load('mailTpl');
        $offer_cond  = 'offer_type=2' . ' and status=1 and start_time <' . SYS_TIME . ' and end_time >' . SYS_TIME;
        $offers = $offerLogic->findAll($offer_cond, TRUE);         
        $emails   = $tplLogic->findAll('', TRUE);
        Core::$tpl->set('event', $event);
        Core::$tpl->set('event_cond', $event_cond);
        Core::$tpl->set('event_coupon', $event_coupon);
        Core::$tpl->set('offers', $offers);
        Core::$tpl->set('email_tpl', $emails);
        Core::$tpl->set('stages', $this->taskLogic->findAll('task_id=1 order by listorder desc'));
        Core::$htmlFile  = 'event/form';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
     }     
   }
   /**
    * 查询事件 
    */
   public function actionList()
   {
     $events    = $this->eventLogic->findAll( ' 1 order by id');
     $event_ids = array();
     foreach ($events as $value)
     {
       if($value['is_coupon'])
       {
         $event_ids[] = $value['id'];
       }       
     }
      $coupons = array();
     if(!empty($event_ids))
     {        
        $eventJoinOfferLogic = $this->load('eventCouponJoinOffer');
        $cond    = 'e.event_id in (' . implode(',', $event_ids) . ')';
        $offers  = $eventJoinOfferLogic->findAll($cond);
        foreach ($offers as $item)
        {
          $coupons[$item['event_id']] = $item;
        }
     }
     Core::$tpl->set('type', _g('type'));
     Core::$tpl->set('res', $events);
     Core::$tpl->set('offers', $coupons);
     Core::$tpl->set('email_tpl', $this->load('mailTpl')->findAll('', TRUE));
   }
   /**
    * 获取有用的优惠券
    *  ajax
    */
   public function actionUsefulOffer()
   {
     $offerLogic  = $this->load('offer');
     $offer_cond  = 'offer_type=2' . ' and status=1 and start_time <' . SYS_TIME . ' and end_time >' . SYS_TIME;
     $offers = $offerLogic->findAll($offer_cond, TRUE);     
     if($offers && !empty($offers))
     {
       $result= array('status' => 1, 'offers' => $offers);
     }
     else
     {
       $result= array('status' => 0, 'msg' => 'No coupon');
     }
     echo json_encode($result);
   }
   /**
    * 读取邮件模板 
    */
   public function actionEmailTpl()
   {
     $tplLogic = $this->load('mailTpl');
     $emails   = $tplLogic->findAll();
     echo json_encode($emails);
   }
   /**
     * ajax 更新状态
     */
    public function actionPublicEditStatus()
    {
        $id     = Common::queryInt(_g('id'));
        $status = _g('currentStatus');
        $map    = Zhtx::createDataMap();
        $map->addEntry('status', $status, DB::INT);
        $res    = $this->eventLogic->updateById($map, $id);
        echo $res ? 1 : 0;
    }
}

?>
