<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of FriendlinkController
 *
 * @author cx
 */
class FriendlinkController extends AppController
{
    private $friendlinkLogic;
    private $languageLogic;
    public function __construct()
    {
        parent::__construct();
        $this->friendlinkLogic = $this->load('friendlink');
        $this->languageLogic  = $this->load('language');
    }
    public function actionList()
    {
        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'),1);
		$where = '1=1';
        if(_g('base_name'))
        {
            $where .= " and base_name like '%" . _g('base_name') . "%'";
        }
		$where .= " ORDER BY listorder DESC,id DESC";
        $res = $this->friendlinkLogic->getCurrentDatas($where, $page_size, $curr_page);
        $count = $this->friendlinkLogic->getCount($where);
        $page_list = Common::getPages($count, $curr_page, $page_size);
        Core::$tpl->set('res', $res);
        Core::$tpl->set('pages', $page_list);
		
        $languageLogic = $this->load('language');
        $languages = $languageLogic->findAll('', true);
        foreach ($languages as $key => $value) {
            $lang[$value['id']] = $value['base_name'];
        }
        Core::$tpl->set('languages', $lang);
    }
    public function actionAdd()
    {
        if(_p())
        {
            $base_name = $_POST['base_name'];
            $href = str_replace(array('?', '&', '%'), '-', _p('href'));
			$friend_link_map = Zhtx::createDataMap();
			$friend_link_map->addEntry('base_name', Common::strEscape($base_name), DB::VARCHAR);
			$friend_link_map->addEntry('create_time', SYS_TIME, DB::INT);
			$friend_link_map->addEntry('image', Common::strEscape(_p('image')), DB::VARCHAR);
			$friend_link_map->addEntry('href', Common::strEscape($href), DB::VARCHAR);
			$friend_link_map->addEntry('language_id', Common::queryInt(_p('language_id'),0), DB::INT);
			$friend_link_map->addEntry('type', Common::queryInt(_p('type'),0), DB::INT);
			$friend_link_map->addEntry('status', Common::queryInt(_p('status'),0), DB::INT);
			$friend_link_map->addEntry('listorder', Common::queryInt(_p('listorder'),0), DB::INT);
			$res = $this->friendlinkLogic->insert($friend_link_map);
			if($res)
			{
                            if(!_p('listorder')){
                                $map = Zhtx::createDataMap(); 
                                $map->addEntry('listorder', 10*$res, DB::INT);
                                $this->friendlinkLogic->update($map, 'id='.$res);
                            }
				return $this->success('add_success', Common::adminURL('admin', 'friendlink', 'list'));
			}
			else
			{
				return $this->error('add_failure', Common::adminURL('admin', 'friendlink', 'list'));
			}  
        }
        else
        {
            $languageLogic = $this->load('language');
            $languages = $languageLogic->findAll('', true);
            Core::$tpl->set('languages', $languages);
        }
    }
    public function actionEdit()
    {
        if(_p())
        {
            $id = Common::queryInt(_p('id'),0) ;
            $href = str_replace(array('?', '&', '%'), '-', _p('href'));
            $friendlink_map = Zhtx::createDataMap();
            $friendlink_map->addEntry('base_name', Common::strEscape(_p('base_name')), DB::VARCHAR);
            $friendlink_map->addEntry('create_time', SYS_TIME, DB::INT);
			$friendlink_map->addEntry('image', Common::strEscape(_p('image')), DB::VARCHAR);
			$friendlink_map->addEntry('href', Common::strEscape($href), DB::VARCHAR);
			$friendlink_map->addEntry('language_id', Common::queryInt(_p('language_id')), DB::INT);
			$friendlink_map->addEntry('type', Common::queryInt(_p('type')), DB::INT);
			$friendlink_map->addEntry('status', Common::queryInt(_p('status')), DB::INT);
			$friendlink_map->addEntry('listorder', Common::queryInt(_p('listorder')), DB::INT);
			$res = $this->friendlinkLogic->update($friendlink_map, 'id='.$id);
			if($res)
			{
				return $this->success('edit_success', Common::adminURL('admin', 'friendlink', 'list'));
			}
			else
			{
				return $this->error('edit_failure', Common::adminURL('admin', 'friendlink', 'list'));
			}  
		}
		else
        {
            $id = Common::queryInt(_g('id'),0) ;
            $where = 'id = ' . $id;
            $friendlink = $this->friendlinkLogic->getOne($where);
            if(!$friendlink)
            {
            	return $this->error('id_error', Common::adminURL('admin', 'friendlink', 'list'));
            }
            Core::$tpl->set('friendlink', $friendlink);
            $cols = array('id','base_name');
            $languages = $this->languageLogic->getCols('1=1', $cols);
            Core::$tpl->set('languages', $languages);
        }
        
    }
    /**
     * 删除数据 
     */
    public function actionDel()
    {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if(!empty($ids))
        {
          $num = 0;
          foreach ($ids as $id)
          {
           
                $res  = $this->friendlinkLogic->delete('id=' . $id);
                if($res)
                {    
                  $num++;
                }
          }
          $staus = 1;
          $flag = $lang['success_delete']. $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }  
   public function actionPublicEditSort()
    {
      $id        = Common::queryInt(_p('id'));
      if(!$id)
      {
        echo 0;return;
      }
	  if(!is_numeric(_p('listorder')))
      {
			echo 0;return;  
	  }
      $map = Zhtx::createDataMap();
      $map->addEntry('listorder', Common::queryInt(_p('listorder')), DB::INT);
      $res = $this->friendlinkLogic->update($map, 'id=' . $id);
      echo $res ? 1 : 0;
    } 
	
	public function actionPublicEditStatus()
    {
        $id     = Common::queryInt(_g('id'));
        $status = _g('currentStatus') ? 1 : 0;
        $map    = Zhtx::createDataMap();
        $map->addEntry('status', $status, DB::INT);
        $res   =  $this->friendlinkLogic->updateById($map, $id);
        echo $res ? 1 : 0;
    }
}
?>
