<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Growth
 * 会员成长值管理
 * @author xrx <QQ:1251679791 www.35zh.com>
 */
class GrowthController extends AppController {

    private $growthEventLogic;
    private $growth_type;

    public function __construct() {
        parent::__construct();
        $this->growthEventLogic = $this->load('growthEvent');
        $this->growth_type = array(
            1 => 'new_user_sent_growth',
//        2 => 'frist_add_cart_sent_growth',
            3 => 'frist_pay_order_sent_growth',
            4 => 'recommend_user_sent_growth',
            5 => 'promise_pay_order_sent_growth',
//        6 => 'continue_days_not_login_reduce',
//        7 => 'continue_orders_not_pay_reduce',
//        8 => 'return_or_rejection_reduce',
//        9 => 'exchange_goods_reduce',
            10 => 'goods_comment_sent_growth',
            11 => 'recommend_user_first_pay_sent',
            12 => 'daily_login_sent_growth',
        );
    }

    public function actionAdd() {
        if (_p()) {
            $condeno = _p('codeno');
            $count = $this->growthEventLogic->getCount('codeno=' . $condeno);
            if ($count > 0) {
                return $this->showMessage('codeno_existed');
            }
            $type = Common::queryInt(_p('type'));
            $growth = Common::queryInt(_p('growth'));
            $data = array(
                'base_name' => _p('base_name'),
                'type' => $type,
                'codeno' => $condeno,
                'growth' => $growth,
                'status' => Common::queryInt(_p('status')),
                'is_notice' => Common::queryInt(_p('is_notice')),
                'user_group_id' => Common::queryInt(_p('user_group_id')),
                'email_tpl_id' => Common::queryInt(_p('email_tpl_id')),
                'msg_tpl_id' => Common::queryInt(_p('msg_tpl_id')),
                'sms_tpl_id' => Common::queryInt(_p('sms_tpl_id')),
                'start_time' => strtotime(_p('start_time')),
                'end_time' => strtotime(_p('end_time')),
                'create_time' => SYS_TIME,
            );
            if ($type == 6 || $type == 7) {
                $data['cond_value'] = Common::queryInt(_p('cond_value'));
            }
            $res = $this->growthEventLogic->save($data);
            return $res ? $this->success('add_success') : $this->showMessage('add_failure');
        } else {
            $tplLogic = $this->load('mailTpl');
            $groupLogic = $this->load('userGroup');
            $emails = $tplLogic->findAll();
            $groups = $groupLogic->findAll();
            Core::$tpl->set('growth_type', $this->growth_type);
            Core::$tpl->set('email_tpl', $emails);
            Core::$tpl->set('user_groups', $groups);
            Core::$htmlFile = 'growth/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }
    /**
     * ajax 更新状态
     */
    public function actionPublicEditStatus()
    {
        $id     = Common::queryInt(_g('id'));
        $status = _g('currentStatus');
        $map    = Zhtx::createDataMap();
        $map->addEntry('status', $status, DB::INT);
        $res    = $this->load('growthEvent')->updateById($map, $id);
        echo $res ? 1 : 0;
    }
    public function actionEdit() {
        if (_p()) {
            $growth_id = Common::queryInt(_p('id'));
            $condeno = _p('codeno');
            $count = $this->growthEventLogic->getCount('id !=' . $growth_id . ' and codeno="' . $condeno . '"');
            if ($count > 0) {
                return $this->showMessage('codeno_existed');
            }
            $type = Common::queryInt(_p('type'));
            $growth = Common::queryInt(_p('growth'));
            $growth_type = Common::queryInt(_p('growth_type'));
            $formula_value = Common::queryInt(_p('formula_value'));
            $data = array(
                'base_name' => _p('base_name'),
                'type' => $type,
                'codeno' => $condeno,
                'growth' => $growth,
                'status' => Common::queryInt(_p('status')),
                'is_notice' => Common::queryInt(_p('is_notice')),
                'user_group_id' => Common::queryInt(_p('user_group_id')),
                'email_tpl_id' => Common::queryInt(_p('email_tpl_id')),
                'msg_tpl_id' => Common::queryInt(_p('msg_tpl_id')),
                'sms_tpl_id' => Common::queryInt(_p('sms_tpl_id')),
                'start_time' => strtotime(_p('start_time')),
                'end_time' => strtotime(_p('end_time')),
                'growth_type' => $growth_type,
                'formula_value' => $formula_value,
            );
            if ($type == 6 || $type == 7) {
                $data['cond_value'] = Common::queryInt(_p('cond_value'));
            }
            $res = $this->growthEventLogic->save($data, $growth_id);
            return $res ? $this->success('add_success') : $this->showMessage('add_failure');
        } else {
            $growth_id = Common::queryInt(_g('id'));
            $growth = $this->growthEventLogic->getOneById($growth_id);
            if (!$growth) {
                return $this->showMessage('illegal_parameters');
            }
            $tplLogic = $this->load('mailTpl');
            $groupLogic = $this->load('userGroup');
            $emails = $tplLogic->findAll();
            $groups = $groupLogic->findAll();
            Core::$tpl->set('growth', $growth);
            Core::$tpl->set('growth_type', $this->growth_type);
            Core::$tpl->set('email_tpl', $emails);
            Core::$tpl->set('user_groups', $groups);
            Core::$htmlFile = 'growth/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    /**
     * 成长值事件列表
     */
    public function actionList() {
        $events = $this->growthEventLogic->findAll();
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $type = array();
        foreach ($this->growth_type as $key => $value) {
            $type[$key] = $lang[$value];
        }
        Core::$tpl->set('res', $events);
        Core::$tpl->set('type', $type);
    }

    /**
     * 删除成长值
     * @return type
     */
    public function actionDel() {
        $growth_id = Common::queryInt(_g('id'));
        $growthDetailLogic = $this->load('growthDetail');
        $detail = $growthDetailLogic->getOneById($growth_id);
        if (!$detail) {
            return $this->showMessage('illegal_operation');
        }
        if ($growthDetailLogic->delete('id=' . $growth_id)) {
            if ($detail['growth']) {
                $userLogic = $this->load('user');
                $user = $userLogic->getOneById($detail['user_id']);
                if ($user) {
                    $growth_value = $detail['growth'];
                    $this->load('userGroup')->updateUserGroupId($user, $detail['growth'], FALSE);
                }
            }
            $this->success('delete_success');
        }
        $this->success('delete_failure');
    }

    public function actionHowtoclean() {

    }

    public function actionCleanAll() {
        $link = mysql_connect(DB_HOST, DB_USER, DB_PSW);
        mysql_select_db(DB_NAME);
        //清除成长值
        $growthLogic = $this->load('growthDetail');
        $userLogic = $this->load("user");

        $sql = "select *,sum(growth) as sum from z_growth_detail where growth>0 group by user_id";
        $GrowData = $growthLogic->query($sql);
        foreach ($GrowData as $value) {
            $Dsql = "select sum(growth) as sum from z_growth_detail where user_id=" . $value['user_id'] . " group by user_id";
            $Dsum = $growthLogic->query($Dsql);
            if ($Dsum[0]['sum'] <= 0) {
                continue;
            }
            $map = array(
                'user_id' => $value['user_id'],
                'growth' => -1 * $Dsum[0]['sum'],
                'language_id' => $value['language_id'],
                'country_id' => $value['country_id'],
                'domain' => $value['domain'],
                'ip' => $value['ip'],
                'order_id' => $value['order_id'],
                'remark' => $value['remark'],
                'create_time' => $value['create_time']
            );
            $Grows = $growthLogic->save($map);
            //$growths = $growthLogic->getOne("user_id=" . $value['user_id'], $cols = array("sum(growth)"));
            $userLogic->save(array('user_group_id' => 6, 'growth' => 0), $value['user_id']);
            if (!$Grows) {
                return;
            }
        }
        echo '清除成长值-OK<br>';
        mysql_close();
    }

}

?>
