<?php

/**
 * Description of IplistController
 *
 * @author czy
 */
class IplistController extends AppController {

    private $iplistLogic;
	private $languageLogic;
    public function __construct() {
        parent::__construct();
        $this->iplistLogic = $this->load('iplist'); //引入iplistLogic.php，返回实例化对象
     	$this->languageLogic  = $this->load('language');
    }

    public function actionList() {
		
		$page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);
		$where = '';
		if(_g('ip'))
        {
            $ip = sprintf('%u',Common::_ip2long(_g('ip')));
			$where .= " $ip between start_ip and end_ip";
        }
        //分页
        $count            = $this->iplistLogic->getCount();      
        $page_data        = Common::getPages($count, $curr_page, $page_size);
        
        $iplist  = $this->iplistLogic->getCurrentDatas($where, $page_size, $curr_page);
        foreach($iplist as $key => $value)
		{
			$iplist[$key]["start_ip"] = long2ip( $iplist[$key]["start_ip"] );
			$iplist[$key]["end_ip"] = long2ip( $iplist[$key]["end_ip"] );
		}
		Core::$tpl->set("iplist", $iplist);
        Core::$tpl->set("pages", $page_data);
		
		$cols = array('id','base_name');
		$languages = $this->languageLogic->findALL('', true);
		Core::$tpl->set('languages', $languages);
    }

    public function actionAdd() {
        if (_p()) {
            $start_ip = _p('start_ip');
            $end_ip = _p('end_ip');
            //验证为空
            if (!$start_ip) {
                return $this->showMessage('start_ip_not_empty');
            } else if (!$end_ip) {
                return $this->showMessage('end_ip_not_empty');
            }
            //验证类型
            if (!Common::_checkip($start_ip)) {
                return $this->showMessage('start_ip_not_righttype');
            } else if (!Common::_checkip($end_ip)) {
                return $this->showMessage('end_ip_not_righttype');
            }
            //转换IP为整型
            $start_ip = sprintf('%u',Common::_ip2long($start_ip));
            $end_ip = sprintf('%u',Common::_ip2long($end_ip));
            //插入动作

			$country_map = Zhtx::createDataMap();
			$country_map->addEntry('start_ip', $start_ip, DB::INT);
			$country_map->addEntry('end_ip', $end_ip, DB::INT);
			$country_map->addEntry('status', _p('status'), DB::TINYINT);
			$country_map->addEntry('descript', Common::strEscape(_p('descript')), DB::VARCHAR);
			$country_map->addEntry('create_time', SYS_TIME, DB::INT);
			$country_map->addEntry('language_id', Common::queryInt(_p('language_id')), DB::INT);
            $res = $this->iplistLogic->insert($country_map);
            if($res)
			{
				return $this->success('add_success', Common::adminURL('admin', 'iplist', 'list'));
			}
			else
			{
				return $this->error('add_failure', Common::adminURL('admin', 'iplist', 'list'));
			}
        } 
		else 
		{
		  	$cols = array('id','base_name');
			$languages = $this->languageLogic->getCols('1=1', $cols);
			Core::$tpl->set('languages', $languages);
		  
        }
    }

    public function actionEdit() {
        if (_p()) 
		{
            $id = Common::queryInt(_p('id'),0) ;
            $start_ip = _p('start_ip');
            $end_ip = _p('end_ip');
            //验证为空
            if (!$start_ip) {
                return $this->showMessage('start_ip_not_empty');
            } else if (!$end_ip) {
                return $this->showMessage('end_ip_not_empty');
            }
            //验证类型
            if (!Common::_checkip($start_ip)) {
                return $this->showMessage('start_ip_not_righttype');
            } else if (!Common::_checkip($end_ip)) {
                return $this->showMessage('end_ip_not_righttype');
            }
            //插入动作
            //转换IP为整型
            $start_ip = Common::_ip2long($start_ip);
            $end_ip = Common::_ip2long($end_ip);

            $country_map = Zhtx::createDataMap();
            $country_map->addEntry('start_ip', $start_ip, DB::INT);
            $country_map->addEntry('end_ip', $end_ip, DB::INT);
            $country_map->addEntry('status', _p('status'), DB::TINYINT);
            $country_map->addEntry('descript', Common::strEscape(_p('descript')), DB::VARCHAR);
            $country_map->addEntry('create_time', SYS_TIME, DB::INT);
           	$country_map->addEntry('language_id', Common::queryInt(_p('language_id')), DB::INT);
            $res = $this->iplistLogic->update($country_map, 'id =' . $id);
            if($res)
			{
				return $this->success('edit_success', Common::adminURL('admin', 'iplist', 'list'));
			}
			else
			{
				return $this->error('edit_failure', Common::adminURL('admin', 'iplist', 'list'));
			}
        } 
		else 
		{
            $id = Common::queryInt(_g('id'),0) ;
            $cols = array("id", "INET_NTOA(start_ip) as start_ip", "INET_NTOA(end_ip) as end_ip", "status", "descript", "create_time", "language_id");
            $ip = $this->iplistLogic->getCols('id=' . $id, $cols);
            if (!$ip) 
			{
                return $this->error('id_error', Common::adminURL('admin', 'iplist', 'list'));
            }
			$cols = array('id','base_name');
			$languages = $this->languageLogic->getCols('1=1', $cols);
			Core::$tpl->set('languages', $languages);
			
            Core::$tpl->set('ip', $ip);
        }
    }

	public function actionPublicEditStatus()
    {
        $id     = Common::queryInt(_g('id'));
        $status = _g('currentStatus') ? 1 : 0;
        $map    = Zhtx::createDataMap();
        $map->addEntry('status', $status, DB::INT);
        $res   =  $this->iplistLogic->updateById($map, $id);
        echo $res ? 1 : 0;
    }

    public function actionDel() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if(!empty($ids))
        {
          $num = 0;
          foreach ($ids as $id)
          {
            $res  = $this->iplistLogic->delete('id=' . $id);
            if($res)
            {             
              $num++;
            }
          }
          $staus = 1;
          $flag = $lang['success_delete']. $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

}

?>
