<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Payment
 *
 * @author huangjp@35zh.cn
 */
class KeywordsurlController extends AppController {

    private $keywordsurlLogic;
    private $languageLogic;

    public function __construct() {
        parent::__construct();
        $this->keywordsurlLogic = $this->load("keywordsurl");
        $this->languageLogic = $this->load("language");
    }

    public function actionList() {
        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);
        $where = '1=1';
        if (_g('base_name')) {
            $where .= " and base_name like '%" . _g('base_name') . "%'";
        }
        $where .= " ORDER BY id DESC";
        //获取数据
        $res = $this->keywordsurlLogic->getCurrentDatas($where, $page_size, $curr_page);
        //分页
        $count = $this->keywordsurlLogic->getCount($where);
        $page_list = Common::getPages($count, $curr_page, $page_size);
        Core::$tpl->set('res', $res);
        Core::$tpl->set('pages', $page_list);
        $cols = array('id', 'base_name');
        $languages = $this->languageLogic->getCols('1=1', $cols, TRUE);
        Core::$tpl->set('languages', $languages);
    }

    public function actionAdd() {
        if (_p()) {
            $name = trim(Common::strEscape(_p("base_name")));
            if (!$name) {
                return $this->showMessage('keywordsurl_not_empty');
            }
            $data = array(
                'base_name' => $name,
                'query_name' => Common::strEscape(_p("query_name")),
                'type' => Common::queryInt(_p("type")),
                'status' => Common::queryInt(_p("status")),
                'language_id' => Common::queryInt(_p("language_id")),
                'create_time' => SYS_TIME
            );
            $res = $this->keywordsurlLogic->save($data);
            return $res ? $this->success('add_success', Common::adminURL('admin', 'keywordsurl', 'list')) : $this->error('add_failure');
        } else {
            $cols = array('id', 'base_name');
            $languages = $this->languageLogic->getCols('1=1', $cols, TRUE);
            Core::$tpl->set('languages', $languages);
            Core::$htmlFile = 'keywordsurl/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    public function actionEdit() {
        if (_p()) {
            $id = Common::queryInt(_p('id'));
            $name =trim( Common::strEscape(_p("base_name")) );
            if (!$name) {
                return $this->showMessage('keywordsurl_not_empty');
            }
            $data = array(
                'base_name' => $name,
                'query_name' => Common::strEscape(_p("query_name")),
                'type' => Common::queryInt(_p("type")),
                'status' => Common::queryInt(_p("status")),
                'language_id' => Common::queryInt(_p("language_id"))
            );
            $res = $this->keywordsurlLogic->save($data, $id);
            return $res ? $this->success('edit_success', Common::adminURL('admin', 'keywordsurl', 'list')) : $this->error('edit_failure');
        } else {
            $id = Common::queryInt(_g('id'));
            $cond = 'id = ' . $id;
            $keywordsurl = $this->keywordsurlLogic->getOne($cond);
            if (!$keywordsurl) {
                return $this->success('id_error', Common::adminURL('admin', 'keywordsurl', 'list'));
            }
            $cols = array('id', 'base_name');
            $languages = $this->languageLogic->getCols('1=1', $cols, TRUE);
            Core::$tpl->set('languages', $languages);
            Core::$tpl->set('keywordsurl', $keywordsurl);
            Core::$htmlFile = 'keywordsurl/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    public function actionPublicEditStatus() {
        $id = Common::queryInt(_g('id'));
        $status = _g('currentStatus') ? 1 : 0;
        $data = array();
        $data['status'] = $status;
        $res = $this->keywordsurlLogic->save($data, $id);
        echo $res ? 1 : 0;
    }

    public function actionPublicEditSort() {
        $id = Common::queryInt(_p('id'));
        $listorder = Common::queryInt(_p('listorder'), 0);
        $data = array();
        $data['listorder'] = $listorder;
        $res = $this->keywordsurlLogic->save($data, $id);
        echo $res ? 1 : 0;
    }

    public function actionDel() {
        $id = Common::queryInt(_g('id'));
        $cond = ' id= ' . $id;
        $keywordsurl = $this->keywordsurlLogic->getOne($cond);
        if (!$keywordsurl) {
            return $this->showMessage('illegal_parameters');
        }
        $res = $this->keywordsurlLogic->delete('id=' . $id);
        return $this->_redirect(Common::adminURL('admin', 'keywordsurl', 'list'));
    }
    
    public function actionBatchDel() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if (!empty($ids)) {
            $num = 0;
            foreach ($ids as $id) {
                $res = $this->keywordsurlLogic->delete('id=' . $id);
                if ($res) {
                    $num++;
                }
            }
            $staus = 1;
            $flag = $lang['success_delete'] . $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

    public function actionAddSynonym() {
        if (_p()) {
            $name = Common::strEscape(_p("base_name"));
            $query_name = _p("query_name");
            $language_id = Common::queryInt(_p("language_id"));
            if (!$name) {
                return $this->showMessage('keywordsurl_not_empty');
            }
            if (!$query_name) {
                return $this->showMessage('keywordsurl_not_basename');
            }
            $cond = "base_name='" . $query_name . "'";
            $Tkeywordurl = $this->keywordsurlLogic->getOne($cond);
            if (!$Tkeywordurl) {
                return $this->showMessage('keywordsurl_not_basename_error');
            }
            $name = str_replace("\\r", "", $name);
            $name = str_replace("\\n", ",", $name);
            $nameArr = explode(",", $name);
            foreach ($nameArr as $val) {
				$val = trim($val) ;
                $Tbasename = $this->keywordsurlLogic->getOne("base_name='" . $val . "' and language_id=" . $language_id);
                if ($Tbasename) {
                    continue;
                }
                $data = array(
                    'base_name' => $val,
                    'query_name' => Common::strEscape($query_name),
                    'type' => 1,
                    'status' => 1,
                    'language_id' => $language_id,
                    'create_time' => SYS_TIME
                );
                $res = $this->keywordsurlLogic->save($data);
            }
            return $res ? $this->success('add_success', Common::adminURL('admin', 'keywordsurl', 'list')) : $this->error('add_failure');
        } else {
            $languages = $this->languageLogic->getCols('1=1', $cols, TRUE);
            Core::$tpl->set('languages', $languages);
        }
    }

}

?>
