<?php

/**
 * Description of Language
 *
 * @author xrx
 */
class LanguageController extends AppController {

    private $langLogic;
    private $countryLogic;
    private $currencyLogic;
    private $themeLogic;

    public function __construct() {
        parent::__construct();
        $this->langLogic = $this->load('language');
        $this->countryLogic = $this->load('country');
        $this->currencyLogic = $this->load('currency');
        $this->themeLogic = $this->load('theme');
        ignore_user_abort(true);
        set_time_limit(0);
    }

    //站点数据状态
    public function actionLanguageStatus() {
        $languages = $this->langLogic->findAll();
        Core::$tpl->set('languages', $languages);
        foreach ($languages as $key => $value) {
            $lang[$value['base_name']] = $value['id'];
        }
        $script_map["goods"] = array("goodsLanguage", "goods_language", "goods", "goods_id", "1", "商品");
        $script_map["articleCategory"] = array("articleCategoryLanguage", "article_category_language", "article_category", "article_category_id", "2", "新闻分类");
        $script_map["article"] = array("articleLanguage", "article_language", "article", "article_id", "3", "新闻");
        $script_map["brand"] = array("brandLanguage", "brand_language", "brand", "brand_id", "4", "品牌");
        $script_map["goodsCategory"] = array("goodsCategoryLanguage", "goods_category_language", "goods_category", "goods_category_id", "5", "商品分类");
        $script_map["goodsTag"] = array("goodsTagLanguage", "goods_tag_language", "goods_tag", "goods_tag_id", "6", "商品标签");
        $script_map["mailTpl"] = array("mailTplLanguage", "mail_tpl_language", "mail_tpl", "mail_tpl_id", "7", "邮件模板");
        $script_map["nav"] = array("navLanguage", "nav_language", "nav", "nav_id", "8", "导航");
        $script_map["navPage"] = array("navPageLanguage", "nav_page_language", "nav_page", "nav_page_id", "9", "页面");
        $script_map["offer"] = array("offerLanguage", "offer_language", "offer", "offer_id", "10", "优惠");
        $script_map["payment"] = array("paymentLanguage", "payment_language", "payment", "payment_id", "11", "支付");
        $script_map["property"] = array("propertyLanguage", "property_language", "property", "property_id", "12", "属性");
        $script_map["seoTpl"] = array("seotplLanguage", "seo_tpl_language", "seo_tpl", "seo_tpl_id", "13", "SEO模板");
        $script_map["shipping"] = array("shippingLanguage", "shipping_language", "shipping", "shipping_id", "14", "配送");
        $script_map["insurance"] = array("InsuranceLanguage", "insurance_language", "insurance", "insurance_id", "15", "运费险");
        $script_map["topictag"] = array("TopicTagLanguage", "topic_tag_language", "topic_tag", "topic_tag_id", "16", "专题标签");
        $script_map["topic"] = array("TopicLanguage", "topic_language", "topic", "topic_id", "17", "专题");
        $script_map["usergroup"] = array("UserGroupLanguage", "user_group_language", "user_group", "user_group_id", "18", "用户组");
        foreach ($script_map as $k => $param) {
            $param_logic = $param[0];
            $param_table_lang = $param[1];
            $param_table = $param[2];
            $param_field_id = $param[3];
            $param_field_order = $param[4];
            $logic = $this->load($param_logic);
            $sql = "select count(*) as num, l . id as language_id from " . TABLE_PREFIX . "_" . $param_table . "  as m left join z_language as l on 1 = 1 left join " . TABLE_PREFIX . "_" . $param_table_lang . " as pl on l . id = pl . language_id and m . id = pl . " . $param_field_id . " where pl . id is null group by l . id";
            $res = $logic->query($sql);
            foreach ($res as $key => $value) {
                $res2[$value['language_id']] = $value['num'];
            }
            $res3 = array_flip($res2);
            $sql2 = "select count(*) as num from " . TABLE_PREFIX . "_" . $param_table . "  as m left join z_language as l on 1 = 1 ";
            $res4 = $logic->query($sql2);
            foreach ($res4 as $value) {
                $total = $value['num'];
            }
            $tabaleInfo[$param_field_order]['cname'] = $param[5];
            $tabaleInfo[$param_field_order]['key'] = $k;
            $tabaleInfo[$param_field_order]['name'] = $param_table;
            $tabaleInfo[$param_field_order]['total'] = $total ? $total : 0;
            if (!$res) {
                foreach ($lang as $key => $value) {
                    $tabaleInfo[$param_field_order]['miss'][$value] = 0;
                }
            }
            if ($res) {
                foreach ($lang as $kk => $vv) {
                    if ((in_array($vv, $res3))) {
                        $tabaleInfo[$param_field_order]['miss'][$vv] = $res2[$vv];
                    } else {
                        $tabaleInfo[$param_field_order]['miss'][$vv] = 0;
                    }
                }
            }
            unset($res2);
        }
        $base_site_id = Common::validSiteConfig();
        Core::$tpl->set('base_site_id', $base_site_id);
        Core::$tpl->set('tabaleInfo', $tabaleInfo);
    }

    //站点数据状态end

    public function actionList() {
        if (_g('do') == "theme_config") {
            $count = $this->langLogic->getCount('1=1');
            if ($count == 1) {
                $language = $this->langLogic->getOne('1=1');
                $url = "?m=admin&c=language&a=config&id=" . $language['id'];
                Common::redirect($url);
            }
        }

        $base_site_id = Common::validSiteConfig();
        Core::$tpl->set('base_site_id', $base_site_id);
        $where = '';
        if (_p('search_value') && _p('search_cond')) {
            $where .= " l." . _p('search_cond') . " = '" . _p('search_value') . "' ";
        }
        $langCountryCurrencyLogic = $this->load('languageCountryCurrency');
        $res = $langCountryCurrencyLogic->getList($where);
        Core::$tpl->set('res', $res['list']);
        Core::$tpl->set('themes', $this->themeLogic->findAll('', TRUE));
        if (_g('do') == "theme_config") {
            Core::$htmlFile = 'language/mobanlist';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    public function actionAdd() {
        if (_p()) {
            $name = _p('base_name');
            $alias_domain = _p('alias_domain');
            $load_tpl_default_data = _p('load_tpl_default_data');
            if (!_p('country_id')) {
                return $this->showMessage('$lang.country_tip');
            }
			if (!_p('currency_id')) {
                return $this->showMessage('$lang.country_tip');
            }
			if (!_p('theme_id')) {
                return $this->showMessage('$lang.currency_tip');
            }
			
			
			
            $country = explode('_', _p('country_id'));
            $data = array(
                'base_name' => $name,
                'language_name' => _p('language_name'),
                'theme_id' => _p('theme_id'),
                'domain_name' => _p('domain_name'),
                'currency_id' => _p('currency_id'),
                'status' => Common::queryInt(_p('status'), 1),
                'country_id' => $country[0],
                'country_code_2' => $country[1],
                'create_time' => SYS_TIME,
                'alias_domain' => $alias_domain,
            );
           $data['is_mobile'] = Common::queryInt(_p('is_mobile'));
            $data['wap_language_id'] = Common::queryInt(_p('wap_language_id'));
            $res = $this->langLogic->save($data);
            if ($res) {
                setcookie('auth_language_id', '');
                _setSession('auth_language_id', '');
                _setSession('front_lang', '');
                _setSession('theme_id', '');
                _setSession('theme_name', '');
                _setSession('is_mobile', '');
                _setSession('wap_language_id', '');
                //导入模板体验数据
                if (true) {
                    $diy_config = AppController::load('DiyConfig');
                    $language = $this->langLogic->getOne('id=' . $res);
                    if (!$language) {
                        return $this->error('id_error', Common::adminURL('admin', 'language', 'list'));
                    }
                    $flag = TRUE;

                    $theme = $this->themeLogic->getOne('id=' . $data['theme_id']);
                    if (!$theme) {
                        return $this->error('theme_error', Common::adminURL('admin', 'language', 'list'));
                    }
                    if (!$theme['theme_dir'] || !is_dir(THEME_ROOT . $theme['theme_dir'])) {
                        return $this->error('theme_error', Common::adminURL('admin', 'language', 'list'));
                    }
                    if (is_file(THEME_ROOT . $theme['theme_dir'] . '/default.conf.php')) {
                        include(THEME_ROOT . $theme['theme_dir'] . '/default.conf.php');
                        foreach ($diy_defalut_data as $key => $value) {
                            if (preg_match("/diy_[^\">]+/i", $value['name'])) {
                                $data = array(
                                    'name' => $value['name'],
                                    'language_id' => $language['id'],
                                    'value' => Common::strEscape($value['value'], false),
                                );
                                $diyconfig_map = Zhtx::createDataMap();
                                $diyconfig_map->createEntry($data);
                                $res = $diy_config->replaceByCond($diyconfig_map, "name='" . $value['name'] . "' and language_id=" . $language['id']);
                                if (!$res) {
                                    $flag = FALSE;
                                }
                            }
                        }
                    }
                }
                return $this->success('add_success', Common::adminURL('admin', 'language', 'list'));
            } else {
                return $this->error('add_failure', Common::adminURL('admin', 'language', 'list'));
            }
        } else {
            $language_config = Common::get_language();
            $cols = array('id', 'base_name');
            $country_cols = array('id', 'base_name', 'country_code_2');
            $currencys = $this->currencyLogic->getCols('', $cols);
            $countrys = $this->countryLogic->getCols('', $country_cols);
            Core::$tpl->set('currencys', $currencys);
            Core::$tpl->set('countrys', $countrys);
            Core::$tpl->set('langs', $language_config);
            Core::$tpl->set('themes', $this->themeLogic->findAll());
            Core::$tpl->set('languages', $this->langLogic->findAll('is_mobile=1', true));
            Core::$htmlFile = 'language/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    public function actionEdit() {
        if (_p()) {
            $id = Common::queryInt(_p('id'), 0);
            $name = _p('base_name');
            $domain = _p('domain_name');
            $alias_domain = _p('alias_domain');
            $load_tpl_default_data = _p('load_tpl_default_data');

            if (!_p('country_id')) {
                return $this->showMessage('$lang.country_tip');
            }
			
			if (!_p('currency_id')) {
                return $this->showMessage('$lang.country_tip');
            }
			if (!_p('theme_id')) {
                return $this->showMessage('$lang.currency_tip');
            }
			
            $country = explode('_', _p('country_id'));
            $data = array(
                'base_name' => $name,
                'language_name' => _p('language_name'),
                'theme_id' => _p('theme_id'),
                'domain_name' => $domain,
                'currency_id' => _p('currency_id'),
                'status' => Common::queryInt(_p('status')),
                'country_id' => $country[0],
                'country_code_2' => $country[1],
                'alias_domain' => $alias_domain,
            );
      
            $data['is_mobile'] = Common::queryInt(_p('is_mobile'));
            $data['wap_language_id'] = Common::queryInt(_p('wap_language_id'));
            $res = $this->langLogic->save($data, $id);
            if ($res) {
                setcookie('auth_language_id', '');
                _setSession('auth_language_id', '');
                _setSession('front_lang', '');
                _setSession('theme_id', '');
                _setSession('theme_name', '');
                _setSession('is_mobile', '');
                _setSession('wap_language_id', '');
                //导入模板体验数据
                if (true) {
                    $diy_config = AppController::load('DiyConfig');
                    $language = $this->langLogic->getOne('id=' . $id);
                    if (!$language) {
                        return $this->error('id_error', Common::adminURL('admin', 'language', 'list'));
                    }
                    $flag = TRUE;

                    $theme = $this->themeLogic->getOne('id=' . $data['theme_id']);
                    if (!$theme) {
                        return $this->error('theme_error', Common::adminURL('admin', 'language', 'list'));
                    }
                    if (!$theme['theme_dir'] || !is_dir(THEME_ROOT . $theme['theme_dir'])) {
                        return $this->error('theme_error', Common::adminURL('admin', 'language', 'list'));
                    }

                    if (is_file(THEME_ROOT . $theme['theme_dir'] . '/default.conf.php')) {
                        include(THEME_ROOT . $theme['theme_dir'] . '/default.conf.php');
                        foreach ($diy_defalut_data as $key => $value) {
                            if (preg_match("/diy_[^\">]+/i", $value['name'])) {
                                $data = array(
                                    'name' => $value['name'],
                                    'language_id' => $language['id'],
                                    'value' => Common::strEscape($value['value'], false),
                                );

                                $diy = $diy_config->getOne("name='" . $value['name'] . "' and language_id=" . $language['id']);
                                if ($diy && !_p('load_tpl_default_data')) {
                                    continue;
                                }

                                $diyconfig_map = Zhtx::createDataMap();
                                $diyconfig_map->createEntry($data);
                                $res = $diy_config->replaceByCond($diyconfig_map, "name='" . $value['name'] . "' and language_id=" . $language['id']);
                                if (!$res) {
                                    $flag = FALSE;
                                }
                            }
                        }
                    }
                }

                return $this->success('edit_success', Common::adminURL('admin', 'language', 'list'));
            } else {
                return $this->error('edit_failure', Common::adminURL('admin', 'language', 'list'));
            }
        } else {
            $id = Common::queryInt(_g('id'), 0);
            $language = $this->langLogic->getOne('id=' . $id);
            if (!$language) {
                return $this->error('id_error', Common::adminURL('admin', 'language', 'list'));
            }
            $language_config = Common::get_language();
            $cols = array('id', 'base_name');
            $country_cols = array('id', 'base_name', 'country_code_2');
            $currencys = $this->currencyLogic->getCols('', $cols);
            $countrys = $this->countryLogic->getCols('', $country_cols);
            Core::$tpl->set('language', $language);
            Core::$tpl->set('currencys', $currencys);
            Core::$tpl->set('countrys', $countrys);
            Core::$tpl->set('langs', $language_config);
            Core::$tpl->set('themes', $this->themeLogic->findAll());
            Core::$tpl->set('languages', $this->langLogic->findAll('is_mobile=1', true));
            Core::$htmlFile = 'language/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    /**
     * ajax 检测站点名称唯一  
     */
    public function actionPublicValidName() {
        $name = _p('base_name');
        $id = Common::queryInt(_g('id'));
        $cond = "base_name ='" . $name . "'";
        if ($id) {
            $cond .= " and id !=" . $id;
        }
        $count = $this->langLogic->getCount($cond);
        echo $count > 0 ? FALSE : TRUE;
    }

    /**
     * ajax 检测站点域名唯一 
     */
    public function actionPublicValidDomain() {
        $name = _p('domain_name');
        $id = Common::queryInt(_g('id'));
        $cond = "domain_name ='" . $name . "'";
        if ($id) {
            $cond .= " and id !=" . $id;
        }
        $count = $this->langLogic->getCount($cond);
        echo $count > 0 ? FALSE : TRUE;
    }

    /**
     * ajax 更新状态
     */
    public function actionPublicEditStatus() {
        $base_site = Common::validSiteConfig();
        $id = Common::queryInt(_g('id'));
        $status = _g('currentStatus');
        if ($id != $base_site) {
            $map = Zhtx::createDataMap();
            $map->addEntry('status', $status, DB::INT);
            $res = $this->langLogic->updateById($map, $id);
            echo $res ? 1 : 0;
            die();
        }
        echo 0;
        die();
    }

    public function actionDel() {
        $ids = _p('ids');
        if (!empty($ids)) {
            
        }
    }

    /**
     * 同步数据,生成TXT
     */
    public function actionSynchroByTxt() {
        if (_p()) {
            $dest_id = Common::queryInt(_p('id'));
            $source_id = Common::queryInt(_p('source_id'));
            if (!$dest_id) {
                return $this->showMessage('illegal_operation');
            }
            if (!$source_id) {
                return $this->showMessage('pease_select_source');
            }
            $languages = $this->langLogic->findAll('id in (' . $dest_id . ',' . $source_id . ')', TRUE);
            $remark = '同步' . $languages[$source_id]['base_name'] . '站数据到' . $languages[$dest_id]['base_name'] . '站';

            $script_map["articleCategory"] = array("articleCategoryLanguage", "article_category_language", _p('articleCategory'),);
            $script_map["article"] = array("articleLanguage", "article_language", _p('article'),);
            $script_map["brand"] = array("brandLanguage", "brand_language", _p('brand'));
            $script_map["goodsCategory"] = array("goodsCategoryLanguage", "goods_category_language", _p('goodsCategory'));
            $script_map["goods"] = array("goodsLanguage", "goods_language", _p('goods'));
            $script_map["goodsTag"] = array("goodsTagLanguage", "goods_tag_language", _p('goodsTag'));
            $script_map["mailTpl"] = array("mailTplLanguage", "mail_tpl_language", _p('mailTpl'));
            $script_map["nav"] = array("navLanguage", "nav_language", _p('nav'));
            $script_map["navPage"] = array("navPageLanguage", "nav_page_language", _p('navPage'));
            $script_map["offer"] = array("offerLanguage", "offer_language", _p('offer'));
            $script_map["payment"] = array("paymentLanguage", "payment_language", _p('payment'));
            $script_map["property"] = array("propertyLanguage", "property_language", _p('property'));
            $script_map["seoTpl"] = array("seotplLanguage", "seo_tpl_language", _p('seoTpl'));
            $script_map["shipping"] = array("shippingLanguage", "shipping_language", _p('shipping'));
            //$script_map["diyConfig"] = array("DiyConfig", "diy_config", _p('diyConfig'));
            $script_map["insurance"] = array("InsuranceLanguage", "insurance_language", _p('insurance'));
            $script_map["topictag"] = array("TopicTagLanguage", "topic_tag_language", _p('topictag'));
            $script_map["topic"] = array("TopicLanguage", "topic_language", _p('topic'));
            $script_map["usergroup"] = array("UserGroupLanguage", "user_group_language", _p('usergroup'));
            $script_map["channeltag"] = array("ChannelTagLanguage", "channel_tag_language", _p('channeltag'));
            $script_map["goodspackagesale"] = array("GoodsPackageSaleLanguage", "goods_package_sale_language", _p('goodspackagesale'));
            $num = 0;
            foreach ($script_map as $param) {
                $synchroField = '';
                $param_logic = $param[0];
                $param_table = $param[1];
                $param_status = $param[2];
                if ($param_status == 1) {
                    $logic = $this->load($param_logic);
//                    $logic->delete('language_id=' . $dest_id);
                    $sql = "delete from " . TABLE_PREFIX . "_" . $param_table . " where language_id=" . $dest_id;
                    $sql_log .= "" . "$sql;\r\n";
                    $field = $logic->query('SHOW FIELDS FROM ' . TABLE_PREFIX . '_' . $param_table);
                    foreach ($field as $key => $value) {
                        if (strtolower($value['Field']) == 'id' || strtolower($value['Field']) == 'language_id')
                            continue;
                        $synchroField[] = $value['Field'];
                    }

                    $sql = "replace into " . TABLE_PREFIX . "_" . $param_table . " (" . join(',', $synchroField) . ",language_id) select " . join(',', $synchroField) . "," . $dest_id . " from " . TABLE_PREFIX . "_" . $param_table . " where language_id = " . $source_id . ";";
                    $sql_log .= "" . "$sql\r\n";
                    Core::$tpl->set('sql', $sql_log);
                    $temp = 'synchro.txt';
                    if (is_file($temp)) {
                        $content = trim(@file_get_contents($temp));
                        @file_put_contents($temp, $sql_log);
                    } else {
                        @file_put_contents($temp, $sql_log);
                    }
                }
            }
            Core::$htmlFile = 'language/synchrobytxt';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        } else {
            $id = Common::queryInt(_g('id'));
            $languages = $this->langLogic->findAll('status=1', true);
            if (!$languages[$id]) {
                return $this->showMessage('not_found_record');
            }
            $language = $languages[$id];
            unset($languages[$id]);
            Core::$tpl->set('language', $language);
            Core::$tpl->set('languages', $languages);
            Core::$htmlFile = 'language/synchro';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    function actionDownLoadTXT() {
        $filename = 'synchro.txt';
        header("Content-Type:text/plain");
        header('Content-Disposition: attachment; filename=' . $filename);
        header('Content-Length:' . filesize($filename));
        readfile($filename);
//        unlink($filename);
        exit();
    }

    public function actionPublicSynchro() {
        if (_p()) {
            $is_cover = Common::queryInt(_p('is_cover'));
            $script_map["articleCategory"] = array("articleCategoryLanguage", "article_category_id", $is_cover);
            $script_map["article"] = array("articleLanguage", "article_id", $is_cover);
            $script_map["brand"] = array("brandLanguage", "brand_id", $is_cover);
            $script_map["goodsCategory"] = array("goodsCategoryLanguage", "goods_category_id", $is_cover);
            $script_map["goods"] = array("goodsLanguage", "goods_id", $is_cover);
            $script_map["goodsTag"] = array("goodsTagLanguage", "goods_tag_id", $is_cover);
            $script_map["mailTpl"] = array("mailTplLanguage", "mail_tpl_id", $is_cover);
            $script_map["nav"] = array("navLanguage", "nav_id", $is_cover);
            $script_map["navPage"] = array("navPageLanguage", "nav_page_id", $is_cover);
            $script_map["offer"] = array("offerLanguage", "offer_id", $is_cover);
            $script_map["payment"] = array("paymentLanguage", "payment_id", $is_cover);
            $script_map["property"] = array("propertyLanguage", "property_id", $is_cover);
            $script_map["seoTpl"] = array("seotplLanguage", "seo_tpl_id", $is_cover);
            $script_map["shipping"] = array("shippingLanguage", "shipping_id", $is_cover);
            $script_map["diyConfig"] = array("DiyConfig", "name", $is_cover);
            $script_map["insurance"] = array("InsuranceLanguage", "insurance_id", $is_cover);
            $script_map["topictag"] = array("TopicTagLanguage", "topic_tag_id", $is_cover);
            $script_map["topic"] = array("TopicLanguage", "topic_id", $is_cover);
            $script_map["usergroup"] = array("UserGroupLanguage", "user_group_id", $is_cover);
            $dest_id = Common::queryInt(_p('id'));
            $source_id = Common::queryInt(_p('source_id'));
            if (!$dest_id) {
                return $this->showMessage('illegal_operation');
            }
            if (!$source_id) {
                return $this->showMessage('pease_select_source');
            }
            $languages = $this->langLogic->findAll('id in (' . $dest_id . ',' . $source_id . ')', TRUE);
            $remark = '同步' . $languages[$source_id]['base_name'] . '站数据到' . $languages[$dest_id]['base_name'] . '站';
            $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
            $taskListLogic = $this->load('taskList');
            foreach ($script_map as $formkey => $info) {
                if (!_p($formkey)) {
                    continue;
                }
                $logic = AppController::load($info[0]);
//				$count  = $logic->getCount("language_id=".$dest_id);
                //数据来源站点记录统计
                $count = $logic->getCount("language_id=" . $source_id);
                $offset = 0;
                $limit = 5000 > $count ? $count : 5000;
                while ($offset < $count) {
                    $codeno = $dest_id . '_' . $source_id . '_' . $formkey . '_' . $offset . '_' . $limit;
                    $tcount = $taskListLogic->getCount('codeno="' . $codeno . '"');
                    if ($tcount > 0) {
                        $offset += $limit;
                        continue;
                    }
                    $task_data = array(
                        'task_stage_id' => 10,
                        'base_name' => $lang[$formkey] . '数据同步',
                        'codeno' => $codeno,
                        'language_id' => $dest_id,
                        'params' => json_encode($info),
                        'status' => 0,
                        'remote_url' => Common::frontURL('home', 'module', 'synchro', array('codeno' => $codeno, 'key' => $security_key)), //执行地址
                        'remark' => $remark,
                        'create_time' => SYS_TIME,
                    );
                    $taskListLogic->save($task_data);
                    $offset += $limit;
                }
            }
            return $this->_redirect(Common::adminURL('admin', 'language', 'publicShowSynchro', array('id' => $dest_id)));
        } else {
            $id = Common::queryInt(_g('id'));
            $languages = $this->langLogic->findAll('status=1', true);
            if (!$languages[$id]) {
                return $this->showMessage('not_found_record');
            }
            $language = $languages[$id];
            unset($languages[$id]);
            Core::$tpl->set('language', $language);
            Core::$tpl->set('languages', $languages);
            Core::$htmlFile = 'language/synchro';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    /**
     * 同步数据 
     */
    public function actionSynchro() {
        $codeno = _g('codeno');
        $taskListLogic = $this->load('taskList');
        $taskList = $taskListLogic->getOne('codeno="' . $codeno . '"');
        if (!$taskList) {
            echo 0;
            exit;
        }
        $info = explode('_', $codeno);
        $params = json_decode($taskList['params'], TRUE);
        $logic = $this->load($params[0]);

        $dest_cond = 'language_id =' . $info[0] . ' order by id asc limit ' . $info[3] . ',' . $info[4];
        $source_cond = 'language_id =' . $info[1] . ' order by id asc limit ' . $info[3] . ',' . $info[4];
        $dest = $logic->findAll($dest_cond);
        $source = $logic->findAll($source_cond);
        foreach ($dest as $key => $value) {
            $exists_dest[$value[$params[1]]] = $value;
        }
        $success = 0;
        $failure = 0;
        foreach ($source as $key => $value) {
            $map = Zhtx::createDataMap();
            $exist_obj = isset($exists_dest[$value[$params[1]]]) ? $exists_dest[$value[$params[1]]] : '';
            unset($value['id']);
            unset($value['language_id']);
            if (!$exist_obj) {
                $map->addEntry($params[1], $value[$params[1]], DB::INT);
                $map->addEntry('language_id', $info[0]);
                foreach ($value as $field => $v) {
                    if (is_int($field)) {
                        continue;
                    }
                    if ($field == 'detail') {
                        $map->addEntry($field, Common::strEscape($v, FALSE));
                    } else {
                        $map->addEntry($field, Common::strEscape($v));
                    }
                }
                if ($logic->insert($map)) {
                    $success++;
                } else {
                    $failure++;
                }
            } else {
                foreach ($value as $field => $v) {
                    if (is_int($field)) {
                        continue;
                    }
                    if ((!$exist_obj[$field] || $params[2] != 0) && $v) {
                        if ($field == 'detail') {
                            $map->addEntry($field, Common::strEscape($v, FALSE));
                        } else {
                            $map->addEntry($field, Common::strEscape($v));
                        }
                    }
                }
                if ($map->getData()) {
                    if ($logic->updateById($map, $exist_obj['id'])) {
                        $success++;
                    } else {
                        $failure++;
                    }
                }
            }
        }
        $task_map = Zhtx::createDataMap();
        if ($failure === 0) {
            $task_map->addEntry('status', 1, DB::INT);
            $task_map->addEntry('result', 'Success', DB::VARCHAR);
        } else {
            $task_map->addEntry('status', 2, DB::INT);
            $task_map->addEntry('result', '成功同步' . $success . '记录\,同步失败' . $failure . '记录', DB::VARCHAR);
        }
        if ($task_map->getData()) {
            $taskListLogic->updateById($task_map, $taskList['id']);
        }
        echo 1;
        exit;
    }

    /**
     * 展示同步的信息 
     */
    public function actionPublicShowSynchro() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $language_id = Common::queryInt(_g('id'));
        $taskListLogic = $this->load('taskList');
        $cond = 'task_stage_id=10 and language_id=' . $language_id . ' order by codeno desc';
        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);
        $count = $taskListLogic->getCount($cond);
        $page_data = Common::getPages($count, $current_page, $page_size);
        $taskLists = $taskListLogic->getCurrentDatas($cond, $page_size, $curr_page);
        $area_info = array();
        $source_id = array();
        foreach ($taskLists as $value) {
            $array = explode('_', $value['codeno']);
            $area_info[$value['id']]['area'] = $lang[$array[2]];
            $area_info[$value['id']]['limit'] = $array[3] . '-' . $array[4];
            $area_info[$value['id']]['source_id'] = $array[1];
            $source_id[] = $array[1];
        }
        $source_id[] = $language_id;
        $lang_ids = array_unique($source_id);
        $languages = $this->langLogic->findAll('id in(' . implode(',', $lang_ids) . ')', TRUE);
        Core::$tpl->set('res', $taskLists);
        Core::$tpl->set('pages', $page_data);
        Core::$tpl->set('area_info', $area_info);
        Core::$tpl->set('languages', $languages);
        Core::$tpl->set('language_id', $language_id);
        Core::$htmlFile = 'language/tasklist';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

    /**
     * 站点配置
     */
    public function actionConfig() {
        $diy_config = AppController::load('DiyConfig');
        if (_p()) {
            $id = Common::queryInt(_p('id'), 0);
            $language = $this->langLogic->getOne('id=' . $id);
            if (!$language) {
                return $this->error('id_error', Common::adminURL('admin', 'language', 'list'));
            }
            $flag = TRUE;
            foreach (_p() as $key => $value) {
                if (preg_match("/diy_[^\">]+/i", $key)) {
                    $data = array(
                        'name' => $key,
                        'language_id' => $language['id'],
                        'value' => Common::strEscape(Inputer::getOrgPost($key), false),
                    );
                    $diyconfig_map = Zhtx::createDataMap();
                    $diyconfig_map->createEntry($data);
                    $res = $diy_config->replaceByCond($diyconfig_map, "name='" . $key . "' and language_id=" . $language['id']);
                    if (!$res) {
                        $flag = FALSE;
                    }
                }
            }
            if ($flag) {
                $diy_config->delCache($language['id']);
                return $this->success('edit_success', Common::adminURL('admin', 'language', 'list',array('do'=>'theme_config')));
            } else {
                return $this->error('edit_failure', Common::adminURL('admin', 'language', 'list',array('do'=>'theme_config')));
            }
        } else {
            $id = Common::queryInt(_g('id'), 0);
            $language = $this->langLogic->getOne('id=' . $id);
            if (!$language) {
                return $this->error('id_error', Common::adminURL('admin', 'language', 'list'));
            }
            if (!$language['theme_id']) {
                return $this->error('theme_id_null', Common::adminURL('admin', 'language', 'list'));
            }
            $theme = $this->themeLogic->getOne('id=' . $language['theme_id']);
            if (!$theme) {
                return $this->error('theme_error', Common::adminURL('admin', 'language', 'list'));
            }
            if (!$theme['theme_dir'] || !is_dir(THEME_ROOT . $theme['theme_dir'])) {
                return $this->error('theme_error', Common::adminURL('admin', 'language', 'list'));
            }
            if (!is_file(THEME_ROOT . $theme['theme_dir'] . '/template.conf.php')) {
                return $this->error('theme_config_null', Common::adminURL('admin', 'language', 'list'));
            }
            require_once THEME_ROOT . $theme['theme_dir'] . '/template.conf.php';
            if (is_file(THEME_ROOT . $theme['theme_dir'] . '/diy.conf.php')) {
                require_once THEME_ROOT . $theme['theme_dir'] . '/diy.conf.php';
            }
            //$diy_key替换默认值
            $res = $diy_config->findAll('language_id=' . $language['id']);
            if ($res) {
                foreach ($res as $value) {
                    foreach ($diy_key as $key => $diyvalue) {
                        if ($value['value'] != '' && $diy_key[$key]['name'] == $value['name'])
                            $diy_key[$key]['value'] = $value['value'];
                    }
                }
            }
            $goodsTagLogic = AppController::load('goodsTag');
            $goodsTags = $goodsTagLogic->getList('status=1 order by listorder desc');
            $where = "parent_id=0 and status=1 ORDER BY id desc limit 100";
            $navlogic = AppController::load('nav');
            $navList = $navlogic->findAll($where);
            $specialLogic = $this->load('specialOffer');
            $deals = $specialLogic->findAll('order by create_time desc');
            Core::$tpl->set('deals', $deals);
            Core::$tpl->set('taglist', $goodsTags['list']);
            Core::$tpl->set('navlist', $navList);
            Core::$tpl->set('diy_key', $diy_key);
            Core::$tpl->set('language', $language);
            Core::$tpl->set('theme_dir', $theme['theme_dir']);
        }
    }

    public function actionNullList() {

        $script_map["goods"] = array("goodsLanguage", "goods_language", "goods", "goods_id", "1", "商品", "?m=product&c=product&a=edit&id=");
        $script_map["articleCategory"] = array("articleCategoryLanguage", "article_category_language", "article_category", "article_category_id", "2", "新闻分类", "?m=admin&c=articlecategory&a=edit&id=");
        $script_map["article"] = array("articleLanguage", "article_language", "article", "article_id", "3", "新闻", "?m=admin&c=article&a=edit&id=");
        $script_map["brand"] = array("brandLanguage", "brand_language", "brand", "brand_id", "4", "品牌", "?m=product&c=brand&a=edit&id=");
        $script_map["goodsCategory"] = array("goodsCategoryLanguage", "goods_category_language", "goods_category", "goods_category_id", "5", "商品分类", "?m=product&c=category&a=edit&id=");
        $script_map["goodsTag"] = array("goodsTagLanguage", "goods_tag_language", "goods_tag", "goods_tag_id", "6", "商品标签", "?m=product&c=tag&a=edit&id=");
        $script_map["mailTpl"] = array("mailTplLanguage", "mail_tpl_language", "mail_tpl", "mail_tpl_id", "7", "邮件模板", "?m=admin&c=mailtpl&a=edit&id=");
        $script_map["nav"] = array("navLanguage", "nav_language", "nav", "nav_id", "8", "导航", "?m=admin&c=nav&a=edit&id=");
        $script_map["navPage"] = array("navPageLanguage", "nav_page_language", "nav_page", "nav_page_id", "9", "页面", "?m=admin&c=navpage&a=edit&id=");
        $script_map["offer"] = array("offerLanguage", "offer_language", "offer", "offer_id", "10", "优惠", "?m=product&c=offer&a=edit&id=");
        $script_map["payment"] = array("paymentLanguage", "payment_language", "payment", "payment_id", "11", "支付", "?m=admin&c=payment&a=edit&id=");
        $script_map["property"] = array("propertyLanguage", "property_language", "property", "property_id", "12", "属性", "?m=product&c=property&a=editvalue&id=");
        $script_map["seoTpl"] = array("seotplLanguage", "seo_tpl_language", "seo_tpl", "seo_tpl_id", "13", "SEO模板", "?m=admin&c=seotpl&a=edit&id=");
        $script_map["shipping"] = array("shippingLanguage", "shipping_language", "shipping", "shipping_id", "14", "配送", "?m=admin&c=shipping&a=edit&id=");
        $script_map["insurance"] = array("InsuranceLanguage", "insurance_language", "insurance", "insurance_id", "15", "运费险", "?m=order&c=insurance&a=config&id");
        $script_map["topictag"] = array("TopicTagLanguage", "topic_tag_language", "topic_tag", "topic_tag_id", "16", "专题标签", "?m=admin&c=topic&a=editTag&id=16&topic_id=");
        $script_map["topic"] = array("TopicLanguage", "topic_language", "topic", "topic_id", "17", "专题", "?m=admin&c=topic&a=edit&id=");
        $script_map["usergroup"] = array("UserGroupLanguage", "user_group_language", "user_group", "user_group_id", "18", "用户组", "?m=admin&c=user&a=editUserGroup&id=");
        $key = _g("key");
        $language_id = _g("language_id");

        $element = $script_map[$key];
        $logic = $this->load($element[0]);
        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);
        //分页
        $sql_count = "select m.id from " . TABLE_PREFIX . "_" . $element[2] . "  as m  left join " . TABLE_PREFIX . "_" . $element[1] . " as l on  m.id = l." . $element[3] . " and l.language_id=" . $language_id . " where l.id is null";
        $count = $logic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);

        $sql = "select m.id from " . TABLE_PREFIX . "_" . $element[2] . "  as m  left join " . TABLE_PREFIX . "_" . $element[1] . " as l on  m.id = l." . $element[3] . " and language_id=" . $language_id . " where l.id is null limit " . ($curr_page - 1) * $page_size . ',' . $page_size;
        $res = $logic->query($sql);
        Core::$tpl->set("pages", $page_data);
        Core::$tpl->set('res', $res);
        Core::$tpl->set('element', $element);
    }

}

?>
