<?php

/**
 * Description of mailtpl
 *
 * @author HHH
 */
class MailtplController extends AppController {

    private $mailtplLogic;
    private $mailtplLanguageLogic;
    private $languageJoinCountryLogic;
    private $email_tpl;

    /**
     * 初始化程序
     */
    public function __construct() {
        parent::__construct();
        $this->mailtplLogic = $this->load('mailTpl');
        $this->languageJoinCountryLogic = $this->load('languageJoinCountry');
        $this->mailtplLanguageLogic = $this->load('mailTplLanguage');
        $this->languageLogic = $this->load('language');
        $this->email_tpl = APP_ROOT . 'cache/email';
    }

    /**
     * 列表
     */
    public function actionList() {

        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);

        $where = '1=1';
        if (_g('base_name')) {
            $where .= " and base_name like '%" . _g('base_name') . "%'";
        }
        $where .= " ORDER BY id DESC";

        //获取数据
        $res = $this->mailtplLogic->getCurrentDatas($where, $page_size, $curr_page);
        //分页
        $count = $this->mailtplLogic->getCount($where);
        $page_list = Common::getPages($count, $curr_page, $page_size);
        Core::$tpl->set('res', $res);
        Core::$tpl->set('pages', $page_list);
    }

    /**
     * 新增数据
     */
    public function actionAdd() {
        //如果是 POST 请求,则执行添加数据操作,else 进行视图输出
        if (_p()) {
            //插入主表信息
            $mailtpl = Zhtx::createDataMap();
            $mailtpl->addEntry('base_name', Common::strEscape(_p('base_name')), DB::VARCHAR);
            $mailtpl->addEntry('descript', Common::strEscape(_p('descript')), DB::VARCHAR);
            $mailtpl->addEntry('var_descript', Common::strEscape(_p('var_descript')), DB::VARCHAR);
            $mailtpl->addEntry('create_time', SYS_TIME, DB::INT);
            $mailRes = $this->mailtplLogic->insert($mailtpl);
            if ($mailRes) {    //获得 insert_id 插入附表信息
                $languages = $this->languageLogic->findALL('status=1', true);
                //更新选中的信息
                foreach ($languages as $key => $item) {
                    $mailLanguage = Zhtx::createDataMap();
                    $mailLanguage->addEntry('mail_tpl_id', $mailRes, DB::INT);
                    $mailLanguage->addEntry('language_id', $item["id"], DB::INT);
                    $mailLanguage->addEntry('detail', Common::strEscape(Inputer::getOrgPost('detail' . $item["id"]), false), DB::TEXT);
                    $mailLanguage->addEntry('base_name', Common::strEscape(_p('base_name' . $item["id"])), DB::VARCHAR);
                    $lang_res = $this->mailtplLanguageLogic->insert($mailLanguage);
                    if ($lang_res) {
                        Common::_mkdir($this->email_tpl);
                        $tpl_file = $tpl_dir . '/' . $mailRes . '_' . $lang_res . '_tpl.htm';
                        $content = Inputer::getOrgPost('detail' . $item["id"]);
                        preg_match_all('/(<img\"?.+\ssrc=["|\'])(.*?)([a-z0-9A-Z_\-.]["|\']\"?.+>)/i', $content, $img_arr);
                        foreach ($img_arr[0] as $k => $value) {
                            $new_value = str_replace('src="/upload', 'src="' . SITE_PROTOCOL . SITE_URL . '/upload', $value);
                            $content = str_replace($value, $new_value, $content);
                        }
                        $fp = fopen($tpl_file, "w+");
                        @fwrite($fp, $content);
                        @fclose($fp);
                    }
                }

                return $this->success('add_success', Common::adminURL('admin', 'mailtpl', 'list'));
            } else
                return $this->error('add_failure', Common::adminURL('admin', 'mailtpl', 'list'));
        }
        else {
            $languages = $this->languageJoinCountryLogic->getList('l.status=1');
            Core::$tpl->set('languages', $languages["list"]);
        }
    }

    /**
     * 编辑数据
     */
    public function actionEdit() {
        if (_p()) {
            //更新主表信息
            $id = Common::queryInt(_p('id'));
            $mailtpl = Zhtx::createDataMap();
            $mailtpl->addEntry('base_name', Common::strEscape(_p('base_name')), DB::VARCHAR);
            $mailtpl->addEntry('descript', Common::strEscape(_p('descript')), DB::VARCHAR);
            $mailtpl->addEntry('var_descript', Common::strEscape(_p('var_descript')), DB::VARCHAR);
            $mailtpl->addEntry('create_time', SYS_TIME, DB::INT);
            $mailRes = $this->mailtplLogic->update($mailtpl, 'id = ' . $id);
            if ($mailRes) {    //如果主表信息更新成功,则更新附表信息
                $languages = $this->languageLogic->findALL('status=1', true);
                //更新选中的信息
                $flag = true;
                foreach ($languages as $key => $item) {
                    $mailLanguage = Zhtx::createDataMap();
                    $mailLanguage->addEntry('mail_tpl_id', $id, DB::INT);
                    $mailLanguage->addEntry('language_id', $item["id"], DB::INT);
                    $mailLanguage->addEntry('detail', Common::strEscape(Inputer::getOrgPost('detail' . $item["id"]), false), DB::VARCHAR);
                    $mailLanguage->addEntry('base_name', Common::strEscape(_p('base_name' . $item["id"])), DB::VARCHAR);
                    /*
                     * 没有replace操作,所以要先查询一遍是否有当前mail_tpl_id 和 language_id的数据值
                     * 如果没有,则添加数据,否则更新数据
                     */
                    $values = $item["id"];
                    if ($this->mailtplLanguageLogic->getOne("mail_tpl_id = {$id} AND language_id = {$values}")) {
                        $lang_res = $this->mailtplLanguageLogic->update($mailLanguage, "mail_tpl_id = {$id} AND language_id = {$values}");
                    } else {
                        $lang_res = $this->mailtplLanguageLogic->insert($mailLanguage);
                    }
                    if ($lang_res) { //生成邮件模板，调用图片需保证绝对路径
                        Common::_mkdir($this->email_tpl);
                        $tpl_file = $this->email_tpl . '/' . $id . '_' . $values . '_tpl.htm';
                        $content = Inputer::getOrgPost('detail' . $item["id"]);
                        preg_match_all('/(<img\"?.+\ssrc=["|\'])(.*?)([a-z0-9A-Z_\-.]["|\']\"?.+>)/i', $content, $img_arr);
                        foreach ($img_arr[0] as $k => $value) {
                            $new_value = str_replace('src="/upload', 'src="' . SITE_PROTOCOL . SITE_URL . '/upload', $value);
                            $content = str_replace($value, $new_value, $content);
                        }
                        $fp = fopen($tpl_file, "w+");
                        @fwrite($fp, $content);
                        @fclose($fp);
                    } else {
                        $flag = FALSE;
                    }
                }
                return $flag ? $this->success('edit_success', Common::adminURL('admin', 'mailtpl', 'list')) : $this->error('edit_failure', Common::adminURL('admin', 'mailtpl', 'list'));
            } else {
                return $this->error('edit_failure', Common::adminURL('admin', 'mailtpl', 'list'));
            }
        } else {
            $id = Common::queryInt(_g('id'));
            $where = 'id = ' . $id;
            $mailtpl = $this->mailtplLogic->getOne($where);
            if (!$mailtpl) {
                return $this->error('id_error', Common::adminURL('admin', 'mailtpl', 'list'));
            }
            //获得当前支持的语言列表
            $languages = $this->languageJoinCountryLogic->getList('l.status=1');
            //获得多语言对应的模板信息
            $cond = 'mail_tpl_id = ' . $id;
            $mailtplLanguage = $this->mailtplLanguageLogic->getList($cond);
            $mailtpllang_arr = array();
            foreach ($mailtplLanguage['list'] as $value) {
                $mailtpllang_arr[$value['language_id']] = $value;
            }
            Core::$tpl->set('mailtplLanguage', $mailtpllang_arr);
            Core::$tpl->set('languages', $languages["list"]);
            Core::$tpl->set('mailtpl', $mailtpl);
        }
    }

    public function actionDel() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if (!empty($ids)) {
            $num = 0;
            foreach ($ids as $id) {
                $res = $this->mailtplLogic->delete('id=' . $id);
                if ($res) {
                    $this->mailtplLanguageLogic->delete('mail_tpl_id=' . $id);
                    $num++;
                }
            }
            $staus = 1;
            $flag = $lang['success_delete'] . $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

    //
    public function actionRefresh() {
        $mailTpls = $this->mailtplLanguageLogic->findAll();
        $errors = array();
        foreach ($mailTpls as $val) {
            $files = $_SERVER['DOCUMENT_ROOT'] . '/cache/email/' . $val['id'] . '_' . $val['language_id'] . '_tpl.htm';
            @file_put_contents($files, $val['detail']);
        }
        return $this->success('刷新缓存成功', Common::adminURL('admin', 'mailtpl', 'list'));
    }

}

?>
