<?php

/**
 * Description of Menu
 *
 * @author xrx
 */
class MenuController extends AppController
{
    private $menuLogic;
    private $languageLogic;
    private $menuLangLogic;
    public function __construct()
    {
        parent::__construct();
        $this->menuLogic     = $this->load('adminMenu');
        $this->languageLogic = $this->load('language');
        $this->menuLangLogic = $this->load('adminMenuLanguage');
    }
    public function actionList()
    {         
        //$menus  = $this->menuLogic->getMenus();
        $menu_list     = $this->menuLogic->getList('1=1 order by parent_id asc, listorder desc,id DESC');
		foreach($menu_list['list'] as $key => $value)
		{
			///$menu_list['list'][$key]["level"] = substr_count( $value["path_id"] , ',');
		}
        $menus = Common::getMenuTree($menu_list['list']);
        Core::$tpl->set('menus', $menus);
    }
    public function actionAdd()
    {       
        if(_p())
        {
            $menuName = _p('base_name');
            $lang_key = _p('lang_key');
            if(!$menuName)
            {
                return $this->showMessage('menu_name_not_empty');
            }
            if(!$lang_key)
            {
                $lang_key = _p('m') . "_" . _p('c') . "_" . _p('a');
            }
            $menu_cond = 'base_name = "'. $menuName .'"';
            $edit_menu = $this->menuLogic->getOne($menu_cond);
            if($edit_menu)
            {              
                return $this->showMessage('name_already_exists');
            }
            $menu_cond1 = 'lang_key = "'. $lang_key .'"';
            $edit_menu1 = $this->menuLogic->getOne($menu_cond1);
            if($edit_menu1)
            {
                return $this->showMessage('key_already_exists');
            }
            $grade = 1;
            $parentid = Common::queryInt(_p('parent_id'));
            $class    = _p('class');
            if($parentid != '0')
            {
                $parentMenu = $this->menuLogic->getOne('id='.$parentid);
                if($parentMenu)
                {
                    $grade = $parentMenu['level'] + 1;
                    $class = $parentMenu['class'];
                }
                else
                {
                   return $this->showMessage('illegal_operation');
                }
            }
            $menu_map = Zhtx::createDataMap();
            $menu_map->addEntry('base_name', Common::strEscape($menuName), DB::VARCHAR);
            $menu_map->addEntry('parent_id', $parentid, DB::INT);
            $menu_map->addEntry('m', _p('m'), DB::VARCHAR);
            $menu_map->addEntry('c', _p('c'), DB::VARCHAR);
            $menu_map->addEntry('a', _p('a'), DB::VARCHAR);
            $menu_map->addEntry('data', _p('data'), DB::VARCHAR);
            $menu_map->addEntry('listorder', Common::queryInt(_p('listorder')), DB::INT);
            $menu_map->addEntry('display', Common::queryInt(_p('display')), DB::INT);
            $menu_map->addEntry('isopen', Common::queryInt(_p('isopen')), DB::INT);
            $menu_map->addEntry('level', $grade, DB::INT);
            $menu_map->addEntry('lang_key', $lang_key, DB::VARCHAR);
            $menu_map->addEntry('class', $class, DB::VARCHAR);
            $res = $this->menuLogic->insert($menu_map);
            if($res)
            {
                if($parentid)
                {                    
                    $map    = Zhtx::createDataMap();
                    $map->addEntry('has_sun', 1, DB::INT);
                    $this->menuLogic->updateById($map, $parentid);
                }
                $this->write_menu($lang_key, $menuName);
                //更新缓存
                $this->menuLogic->updateCache();
            }
			if($res)
			{
				return $this->success('add_success', Common::adminURL('admin', 'menu', 'list'));
			}
			else
			{
				return $this->error('add_failure', Common::adminURL('admin', 'menu', 'list'));
			}
        }
        else
        {  
            $menus = $this->menuLogic->getList();
            $parents = array();
            foreach (Common::_getTree($menus['list']) as $item) {
                $parents[$item['id']] = str_repeat('　', $item['level']) . $item['base_name'];
            }
            if(_g('pid'))
            {
               Core::$tpl->set('parent_id', intval(_g('pid'))); 
            }
            Core::$tpl->set('parentMenus', $parents);
            Core::$htmlFile  = 'menu/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
        
    }
   public function actionEdit()
    {
        if(_p())
        {
            $id       = Common::queryInt(_p('id'));
            $menuName = _p('base_name');
            $lang_key = _p('lang_key');
            if(!$menuName)
            {
                return $this->showMessage('menu_name_not_empty');
            }
            if(!$lang_key)
            {
                $lang_key = _p('m') . "_" . _p('c') . "_" . _p('a');
            }
            $menu_cond = 'id !='. $id . ' AND base_name = "'. $menuName .'"';
            $edit_menu = $this->menuLogic->getOne($menu_cond);
            if($edit_menu)
            {
                return $this->showMessage('name_already_exists');
            }
            $grade = 1;
            $parentid = Common::queryInt(_p('parent_id'));
             $class   = _p('class');
            if($parentid)
            {
                $parentMenu = $this->menuLogic->getOne('id='.intval($parentid));
                if($parentMenu)
                {
                    $grade = $parentMenu['level'] + 1;
                    $class = $parentMenu['class'];
                }
                else
                {
                   return $this->showMessage('illegal_operation');
                }
            }
            $menu_map = Zhtx::createDataMap();
            $menu_map->addEntry('base_name', Common::strEscape($menuName), DB::VARCHAR);
            $menu_map->addEntry('parent_id', $parentid, DB::INT);
            $menu_map->addEntry('m', _p('m'), DB::VARCHAR);
            $menu_map->addEntry('c', _p('c'), DB::VARCHAR);
            $menu_map->addEntry('a', _p('a'), DB::VARCHAR);
            $menu_map->addEntry('data', _p('data'), DB::VARCHAR);
            $menu_map->addEntry('listorder', Common::queryInt(_p('listorder')), DB::INT);
            $menu_map->addEntry('display', Common::queryInt(_p('display')), DB::INT);
            $menu_map->addEntry('isopen', Common::queryInt(_p('isopen')), DB::INT);
            $menu_map->addEntry('level', $grade, DB::INT);
            $menu_map->addEntry('lang_key', $lang_key, DB::VARCHAR);
            $menu_map->addEntry('class', $class, DB::VARCHAR);
            $res = $this->menuLogic->updateById($menu_map, $id);
            if($res)
            {
                if($parentid)
                {                    
                    $map    = Zhtx::createDataMap();
                    $map->addEntry('has_sun', 1, DB::INT);
                    $this->menuLogic->updateById($map, $parentid);
                }
                $cond   = 'parent_id =' . $id;
                $childs = $this->menuLogic->getList($cond);
                foreach ($childs['list'] as $value)
                {
                    $menu_map = Zhtx::createDataMap();
                    $menu_map->addEntry('level', $grade+1, DB::INT);
                    $res = $this->menuLogic->updateById($menu_map, $value['id']);
                } 
                $this->write_menu($lang_key, $menuName);
                //更新缓存
                $this->menuLogic->updateCache();
            }
            if($res)
			{
				return $this->success('edit_success', Common::adminURL('admin', 'menu', 'list'));
			}
			else
			{
				return $this->error('edit_failure', Common::adminURL('admin', 'menu', 'list'));
			}
        }
        else
        {
            $id = Common::queryInt(_g('id'),0) ;
            $menu = $this->menuLogic->getOne('id='.$id);
            if(!$menu)
            {
                return $this->error('id_error', Common::adminURL('admin', 'menu', 'list'));
            }
            $cond  = 'id !=' . $id; 
            $menus = $this->menuLogic->getList($cond);
            $parents = array();
            foreach (Common::_getTree($menus['list']) as $item) {
                $parents[$item['id']] = str_repeat('　', $item['level']) . $item['base_name']; 
            }
             Core::$tpl->set('parentMenus', $parents);
             Core::$tpl->set('menu', $menu);
             Core::$htmlFile  = 'menu/form';
             Core::$isdisplay = 0;
             Core::$tpl->render(Core::$htmlFile . '.htm');

        }
    }
    /**
     * 把多语言菜单的KEY 写入配置文件
     * @param type $lang_key
     * @param type $value 
     */
    public function write_menu($lang_key, $value)
    {    
        $language  = Core::$language;
        $lang_file = APP_ROOT . 'languages' . DIRECTORY_SEPARATOR . $language . DIRECTORY_SEPARATOR . 'menus.lang.php';
        $LANG      = array();
        if (file_exists($lang_file))
        {
             require $lang_file;
        }
       $LANG[$lang_key] = $value;
       $fp  = @fopen($lang_file, "w+"); 
        $val  = '<?php ';
        foreach ($LANG as $key => $_val)
        {
            if($_val){

                $val .= '$LANG[' . "'" . $key . "'] = '" . $_val . "' ; ";
            }

        }
        $val .= '?>';
        @fwrite($fp, $val);
        @fclose($fp);
    }
    public function actionDel()
    {
        $id = Common::queryInt(_g('id'));
        $res = $this->menuLogic->delete('id='.$id);
        //更新缓存
        $this->menuLogic->updateCache();
        return $res ? $this->success('delete_success') : $this->showMessage('delete_failure');
    }
	
	public function actionPublicQuickEdit()
    {
      $id        = Common::queryInt(_p('id'));
      if(!$id)
      {
        echo 0;return;
      }
	  if(!is_numeric(_p('listorder')))
      {
			echo 0;return;  
	  }
      $map = Zhtx::createDataMap();
      $map->addEntry('listorder', Common::queryInt(_p('listorder')), DB::INT);
      $res = $this->menuLogic->update($map, 'id=' . $id);
      echo $res ? 1 : 0;
    }
}

?>
