<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of NavController
 *
 * @author cx
 */
class NavController extends AppController
{
    private $navLogic;
    private $navLanguageLogic;
    private $navJoinLanguageLogic;
    private $languageJoinCountryLogic;
    public function __construct()
    {
        parent::__construct();
        $this->navLogic = $this->load('nav');
		$this->languageLogic = $this->load('language');
        $this->navLanguageLogic = $this->load('navLanguage');
        $this->navJoinLanguageLogic = $this->load('navJoinLanguage');
        $this->languageJoinCountryLogic = $this->load('languageJoinCountry');
    }
   
    public function actionList()
    {
       //$nav_list = $this->navLogic->getList('order by parent_id');
        //$nav_tree = Common::getTree($nav_list['list']);
        //Core::$tpl->set('nav_tree', $nav_tree);
                global $cfg;
		$where = 'language_id='.$cfg['sites'][0]['base_site'];
		$nav     = $this->navJoinLanguageLogic->findALL($where . ' order by parent_id ASC,listorder DESC,id DESC');
		$nav = Common::setTreeData($nav);
		Common::getTree($nav,$nav_tree,0);
                foreach ($nav_tree as $key=>$value)
                {
                    if($value['url'])
                    {
                        $preg = "/[i|\/page\/]+(\d+)\.html/";
                        preg_match($preg, $value['url'] ,$page_id);
                        if($page_id[1])
                        {
                            $nav_tree[$key]['page_id'] = $page_id[1];
                        }else{
                            $urlAlias = $this->load('urlAlisa')->getOne("url='".  substr($value['url'], 1) . "'");
                            $preg = "/navpage_id=(\d+)/";
                            preg_match($preg, $urlAlias['route'] ,$page_id);
                            $nav_tree[$key]['page_id'] = $page_id[1];
                        }
                    }
                }
        Core::$tpl->set('nav_tree', $nav_tree);
    }
    public function actionAdd()
    {
        global $cfg;		
		if(_p())
        {
            $base_site_id = Common::validSiteConfig();
            $lang_name  = _p('lang_name');
            $nav_name = $lang_name[$base_site_id];
            if(!$nav_name)
            {
              return $this->showMessage('default_site_required');
            }
            $nav_map = Zhtx::createDataMap();            
            $parent_id = intval(_p('parent_id'));
            $nav_map->addEntry('parent_id', $parent_id, DB::INT);
            $nav_map->addEntry('base_name', Common::strEscape($nav_name), DB::VARCHAR);
            $nav_map->addEntry('target', Common::strEscape(_p('target')), DB::VARCHAR);
            $nav_map->addEntry('tag_property', Common::strEscape(_p('tag_property')), DB::VARCHAR);
            $nav_map->addEntry('listorder', Common::queryInt(_p('listorder'), 0), DB::INT);
            $nav_map->addEntry('create_time', SYS_TIME, DB::INT);
            $nav_map->addEntry('path_id', '', DB::VARCHAR);
            $nav_map->addEntry('status', 1, DB::INT);
            $res = $this->navLogic->insert($nav_map);
            if($res)
            {
                if(!_p('listorder')){
                    $map = Zhtx::createDataMap(); 
                    $map->addEntry('listorder', 100000-10*$res, DB::INT);
                    $this->navLogic->update($map, 'id='.$res);
                }
                $path_id = "";
                if($parent_id)
                {  
                	$nav = $this->navLogic->getOne('id='.$parent_id);
               		$path_id = $nav['path_id']; 
                }
				$path_id = $path_id . $res . ",";
                $nav_map = Zhtx::createDataMap();
                $nav_map->addEntry('path_id', $path_id, DB::VARCHAR);
                $this->navLogic->update($nav_map, 'id='.$res);
                //多语言处理           
				if ($res)
            	{  
					$languages = $this->languageLogic->findALL('status=1', true);
                    //更新选中的信息                  
                    $is_navpage = _p('is_navpage');
                    $url        = str_replace(array('?', '&', '%'), '-', _p('url'));
                    $is_add_page = FALSE;
                    foreach ($lang_name as $key => $value)
                    {
                      if($value && isset($is_navpage[$key]) && $is_navpage[$key])
                      {
                        $is_add_page = TRUE;
                      }
                    }
                    $navpageres = array();
                    $pagelangLogic = NULL;
                    if($is_add_page)
                    {
                      $navpage_map = Zhtx::createDataMap();
                      $navpage_map->addEntry('base_name', Common::strEscape($nav_name), DB::VARCHAR);
                      $navpage_map->addEntry('type',1, DB::INT);
                      $navpage_map->addEntry('status', 1, DB::INT);
                      $navpageres    = $this->load('navPage')->insert($navpage_map);
                      $pagelangLogic = $this->load('navPageLanguage');
                    }					                    
					foreach ($lang_name as $_key => $_val)
					{
                       if(!$_val)
                       {
                         continue;
                       }
						$navLanguage = Zhtx::createDataMap();
						$navLanguage->addEntry('nav_id', $res, DB::INT);
						$navLanguage->addEntry('language_id', $_key, DB::INT);
						$navLanguage->addEntry('base_name', Common::strEscape($_val), DB::VARCHAR);
						if($is_navpage[$_key])
						{	
                            //更新选中的信息                         
							if ($navpageres)
							{  
								$navpageLanguage = Zhtx::createDataMap();
								$navpageLanguage->addEntry('nav_page_id', $navpageres, DB::INT);
								$navpageLanguage->addEntry('language_id', $_key, DB::INT);
								$navpageLanguage->addEntry('base_name', Common::strEscape($_val), DB::VARCHAR);
								$pagelangLogic->insert($navpageLanguage);
								if($cfg['sites'][$item["id"]]['rewrite_type']==0)
								{
									$theurl = FOLDER_ROOT."page/".$navpageres.".html";
								}
								else if($cfg['sites'][$item["id"]]['rewrite_type']==1)
								{
									$theurl = FOLDER_ROOT."page/".$navpageres.".html";
								}
								else if($cfg['sites'][$item["id"]]['rewrite_type']==2)
								{
									$theurl = FOLDER_ROOT."page/".$navpageres.".html";
								}
								$navLanguage->addEntry('url', Common::strEscape($theurl), DB::VARCHAR);
							}
						}
						else
                        {
							$navLanguage->addEntry('url', Common::strEscape($url[$_key]), DB::VARCHAR);
                        }						
						$this->navLanguageLogic->insert($navLanguage);                       
					} 
				}
				return $this->success('add_success', Common::adminURL('admin', 'nav', 'list'));
            }
			else
				return $this->success('add_failure', Common::adminURL('admin', 'nav', 'list'));
        }
        else
        {            
            $nav_list = $this->navLogic->getList("order by parent_id asc,listorder desc,id DESC");
            $nav_tree = array();
			$nav_list = Common::setTreeData($nav_list["list"]);
			Common::getTree($nav_list,$nav_tree,0);
            foreach ($nav_tree as $item) {     
                $nav_tree[$item['id']] = str_repeat('　', $item['level']) . $item['base_name']; 
            }
            Core::$tpl->set('nav_tree', $nav_tree);  
            $languages = $this->languageJoinCountryLogic->getList('l.status=1');
            core::$tpl->set('languages', $languages['list']);
			core::$tpl->set('parent_id', _g('parent_id'));
			
        }
    }
    public function actionEdit()
    {
        if(_p())
        {        
			$id = Common::queryInt(_p('id'));
            $base_site_id = Common::validSiteConfig();
            $nav_name = _p('base_name'.$base_site_id);
            if(!$nav_name)
            {
              return $this->showMessage('default_site_required');
            }

            $parent_id = intval(_p('parent_id'));            
            $nav_map = Zhtx::createDataMap();
            $nav_map->addEntry('parent_id', $parent_id, DB::INT);
            $nav_map->addEntry('base_name', Common::strEscape($nav_name), DB::VARCHAR);
            $nav_map->addEntry('target', Common::strEscape(_p('target')), DB::VARCHAR);
            $nav_map->addEntry('tag_property', Common::strEscape(_p('tag_property')), DB::VARCHAR);
            $nav_map->addEntry('status', _p('status')?_p('status'):1, DB::INT);
            $nav_map->addEntry('listorder', (int)$_POST['listorder']?$_POST['listorder']:1, DB::INT);
            $nav_map->addEntry('create_time', SYS_TIME, DB::INT);
            $nav_map->addEntry('path_id', '', DB::VARCHAR);
            
            $res = $this->navLogic->update($nav_map, 'id='.$id);
            if($res)
            { 
                $path_id = "";
                if($parent_id)
                {  
                	$nav = $this->navLogic->getOne('id='.$parent_id);
               		$path_id = $nav['path_id']; 
                }
				$path_id = $path_id . $id . ",";
				$nav_map = Zhtx::createDataMap();
                $nav_map->addEntry('path_id', $path_id, DB::VARCHAR);
                $this->navLogic->update($nav_map, 'id='.$id);
                //多语言处理               
                $languages = $this->languageLogic->findALL('status=1', true);
                //更新选中的信息
                foreach ($languages as $item)
                {
                    $url        = str_replace(array('?', '&', '%'), '-', _p('url'.$item["id"]));
                    $navLanguage = Zhtx::createDataMap();
                    $navLanguage->addEntry('nav_id', $id, DB::INT);
                    $navLanguage->addEntry('language_id', $item["id"], DB::INT);
                    $navLanguage->addEntry('base_name', Common::strEscape(_p('base_name'.$item["id"])), DB::VARCHAR);
                    $navLanguage->addEntry('url', Common::strEscape($url), DB::VARCHAR);
                    $values = $item["id"];
                    if ($this->navLanguageLogic->getOne("nav_id = {$id} AND language_id = {$values}"))
                    {
                        $this->navLanguageLogic->update($navLanguage, "nav_id = {$id} AND language_id = {$values}");
                    }
                    else
                    {
                        $this->navLanguageLogic->insert($navLanguage);
                    } 
                                      
                }
                 //清除缓存
				$this->navLanguageLogic->updateCache();
                return $this->success('edit_success', Common::adminURL('admin', 'nav', 'list'));
            }
      		else
            {
				return $this->showMessage('edit_failure', Common::adminURL('admin', 'nav', 'list'));
            }
        }
        else
        {
            $id = Common::queryInt(_g('id'));
            $nav = $this->navLogic->getOne('id='.$id);
            if(!$nav)
            {
                return $this->success('id_error', Common::adminURL('admin', 'nav', 'list'));
            }
			
            $languages = $this->languageJoinCountryLogic->getList('l.status=1');
			$cond = 'nav_id = ' . $id;
			$navpagelang = $this->navLanguageLogic->getList($cond);
			$navpagelang_arr = array();
			foreach ($navpagelang['list'] as $value)
			{
				$navpagelang_arr[$value['language_id']] = $value;
			}
			$nav_list = $this->navLogic->getList("id !=".$id . " order by parent_id asc,listorder desc,id DESC");
            $nav_list = Common::setTreeData($nav_list["list"]);
			Common::getTree($nav_list,$nav_tree,0);
            foreach ($nav_tree as $item) {     
                $nav_tree[$item['id']] = str_repeat('　', $item['level']) . $item['base_name']; 
            }
            Core::$tpl->set('nav_tree', $nav_tree);
            Core::$tpl->set('nav', $nav);
			Core::$tpl->set('navLanguage', $navpagelang_arr);
            Core::$tpl->set('languages', $languages["list"]);
        }
    }
   /**
     * 删除
     * @return type 
     */
    public function actionDel()
    {
        $nav_id = Common::queryInt(_g('id'));
        $nav    = $this->navLogic->getOneById($nav_id);
        if(!$nav)
        {
          return $this->showMessage('illegal_parameters');
        }
        $cond  = 'path_id like "' . $nav['path_id'] . '%"';
        $count = $this->navLogic->getCount($cond);
        if ($count > 1)
        {            
            return $this->showMessage('has_child_not_delete');
        }
        $res = $this->navLogic->delete('id=' . $nav_id);
        if($res)
        {
          $this->navLanguageLogic->updateCache();
          $this->navLanguageLogic->delete('nav_id=' . $nav_id);          
        }
        return $this->_redirect(Common::adminURL('admin', 'nav', 'list'));
    }   
	public function actionPublicEditSort()
    {
      $id        = Common::queryInt(_p('id'));
      if(!$id)
      {
        echo 0;return;
      }
	  if(!is_numeric(_p('listorder')))
      {
			echo 0;return;  
	  }
      $map = Zhtx::createDataMap();
      $map->addEntry('listorder', Common::queryInt(_p('listorder')), DB::INT);
      $res = $this->navLogic->update($map, 'id=' . $id);
      $this->navLanguageLogic->updateCache();
      echo $res ? 1 : 0;
    }
	
	public function actionPublicEditStatus()
    {
        $id     = Common::queryInt(_g('id'));
        $cat = $this->navLogic->getOneById($id);
        if(!$cat)
        {
            return $this->showMessage('illegal_parameters');
        }
        $status = _g('currentStatus') ? 1 : 0;
        $data['status']  = $status;
        $map    = Zhtx::createDataMap();
        $map->addEntry('status', $status, DB::INT);
        $res   =  $this->navLogic->updateById($map, $id);
        if($res){
            $cond = 'path_id like "' . $cat['path_id'] . '%" and id !=' . $id;
            $cat_res = $this->navLogic->findAll($cond);
            $nav_category_ids = array();
            foreach($cat_res as $value){
                $nav_category_ids[] =$value['id'];
            }
            $cond = 'id in (' . implode(',', $nav_category_ids) .','.$id.')';
            $this->navLogic->saveByCond($data, $cond);
        }
        $this->navLanguageLogic->updateCache();
        echo $res ? 1 : 0;
    }
}
?>
