<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of NavpageController
 *
 * @author cx
 */
class NavpageController extends AppController
{
    private $navPageLogic;
    private $navPageLanguageLogic;
    private $languageLogic;
    public function __construct()
    {
        parent::__construct();
        $this->navPageLogic = $this->load('navPage');
		$this->languageJoinCountryLogic = $this->load('languageJoinCountry');
        $this->navPageLanguageLogic = $this->load('navPageLanguage');
        $this->languageLogic = $this->load('language');
    }
    public function actionList()
    {
        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'),1);        
		$where = '1=1';
        if(_g('base_name'))
        {
            $where .= " and base_name like '%" . _g('base_name') . "%'";
        }
		$where .= " ORDER BY id DESC";		
        //获取数据
        $res = $this->navPageLogic->getCurrentDatas($where, $page_size, $curr_page);
        //分页
        $count = $this->navPageLogic->getCount($where);
        $page_list = Common::getPages($count, $curr_page, $page_size);
        Core::$tpl->set('res', $res);
        Core::$tpl->set('pages', $page_list);
    	
	}
    public function actionAdd()
    {
        if(_p())
        {
            $base_site_id = Common::validSiteConfig();
            $base_name = _p('base_name'.$base_site_id);
            if(!$base_name)
            {
              return $this->showMessage('default_site_required');
            }
                $navpage_map = Zhtx::createDataMap();
                $navpage_map->addEntry('base_name', Common::strEscape($base_name), DB::VARCHAR);
                $navpage_map->addEntry('type',Common::queryInt( _p('type')), DB::INT);
                $navpage_map->addEntry('status', Common::queryInt(_p('status')), DB::INT);				
                $res = $this->navPageLogic->insert($navpage_map);          		
				if ($res)
            	{  
					$languages = $this->languageLogic->findALL('status=1', true);
					//更新选中的信息
					foreach ($languages as $item)
					{
                        $data = array(
                            'nav_page_id' => $res,
                            'language_id' => $item["id"],
                            'base_name'   => Common::strEscape(_p('base_name'.$item["id"])),
                            'title'       => Common::strEscape(_p('title'.$item["id"])),
                            'keywords'    => Common::strEscape(_p('keywords'.$item["id"])),
                            'descript'    => Common::strEscape(_p('descript'.$item["id"])),
                            'detail'      => Common::strEscape(Inputer::getOrgPost('detail'.$item["id"]),false),
                        );
						
						$this->navPageLanguageLogic->save($data);
					}                   
                    $diy_url_flag = TRUE;
                    if (_p('page_url'))
                    {
                        $diyUrlLogic = $this->load('urlAlisa');
                        $true_url    = Common::frontURL('home', 'navpage', 'detail', array('navpage_id' => $res), FALSE);
                        $page_url = str_replace(array('?', '&', '%'), '-', _p('page_url'));
                        $diy_res     = $diyUrlLogic->createDiyUrl($page_url, $true_url);
                        if ($diy_res)
                        {
                            $new_cat_map = Zhtx::createDataMap(); 
                            $new_cat_map->addEntry('page_url', Common::strEscape($page_url), DB::VARCHAR);
                            $this->navPageLogic->updateById($new_cat_map, $res);
                        }
                        else
                        {
                          $diy_url_flag = FALSE;
                        }                    
                    }            
                   return $diy_url_flag ? $this->success('add_success', Common::adminURL('admin', 'navpage', 'list')) : $this->showMessage('diy_url_already_exists');
				}
				else
					return $this->success('add_failure', Common::adminURL('admin', 'navpage', 'list'));
        }
		else
		{
			$languages = $this->languageJoinCountryLogic->getList('l.status=1');
            Core::$tpl->set('languages', $languages["list"]);	
		}
    }
    public function actionEdit()
    {
        if(_p())
        {
			$base_site_id = Common::validSiteConfig();
            $base_name = _p('base_name'.$base_site_id);
            if(!$base_name)
            {
              return $this->showMessage('default_site_required');
            }
            $id = Common::queryInt(_p('id'));
			$navpage_map = Zhtx::createDataMap();
			$navpage_map->addEntry('base_name', Common::strEscape($base_name), DB::VARCHAR);
			$navpage_map->addEntry('type', Common::queryInt(_p('type')), DB::INT);
			$navpage_map->addEntry('status', Common::queryInt(_p('status')), DB::INT);			
			$res = $this->navPageLogic->update($navpage_map, 'id='.$id);
			if ($res)
			{  
				$languages = $this->languageLogic->findALL('status=1', true);
				//更新选中的信息
				foreach ($languages as $key=>$item)
				{					
					$data = array(
                            'nav_page_id' => $id,
                            'language_id' => $item["id"],
                            'base_name'   => Common::strEscape(_p('base_name'.$item["id"])),
                            'title'       => Common::strEscape(_p('title'.$item["id"])),
                            'keywords'    => Common::strEscape(_p('keywords'.$item["id"])),
                            'descript'    => Common::strEscape(_p('descript'.$item["id"])),
                            'detail'      => Common::strEscape(Inputer::getOrgPost('detail'.$item["id"]),false),
                        );
                    $cond = "nav_page_id =". $id . " AND language_id =" . $item["id"];
                    $is_exist = $this->navPageLanguageLogic->getOne($cond);
					$is_exist_id = 	$is_exist ? $is_exist['id'] : 0;
                    $this->navPageLanguageLogic->save($data, $is_exist_id);
                    //清除缓存
                    $this->navPageLanguageLogic->delCache($id, $item["id"]);
				}               
                $diy_url_flag = TRUE;                
                $diyUrlLogic = $this->load('urlAlisa');
                $true_url    = Common::frontURL('home', 'navpage', 'detail', array('navpage_id' => $id), FALSE);
                $page_url = str_replace(array('?', '&', '%'), '-', _p('page_url'));
                $diy_res     = $diyUrlLogic->createDiyUrl($page_url, $true_url);
                if ($diy_res)
                {
                    $new_cat_map = Zhtx::createDataMap(); 
                    $new_cat_map->addEntry('page_url', Common::strEscape($page_url), DB::VARCHAR);
                    $this->navPageLogic->updateById($new_cat_map, $id);
                }
                else
                {
                    $diy_url_flag = FALSE;
                }                    
                return $diy_url_flag ? $this->success('edit_success', Common::adminURL('admin', 'navpage', 'list')) : $this->showMessage('diy_url_already_exists');
			}
				return $this->error('edit_failure', Common::adminURL('admin', 'navpage', 'list'));

        }
        else
        {
            $id = Common::queryInt(_g('id'));
            $cond = 'id = ' . $id;
            $navpage = $this->navPageLogic->getOne($cond);
            if(!$navpage)
            {
            	return $this->success('id_error', Common::adminURL('admin', 'navpage', 'list'));
            }
			
			$languages = $this->languageJoinCountryLogic->getList('l.status=1');
			$cond = 'nav_page_id = ' . $id;
			$navpagelang = $this->navPageLanguageLogic->getList($cond);
			$navpagelang_arr = array();
			foreach ($navpagelang['list'] as $value)
			{
				$navpagelang_arr[$value['language_id']] = $value;
			}
            Core::$tpl->set('navpage', $navpage);
			Core::$tpl->set('navpageLanguage', $navpagelang_arr);
            Core::$tpl->set('languages', $languages["list"]);
        }
        
    }
    public function actionDel()
    {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if(!empty($ids))
        {
          $num = 0;
          foreach ($ids as $id)
          {
                $navPage = $this->navPageLogic->getOneById($id);
                $this->load('urlAlisa')->deleteDiyUrl($navPage['page_url']);
                $res  = $this->navPageLogic->delete('id=' . $id);
                if($res)
                { 
                  $this->navPageLanguageLogic->delCache($id);
                  $this->navPageLanguageLogic->delete('nav_page_id =' . $id);                  
                  $num++;
                }
          }
          $staus = 1;
          $flag = $lang['success_delete']. $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }
    
    public function actionPublicEditStatus()
    {
        $id     = Common::queryInt(_g('id'));
        $status = _g('currentStatus') ? 1 : 0;
        $map    = Zhtx::createDataMap();
        $map->addEntry('status', $status, DB::INT);
        $res   =  $this->navPageLogic->updateById($map, $id);
        $this->navPageLanguageLogic->delCache($id);
        echo $res ? 1 : 0;
    }
    
}
?>
