<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Payment
 *
 * @author huangjp@35zh.cn
 */
class PaymentController extends AppController
{
    private $paymentlogic;
    private $languageJoinCountryLogic;
    private $paymentLanguageLogic;
    private $languageLogic;
    public function __construct()
    {
        parent::__construct();
        $this->paymentlogic = $this->load("payment");
        $this->languageJoinCountryLogic = $this->load('languageJoinCountry');
        $this->paymentLanguageLogic = $this->load('PaymentLanguage');
		$this->languageLogic = $this->load('language');
    }   
    public function actionList()
    {
        $cond = 'ORDER BY listorder DESC,id DESC';
        $res = $this->paymentlogic->findAll($cond);
        Core::$tpl->set('res', $res);
        Core::$tpl->set('languages', $this->languageLogic->findAll('1=1', true));
    }
    /**
     * 添加支付方式
     * @return type 
     */
    public function actionAdd()
    {
        if(_p())
        {
            $name=  Common::strEscape(_p("base_name"));
            $language_id  = Common::queryInt(_p('language_id'));
            $cond = 'base_name="' . $name . '" and language_id=' . $language_id ;
            $count = $this->paymentlogic->getCount($cond);
            if($count > 0)
            {
               return $this->showMessage('one_language_has_payment');
            }
            if(!$name)
            {
              return $this->showMessage('payment_name_not_empty');
            }
			$config_param = array();
			foreach ($_POST as $key => $value)
			{
				if (strpos($key, "exp_") !== false)
				{
					$config_param[$key] = $value;
				}
			}
			$config_param = json_encode($config_param);			
            $data = array(
                'base_name' => $name,
                'formula'   => _p("formula"),
                'config_param'   => Common::strEscape($config_param,false),
                'interface_type' => _p("interface_type"),
                'image' => Common::strEscape(_p("image")),
                'href'  => Common::strEscape(_p("href")),
                'listorder' => Common::queryInt(_p("listorder")),
                'status'    => Common::queryInt(_p("status")),
                'language_id' => Common::queryInt(_p("language_id")),
                'post_language_id' => Common::queryInt(_p("post_language_id")),
                'descript'    => Common::strEscape(_p('descript')),
                'detail'    => Common::strEscape(Inputer::getOrgPost('detail'),false),
                'min_order_amount' => Common::queryInt(_p("min_order_amount")),
                'max_order_amount' => Common::queryInt(_p("max_order_amount")),
                'create_time' => SYS_TIME,
                'is_billing' => Common::queryInt(_p("is_billing"),0),             
            );
			$res = $this->paymentlogic->save($data);
                        if($res){
                            if(!_p('listorder')){
                                $map = Zhtx::createDataMap(); 
                                $map->addEntry('listorder', 10*$res, DB::INT);
                                $this->paymentlogic->update($map, 'id='.$res);
                            }
                        }
            return $res ? $this->success('add_success', Common::adminURL('admin', 'payment', 'list')) : $this->error('add_failure');
        }
        else
        {
            $languages = $this->languageJoinCountryLogic->findAll('1=1');
            Core::$tpl->set('languages', $languages);
            Core::$tpl->set('paymentlist', $this->getApiType(APP_ROOT.'api/payment/'));
			Core::$tpl->set('formulalist', $this->getApiType(APP_ROOT.'api/paymentformula/'));
            Core::$htmlFile  = 'payment/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }
    
    public function actionEdit()
    {
        if(_p())
        {
            $id   = Common::queryInt(_p('id'));
            $name = Common::strEscape(_p("base_name"));
            $language_id  = Common::queryInt(_p('language_id'));
            $cond = 'base_name="' . $name . '" and language_id=' . $language_id . ' and id !=' . $id;
            $count = $this->paymentlogic->getCount($cond);
            if($count > 0)
            {
               return $this->showMessage('one_language_has_payment');
            }
			$config_param = array();
			foreach ($_POST as $key => $value)
			{
				if (strpos($key, "exp") !== false)
				{
					$config_param[$key] = $value;
				}
			}
			$config_param = json_encode($config_param);
            $data = array(
                'base_name' => $name,
                'formula'   => _p("formula"),
                'config_param'   => Common::strEscape($config_param,false),
                'interface_type' => _p("interface_type"),
                'image' => Common::strEscape(_p("image")),
                'href'  => Common::strEscape(_p("href")),
                'listorder' => Common::queryInt(_p("listorder")),
                'status'    => Common::queryInt(_p("status")),
                'language_id' => $language_id,
                'post_language_id' => Common::queryInt(_p("post_language_id")),                
                'min_order_amount' => Common::queryInt(_p("min_order_amount")),
                'max_order_amount' => Common::queryInt(_p("max_order_amount")),
                'descript'    => Common::strEscape(_p('descript')),
                'detail'      => Common::strEscape(Inputer::getOrgPost('detail'),false),
                'is_billing' => Common::queryInt(_p("is_billing"),0),                 
            );
			$res = $this->paymentlogic->save($data, $id);
            return $res ? $this->success('add_success', Common::adminURL('admin', 'payment', 'list')) : $this->error('add_failure');           
        }
        else
        {
            $id = Common::queryInt(_g('id'));
            $payment = $this->paymentlogic->getOne('id='.$id);
            if(!$payment)
			{
               return $this->error('id_error', Common::adminURL('admin', 'payment', 'list'));
            }
            $languages = $this->languageJoinCountryLogic->findAll('1=1');			
            Core::$tpl->set('languages', $languages);
            Core::$tpl->set('payment', $payment);
            Core::$tpl->set('paymentlist', $this->getApiType(APP_ROOT.'api/payment/'));
			Core::$tpl->set('formulalist', $this->getApiType(APP_ROOT.'api/paymentformula/'));
            Core::$htmlFile  = 'payment/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');           
        }
    }

    /**
     * ajax 获取支付配置参数html表单
     */
    public function actionPublicGetPayFormulaform()
    {
		$id =  _g("id");
        $folder =  _g("folder");
		$cond="id={$id}";
        $payment = $this->paymentlogic->getOne($cond);
		if($payment)
        {
            $param=array();
			if($payment["config_param"]!="")
            {
                $param = json_decode($payment["config_param"],true);
            }
        }
		if(is_file(APP_ROOT.'api/paymentformula/'.$folder.'/form.php'))
		{
			require_once APP_ROOT.'api/paymentformula/'.$folder.'/form.php';
		}
		exit();
    }
	
	 public function actionPublicGetPayform()
    {
		$id =  _g("id");
        $folder =  _g("folder");
		$cond="id={$id}";
		if(!$folder)
		{
			echo "";
			die();
		}
        $payment = $this->paymentlogic->getOne($cond);
        if($payment)
        {
            $param=array();
			if($payment["config_param"]!="")
            {
                $param = json_decode($payment["config_param"],true);
            }
        }
		if(is_file(APP_ROOT.'api/payment/'.$folder.'/form.php'))
		{
			require_once APP_ROOT.'api/payment/'.$folder.'/form.php';
		}
		exit();
    }
	
	public function actionPublicEditStatus()
    {
        $id     = Common::queryInt(_g('id'));
        $status = _g('currentStatus') ? 1 : 0;
        $map    = Zhtx::createDataMap();
        $map->addEntry('status', $status, DB::INT);
        $res   =  $this->paymentlogic->updateById($map, $id);
        echo $res ? 1 : 0;
    }
	
	 private function getApiType($folder)
    {
        $formula = array();
        $fp = opendir($folder);
        while ($file = readdir($fp))
        {
            if ($file != '.' && $file != '..'&& $file != '.svn')
            {
               if( is_dir( $folder.$file ) )
			   {
				   $formula_item = array();
				   $formula_item["name"] = trim(file_get_contents($folder . $file . '/readme.txt'));
				   $formula_item["type"] = trim($file);
				   $formula[] = $formula_item;
			   }
			}
        }
        closedir($fp);
        return $formula;
    }
    public function actionDel()
    {
      $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
      $ids = _p('ids');
      $staus = 0;
      $flag = $lang['illegal_operation'];
      if(!empty($ids))
      {
        $num = 0;
        foreach ($ids as $id)
        {
           $res  = $this->paymentlogic->delete('id=' . $id);
           if($res)
           {
             $this->paymentLanguageLogic->delete('payment_id=' . $id);
             $num++;
           }
        }
        $staus = 1;
        $flag = $lang['success_delete']. $num . $lang['num_records'];
      }
      echo json_encode(array('status' => $staus, 'msg' => $flag));
    }
	
	public function actionPublicQuickEdit()
    {
      $id        = Common::queryInt(_p('id'));
      if(!$id)
      {
        echo 0;return;
      }
	  if(!is_numeric(_p('listorder')))
      {
			echo 0;return;  
	  }
	  $listorder   = Common::queryInt(_p('listorder'));
      $map = Zhtx::createDataMap();
      $map->addEntry('listorder', $listorder, DB::INT);
      $res = $this->paymentlogic->update($map, 'id=' . $id);
      echo $res ? 1 : 0;
    }
}

?>
