<?php
/**
 * Description of AdminRole
 *
 * @author XRX
 */
class RoleController extends AppController
{
    private $roleLogic;
    private $menuLogic;
    private $roleMenuLogic;
    public function __construct() {
        parent::__construct();
        $this->roleLogic = $this->load('role');
        $this->menuLogic = $this->load('adminMenu');
        $this->roleMenuLogic = $this->load('adminRolePriv');
    }
    /**
     * 添加角色 权限设置的脚本暂时未处理
     */
    public function actionAdd()
    {
        if(_p())    
        {           
            $adminRole = $_POST;
			$role_map = Zhtx::createDataMap();
			$role_map->addEntry('rolename', Common::strEscape($adminRole['rolename']), DB::VARCHAR);
			$role_map->addEntry('description', Common::strEscape($adminRole['description']), DB::VARCHAR);
			$role_map->addEntry('listorder', $adminRole['listorder'] ? $adminRole['listorder'] : 1, DB::INT);
			$res = $this->roleLogic->insert($role_map);
			if($res)
			{
				if(_p('menu_id'))
				{
						$this->roleMenuLogic->saveAll($res, _p('menu_id'));
				}
				//更新缓存
				$this->roleMenuLogic->updateCache($res, _p('menu_id'));
			}
			if($res)
				return $this->success('add_success', Common::adminURL('admin', 'role', 'list'));
			else
				return $this->error('add_failure', Common::adminURL('admin', 'role', 'list'));
            
        }
        else
        {
            $menus = $this->menuLogic->getList();            
            Core::$tpl->set('menus', Common::_getTree($menus['list']));
            Core::$htmlFile  = 'role/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }
    /**
     * 查询角色列表 
     */
    public function actionList()
    {
        $where = 'ORDER BY listorder DESC,id DESC';
        $roles = $this->roleLogic->getList($where);
        Core::$tpl->set("roles", $roles['list']);
//        print_r($roles);exit();
    }
    /**
     * 编辑角色 权限的那一块还需慎重考虑
     * @return type 
     */
    public function actionEdit()
    { 
        if(_p())
        {
            	$role_id = Common::queryInt(_p('id'));
            	$rolename = $_POST['rolename'];
                $cond = 'id = '.$role_id;
                $role_map = Zhtx::createDataMap();           
                $role_map->addEntry('rolename', Common::strEscape($rolename), DB::VARCHAR);
                $role_map->addEntry('description', Common::strEscape($_POST['description']), DB::VARCHAR);
                $role_map->addEntry('listorder', Common::queryInt($_POST['listorder']), DB::INT);
                $role_map->addEntry('disabled', $_POST['disabled'], DB::INT);
                $res = $this->roleLogic->update($role_map , $cond); 
                if($res)
                {
                    //查找当前角色的菜单
                    $conds = 'role_id='.$role_id;
                    $my_menus = $this->roleMenuLogic->getList($conds);
                    $my_menus_arr = array();
                    $my_menu_ids = array();
                    foreach ($my_menus['list'] as $value) {
                        $my_menus_arr[$value['admin_menu_id']] = $value['id'];
                        $my_menu_ids[] = $value['admin_menu_id'];
                    }
                    $menuIds = _p('menu_id');                   
                    foreach($menuIds as $value)
                    {
                        if(!isset($my_menus_arr[$value]))
                        {
                            $priv_map = Zhtx::createDataMap();
                            $priv_map->addEntry('role_id', $role_id, DB::INT);
                            $priv_map->addEntry('admin_menu_id', $value, DB::INT);
                            $this->roleMenuLogic->insert($priv_map);
                        }
                        
                    }                    
                    //删除移除的权限
                    $del_menus = array_diff($my_menu_ids, $menuIds);
                    if(!empty($del_menus))
                    {
                        foreach ($del_menus as $item)
                        {
                            if(isset($my_menus_arr[$item]))
                            {
                                $this->roleMenuLogic->delete('id='.$my_menus_arr[$item]);
                            }
                        }
                    }
                    //更新缓存
                    $this->roleMenuLogic->updateCache($role_id, $menuIds);
                }
                
                if($res)
					return $this->success('edit_success', Common::adminURL('admin', 'role', 'list'));
				else
					return $this->error('edit_failure', Common::adminURL('admin', 'role', 'list'));
            
        }
        else
        {
            $role_id = Common::queryInt(_g('id'));
            $role = $this->roleLogic->getOneById($role_id);			
            if(!$role)
                return $this->error('id_error', Common::adminURL('admin', 'role', 'list'));
            //查找当前角色的菜单
            $conds = 'role_id='.$role_id;
            $my_menus = $this->roleMenuLogic->getList($conds);
            $my_menus_arr = array();
            foreach ($my_menus['list'] as $value) {
                $my_menus_arr[$value['admin_menu_id']] = $value;
            }
            //查询所有权限菜单
            $menus = $this->menuLogic->getList(); 
            $menus_array = array();
            foreach ($menus['list'] as  $key => $menu) {                
                $menu['my'] = isset($my_menus_arr[$menu['id']]) ? 1 : 0;
                $menus_array[$key] = $menu;
            }
//            print_r(Common::_getTree($menus_array));die;
            Core::$tpl->set('menus', Common::_getTree($menus_array));
            Core::$htmlFile  = 'role/form';
			Core::$tpl->set('role', $role);
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
          
    }
    public function actionDel() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if(!empty($ids))
        {
          $num = 0;
          foreach ($ids as $id)
          {
               if($id != 1)
               {
                $res  = $this->roleLogic->delete('id=' . $id);
                if($res)
                {    
                  $this->roleMenuLogic->delete('role_id=' . $id);
                  $num++;
                }
               }
          }
          $staus = 1;
          $flag = $lang['success_delete']. $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }
    /**
     * ajax 更新状态
     */
    public function actionPublicEditStatus()
    {
        $id     = Common::queryInt(_g('id'));
        $status = _g('currentStatus');
        $map    = Zhtx::createDataMap();
        $map->addEntry('disabled', $status, DB::INT);
        $res    = $this->roleLogic->updateById($map, $id);
        echo $res ? 1 : 0;
    }
	
	public function actionPublicEditSort()
    {
      $id        = Common::queryInt(_p('id'));
      if(!$id)
      {
        echo 0;return;
      }
	  if(!is_numeric(_p('listorder')))
      {
			echo 0;return;  
	  }
      $map = Zhtx::createDataMap();
      $map->addEntry('listorder', Common::queryInt(_p('listorder')), DB::INT);
      $res = $this->roleLogic->update($map, 'id=' . $id);
      echo $res ? 1 : 0;
    } 
}

?>
