<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Payment
 *
 * @author huangjp@35zh.cn
 */
class SearchkeywordsController extends AppController
{
    private $searchkeywordsLogic;
    private $languageLogic;
    public function __construct()
    {
        parent::__construct();
        $this->searchkeywordsLogic = $this->load("searchkeywords");
        $this->languageLogic = $this->load("language");
    } 
    
    public function actionList()
    {
        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'),1);        
		$where = '1=1';
        if(_g('base_name'))
        {
            $where .= " and base_name like '%" . _g('base_name') . "%'";
        }
		if(_g('order')=='weight')
			$where .= " ORDER BY listorder DESC,search_num desc";
		else
			$where .= " ORDER BY id DESC,listorder desc";		
        //获取数据
        $res = $this->searchkeywordsLogic->getCurrentDatas($where, $page_size, $curr_page);
        //分页
        $count = $this->searchkeywordsLogic->getCount($where);
        $page_list = Common::getPages($count, $curr_page, $page_size);
        Core::$tpl->set('res', $res);
        Core::$tpl->set('pages', $page_list);  
        $cols = array('id','base_name');
        $languages = $this->languageLogic->getCols('1=1', $cols, TRUE);
        Core::$tpl->set('languages', $languages);  
    }
    
    public function actionAdd()
    {
        if(_p())
        {
            $name= trim( Common::strEscape(_p("base_name")));
            if(!$name)
            {
              return $this->showMessage('searchkeywords_not_empty');
            }	
            $data = array(
                'base_name' => $name,
                'result_num'  => Common::queryInt(_p("result_num")),
                'listorder' => Common::queryInt(_p("listorder")),
                'status'    => Common::queryInt(_p("status")),
                'language_id' => Common::queryInt(_p("language_id")),
                'search_num' => Common::queryInt(_p("search_num"))
            );
	    $res = $this->searchkeywordsLogic->save($data);
            return $res ? $this->success('add_success', Common::adminURL('admin', 'searchkeywords', 'list')) : $this->error('add_failure'); 
        }
        else
        {
            $cols = array('id','base_name');
            $languages = $this->languageLogic->getCols('1=1', $cols, TRUE);
            Core::$tpl->set('languages', $languages);    
            Core::$htmlFile  = 'searchkeywords/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');       
        }
    }
    
    public function actionEdit()
    {
        if(_p())
        {
            $id = Common::queryInt(_p('id'));
            $name= trim( Common::strEscape(_p("base_name")));
            if(!$name)
            {
              return $this->showMessage('searchkeywords_not_empty');
            }	
            $data = array(
                'base_name' => $name,
                'result_num'  => Common::queryInt(_p("result_num")),
                'listorder' => Common::queryInt(_p("listorder")),
                'status'    => Common::queryInt(_p("status")),
                'language_id' => Common::queryInt(_p("language_id")),
                'search_num' => Common::queryInt(_p("search_num"))
            );
	    $res = $this->searchkeywordsLogic->save($data,$id);
            return $res ? $this->success('edit_success', Common::adminURL('admin', 'searchkeywords', 'list')) : $this->error('edit_failure'); 
        }
        else
        {   $id = Common::queryInt(_g('id'));
            $cond = 'id = ' . $id;
            $searchkeywords = $this->searchkeywordsLogic->getOne($cond);
            if(!$searchkeywords)
            {
            	return $this->success('id_error', Common::adminURL('admin', 'searchkeywords', 'list'));
            }
            $cols = array('id','base_name');
            $languages = $this->languageLogic->getCols('1=1', $cols, TRUE);
            Core::$tpl->set('languages', $languages);       
            Core::$tpl->set('searchkeywords', $searchkeywords);
            Core::$htmlFile  = 'searchkeywords/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');     
        }
    }
    
    public function actionPublicEditStatus()
    {
        $id     = Common::queryInt(_g('id'));
        $status = _g('currentStatus') ? 1 : 0;
        $data=array();
        $data['status'] = $status;
        $res   =  $this->searchkeywordsLogic->save($data, $id);
        echo $res ? 1 : 0;
    }
    
    public function actionPublicEditSort()
    {
        $id     = Common::queryInt(_p('id'));
        $listorder= Common::queryInt(_p('listorder'),0);
        $data=array();
        $data['listorder'] = $listorder;
        $res   =  $this->searchkeywordsLogic->save($data, $id);
        echo $res ? 1 : 0;
    }
    
    public function actionDel()
    {
        $id = Common::queryInt(_g('id'));
        $cond=' id= '.$id;
        $searchkeywords    = $this->searchkeywordsLogic->getOne($cond);
        if(!$searchkeywords)
        {
          return $this->showMessage('illegal_parameters');
        }
        $res = $this->searchkeywordsLogic->delete('id=' . $id);
        return $this->_redirect(Common::adminURL('admin', 'searchkeywords', 'list'));
    }
    
    public function actionBatchDel() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if (!empty($ids)) {
            $num = 0;
            foreach ($ids as $id) {
                $res = $this->searchkeywordsLogic->delete('id=' . $id);
                if ($res) {
                    $num++;
                }
            }
            $staus = 1;
            $flag = $lang['success_delete'] . $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

    public function actionPublicEditSearchNum() {
        $id = Common::queryInt(_p('id'));
        $search_num = Common::queryInt(_p('search_num'), 0);
        $data = array();
        $data['search_num'] = $search_num;
        $res = $this->searchkeywordsLogic->save($data, $id);
        echo $res ? 1 : 0;
    }

    
    public function actionBatchAdd() {
        if (_p()) {
            $name = trim(Common::strEscape(_p("base_name")));
            $listorder = _p("listorder");
            if (!$name) {
                return $this->showMessage('searchkeywords_not_empty');
            }
            if (!$listorder) {
                return $this->showMessage('listorder_not_empty');
            }
            $name = str_replace("\\r", "", $name);
            $name = str_replace("\\n", ",", $name);
            $nameArr = explode(",", $name);
            foreach ($nameArr as $val) {
				$val = trim($val) ;
                $Tbasename = $this->searchkeywordsLogic->getOne("base_name='" . $val . "'");
                if ($Tbasename) {
                    continue;
                }
                $data = array(
                    'base_name' => $val,
                    'result_num' => 0,
                    'listorder' => $listorder,
                    'status' => 1,
                    'language_id' => 0,
                    'search_num' => 0
                );
                $res = $this->searchkeywordsLogic->save($data);
            }
            return $this->success('add_success', Common::adminURL('admin', 'searchkeywords', 'list')) ;
        } 
    }
}
?>
