<?php

/**
 * Description of seotpl
 *
 * @author HHH
 */
class SeotplController extends AppController
{

    private $seotplLogic;
    private $seotplLanguageLogic;
    private $languageJoinCountryLogic;

    /**
     * 初始化程序
     */
    public function __construct()
    {
        parent::__construct();
        $this->seotplLogic = $this->load('seotpl');
        $this->languageJoinCountryLogic = $this->load('languageJoinCountry');
        $this->seotplLanguageLogic = $this->load('seotplLanguage');
		$this->languageLogic = $this->load('language');
    }

    /**
     * 列表
     */
    public function actionList()
    {
        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'),1);
		$where = '1=1';
        if(_g('base_name'))
        {
            $where .= " and base_name like '%" . _g('base_name') . "%'";
        }
		$where .= " ORDER BY id DESC";
        $res = $this->seotplLogic->getCurrentDatas($where, $page_size, $curr_page);
        $count = $this->seotplLogic->getCount($where);
        $page_list = Common::getPages($count, $curr_page, $page_size);
        Core::$tpl->set('res', $res);
        Core::$tpl->set('pages', $page_list);
    }

    /**
     * 新增数据
     */
    public function actionAdd()
    {
        //如果是 POST 请求,则执行添加数据操作,else 进行视图输出
        if (_p())
        {
            //插入主表信息
            $seotpl = Zhtx::createDataMap();
            $seotpl->addEntry('base_name', Common::strEscape(_p('base_name')), DB::VARCHAR);
            $seotpl->addEntry('var_descript', Common::strEscape(_p('var_descript')), DB::VARCHAR);
            $seotpl->addEntry('create_time', SYS_TIME, DB::TEXT);
            $seoRes = $this->seotplLogic->insert($seotpl);

            if ($seoRes)
            {
                //更新id
                if($seoRes<10000)
                {
                    $reSeoId = $seoRes+10000;
                    $seoupdatetpl = Zhtx::createDataMap();
                    $seoupdatetpl->addEntry('id', $reSeoId, DB::INT);
                    $res = $this->seotplLogic->update($seoupdatetpl,'id='.$seoRes);
                    if($res)
                    {
                        $seoRes = $reSeoId;
                    }
                }
                //获得 insert_id 插入附表信息
                $cols = array('id','base_name');
				$languages = $this->languageLogic->findALL('status=1', true);
                //更新选中的信息
               	foreach ($languages as $key=>$item)
                {
                    $seoLanguage = Zhtx::createDataMap();
                    $seoLanguage->addEntry('seo_tpl_id', $seoRes, DB::INT);
                    $seoLanguage->addEntry('language_id', $item["id"], DB::INT);
                    $seoLanguage->addEntry('title', Common::strEscape(_p('title'.$item["id"])), DB::VARCHAR);
                    $seoLanguage->addEntry('keywords', Common::strEscape(_p('keywords'.$item["id"])), DB::VARCHAR);
                    $seoLanguage->addEntry('descript', Common::strEscape(_p('descript'.$item["id"])), DB::VARCHAR);
                    $this->seotplLanguageLogic->insert($seoLanguage);
                }
                return $this->success('add_success', Common::adminURL('admin', 'seotpl', 'list'));
            }
			else
				return $this->error('add_failure', Common::adminURL('admin', 'seotpl', 'list'));
        } 
		else
        {

            $languages = $this->languageJoinCountryLogic->getList('l.status=1');
            Core::$tpl->set('languages', $languages['list']);
        }
    }

    /**
     * 编辑数据
     */
    public function actionEdit()
    {
        if (_p())
        {
            //更新主表信息
            $id = Common::queryInt(_p('id'));
            $seotpl = Zhtx::createDataMap();
            $seotpl->addEntry('base_name', Common::strEscape(_p('base_name')), DB::VARCHAR);
            //$seotpl->addEntry('var_descript', _p('var_descript'), DB::VARCHAR);
            $seotpl->addEntry('create_time', SYS_TIME, DB::INT);
            $seoRes = $this->seotplLogic->update($seotpl, 'id = ' . $id);

            if ($seoRes)
            {    //如果主表信息更新成功,则更新附表信息 
               	$cols = array('id','base_name');
				$languages = $this->languageLogic->findALL('status=1', true);
                //更新选中的信息
               	foreach ($languages as $key=>$item)
                {
                    $seoLanguage = Zhtx::createDataMap();
                    $seoLanguage->addEntry('seo_tpl_id', $id, DB::INT);
                    $seoLanguage->addEntry('language_id', $item["id"], DB::INT);
                    $seoLanguage->addEntry('title', Common::strEscape(_p('title'.$item["id"])), DB::VARCHAR);
                    $seoLanguage->addEntry('keywords', Common::strEscape(_p('keywords'.$item["id"])), DB::VARCHAR);
                    $seoLanguage->addEntry('descript', Common::strEscape(_p('descript'.$item["id"])), DB::VARCHAR);
                    /*
                     * 没有replace操作,所以要先查询一遍是否有当前seo_tpl_id 和 language_id的数据值
                     * 如果没有,则添加数据,否则更新数据
                     */
					$values = $item["id"];
                    if ($this->seotplLanguageLogic->getOne("seo_tpl_id = {$id} AND language_id = {$values}"))
                    {
                        // echo(1); 
                        $this->seotplLanguageLogic->update($seoLanguage, "seo_tpl_id = {$id} AND language_id = {$values}");
                    } else
                    {
                        //echo(2); 
                        $this->seotplLanguageLogic->insert($seoLanguage);
                    }
                }
               return $this->success('edit_success', Common::adminURL('admin', 'seotpl', 'list'));
               
            }
			else
			 	return $this->error('edit_failure', Common::adminURL('admin', 'seotpl', 'list'));
        } 
		else
        {
            
                $id = Common::queryInt(_g('id'));
                $where = 'id = ' . $id;
                $seotpl = $this->seotplLogic->getOne($where);
				if(!$seotpl)
					return $this->error('id_error', Common::adminURL('admin', 'seotpl', 'list'));
                //获得当前支持的语言列表
                $languages = $this->languageJoinCountryLogic->getList('l.status=1');
                //获得多语言信息
                //获得对应语言对应的邮件多语言模板信息
               	$cond = 'seo_tpl_id = ' . $id;
				$seotplLanguage = $this->seotplLanguageLogic->getList($cond);
				$seotpllang_arr = array();
				foreach ($seotplLanguage['list'] as $value)
				{
					$seotpllang_arr[$value['language_id']] = $value;
				}
				
                Core::$tpl->set('seotplLanguage', $seotpllang_arr);
                Core::$tpl->set('languages', $languages['list']);
                Core::$tpl->set('seotpl', $seotpl);
        }
    }

    /**
     * 数据删除 
     */
    public function actionDel()
    {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if(!empty($ids))
        {
          $num = 0;
          foreach ($ids as $id)
          {
            
              $res  = $this->seotplLogic->delete('id=' . $id);
              if($res)
              {   
                $this->seotplLanguageLogic->delete('seo_tpl_id=' . $id);
                $num++;
              }

          }
          $staus = 1;
          $flag = $lang['success_delete']. $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

}

?>
