<?php

/**
 * Description of shipping
 *
 * @author HHH
 */
class ShippingController extends AppController
{

    private $shippingLogic;
    private $shippingLanguageLogic;
    private $languageJoinCountryLogic;
    private $shippingCorpLogic;
    private $shippingAreaLogic;

    /**
     * 初始化程序
     */
    public function __construct()
    {
        parent::__construct();
        $this->shippingLogic = $this->load('shipping');
        $this->languageJoinCountryLogic = $this->load('languageJoinCountry');
        $this->shippingLanguageLogic = $this->load('shippingLanguage');
        $this->shippingCorpLogic = $this->load('shippingCorp');
        $this->shippingAreaLogic = $this->load('shippingArea');
		$this->languageLogic  = $this->load('language');
    }

    /**
     * 列表
     */
    public function actionList()
    {		
		$page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);
		$where = '1=1';
		if(_g('base_name'))
        {
            $where .= " and base_name like '%" . _g('base_name') . "%'";
        }
        //分页
        $count      = $this->shippingLogic->getCount($where);      
        $page_data  = Common::getPages($count, $curr_page, $page_size);
        $where     .= ' ORDER BY id desc';
        $res  = $this->shippingLogic->getCurrentDatas($where, $page_size, $curr_page);
		
		$corp = $this->shippingCorpLogic->findALL('',true);
		$area = $this->shippingAreaLogic->findALL('',true);		
		Core::$tpl->set("corp", $corp);
		Core::$tpl->set("area", $area);
        Core::$tpl->set("res", $res);
        Core::$tpl->set("pages", $page_data);	
	}

    /**
     * 新增数据
     */
    public function actionAdd()
    {
        //如果是 POST 请求,则执行添加数据操作,else 进行视图输出
        if (_p())
        {         
            $base_site_id = Common::validSiteConfig();
            $name = _p('base_name'.$base_site_id);
            if(!$name)
            {
              return $this->showMessage('default_site_required');
            }
			if(!_p('area_id'))
            {
              return $this->showMessage('pls_shipping');
            }
			//插入主表信息
            $shipping = Zhtx::createDataMap();
            $shipping->addEntry('base_name', Common::strEscape($name), DB::VARCHAR);
            $shipping->addEntry('area_id', Common::queryInt(_p('area_id')), DB::INT);
            $shipping->addEntry('shipping_corp_id', Common::queryInt(_p('shipping_corp_id')), DB::INT);
            $shipping->addEntry('discount', _p('discount'), DB::FLOAT);
            $shipping->addEntry('status', Common::queryInt(_p('status')), DB::INT);
            $shipping->addEntry('formula', _p('formula'), DB::VARCHAR);
            $shipping->addEntry('create_time', SYS_TIME, DB::INT);
            $shipping->addEntry('listorder', Common::queryInt(_p('listorder'),0), DB::INT);
            //获取自定义shipping接口的数据
            $formula_param = array();
            foreach ($_POST as $key => $value)
            {
                if (strpos($key, "exp_") !== false)
                {
                    $formula_param[$key] = $value;
                }
            }
            $formula_param = json_encode($formula_param);
            $shipping->addEntry('formula_param', Common::strEscape($formula_param,false), DB::VARCHAR);
            $shippingRes = $this->shippingLogic->insert($shipping);
            if($shippingRes)
            {
                if(!_p('listorder')){
                    $map = Zhtx::createDataMap(); 
                    $map->addEntry('listorder', 10*$shippingRes, DB::INT);
                    $this->shippingLogic->update($map, 'id='.$shippingRes);
                }
		$languages = $this->languageLogic->findALL('status=1', true);
               	foreach ($languages as $item)
                {
                    $shippingLanguage = Zhtx::createDataMap();
                    $shippingLanguage->addEntry('shipping_id', $shippingRes, DB::INT);
                    $shippingLanguage->addEntry('language_id', $item["id"], DB::INT);
                    $shippingLanguage->addEntry('base_name', Common::strEscape(_p('base_name'.$item["id"])), DB::VARCHAR);
                    $shippingLanguage->addEntry('detail', Common::strEscape(Inputer::getOrgPost('detail'.$item["id"]),false), DB::VARCHAR);
                    $this->shippingLanguageLogic->insert($shippingLanguage);
                }
                return $this->success('add_success', Common::adminURL('admin', 'shipping', 'list'));
            }
			else
				return $this->error('add_failure', Common::adminURL('admin', 'shipping', 'list'));
        } 
		else
        {
                $languages = $this->languageJoinCountryLogic->getList('l.status=1');
                $where = 'ORDER BY id desc';
                $shippingCorp = $this->shippingCorpLogic->getCols($where, array('id', 'base_name'));
                $shippingArea = $this->shippingAreaLogic->getCols($where, array('id', 'base_name'));
                Core::$tpl->set('shippingFormula', $this->getFormula());
                Core::$tpl->set('shippingCorp', $shippingCorp);
                Core::$tpl->set('shippingArea', $shippingArea);
                Core::$tpl->set('languages', $languages['list']);
        }
    }

    /**
     * 编辑数据
     */
    public function actionEdit()
    {
        if (_p())
        {
            $base_site_id = Common::validSiteConfig();
            $name = _p('base_name'.$base_site_id);
            if(!$name)
            {
              return $this->showMessage('default_site_required');
            }
			if(!_p('area_id'))
            {
              return $this->showMessage('pls_shipping');
            }
			//更新主表信息
            $id = _p('id');
            $shipping = Zhtx::createDataMap();
            $shipping->addEntry('base_name', Common::strEscape($name), DB::VARCHAR);
            $shipping->addEntry('area_id', Common::queryInt(_p('area_id')), DB::INT);
            $shipping->addEntry('shipping_corp_id', Common::queryInt(_p('shipping_corp_id')), DB::INT);
            $shipping->addEntry('discount', _p('discount') , DB::DECIMAL);
            $shipping->addEntry('status', Common::queryInt(_p('status')), DB::INT);
            $shipping->addEntry('formula', _p('formula'), DB::VARCHAR);
            $shipping->addEntry('create_time', SYS_TIME, DB::INT);
            //获取自定义shipping接口的数据
            $formula_param = array();
            foreach ($_POST as $key => $value)
            {
                if (strpos($key, "exp_") !== false)
                {
                    $formula_param[$key] = $value;
                }
            }
            $formula_param = json_encode($formula_param);
            $shipping->addEntry('formula_param', Common::strEscape($formula_param,false), DB::VARCHAR);
            $shippingRes = $this->shippingLogic->update($shipping, 'id = ' . $id);
			
            if ($shippingRes)
            {    
				//如果主表信息更新成功,则更新附表信息
				$languages = $this->languageLogic->findALL('status=1', true);
                //更新选中的信息
                foreach ($languages as $item)
                {
                    $shippingLanguage = Zhtx::createDataMap();
                    $shippingLanguage->addEntry('shipping_id', $id, DB::INT);
                    $shippingLanguage->addEntry('language_id', $item["id"], DB::INT);
                    $shippingLanguage->addEntry('base_name', Common::strEscape(_p('base_name'.$item["id"])), DB::VARCHAR);
                    $shippingLanguage->addEntry('detail', Common::strEscape(Inputer::getOrgPost('detail'.$item["id"]),false), DB::VARCHAR);
                    /*
                     * 没有replace操作,所以要先查询一遍是否有当前shipping_id 和 language_id的数据值
                     * 如果没有,则添加数据,否则更新数据
                     */
					$values = $item["id"];
                    if ($this->shippingLanguageLogic->getOne("shipping_id = {$id} AND language_id = {$values}"))
                    {
                        $this->shippingLanguageLogic->update($shippingLanguage, "shipping_id = {$id} AND language_id = {$values}");
                    } else
                    {
                        $this->shippingLanguageLogic->insert($shippingLanguage);
                    }
                }
                return $this->success('edit_success', Common::adminURL('admin', 'shipping', 'list'));
            }
			else
				return $this->error('edit_failure', Common::adminURL('admin', 'shipping', 'list'));
        } 
		else
        {          
			//获得基本信息
			$id = Common::queryInt(_g('id'));
			$where = 'id = ' . $id;
			$shipping = $this->shippingLogic->getOne($where);
			if(!$shipping)
				return $this->error('id_error', Common::adminURL('admin', 'shipping', 'list'));
			//获多语言
			$languages = $this->languageJoinCountryLogic->getList('l.status=1');
			$cond = 'shipping_id = ' . $id;
			$shippinglang = $this->shippingLanguageLogic->getList($cond);
			$shippinglang_arr = array();
			foreach ($shippinglang['list'] as $value)
			{
				$shippinglang_arr[$value['language_id']] = $value;
			}
			//获得配送区域
			$where = 'ORDER BY id desc';
			$shippingCorp = $this->shippingCorpLogic->getCols($where, array('id', 'base_name'));
  
			//获得配送物流公司
			$shippingArea = $this->shippingAreaLogic->getCols($where, array('id', 'base_name'));
			//获得配送公式列表
			Core::$tpl->set('shippingFormula', $this->getFormula());
			Core::$tpl->set('shippingCorp', $shippingCorp);
			Core::$tpl->set('shippingArea', $shippingArea);
			Core::$tpl->set('shippingLanguage', $shippinglang_arr);
			Core::$tpl->set('languages', $languages["list"]);
			Core::$tpl->set('shipping', $shipping);         
        }
    }


    /**
     * 获得配送列表
     */
    private function getFormula()
    {
        $formula = array();
        $fp = opendir('./api/shipping/');
        while ($file = readdir($fp))
        {
            if ($file != '.' && $file != '..'&& $file != '.svn')
            {
               if( is_dir( './api/shipping/'.$file ) )
			   {
				   $formula_item = array();
				   $formula_item["name"] = trim(file_get_contents('./api/shipping/' . $file . '/readme.txt'));
				   $formula_item["formula"] = trim($file);
				   $formula[] = $formula_item;
			   }
			}
        }
        closedir($fp);
        return $formula;
    }
	
	public function actionChangediscountfield()
	{
		$id = _p('id');
        $shipping = Zhtx::createDataMap();
        $shipping->addEntry('discount', _p('discount'), DB::INT);
        $shippingRes = $this->shippingLogic->update($shipping, 'id = ' . $id);
		if ($shippingRes)
		{
			echo 1;
			die();
		}
		else
			die("nothing");
	}
	
	public function actionGetParamForm()
    {
		$id     =  _g("id");
        $folder =  _g("folder");
		$cond="id={$id}";
        $payment = $this->shippingLogic->getOne($cond);
		if(!$folder)
		{
			echo "";
			die();
		}
		if($payment)
        {
            $param=array();
			if($payment["formula_param"]!="")
            {
                $param = json_decode($payment["formula_param"],true);
            }
        }
		if(is_file(APP_ROOT.'api/shipping/'.$folder.'/form.php'))
		{
			require_once APP_ROOT.'api/shipping/'.$folder.'/form.php';
		}
		exit();
    }
    
     /**
     * 删除
     */
     public function actionDel() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if(!empty($ids))
        {
          $num = 0;
          foreach ($ids as $id)
          {
          
                $res  = $this->shippingLogic->delete('id=' . $id);
                $shippingLanguageLogic = $this->load('shippingLanguage');
				$shippingLanguageLogic->delete('shipping_id=' . $id);
				if($res)
                {                      
                  $num++;
                }
          }
          $staus = 1;
          $flag = $lang['success_delete']. $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }
/**
     * ajax 更新状态
     */
    public function actionPublicEditStatus()
    {
        $id     = Common::queryInt(_g('id'));
        $status = _g('currentStatus');
        $map    = Zhtx::createDataMap();
        $map->addEntry('status', $status, DB::INT);
        $res    = $this->shippingLogic->updateById($map, $id);
        echo $res ? 1 : 0;
    }
	
	public function actionPublicQuickEdit()
    {
      $id        = Common::queryInt(_p('id'));
      if(!$id)
      {
        echo 0;return;
      }
	  if(!is_numeric(_p('discount')))
      {
			echo 0;return;  
	  }
      $map = Zhtx::createDataMap();
      $map->addEntry('discount', _p('discount'), DB::FLOAT);
      $res = $this->shippingLogic->update($map, 'id=' . $id);
      echo $res ? 1 : 0;
    }
    
    public function actionPublicQuickEditListorder()
    {
      $id        = Common::queryInt(_p('id'));
      if(!$id)
      {
        echo 0;return;
      }
	  if(!is_numeric(_p('listorder')))
      {
			echo 0;return;  
	  }
	  $listorder   = Common::queryInt(_p('listorder'));
      $map = Zhtx::createDataMap();
      if($listorder)
      	$map->addEntry('listorder', $listorder, DB::INT);
      $res = $this->shippingLogic->update($map, 'id=' . $id);
      echo $res ? 1 : 0;
    }
    /**
     * 获取配送方式 
     */
    public function actionPublicList()
    {
        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);
		$where = '1=1';
		if(_g('base_name'))
        {
            $where .= " and base_name like '%" . _g('base_name') . "%'";
        }
        //分页
        $count      = $this->shippingLogic->getCount($where);      
        $page_data  = Common::getPages($count, $curr_page, $page_size);
        $where     .= ' ORDER BY id desc';
        $res  = $this->shippingLogic->getCurrentDatas($where, $page_size, $curr_page);		
		$corp = $this->shippingCorpLogic->findALL('',true);
		$area = $this->shippingAreaLogic->findALL('',true);		
		Core::$tpl->set("corp", $corp);
		Core::$tpl->set("area", $area);
        Core::$tpl->set("res", $res);
        Core::$tpl->set("pages", $page_data);
      
    }
}

?>
