<?php

/**
 * Description of shippingArea
 *
 * @author HHH
 */
class ShippingAreaController extends AppController
{
    private $shippingAreaLogic;
    /**
     * 初始化程序
     */
    public function __construct()
    {
        parent::__construct();
        $this->shippingAreaLogic = $this->load('shippingArea');
    }
    /**
     * 列表
     */
    public function actionList()
    {
		$page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);
		$where = '1=1';
		if(_g('base_name'))
        {
            $where .= " and base_name like '%" . _g('base_name') . "%'";
        }
		$where .= ' ORDER BY id desc';
		$count            = $this->shippingAreaLogic->getCount($where);      
        $page_data        = Common::getPages($count, $curr_page, $page_size);
        $shippingArea = $this->shippingAreaLogic->getCurrentDatas($where, $page_size, $curr_page);
		Core::$tpl->set("pages", $page_data);
        Core::$tpl->set('res', $shippingArea);
    }

    /**
     * 新增数据
     */
    public function actionAdd()
    {
        //如果是 POST 请求,则执行添加数据操作,else 进行视图输出
        if (_p())
        {
            //插入主表信息
			for($index=1;$index<=20;$index++)
			{
				if(_p('base_name'.$index))
				{
					$shippingArea = Zhtx::createDataMap();
					$shippingArea->addEntry('base_name', Common::strEscape(_p('base_name'.$index)), DB::VARCHAR);
					$shippingArea->addEntry('create_time', SYS_TIME, DB::INT);
					$seoRes = $this->shippingAreaLogic->insert($shippingArea);
				}
			}
			return $this->success('add_success', Common::adminURL('admin', 'shippingArea', 'list'));
			
        }
		else
		{
			$arr_count = array(1,2,3,4,5,6,7,8,9,10);
			Core::$tpl->set('arr_count', $arr_count);	
		}
    }

    /**
     * 编辑数据
     */
    public function actionEdit()
    {
        if (_p())
        {
            //更新主表信息
            $id = Common::queryInt(_p('id'));
            $shippingArea = Zhtx::createDataMap();
            $shippingArea->addEntry('base_name', Common::strEscape(_p('name')), DB::VARCHAR);
            $seoRes = $this->shippingAreaLogic->update($shippingArea, 'id = ' . $id);

           	if($seoRes)
			{
				return $this->success('edit_success', Common::adminURL('admin', 'shippingArea', 'list'));
			}
			else
			{
				return $this->error('edit_failure', Common::adminURL('admin', 'shippingArea', 'list'));
			}
        }
		else
        {
                //获得基本信息
                $id = Common::queryInt(_g('id'));
                $where = 'id = ' . $id;
                $shippingArea = $this->shippingAreaLogic->getOne($where);
				if(!$shippingArea)
					return $this->success('id_error', Common::adminURL('admin', 'shippingArea', 'list'));
                Core::$tpl->set('shippingArea', $shippingArea);
        }
    }
    /**
     * 删除数据
     */
     public function actionDel() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if(!empty($ids))
        {
          $num = 0;
          $relationLogic = $this->load('ShippingAreaCountryRel');
          foreach ($ids as $id)
          {
            
              $res  = $this->shippingAreaLogic->delete('id=' . $id);
              if($res)
              {                    
                $relationLogic->delete('area_id=' . $id);
                $num++;
              }
            
          }
          $staus = 1;
          $flag = $lang['success_delete']. $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

}

?>
