<?php

/**
 * Description of shippingArea
 *
 * @author HHH
 */
class ShippingAreaCountryRelController extends AppController {

    private $countryLogic;
    private $shippingAreaLogic;
    private $ShippingAreaCountryRelLogic;

    /**
     * 初始化程序
     */
    public function __construct() {
        parent::__construct();
        $this->countryLogic = $this->load('country');
        $this->shippingAreaLogic = $this->load('shippingArea');
        $this->ShippingAreaCountryRelLogic = $this->load('ShippingAreaCountryRel');
    }

    /**
     * 编辑数据
     */
    public function actionEdit() {
        if (_p()) {
            //更新信息
            $area_id = _p('area_id');
            $countryId = _p('country_id');
            $tempAreaCountry = explode(',', _p('tempAreaCountry'));
            //如果有分配国家
            if ($countryId) {
                $insertCountryIdList = array();
                //如果原来已经有分配了,则不继续添加
                foreach ($countryId as $key => $value) {
                    if (!in_array($value, $tempAreaCountry)) {
                        $insertCountryIdList[] = $value;
                    }
                }

                $delCountryIdList = array();
                //这个对比是为了找到已经被删除的选项
                foreach ($tempAreaCountry as $key => $value) {
                    if (!in_array($value, $countryId)) {
                        $delCountryIdList[] = $value;
                    }
                }

                //删除已经没有选择的选项
                $Counts = $this->ShippingAreaCountryRelLogic->getCount("area_id={$area_id}");
                if ($Counts > 0) {
                    $delCountryId = implode(',', $delCountryIdList);
                    if ($delCountryId) {
                        $this->ShippingAreaCountryRelLogic->delete("country_id in({$delCountryId}) AND area_id = {$area_id}");
                    }
                }

                //增加上新的分配国家
                foreach ($insertCountryIdList as $value) {
                    $ShippingAreaCountryRel = Zhtx::createDataMap();
                    $ShippingAreaCountryRel->addEntry('area_id', $area_id, DB::INT);
                    $ShippingAreaCountryRel->addEntry('country_id', $value, DB::INT);
                    $this->ShippingAreaCountryRelLogic->insert($ShippingAreaCountryRel);
                }
            } else {
                $this->ShippingAreaCountryRelLogic->delete("area_id = {$area_id}");
            }
            return $this->success('edit_success', Common::adminURL('admin', 'shippingArea', 'list'));
        } else {
            $id = Common::queryInt(_g('id'));
            $where = "id = {$id}";
            $shippingAreaResult = $this->shippingAreaLogic->getCols($where, array('id', 'base_name'));
            $shippingArea = $shippingAreaResult[0];
            if (!$shippingArea)
                return $this->error('id_error', Common::adminURL('admin', 'shippingArea', 'list'));
            //获得所有国家
            $where = 'ORDER BY base_name ASC';
            $countryList = $this->countryLogic->getList($where);
            $country = $countryList['list'];

            //获得当前区域已经可能存在的关联国家信息
            $where = "area_id = {$id}";
            $areaCountryList = $this->ShippingAreaCountryRelLogic->getList($where);

            //遍历获得相关分配的国家信息
            $tempAreaCountryList = array();
            $areaCountry = array();
            foreach ($country as $key => $value) {
                foreach ($areaCountryList['list'] as $k => $v) {
                    if ($value['id'] == $v['country_id']) {
                        $areaCountry[] = $value;
                        $tempAreaCountryList[] = $v['country_id'];
                        unset($areaCountryList[$k]);
                        unset($country[$key]); //如果已经存在了。左边所有国家就不需要存在了
                        break;
                    }
                }
            }
            $tempAreaCountry = implode(',', $tempAreaCountryList); //分配一个临时变量,在更新信息的时候用做对比信息

            Core::$tpl->set('tempAreaCountry', $tempAreaCountry);
            Core::$tpl->set('areaCountryList', $areaCountry);
            Core::$tpl->set('countryList', $country);
            Core::$tpl->set('shippingArea', $shippingArea);
        }
    }

}

?>