<?php

/**
 * Description of shippingCorp
 *
 * @author HHH
 */
class ShippingCorpController extends AppController
{

    private $shippingCorpLogic;

    /**
     * 初始化程序
     */
    public function __construct()
    {
        parent::__construct();
        $this->shippingCorpLogic = $this->load('shippingCorp');
    }

    /**
     * 列表
     */
    public function actionList()
    {
        $where = 'ORDER BY listorder desc,id DESC';
        $shippingCorp = $this->shippingCorpLogic->getList($where);
        Core::$tpl->set('res', $shippingCorp['list']);
    }

    /**
     * 新增数据
     */
    public function actionAdd()
    {
        //如果是 POST 请求,则执行添加数据操作,else 进行视图输出
        if (_p())
        {
            //插入主表信息
            $shippingCorp = Zhtx::createDataMap();
            $shippingCorp->addEntry('base_name', Common::strEscape(_p('base_name')), DB::VARCHAR);
            $shippingCorp->addEntry('interface_code', _p('interface_code'), DB::VARCHAR);
            $shippingCorp->addEntry('image', Common::strEscape(_p('image')), DB::VARCHAR);
			$shippingCorp->addEntry('codeno', _p('codeno'), DB::VARCHAR);
            $shippingCorp->addEntry('href', Common::strEscape(_p('href')), DB::VARCHAR);
            $shippingCorp->addEntry('listorder', Common::queryInt(_p('listorder')), DB::INT);
            $res = $this->shippingCorpLogic->insert($shippingCorp);

            if($res)
			{
				return $this->success('add_success', Common::adminURL('admin', 'shippingcorp', 'list'));
			}
			else
			{
				return $this->error('add_failure', Common::adminURL('admin', 'shippingcorp', 'list'));
			}
        }
    }

    /**
     * 编辑数据
     */
    public function actionEdit()
    {
        if (_p())
        {
            //更新主表信息
            $id = Common::queryInt(_p('id'));
            $shippingCorp = Zhtx::createDataMap();
            $shippingCorp->addEntry('base_name', Common::strEscape(_p('base_name')), DB::VARCHAR);
            $shippingCorp->addEntry('interface_code', _p('interface_code'), DB::VARCHAR);
			$shippingCorp->addEntry('codeno', _p('codeno'), DB::VARCHAR);
            $shippingCorp->addEntry('image', Common::strEscape(_p('image')), DB::VARCHAR);
            $shippingCorp->addEntry('href', Common::strEscape(_p('href')), DB::VARCHAR);
            $shippingCorp->addEntry('listorder', Common::queryInt(_p('listorder')), DB::INT);
            $res = $this->shippingCorpLogic->update($shippingCorp, 'id = ' . $id);
           	if($res)
			{
				return $this->success('edit_success', Common::adminURL('admin', 'shippingcorp', 'list'));
			}
			else
			{
				return $this->error('edit_failure', Common::adminURL('admin', 'shippingcorp', 'list'));
			}
        } 
		else
        {
            $id = Common::queryInt(_g('id'));
            $where = 'id = ' . $id;
            $shippingCorp = $this->shippingCorpLogic->getOne($where);
			if(!$shippingCorp)
				return $this->error('id_error', Common::adminURL('admin', 'shippingcorp', 'list'));
            Core::$tpl->set('shippingCorp', $shippingCorp);
        }
    }

   
    /**
     * 删除物流公司
     */
     public function actionDel() 
	 {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if(!empty($ids))
        {
          $num = 0;
          foreach ($ids as $id)
          {
                $res  = $this->shippingCorpLogic->delete('id=' . $id);
                $shippingLogic = $this->load('shipping');
				$shippingLanguageLogic = $this->load('shippingLanguage');
				$shipping = $shippingLogic->findAll('shipping_corp_id=' . $id,false);
				foreach($shipping as $key => $value)
				{       if($value["id"]){
					$shippingLogic->delete('id=' . $value["id"]);
					$shippingLanguageLogic->delete('shipping_id=' . $value["id"]);
                                       }
				}
				if($res)
                {                      
                  $num++;
                }
          }
          $staus = 1;
          $flag = $lang['success_delete']. $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }
	
	public function actionPublicQuickEdit()
    {
      $id        = Common::queryInt(_p('id'));
      if(!$id)
      {
        echo 0;return;
      }
	  if(!is_numeric(_p('listorder')))
      {
			echo 0;return;  
	  }
      $map = Zhtx::createDataMap();
      $map->addEntry('listorder', Common::queryInt(_p('listorder')), DB::INT);
      $res = $this->shippingCorpLogic->update($map, 'id=' . $id);
      echo $res ? 1 : 0;
    }
	
}

?>
